@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property comparisonOperator The comparison operator for this scaling rule specific metrics trigger. Invalid values: `EQ`, `NE`, `GT`, `LT`, `GE`, `LE`.
 * @property metricName The metric name for this scaling rule specific metrics trigger.
 * @property statistics The statistics for this scaling rule specific metrics trigger.
 * @property tags A mapping of tags to assign to the resource.
 * @property threshold The threshold for this scaling rule specific metrics trigger.
 */
public data class ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition(
    public val comparisonOperator: String,
    public val metricName: String,
    public val statistics: String,
    public val tags: List<ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTag>? =
        null,
    public val threshold: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition): ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition =
            ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerCondition(
                comparisonOperator = javaType.comparisonOperator(),
                metricName = javaType.metricName(),
                statistics = javaType.statistics(),
                tags = javaType.tags().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.emrv2.kotlin.outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleMetricsTriggerConditionTag.Companion.toKotlin(args0)
                    })
                }),
                threshold = javaType.threshold(),
            )
    }
}
