@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endTime The end time for this scaling rule specific metrics trigger.
 * @property launchExpirationTime The launch expiration time for this scaling rule specific time trigger. The value should between 0 and 3600.
 * @property launchTime The launch time for this scaling rule specific time trigger.
 * @property recurrenceType The recurrence type for this scaling rule specific time trigger. Valid values: `MINUTELY`, `HOURLY`, `DAILY`, `WEEKLY`, `MONTHLY`.
 * @property recurrenceValue The recurrence value for this scaling rule specific time trigger.
 * @property startTime The start time for this scaling rule specific metrics trigger.
 */
public data class ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger(
    public val endTime: String? = null,
    public val launchExpirationTime: Int? = null,
    public val launchTime: String,
    public val recurrenceType: String? = null,
    public val recurrenceValue: String? = null,
    public val startTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger): ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger =
            ClusterNodeGroupAutoScalingPolicyScalingRuleTimeTrigger(
                endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
                launchExpirationTime = javaType.launchExpirationTime().map({ args0 -> args0 }).orElse(null),
                launchTime = javaType.launchTime(),
                recurrenceType = javaType.recurrenceType().map({ args0 -> args0 }).orElse(null),
                recurrenceValue = javaType.recurrenceValue().map({ args0 -> args0 }).orElse(null),
                startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            )
    }
}
