@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property onDemandBaseCapacity The cost optimized configuration which on demand based capacity.
 * @property onDemandPercentageAboveBaseCapacity The cost optimized configuration which on demand percentage above based capacity.
 * @property spotInstancePools The cost optimized configuration with spot instance pools.
 */
public data class ClusterNodeGroupCostOptimizedConfig(
    public val onDemandBaseCapacity: Int,
    public val onDemandPercentageAboveBaseCapacity: Int,
    public val spotInstancePools: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterNodeGroupCostOptimizedConfig): ClusterNodeGroupCostOptimizedConfig = ClusterNodeGroupCostOptimizedConfig(
            onDemandBaseCapacity = javaType.onDemandBaseCapacity(),
            onDemandPercentageAboveBaseCapacity = javaType.onDemandPercentageAboveBaseCapacity(),
            spotInstancePools = javaType.spotInstancePools(),
        )
    }
}
