@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
 * @property count The count of a data disk.
 * @property performanceLevel Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
 * @property size The size of a data disk, at least 40. Unit: GiB.
 */
public data class ClusterNodeGroupDataDisk(
    public val category: String,
    public val count: Int? = null,
    public val performanceLevel: String? = null,
    public val size: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterNodeGroupDataDisk): ClusterNodeGroupDataDisk = ClusterNodeGroupDataDisk(
            category = javaType.category(),
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            performanceLevel = javaType.performanceLevel().map({ args0 -> args0 }).orElse(null),
            size = javaType.size(),
        )
    }
}
