@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoPayOrder Auto pay order for payment type of subscription, ’true’ or ‘false’ .
 * @property autoRenew Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
 * @property autoRenewDuration If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
 * @property autoRenewDurationUnit If paymentType is Subscription, this should be specified. Supported value: Month or Year.
 * @property paymentDuration If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
 * @property paymentDurationUnit If paymentType is Subscription, this should be specified. Supported value: Month or Year.
 */
public data class ClusterNodeGroupSubscriptionConfig(
    public val autoPayOrder: Boolean? = null,
    public val autoRenew: Boolean? = null,
    public val autoRenewDuration: Int? = null,
    public val autoRenewDurationUnit: String? = null,
    public val paymentDuration: Int,
    public val paymentDurationUnit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.ClusterNodeGroupSubscriptionConfig): ClusterNodeGroupSubscriptionConfig = ClusterNodeGroupSubscriptionConfig(
            autoPayOrder = javaType.autoPayOrder().map({ args0 -> args0 }).orElse(null),
            autoRenew = javaType.autoRenew().map({ args0 -> args0 }).orElse(null),
            autoRenewDuration = javaType.autoRenewDuration().map({ args0 -> args0 }).orElse(null),
            autoRenewDurationUnit = javaType.autoRenewDurationUnit().map({ args0 -> args0 }).orElse(null),
            paymentDuration = javaType.paymentDuration(),
            paymentDurationUnit = javaType.paymentDurationUnit(),
        )
    }
}
