@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property clusterId The first ID of the resource.
 * @property clusterName The name of the emr cluster.
 * @property clusterState The state of the emr cluster.
 * @property clusterType The type of the emr cluster.
 * @property createTime The creation time of the resource.
 * @property emrDefaultRole The ecs default role belongs to this emr cluster.
 * @property endTime The end time of the resource.
 * @property expireTime The expire time of the resource.
 * @property paymentType The payment type of the emr cluster.
 * @property readyTime The ready time of the resource.
 * @property releaseVersion The release version of the resource.
 * @property resourceGroupId The resource group id of the resource.
 * @property stateChangeReason The cluster state change reason.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetClustersCluster(
    public val clusterId: String,
    public val clusterName: String,
    public val clusterState: String,
    public val clusterType: String,
    public val createTime: String,
    public val emrDefaultRole: String,
    public val endTime: String,
    public val expireTime: String,
    public val paymentType: String,
    public val readyTime: String,
    public val releaseVersion: String,
    public val resourceGroupId: String,
    public val stateChangeReason: Map<String, String>,
    public val tags: List<GetClustersClusterTag>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.GetClustersCluster): GetClustersCluster = GetClustersCluster(
            clusterId = javaType.clusterId(),
            clusterName = javaType.clusterName(),
            clusterState = javaType.clusterState(),
            clusterType = javaType.clusterType(),
            createTime = javaType.createTime(),
            emrDefaultRole = javaType.emrDefaultRole(),
            endTime = javaType.endTime(),
            expireTime = javaType.expireTime(),
            paymentType = javaType.paymentType(),
            readyTime = javaType.readyTime(),
            releaseVersion = javaType.releaseVersion(),
            resourceGroupId = javaType.resourceGroupId(),
            stateChangeReason = javaType.stateChangeReason().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emrv2.kotlin.outputs.GetClustersClusterTag.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
