@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.emrv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getClusters.
 * @property clusterName
 * @property clusterStates
 * @property clusterTypes
 * @property clusters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property maxResults
 * @property nameRegex
 * @property names
 * @property nextToken
 * @property outputFile
 * @property paymentTypes
 * @property resourceGroupId
 * @property tags
 * @property totalCount
 */
public data class GetClustersResult(
    public val clusterName: String? = null,
    public val clusterStates: List<String>? = null,
    public val clusterTypes: List<String>? = null,
    public val clusters: List<GetClustersCluster>,
    public val id: String,
    public val ids: List<String>,
    public val maxResults: Int? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val nextToken: String? = null,
    public val outputFile: String? = null,
    public val paymentTypes: List<String>? = null,
    public val resourceGroupId: String? = null,
    public val tags: Map<String, String>? = null,
    public val totalCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.emrv2.outputs.GetClustersResult): GetClustersResult = GetClustersResult(
            clusterName = javaType.clusterName().map({ args0 -> args0 }).orElse(null),
            clusterStates = javaType.clusterStates().map({ args0 -> args0 }),
            clusterTypes = javaType.clusterTypes().map({ args0 -> args0 }),
            clusters = javaType.clusters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.emrv2.kotlin.outputs.GetClustersCluster.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            maxResults = javaType.maxResults().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            nextToken = javaType.nextToken().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            paymentTypes = javaType.paymentTypes().map({ args0 -> args0 }),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalCount = javaType.totalCount(),
        )
    }
}
