@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Disk].
 */
@PulumiTagMarker
public class DiskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskArgs = DiskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskArgsBuilder.() -> Unit) {
        val builder = DiskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Disk {
        val builtJavaResource = com.pulumi.alicloud.ens.Disk(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Disk(builtJavaResource)
    }
}

/**
 * Provides a ENS Disk resource. The disk. When you use it for the first time, please contact the product classmates to add a resource whitelist.
 * For information about ENS Disk and how to use it, see [What is Disk](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createdisk).
 * > **NOTE:** Available since v1.213.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ens.Disk("default", {
 *     category: "cloud_ssd",
 *     size: 20,
 *     paymentType: "PayAsYouGo",
 *     ensRegionId: "cn-chongqing-11",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ens.Disk("default",
 *     category="cloud_ssd",
 *     size=20,
 *     payment_type="PayAsYouGo",
 *     ens_region_id="cn-chongqing-11")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ens.Disk("default", new()
 *     {
 *         Category = "cloud_ssd",
 *         Size = 20,
 *         PaymentType = "PayAsYouGo",
 *         EnsRegionId = "cn-chongqing-11",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewDisk(ctx, "default", &ens.DiskArgs{
 * 			Category:    pulumi.String("cloud_ssd"),
 * 			Size:        pulumi.Int(20),
 * 			PaymentType: pulumi.String("PayAsYouGo"),
 * 			EnsRegionId: pulumi.String("cn-chongqing-11"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.Disk;
 * import com.pulumi.alicloud.ens.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Disk("default", DiskArgs.builder()
 *             .category("cloud_ssd")
 *             .size("20")
 *             .paymentType("PayAsYouGo")
 *             .ensRegionId("cn-chongqing-11")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ens:Disk
 *     properties:
 *       category: cloud_ssd
 *       size: '20'
 *       paymentType: PayAsYouGo
 *       ensRegionId: cn-chongqing-11
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Disk can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/disk:Disk example <id>
 * ```
 */
public class Disk internal constructor(
    override val javaResource: com.pulumi.alicloud.ens.Disk,
) : KotlinCustomResource(javaResource, DiskMapper) {
    /**
     * Types of disk instancesValues: cloud_efficiency (high-efficiency cloud disk),cloud_ssd (full Flash cloud disk),local_hdd (local HDD),local_ssd (local ssd).
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * Disk instance creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Name of the disk instance.
     */
    public val diskName: Output<String>?
        get() = javaResource.diskName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether the cloud disk is Encrypted. If Encrypted = true, the default service key is used when KMSKeyId is not entered. Value range:`true`, `false`(default).
     */
    public val encrypted: Output<Boolean>?
        get() = javaResource.encrypted().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Ens node IDExample value: cn-chengdu-telecom.
     */
    public val ensRegionId: Output<String>
        get() = javaResource.ensRegionId().applyValue({ args0 -> args0 })

    /**
     * The ID of the KMS key used by the cloud disk. If Encrypted is set to true, the service default key is used when KMSKeyId is empty.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Billing type of the disk instanceValue: PayAsYouGo.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The size of the disk instance. Unit: GiB.
     */
    public val size: Output<Int>?
        get() = javaResource.size().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the snapshot used to create the cloud disk.
     * The SnapshotId and Size parameters have the following limitations:
     * - If the snapshot capacity corresponding to the **SnapshotId** parameter is greater than the specified **Size** parameter, the Size of the cloud disk created is the Size of the specified snapshot.
     * - If the snapshot capacity corresponding to the **SnapshotId** parameter is less than the set **Size** parameter value, the Size of the cloud disk created is the specified **Size** parameter value.
     */
    public val snapshotId: Output<String>?
        get() = javaResource.snapshotId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Status of the disk instance:Value:In-use: In useAvailable: To be mountedAttaching: AttachingDetaching: uninstallingCreating: CreatingReIniting: Resetting.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DiskMapper : ResourceMapper<Disk> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ens.Disk::class == javaResource::class

    override fun map(javaResource: Resource): Disk = Disk(
        javaResource as
            com.pulumi.alicloud.ens.Disk,
    )
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Disk].
 */
public suspend fun disk(name: String, block: suspend DiskResourceBuilder.() -> Unit): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 */
public fun disk(name: String): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    return builder.build()
}
