@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.alicloud.ens.DiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ENS Disk resource. The disk. When you use it for the first time, please contact the product classmates to add a resource whitelist.
 * For information about ENS Disk and how to use it, see [What is Disk](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createdisk).
 * > **NOTE:** Available since v1.213.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ens.Disk("default", {
 *     category: "cloud_ssd",
 *     size: 20,
 *     paymentType: "PayAsYouGo",
 *     ensRegionId: "cn-chongqing-11",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ens.Disk("default",
 *     category="cloud_ssd",
 *     size=20,
 *     payment_type="PayAsYouGo",
 *     ens_region_id="cn-chongqing-11")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ens.Disk("default", new()
 *     {
 *         Category = "cloud_ssd",
 *         Size = 20,
 *         PaymentType = "PayAsYouGo",
 *         EnsRegionId = "cn-chongqing-11",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewDisk(ctx, "default", &ens.DiskArgs{
 * 			Category:    pulumi.String("cloud_ssd"),
 * 			Size:        pulumi.Int(20),
 * 			PaymentType: pulumi.String("PayAsYouGo"),
 * 			EnsRegionId: pulumi.String("cn-chongqing-11"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.Disk;
 * import com.pulumi.alicloud.ens.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Disk("default", DiskArgs.builder()
 *             .category("cloud_ssd")
 *             .size("20")
 *             .paymentType("PayAsYouGo")
 *             .ensRegionId("cn-chongqing-11")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ens:Disk
 *     properties:
 *       category: cloud_ssd
 *       size: '20'
 *       paymentType: PayAsYouGo
 *       ensRegionId: cn-chongqing-11
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Disk can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/disk:Disk example <id>
 * ```
 * @property category Types of disk instancesValues: cloud_efficiency (high-efficiency cloud disk),cloud_ssd (full Flash cloud disk),local_hdd (local HDD),local_ssd (local ssd).
 * @property diskName Name of the disk instance.
 * @property encrypted Indicates whether the cloud disk is Encrypted. If Encrypted = true, the default service key is used when KMSKeyId is not entered. Value range:`true`, `false`(default).
 * @property ensRegionId Ens node IDExample value: cn-chengdu-telecom.
 * @property kmsKeyId The ID of the KMS key used by the cloud disk. If Encrypted is set to true, the service default key is used when KMSKeyId is empty.
 * @property paymentType Billing type of the disk instanceValue: PayAsYouGo.
 * @property size The size of the disk instance. Unit: GiB.
 * @property snapshotId The ID of the snapshot used to create the cloud disk.
 * The SnapshotId and Size parameters have the following limitations:
 * - If the snapshot capacity corresponding to the **SnapshotId** parameter is greater than the specified **Size** parameter, the Size of the cloud disk created is the Size of the specified snapshot.
 * - If the snapshot capacity corresponding to the **SnapshotId** parameter is less than the set **Size** parameter value, the Size of the cloud disk created is the specified **Size** parameter value.
 */
public data class DiskArgs(
    public val category: Output<String>? = null,
    public val diskName: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val ensRegionId: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val size: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ens.DiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ens.DiskArgs =
        com.pulumi.alicloud.ens.DiskArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .diskName(diskName?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .ensRegionId(ensRegionId?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskArgs].
 */
@PulumiTagMarker
public class DiskArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var diskName: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var ensRegionId: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var size: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    /**
     * @param value Types of disk instancesValues: cloud_efficiency (high-efficiency cloud disk),cloud_ssd (full Flash cloud disk),local_hdd (local HDD),local_ssd (local ssd).
     */
    @JvmName("psdocjwhvrkasmar")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Name of the disk instance.
     */
    @JvmName("jalfyukljqqeosla")
    public suspend fun diskName(`value`: Output<String>) {
        this.diskName = value
    }

    /**
     * @param value Indicates whether the cloud disk is Encrypted. If Encrypted = true, the default service key is used when KMSKeyId is not entered. Value range:`true`, `false`(default).
     */
    @JvmName("istikswofqxyyana")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value Ens node IDExample value: cn-chengdu-telecom.
     */
    @JvmName("eovlytiwhntfxjap")
    public suspend fun ensRegionId(`value`: Output<String>) {
        this.ensRegionId = value
    }

    /**
     * @param value The ID of the KMS key used by the cloud disk. If Encrypted is set to true, the service default key is used when KMSKeyId is empty.
     */
    @JvmName("gadiqfwwffcwakxb")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Billing type of the disk instanceValue: PayAsYouGo.
     */
    @JvmName("jwjnonjskavmxxgg")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The size of the disk instance. Unit: GiB.
     */
    @JvmName("toxdlnjqrcdvgxmv")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value The ID of the snapshot used to create the cloud disk.
     * The SnapshotId and Size parameters have the following limitations:
     * - If the snapshot capacity corresponding to the **SnapshotId** parameter is greater than the specified **Size** parameter, the Size of the cloud disk created is the Size of the specified snapshot.
     * - If the snapshot capacity corresponding to the **SnapshotId** parameter is less than the set **Size** parameter value, the Size of the cloud disk created is the specified **Size** parameter value.
     */
    @JvmName("nliqmnbqxhdnkusm")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value Types of disk instancesValues: cloud_efficiency (high-efficiency cloud disk),cloud_ssd (full Flash cloud disk),local_hdd (local HDD),local_ssd (local ssd).
     */
    @JvmName("kpyklaqjwxxjeime")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Name of the disk instance.
     */
    @JvmName("kmxvjquijxcqjphe")
    public suspend fun diskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskName = mapped
    }

    /**
     * @param value Indicates whether the cloud disk is Encrypted. If Encrypted = true, the default service key is used when KMSKeyId is not entered. Value range:`true`, `false`(default).
     */
    @JvmName("qjauvdbwpobfvfmh")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value Ens node IDExample value: cn-chengdu-telecom.
     */
    @JvmName("koabfogmmsjjudni")
    public suspend fun ensRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ensRegionId = mapped
    }

    /**
     * @param value The ID of the KMS key used by the cloud disk. If Encrypted is set to true, the service default key is used when KMSKeyId is empty.
     */
    @JvmName("lqlqsssjdcxhgoal")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Billing type of the disk instanceValue: PayAsYouGo.
     */
    @JvmName("utdcelqtgkgfgjtw")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The size of the disk instance. Unit: GiB.
     */
    @JvmName("sbmiqsaxffdjvxse")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The ID of the snapshot used to create the cloud disk.
     * The SnapshotId and Size parameters have the following limitations:
     * - If the snapshot capacity corresponding to the **SnapshotId** parameter is greater than the specified **Size** parameter, the Size of the cloud disk created is the Size of the specified snapshot.
     * - If the snapshot capacity corresponding to the **SnapshotId** parameter is less than the set **Size** parameter value, the Size of the cloud disk created is the specified **Size** parameter value.
     */
    @JvmName("swpuykgtquoexplh")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    internal fun build(): DiskArgs = DiskArgs(
        category = category,
        diskName = diskName,
        encrypted = encrypted,
        ensRegionId = ensRegionId,
        kmsKeyId = kmsKeyId,
        paymentType = paymentType,
        size = size,
        snapshotId = snapshotId,
    )
}
