@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Eip].
 */
@PulumiTagMarker
public class EipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EipArgs = EipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EipArgsBuilder.() -> Unit) {
        val builder = EipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Eip {
        val builtJavaResource = com.pulumi.alicloud.ens.Eip(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Eip(builtJavaResource)
    }
}

/**
 * Provides a ENS Eip resource. Edge elastic public network IP. When you use it for the first time, please contact the product classmates to add a resource whitelist.
 * For information about ENS Eip and how to use it, see [What is Eip](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createeipinstance).
 * > **NOTE:** Available since v1.213.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ens.Eip("default", {
 *     description: "EipDescription_autotest",
 *     bandwidth: 5,
 *     isp: "cmcc",
 *     paymentType: "PayAsYouGo",
 *     ensRegionId: "cn-chenzhou-telecom_unicom_cmcc",
 *     eipName: name,
 *     internetChargeType: "95BandwidthByMonth",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ens.Eip("default",
 *     description="EipDescription_autotest",
 *     bandwidth=5,
 *     isp="cmcc",
 *     payment_type="PayAsYouGo",
 *     ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
 *     eip_name=name,
 *     internet_charge_type="95BandwidthByMonth")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ens.Eip("default", new()
 *     {
 *         Description = "EipDescription_autotest",
 *         Bandwidth = 5,
 *         Isp = "cmcc",
 *         PaymentType = "PayAsYouGo",
 *         EnsRegionId = "cn-chenzhou-telecom_unicom_cmcc",
 *         EipName = name,
 *         InternetChargeType = "95BandwidthByMonth",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewEip(ctx, "default", &ens.EipArgs{
 * 			Description:        pulumi.String("EipDescription_autotest"),
 * 			Bandwidth:          pulumi.Int(5),
 * 			Isp:                pulumi.String("cmcc"),
 * 			PaymentType:        pulumi.String("PayAsYouGo"),
 * 			EnsRegionId:        pulumi.String("cn-chenzhou-telecom_unicom_cmcc"),
 * 			EipName:            pulumi.String(name),
 * 			InternetChargeType: pulumi.String("95BandwidthByMonth"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.Eip;
 * import com.pulumi.alicloud.ens.EipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Eip("default", EipArgs.builder()
 *             .description("EipDescription_autotest")
 *             .bandwidth("5")
 *             .isp("cmcc")
 *             .paymentType("PayAsYouGo")
 *             .ensRegionId("cn-chenzhou-telecom_unicom_cmcc")
 *             .eipName(name)
 *             .internetChargeType("95BandwidthByMonth")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ens:Eip
 *     properties:
 *       description: EipDescription_autotest
 *       bandwidth: '5'
 *       isp: cmcc
 *       paymentType: PayAsYouGo
 *       ensRegionId: cn-chenzhou-telecom_unicom_cmcc
 *       eipName: ${name}
 *       internetChargeType: 95BandwidthByMonth
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Eip can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/eip:Eip example <id>
 * ```
 */
public class Eip internal constructor(
    override val javaResource: com.pulumi.alicloud.ens.Eip,
) : KotlinCustomResource(javaResource, EipMapper) {
    /**
     * The peak bandwidth of the EIP to be specified.Rules:Default value: 5, value range: 5~10000, unit: Mbps. Example value: 5.
     */
    public val bandwidth: Output<Int>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    /**
     * The creation time of the EIP instance.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the EIP.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the EIP instance.
     */
    public val eipName: Output<String>?
        get() = javaResource.eipName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Ens node ID.
     */
    public val ensRegionId: Output<String>
        get() = javaResource.ensRegionId().applyValue({ args0 -> args0 })

    /**
     * Billing type of the EIP instance. Valid value: 95bandwidthbymonth.
     */
    public val internetChargeType: Output<String>
        get() = javaResource.internetChargeType().applyValue({ args0 -> args0 })

    /**
     * Internet service provider, if not filled in, it will be assigned according to the default rules.
     */
    public val isp: Output<String>
        get() = javaResource.isp().applyValue({ args0 -> args0 })

    /**
     * The billing type of the EIP instanceValue: PayAsYouGo.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The status of the EIP instance.Rules:Associating: bindingUnassociating: UnbindingInUse: AssignedAvailable: AvailableCreating: CreatingReleasing: Releasing.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object EipMapper : ResourceMapper<Eip> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ens.Eip::class == javaResource::class

    override fun map(javaResource: Resource): Eip = Eip(javaResource as com.pulumi.alicloud.ens.Eip)
}

/**
 * @see [Eip].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Eip].
 */
public suspend fun eip(name: String, block: suspend EipResourceBuilder.() -> Unit): Eip {
    val builder = EipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Eip].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eip(name: String): Eip {
    val builder = EipResourceBuilder()
    builder.name(name)
    return builder.build()
}
