@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.alicloud.ens.EipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ENS Eip resource. Edge elastic public network IP. When you use it for the first time, please contact the product classmates to add a resource whitelist.
 * For information about ENS Eip and how to use it, see [What is Eip](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createeipinstance).
 * > **NOTE:** Available since v1.213.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ens.Eip("default", {
 *     description: "EipDescription_autotest",
 *     bandwidth: 5,
 *     isp: "cmcc",
 *     paymentType: "PayAsYouGo",
 *     ensRegionId: "cn-chenzhou-telecom_unicom_cmcc",
 *     eipName: name,
 *     internetChargeType: "95BandwidthByMonth",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ens.Eip("default",
 *     description="EipDescription_autotest",
 *     bandwidth=5,
 *     isp="cmcc",
 *     payment_type="PayAsYouGo",
 *     ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
 *     eip_name=name,
 *     internet_charge_type="95BandwidthByMonth")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ens.Eip("default", new()
 *     {
 *         Description = "EipDescription_autotest",
 *         Bandwidth = 5,
 *         Isp = "cmcc",
 *         PaymentType = "PayAsYouGo",
 *         EnsRegionId = "cn-chenzhou-telecom_unicom_cmcc",
 *         EipName = name,
 *         InternetChargeType = "95BandwidthByMonth",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewEip(ctx, "default", &ens.EipArgs{
 * 			Description:        pulumi.String("EipDescription_autotest"),
 * 			Bandwidth:          pulumi.Int(5),
 * 			Isp:                pulumi.String("cmcc"),
 * 			PaymentType:        pulumi.String("PayAsYouGo"),
 * 			EnsRegionId:        pulumi.String("cn-chenzhou-telecom_unicom_cmcc"),
 * 			EipName:            pulumi.String(name),
 * 			InternetChargeType: pulumi.String("95BandwidthByMonth"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.Eip;
 * import com.pulumi.alicloud.ens.EipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Eip("default", EipArgs.builder()
 *             .description("EipDescription_autotest")
 *             .bandwidth("5")
 *             .isp("cmcc")
 *             .paymentType("PayAsYouGo")
 *             .ensRegionId("cn-chenzhou-telecom_unicom_cmcc")
 *             .eipName(name)
 *             .internetChargeType("95BandwidthByMonth")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ens:Eip
 *     properties:
 *       description: EipDescription_autotest
 *       bandwidth: '5'
 *       isp: cmcc
 *       paymentType: PayAsYouGo
 *       ensRegionId: cn-chenzhou-telecom_unicom_cmcc
 *       eipName: ${name}
 *       internetChargeType: 95BandwidthByMonth
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Eip can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/eip:Eip example <id>
 * ```
 * @property bandwidth The peak bandwidth of the EIP to be specified.Rules:Default value: 5, value range: 5~10000, unit: Mbps. Example value: 5.
 * @property description The description of the EIP.
 * @property eipName Name of the EIP instance.
 * @property ensRegionId Ens node ID.
 * @property internetChargeType Billing type of the EIP instance. Valid value: 95bandwidthbymonth.
 * @property isp Internet service provider, if not filled in, it will be assigned according to the default rules.
 * @property paymentType The billing type of the EIP instanceValue: PayAsYouGo.
 */
public data class EipArgs(
    public val bandwidth: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val eipName: Output<String>? = null,
    public val ensRegionId: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val isp: Output<String>? = null,
    public val paymentType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ens.EipArgs> {
    override fun toJava(): com.pulumi.alicloud.ens.EipArgs = com.pulumi.alicloud.ens.EipArgs.builder()
        .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .eipName(eipName?.applyValue({ args0 -> args0 }))
        .ensRegionId(ensRegionId?.applyValue({ args0 -> args0 }))
        .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
        .isp(isp?.applyValue({ args0 -> args0 }))
        .paymentType(paymentType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EipArgs].
 */
@PulumiTagMarker
public class EipArgsBuilder internal constructor() {
    private var bandwidth: Output<Int>? = null

    private var description: Output<String>? = null

    private var eipName: Output<String>? = null

    private var ensRegionId: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var isp: Output<String>? = null

    private var paymentType: Output<String>? = null

    /**
     * @param value The peak bandwidth of the EIP to be specified.Rules:Default value: 5, value range: 5~10000, unit: Mbps. Example value: 5.
     */
    @JvmName("tmkmogiibteasxyi")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value The description of the EIP.
     */
    @JvmName("haaundrdqaegwotk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the EIP instance.
     */
    @JvmName("rdphurpeghdkawfw")
    public suspend fun eipName(`value`: Output<String>) {
        this.eipName = value
    }

    /**
     * @param value Ens node ID.
     */
    @JvmName("uuueiucfqruhngwi")
    public suspend fun ensRegionId(`value`: Output<String>) {
        this.ensRegionId = value
    }

    /**
     * @param value Billing type of the EIP instance. Valid value: 95bandwidthbymonth.
     */
    @JvmName("cefulcalseknddlq")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value Internet service provider, if not filled in, it will be assigned according to the default rules.
     */
    @JvmName("gkhfhdbdqlyucixk")
    public suspend fun isp(`value`: Output<String>) {
        this.isp = value
    }

    /**
     * @param value The billing type of the EIP instanceValue: PayAsYouGo.
     */
    @JvmName("ciotmifhuhiodgdu")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The peak bandwidth of the EIP to be specified.Rules:Default value: 5, value range: 5~10000, unit: Mbps. Example value: 5.
     */
    @JvmName("wccnjvafnshlnxur")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The description of the EIP.
     */
    @JvmName("evtvxxxqgcgkgwpl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the EIP instance.
     */
    @JvmName("jnnhbbceiciaepjn")
    public suspend fun eipName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipName = mapped
    }

    /**
     * @param value Ens node ID.
     */
    @JvmName("wuiuwhoxgakuduhi")
    public suspend fun ensRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ensRegionId = mapped
    }

    /**
     * @param value Billing type of the EIP instance. Valid value: 95bandwidthbymonth.
     */
    @JvmName("wslojxlshlxcsell")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value Internet service provider, if not filled in, it will be assigned according to the default rules.
     */
    @JvmName("obsnwkfqgxkkbgkw")
    public suspend fun isp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isp = mapped
    }

    /**
     * @param value The billing type of the EIP instanceValue: PayAsYouGo.
     */
    @JvmName("vmyeqsirwtrklyll")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    internal fun build(): EipArgs = EipArgs(
        bandwidth = bandwidth,
        description = description,
        eipName = eipName,
        ensRegionId = ensRegionId,
        internetChargeType = internetChargeType,
        isp = isp,
        paymentType = paymentType,
    )
}
