@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.alicloud.ens.EnsFunctions.getKeyPairsPlain
import com.pulumi.alicloud.ens.kotlin.inputs.GetKeyPairsPlainArgs
import com.pulumi.alicloud.ens.kotlin.inputs.GetKeyPairsPlainArgsBuilder
import com.pulumi.alicloud.ens.kotlin.outputs.GetKeyPairsResult
import com.pulumi.alicloud.ens.kotlin.outputs.GetKeyPairsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object EnsFunctions {
    /**
     * This data source provides the Ens Key Pairs of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.133.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const nameRegex = alicloud.ens.getKeyPairs({
     *     version: "example_value",
     *     nameRegex: "^my-KeyPair",
     * });
     * export const ensKeyPairId1 = nameRegex.then(nameRegex => nameRegex.pairs?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * name_regex = alicloud.ens.get_key_pairs(version="example_value",
     *     name_regex="^my-KeyPair")
     * pulumi.export("ensKeyPairId1", name_regex.pairs[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var nameRegex = AliCloud.Ens.GetKeyPairs.Invoke(new()
     *     {
     *         Version = "example_value",
     *         NameRegex = "^my-KeyPair",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["ensKeyPairId1"] = nameRegex&#46;Apply(getKeyPairsResult => getKeyPairsResult&#46;Pairs[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		nameRegex, err := ens.GetKeyPairs(ctx, &ens.GetKeyPairsArgs{
     * 			Version:   "example_value",
     * 			NameRegex: pulumi.StringRef("^my-KeyPair"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("ensKeyPairId1", nameRegex.Pairs[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ens.EnsFunctions;
     * import com.pulumi.alicloud.ens.inputs.GetKeyPairsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var nameRegex = EnsFunctions.getKeyPairs(GetKeyPairsArgs.builder()
     *             .version("example_value")
     *             .nameRegex("^my-KeyPair")
     *             .build());
     *         ctx.export("ensKeyPairId1", nameRegex.applyValue(getKeyPairsResult -> getKeyPairsResult.pairs()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:ens:getKeyPairs
     *       Arguments:
     *         version: example_value
     *         nameRegex: ^my-KeyPair
     * outputs:
     *   ensKeyPairId1: ${nameRegex.pairs[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getKeyPairs.
     * @return A collection of values returned by getKeyPairs.
     */
    public suspend fun getKeyPairs(argument: GetKeyPairsPlainArgs): GetKeyPairsResult =
        toKotlin(getKeyPairsPlain(argument.toJava()).await())

    /**
     * @see [getKeyPairs].
     * @param keyPairName The name of the key pair.
     * @param nameRegex A regex string to filter results by Key Pair name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param version The version number.
     * @return A collection of values returned by getKeyPairs.
     */
    public suspend fun getKeyPairs(
        keyPairName: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        version: String,
    ): GetKeyPairsResult {
        val argument = GetKeyPairsPlainArgs(
            keyPairName = keyPairName,
            nameRegex = nameRegex,
            outputFile = outputFile,
            version = version,
        )
        return toKotlin(getKeyPairsPlain(argument.toJava()).await())
    }

    /**
     * @see [getKeyPairs].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ens&#46;kotlin&#46;inputs&#46;GetKeyPairsPlainArgs].
     * @return A collection of values returned by getKeyPairs.
     */
    public suspend fun getKeyPairs(argument: suspend GetKeyPairsPlainArgsBuilder.() -> Unit): GetKeyPairsResult {
        val builder = GetKeyPairsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getKeyPairsPlain(builtArgument.toJava()).await())
    }
}
