@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Image].
 */
@PulumiTagMarker
public class ImageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImageArgs = ImageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImageArgsBuilder.() -> Unit) {
        val builder = ImageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Image {
        val builtJavaResource = com.pulumi.alicloud.ens.Image(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Image(builtJavaResource)
    }
}

/**
 * Provides a ENS Image resource.
 * For information about ENS Image and how to use it, see [What is Image](https://www.alibabacloud.com/help/en/).
 * > **NOTE:** Available since v1.216.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ens.Instance("default", {
 *     systemDisk: {
 *         size: 20,
 *     },
 *     scheduleAreaLevel: "Region",
 *     imageId: "centos_6_08_64_20G_alibase_20171208",
 *     paymentType: "PayAsYouGo",
 *     password: "12345678ABCabc",
 *     amount: 1,
 *     internetMaxBandwidthOut: 10,
 *     publicIpIdentification: true,
 *     ensRegionId: "cn-chenzhou-telecom_unicom_cmcc",
 *     periodUnit: "Month",
 *     instanceType: "ens.sn1.stiny",
 *     status: "Stopped",
 * });
 * const defaultImage = new alicloud.ens.Image("default", {
 *     imageName: name,
 *     instanceId: _default.id,
 *     deleteAfterImageUpload: "false",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ens.Instance("default",
 *     system_disk={
 *         "size": 20,
 *     },
 *     schedule_area_level="Region",
 *     image_id="centos_6_08_64_20G_alibase_20171208",
 *     payment_type="PayAsYouGo",
 *     password="12345678ABCabc",
 *     amount=1,
 *     internet_max_bandwidth_out=10,
 *     public_ip_identification=True,
 *     ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
 *     period_unit="Month",
 *     instance_type="ens.sn1.stiny",
 *     status="Stopped")
 * default_image = alicloud.ens.Image("default",
 *     image_name=name,
 *     instance_id=default.id,
 *     delete_after_image_upload="false")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ens.Instance("default", new()
 *     {
 *         SystemDisk = new AliCloud.Ens.Inputs.InstanceSystemDiskArgs
 *         {
 *             Size = 20,
 *         },
 *         ScheduleAreaLevel = "Region",
 *         ImageId = "centos_6_08_64_20G_alibase_20171208",
 *         PaymentType = "PayAsYouGo",
 *         Password = "12345678ABCabc",
 *         Amount = 1,
 *         InternetMaxBandwidthOut = 10,
 *         PublicIpIdentification = true,
 *         EnsRegionId = "cn-chenzhou-telecom_unicom_cmcc",
 *         PeriodUnit = "Month",
 *         InstanceType = "ens.sn1.stiny",
 *         Status = "Stopped",
 *     });
 *     var defaultImage = new AliCloud.Ens.Image("default", new()
 *     {
 *         ImageName = name,
 *         InstanceId = @default.Id,
 *         DeleteAfterImageUpload = "false",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewInstance(ctx, "default", &ens.InstanceArgs{
 * 			SystemDisk: &ens.InstanceSystemDiskArgs{
 * 				Size: pulumi.Int(20),
 * 			},
 * 			ScheduleAreaLevel:       pulumi.String("Region"),
 * 			ImageId:                 pulumi.String("centos_6_08_64_20G_alibase_20171208"),
 * 			PaymentType:             pulumi.String("PayAsYouGo"),
 * 			Password:                pulumi.String("12345678ABCabc"),
 * 			Amount:                  pulumi.Int(1),
 * 			InternetMaxBandwidthOut: pulumi.Int(10),
 * 			PublicIpIdentification:  pulumi.Bool(true),
 * 			EnsRegionId:             pulumi.String("cn-chenzhou-telecom_unicom_cmcc"),
 * 			PeriodUnit:              pulumi.String("Month"),
 * 			InstanceType:            pulumi.String("ens.sn1.stiny"),
 * 			Status:                  pulumi.String("Stopped"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ens.NewImage(ctx, "default", &ens.ImageArgs{
 * 			ImageName:              pulumi.String(name),
 * 			InstanceId:             _default.ID(),
 * 			DeleteAfterImageUpload: pulumi.String("false"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.Instance;
 * import com.pulumi.alicloud.ens.InstanceArgs;
 * import com.pulumi.alicloud.ens.inputs.InstanceSystemDiskArgs;
 * import com.pulumi.alicloud.ens.Image;
 * import com.pulumi.alicloud.ens.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .systemDisk(InstanceSystemDiskArgs.builder()
 *                 .size("20")
 *                 .build())
 *             .scheduleAreaLevel("Region")
 *             .imageId("centos_6_08_64_20G_alibase_20171208")
 *             .paymentType("PayAsYouGo")
 *             .password("12345678ABCabc")
 *             .amount("1")
 *             .internetMaxBandwidthOut("10")
 *             .publicIpIdentification(true)
 *             .ensRegionId("cn-chenzhou-telecom_unicom_cmcc")
 *             .periodUnit("Month")
 *             .instanceType("ens.sn1.stiny")
 *             .status("Stopped")
 *             .build());
 *         var defaultImage = new Image("defaultImage", ImageArgs.builder()
 *             .imageName(name)
 *             .instanceId(default_.id())
 *             .deleteAfterImageUpload("false")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ens:Instance
 *     properties:
 *       systemDisk:
 *         size: '20'
 *       scheduleAreaLevel: Region
 *       imageId: centos_6_08_64_20G_alibase_20171208
 *       paymentType: PayAsYouGo
 *       password: 12345678ABCabc
 *       amount: '1'
 *       internetMaxBandwidthOut: '10'
 *       publicIpIdentification: true
 *       ensRegionId: cn-chenzhou-telecom_unicom_cmcc
 *       periodUnit: Month
 *       instanceType: ens.sn1.stiny
 *       status: Stopped
 *   defaultImage:
 *     type: alicloud:ens:Image
 *     name: default
 *     properties:
 *       imageName: ${name}
 *       instanceId: ${default.id}
 *       deleteAfterImageUpload: 'false'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Image can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/image:Image example <id>
 * ```
 */
public class Image internal constructor(
    override val javaResource: com.pulumi.alicloud.ens.Image,
) : KotlinCustomResource(javaResource, ImageMapper) {
    /**
     * Image creation time.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Whether the instance is automatically released after the image is packaged and uploaded successfully, only the build machine is supported.  Optional values: true: When the instance is released, the image is released together with the instance. false: When the instance is released, the image is retained and is not released together with the instance. Empty means false by default.
     */
    public val deleteAfterImageUpload: Output<String>?
        get() = javaResource.deleteAfterImageUpload().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Image Name.
     */
    public val imageName: Output<String>
        get() = javaResource.imageName().applyValue({ args0 -> args0 })

    /**
     * The ID of the instance corresponding to the image.
     */
    public val instanceId: Output<String>?
        get() = javaResource.instanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Mirror Status  Optional values: Creating: Creating Packing: Packing Uploading: Uploading Pack_failed: Packing failed Upload_failed: Upload failed Available: Only images in the Available state can be used and operated. Unavailable: Not available Copying: Copying.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object ImageMapper : ResourceMapper<Image> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ens.Image::class == javaResource::class

    override fun map(javaResource: Resource): Image = Image(
        javaResource as
            com.pulumi.alicloud.ens.Image,
    )
}

/**
 * @see [Image].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Image].
 */
public suspend fun image(name: String, block: suspend ImageResourceBuilder.() -> Unit): Image {
    val builder = ImageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Image].
 * @param name The _unique_ name of the resulting resource.
 */
public fun image(name: String): Image {
    val builder = ImageResourceBuilder()
    builder.name(name)
    return builder.build()
}
