@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.alicloud.ens.kotlin.outputs.InstanceDataDisk
import com.pulumi.alicloud.ens.kotlin.outputs.InstanceSystemDisk
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.ens.kotlin.outputs.InstanceDataDisk.Companion.toKotlin as instanceDataDiskToKotlin
import com.pulumi.alicloud.ens.kotlin.outputs.InstanceSystemDisk.Companion.toKotlin as instanceSystemDiskToKotlin

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.ens.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * ENS Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/instance:Instance example <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.ens.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * The number of instances created, with a minimum of 1 and a maximum of 100.
     */
    public val amount: Output<Int>?
        get() = javaResource.amount().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to automatically renew the logo. The default value is false. This parameter is invalid when you pay by volume.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to use vouchers. The default is to use. Value:
     * - true (used)
     * - false (not used).
     */
    public val autoUseCoupon: Output<String>?
        get() = javaResource.autoUseCoupon().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The billing cycle for instance computing resources. Only instance-level pay-as-you-go is supported. Value
     * - Hour: hourly billing
     * - Day: Daily billing
     * - Month: monthly billing.
     */
    public val billingCycle: Output<String>?
        get() = javaResource.billingCycle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Operator, required for regional scheduling. Optional values:
     * - cmcc (mobile)
     * - unicom
     * - telecom.
     */
    public val carrier: Output<String>?
        get() = javaResource.carrier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Data disk specifications. See `data_disk` below.
     */
    public val dataDisks: Output<List<InstanceDataDisk>>
        get() = javaResource.dataDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    instanceDataDiskToKotlin(args0)
                })
            })
        })

    /**
     * The node ID. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big,Middle,Small, EnsRegionId is invalid.
     */
    public val ensRegionId: Output<String>
        get() = javaResource.ensRegionId().applyValue({ args0 -> args0 })

    /**
     * Whether to force the identity when operating the instance. Optional values:
     * - true: Force
     * - false (default): non-mandatory
     */
    public val forceStop: Output<String>?
        get() = javaResource.forceStop().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The host name of the instance. Example value: test-HostName.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * The image ID of the instance. The arm version card cannot be filled in. Other specifications are required. Example value: m-5si16wo6simkt267p8b7h * * * *.
     */
    public val imageId: Output<String>?
        get() = javaResource.imageId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether the Payment type of the disk created with the instance is converted.
     */
    public val includeDataDisks: Output<Boolean>?
        get() = javaResource.includeDataDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The instance billing policy. Optional values:
     * - instance: instance granularity (the subscription method does not support instance)
     * - user: user Dimension (user is not transmitted or supported in the prepaid mode).
     */
    public val instanceChargeStrategy: Output<String>?
        get() = javaResource.instanceChargeStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The instance name. Example value: test-InstanceName. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-) The default value is the InstanceId of the instance. .
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * The specification of the instance. Example value: ens.sn1.small.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Instance bandwidth billing method. If the billing method can be selected for the first purchase, the subsequent value of this field will be processed by default according to the billing method selected for the first time. Optional values:
     * - BandwidthByDay: Daily peak bandwidth
     * - 95bandwidthbymonth: 95 peak bandwidth.
     */
    public val internetChargeType: Output<String>?
        get() = javaResource.internetChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum public network bandwidth. The field type is Long, and the precision may be lost during serialization/deserialization. Please note that the value must not be greater than 9007199254740991.
     */
    public val internetMaxBandwidthOut: Output<Int>
        get() = javaResource.internetMaxBandwidthOut().applyValue({ args0 -> args0 })

    /**
     * The IP type. Value:
     * - ipv4 (default):IPv4
     * - ipv6:IPv6
     * - ipv4Andipv6:IPv4 and IPv6.
     */
    public val ipType: Output<String>?
        get() = javaResource.ipType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The area code. Example value: 350000. Required for regional-level scheduling, invalid for node-level scheduling.
     */
    public val netDistrictCode: Output<String>?
        get() = javaResource.netDistrictCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The network ID of the instance. Can only be used in node-level scheduling.
     */
    public val netWorkId: Output<String>
        get() = javaResource.netWorkId().applyValue({ args0 -> args0 })

    /**
     * The instance password. At least one of Password, KeyPairName, and PasswordInherit.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed.
     */
    public val passwordInherit: Output<Boolean>?
        get() = javaResource.passwordInherit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance payment method. Optional values:
     * - Subscription: prepaid, annual and monthly
     * - PayAsYouGo: Pay by volume.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The duration of the resource purchase. Value method:
     * - If PeriodUnit is set to Day, Period can only be set to 3.
     * - If PeriodUnit is set to Month, Period can be set to 1-9,12.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The unit of time for purchasing resources. Value:
     * - Month (default): purchase by Month
     * - Day: buy by Day.
     */
    public val periodUnit: Output<String>?
        get() = javaResource.periodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The private IP address. Can only be used for node-level scheduling. If a private IP address is specified, the number of instances can only be one, and both the private IP address and the vSwitch ID are not empty, the private IP address takes effect.
     */
    public val privateIpAddress: Output<String>
        get() = javaResource.privateIpAddress().applyValue({ args0 -> args0 })

    /**
     * Whether to assign a public IP identifier. Value:
     * - true (default): Assign
     * - false: do not assign.
     */
    public val publicIpIdentification: Output<Boolean>?
        get() = javaResource.publicIpIdentification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Scheduling level, through which node-level scheduling or area scheduling is performed. Optional values:
     * - Node-level scheduling: Region
     * - Regional scheduling: Big (region),Middle (province),Small (city).
     */
    public val scheduleAreaLevel: Output<String>
        get() = javaResource.scheduleAreaLevel().applyValue({ args0 -> args0 })

    /**
     * Scheduling price policy. If it is not filled in, the default priority is low price. Value:
     * - PriceLowPriority
     * - PriceLowPriority (priority low price).
     */
    public val schedulingPriceStrategy: Output<String>?
        get() = javaResource.schedulingPriceStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Scheduling policy. Optional values:
     * - Concentrate for node-level scheduling
     * - For regional scheduling, Concentrate, Disperse.
     */
    public val schedulingStrategy: Output<String>?
        get() = javaResource.schedulingStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of the security group to which the instance belongs.
     */
    public val securityId: Output<String>
        get() = javaResource.securityId().applyValue({ args0 -> args0 })

    /**
     * Status of the instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
     */
    public val systemDisk: Output<InstanceSystemDisk>?
        get() = javaResource.systemDisk().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    instanceSystemDiskToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Indicates whether to add an ordered suffix to HostName and InstanceName. The ordered suffix starts from 001 and cannot exceed 999.
     */
    public val uniqueSuffix: Output<Boolean>?
        get() = javaResource.uniqueSuffix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User-defined data, maximum support 16KB. You can pass in the UserData information. The UserData is encoded in Base64 format.
     */
    public val userData: Output<String>?
        get() = javaResource.userData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the vSwitch to which the instance belongs. Can only be used in node-level scheduling.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ens.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.ens.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
