@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.alicloud.ens.InstanceArgs.builder
import com.pulumi.alicloud.ens.kotlin.inputs.InstanceDataDiskArgs
import com.pulumi.alicloud.ens.kotlin.inputs.InstanceDataDiskArgsBuilder
import com.pulumi.alicloud.ens.kotlin.inputs.InstanceSystemDiskArgs
import com.pulumi.alicloud.ens.kotlin.inputs.InstanceSystemDiskArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * ENS Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/instance:Instance example <id>
 * ```
 * @property amount The number of instances created, with a minimum of 1 and a maximum of 100.
 * @property autoRenew Whether to automatically renew the logo. The default value is false. This parameter is invalid when you pay by volume.
 * @property autoUseCoupon Whether to use vouchers. The default is to use. Value:
 * - true (used)
 * - false (not used).
 * @property billingCycle The billing cycle for instance computing resources. Only instance-level pay-as-you-go is supported. Value
 * - Hour: hourly billing
 * - Day: Daily billing
 * - Month: monthly billing.
 * @property carrier Operator, required for regional scheduling. Optional values:
 * - cmcc (mobile)
 * - unicom
 * - telecom.
 * @property dataDisks Data disk specifications. See `data_disk` below.
 * @property ensRegionId The node ID. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big,Middle,Small, EnsRegionId is invalid.
 * @property forceStop Whether to force the identity when operating the instance. Optional values:
 * - true: Force
 * - false (default): non-mandatory
 * @property hostName The host name of the instance. Example value: test-HostName.
 * @property imageId The image ID of the instance. The arm version card cannot be filled in. Other specifications are required. Example value: m-5si16wo6simkt267p8b7h * * * *.
 * @property includeDataDisks Whether the Payment type of the disk created with the instance is converted.
 * @property instanceChargeStrategy The instance billing policy. Optional values:
 * - instance: instance granularity (the subscription method does not support instance)
 * - user: user Dimension (user is not transmitted or supported in the prepaid mode).
 * @property instanceName The instance name. Example value: test-InstanceName. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-) The default value is the InstanceId of the instance. .
 * @property instanceType The specification of the instance. Example value: ens.sn1.small.
 * @property internetChargeType Instance bandwidth billing method. If the billing method can be selected for the first purchase, the subsequent value of this field will be processed by default according to the billing method selected for the first time. Optional values:
 * - BandwidthByDay: Daily peak bandwidth
 * - 95bandwidthbymonth: 95 peak bandwidth.
 * @property internetMaxBandwidthOut Maximum public network bandwidth. The field type is Long, and the precision may be lost during serialization/deserialization. Please note that the value must not be greater than 9007199254740991.
 * @property ipType The IP type. Value:
 * - ipv4 (default):IPv4
 * - ipv6:IPv6
 * - ipv4Andipv6:IPv4 and IPv6.
 * @property netDistrictCode The area code. Example value: 350000. Required for regional-level scheduling, invalid for node-level scheduling.
 * @property netWorkId The network ID of the instance. Can only be used in node-level scheduling.
 * @property password The instance password. At least one of Password, KeyPairName, and PasswordInherit.
 * @property passwordInherit Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed.
 * @property paymentType Instance payment method. Optional values:
 * - Subscription: prepaid, annual and monthly
 * - PayAsYouGo: Pay by volume.
 * @property period The duration of the resource purchase. Value method:
 * - If PeriodUnit is set to Day, Period can only be set to 3.
 * - If PeriodUnit is set to Month, Period can be set to 1-9,12.
 * @property periodUnit The unit of time for purchasing resources. Value:
 * - Month (default): purchase by Month
 * - Day: buy by Day.
 * @property privateIpAddress The private IP address. Can only be used for node-level scheduling. If a private IP address is specified, the number of instances can only be one, and both the private IP address and the vSwitch ID are not empty, the private IP address takes effect.
 * @property publicIpIdentification Whether to assign a public IP identifier. Value:
 * - true (default): Assign
 * - false: do not assign.
 * @property scheduleAreaLevel Scheduling level, through which node-level scheduling or area scheduling is performed. Optional values:
 * - Node-level scheduling: Region
 * - Regional scheduling: Big (region),Middle (province),Small (city).
 * @property schedulingPriceStrategy Scheduling price policy. If it is not filled in, the default priority is low price. Value:
 * - PriceLowPriority
 * - PriceLowPriority (priority low price).
 * @property schedulingStrategy Scheduling policy. Optional values:
 * - Concentrate for node-level scheduling
 * - For regional scheduling, Concentrate, Disperse.
 * @property securityId ID of the security group to which the instance belongs.
 * @property status Status of the instance.
 * @property systemDisk System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
 * @property uniqueSuffix Indicates whether to add an ordered suffix to HostName and InstanceName. The ordered suffix starts from 001 and cannot exceed 999.
 * @property userData User-defined data, maximum support 16KB. You can pass in the UserData information. The UserData is encoded in Base64 format.
 * @property vswitchId The ID of the vSwitch to which the instance belongs. Can only be used in node-level scheduling.
 */
public data class InstanceArgs(
    public val amount: Output<Int>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val autoUseCoupon: Output<String>? = null,
    public val billingCycle: Output<String>? = null,
    public val carrier: Output<String>? = null,
    public val dataDisks: Output<List<InstanceDataDiskArgs>>? = null,
    public val ensRegionId: Output<String>? = null,
    public val forceStop: Output<String>? = null,
    public val hostName: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val includeDataDisks: Output<Boolean>? = null,
    public val instanceChargeStrategy: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val internetMaxBandwidthOut: Output<Int>? = null,
    public val ipType: Output<String>? = null,
    public val netDistrictCode: Output<String>? = null,
    public val netWorkId: Output<String>? = null,
    public val password: Output<String>? = null,
    public val passwordInherit: Output<Boolean>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val publicIpIdentification: Output<Boolean>? = null,
    public val scheduleAreaLevel: Output<String>? = null,
    public val schedulingPriceStrategy: Output<String>? = null,
    public val schedulingStrategy: Output<String>? = null,
    public val securityId: Output<String>? = null,
    public val status: Output<String>? = null,
    public val systemDisk: Output<InstanceSystemDiskArgs>? = null,
    public val uniqueSuffix: Output<Boolean>? = null,
    public val userData: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ens.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.ens.InstanceArgs =
        com.pulumi.alicloud.ens.InstanceArgs.builder()
            .amount(amount?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoUseCoupon(autoUseCoupon?.applyValue({ args0 -> args0 }))
            .billingCycle(billingCycle?.applyValue({ args0 -> args0 }))
            .carrier(carrier?.applyValue({ args0 -> args0 }))
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ensRegionId(ensRegionId?.applyValue({ args0 -> args0 }))
            .forceStop(forceStop?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .includeDataDisks(includeDataDisks?.applyValue({ args0 -> args0 }))
            .instanceChargeStrategy(instanceChargeStrategy?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthOut(internetMaxBandwidthOut?.applyValue({ args0 -> args0 }))
            .ipType(ipType?.applyValue({ args0 -> args0 }))
            .netDistrictCode(netDistrictCode?.applyValue({ args0 -> args0 }))
            .netWorkId(netWorkId?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .passwordInherit(passwordInherit?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .publicIpIdentification(publicIpIdentification?.applyValue({ args0 -> args0 }))
            .scheduleAreaLevel(scheduleAreaLevel?.applyValue({ args0 -> args0 }))
            .schedulingPriceStrategy(schedulingPriceStrategy?.applyValue({ args0 -> args0 }))
            .schedulingStrategy(schedulingStrategy?.applyValue({ args0 -> args0 }))
            .securityId(securityId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .systemDisk(systemDisk?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uniqueSuffix(uniqueSuffix?.applyValue({ args0 -> args0 }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var amount: Output<Int>? = null

    private var autoRenew: Output<Boolean>? = null

    private var autoUseCoupon: Output<String>? = null

    private var billingCycle: Output<String>? = null

    private var carrier: Output<String>? = null

    private var dataDisks: Output<List<InstanceDataDiskArgs>>? = null

    private var ensRegionId: Output<String>? = null

    private var forceStop: Output<String>? = null

    private var hostName: Output<String>? = null

    private var imageId: Output<String>? = null

    private var includeDataDisks: Output<Boolean>? = null

    private var instanceChargeStrategy: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var internetMaxBandwidthOut: Output<Int>? = null

    private var ipType: Output<String>? = null

    private var netDistrictCode: Output<String>? = null

    private var netWorkId: Output<String>? = null

    private var password: Output<String>? = null

    private var passwordInherit: Output<Boolean>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var publicIpIdentification: Output<Boolean>? = null

    private var scheduleAreaLevel: Output<String>? = null

    private var schedulingPriceStrategy: Output<String>? = null

    private var schedulingStrategy: Output<String>? = null

    private var securityId: Output<String>? = null

    private var status: Output<String>? = null

    private var systemDisk: Output<InstanceSystemDiskArgs>? = null

    private var uniqueSuffix: Output<Boolean>? = null

    private var userData: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value The number of instances created, with a minimum of 1 and a maximum of 100.
     */
    @JvmName("qihgawvdbkmyjruf")
    public suspend fun amount(`value`: Output<Int>) {
        this.amount = value
    }

    /**
     * @param value Whether to automatically renew the logo. The default value is false. This parameter is invalid when you pay by volume.
     */
    @JvmName("nfxcxtcmjgncdvgl")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Whether to use vouchers. The default is to use. Value:
     * - true (used)
     * - false (not used).
     */
    @JvmName("mvaokkmpqbpdptrh")
    public suspend fun autoUseCoupon(`value`: Output<String>) {
        this.autoUseCoupon = value
    }

    /**
     * @param value The billing cycle for instance computing resources. Only instance-level pay-as-you-go is supported. Value
     * - Hour: hourly billing
     * - Day: Daily billing
     * - Month: monthly billing.
     */
    @JvmName("ahggtdvilvtuwsoa")
    public suspend fun billingCycle(`value`: Output<String>) {
        this.billingCycle = value
    }

    /**
     * @param value Operator, required for regional scheduling. Optional values:
     * - cmcc (mobile)
     * - unicom
     * - telecom.
     */
    @JvmName("xcryduxicxaofnwp")
    public suspend fun carrier(`value`: Output<String>) {
        this.carrier = value
    }

    /**
     * @param value Data disk specifications. See `data_disk` below.
     */
    @JvmName("ruwmtgpboelkwqfr")
    public suspend fun dataDisks(`value`: Output<List<InstanceDataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("tjptwnipoyxersgp")
    public suspend fun dataDisks(vararg values: Output<InstanceDataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values Data disk specifications. See `data_disk` below.
     */
    @JvmName("qtkiccqpuxsorrsq")
    public suspend fun dataDisks(values: List<Output<InstanceDataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value The node ID. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big,Middle,Small, EnsRegionId is invalid.
     */
    @JvmName("wfxvhoukanytwjdt")
    public suspend fun ensRegionId(`value`: Output<String>) {
        this.ensRegionId = value
    }

    /**
     * @param value Whether to force the identity when operating the instance. Optional values:
     * - true: Force
     * - false (default): non-mandatory
     */
    @JvmName("oxcmcmncqvapginc")
    public suspend fun forceStop(`value`: Output<String>) {
        this.forceStop = value
    }

    /**
     * @param value The host name of the instance. Example value: test-HostName.
     */
    @JvmName("rixpmtaiswaehjct")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The image ID of the instance. The arm version card cannot be filled in. Other specifications are required. Example value: m-5si16wo6simkt267p8b7h * * * *.
     */
    @JvmName("onvumsimjkrsnwwx")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value Whether the Payment type of the disk created with the instance is converted.
     */
    @JvmName("mkalbwvvugewapre")
    public suspend fun includeDataDisks(`value`: Output<Boolean>) {
        this.includeDataDisks = value
    }

    /**
     * @param value The instance billing policy. Optional values:
     * - instance: instance granularity (the subscription method does not support instance)
     * - user: user Dimension (user is not transmitted or supported in the prepaid mode).
     */
    @JvmName("fbapeqiygbmpfgyi")
    public suspend fun instanceChargeStrategy(`value`: Output<String>) {
        this.instanceChargeStrategy = value
    }

    /**
     * @param value The instance name. Example value: test-InstanceName. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-) The default value is the InstanceId of the instance. .
     */
    @JvmName("xcmcacuqpsmlduem")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The specification of the instance. Example value: ens.sn1.small.
     */
    @JvmName("amdwocmcyeuhstwh")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Instance bandwidth billing method. If the billing method can be selected for the first purchase, the subsequent value of this field will be processed by default according to the billing method selected for the first time. Optional values:
     * - BandwidthByDay: Daily peak bandwidth
     * - 95bandwidthbymonth: 95 peak bandwidth.
     */
    @JvmName("jxdjdnbaxmuigvlc")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value Maximum public network bandwidth. The field type is Long, and the precision may be lost during serialization/deserialization. Please note that the value must not be greater than 9007199254740991.
     */
    @JvmName("jjavpamohxxxisxv")
    public suspend fun internetMaxBandwidthOut(`value`: Output<Int>) {
        this.internetMaxBandwidthOut = value
    }

    /**
     * @param value The IP type. Value:
     * - ipv4 (default):IPv4
     * - ipv6:IPv6
     * - ipv4Andipv6:IPv4 and IPv6.
     */
    @JvmName("eyjhdfuxtkvuuaxx")
    public suspend fun ipType(`value`: Output<String>) {
        this.ipType = value
    }

    /**
     * @param value The area code. Example value: 350000. Required for regional-level scheduling, invalid for node-level scheduling.
     */
    @JvmName("bixkeexruftsgqle")
    public suspend fun netDistrictCode(`value`: Output<String>) {
        this.netDistrictCode = value
    }

    /**
     * @param value The network ID of the instance. Can only be used in node-level scheduling.
     */
    @JvmName("gcybnialtqmcrgcm")
    public suspend fun netWorkId(`value`: Output<String>) {
        this.netWorkId = value
    }

    /**
     * @param value The instance password. At least one of Password, KeyPairName, and PasswordInherit.
     */
    @JvmName("waqftnyapspkygvy")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed.
     */
    @JvmName("bprfgrldiiypnfdo")
    public suspend fun passwordInherit(`value`: Output<Boolean>) {
        this.passwordInherit = value
    }

    /**
     * @param value Instance payment method. Optional values:
     * - Subscription: prepaid, annual and monthly
     * - PayAsYouGo: Pay by volume.
     */
    @JvmName("rxtrjnqopijjgxwr")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The duration of the resource purchase. Value method:
     * - If PeriodUnit is set to Day, Period can only be set to 3.
     * - If PeriodUnit is set to Month, Period can be set to 1-9,12.
     */
    @JvmName("stqfqsurxlgouvte")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The unit of time for purchasing resources. Value:
     * - Month (default): purchase by Month
     * - Day: buy by Day.
     */
    @JvmName("jodrlwoqefnnfkft")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The private IP address. Can only be used for node-level scheduling. If a private IP address is specified, the number of instances can only be one, and both the private IP address and the vSwitch ID are not empty, the private IP address takes effect.
     */
    @JvmName("kebaqsafpymprouj")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value Whether to assign a public IP identifier. Value:
     * - true (default): Assign
     * - false: do not assign.
     */
    @JvmName("eafxymwviswxwyvi")
    public suspend fun publicIpIdentification(`value`: Output<Boolean>) {
        this.publicIpIdentification = value
    }

    /**
     * @param value Scheduling level, through which node-level scheduling or area scheduling is performed. Optional values:
     * - Node-level scheduling: Region
     * - Regional scheduling: Big (region),Middle (province),Small (city).
     */
    @JvmName("wfmnpipnxsypjfbm")
    public suspend fun scheduleAreaLevel(`value`: Output<String>) {
        this.scheduleAreaLevel = value
    }

    /**
     * @param value Scheduling price policy. If it is not filled in, the default priority is low price. Value:
     * - PriceLowPriority
     * - PriceLowPriority (priority low price).
     */
    @JvmName("lqwfpwlgcnklgdet")
    public suspend fun schedulingPriceStrategy(`value`: Output<String>) {
        this.schedulingPriceStrategy = value
    }

    /**
     * @param value Scheduling policy. Optional values:
     * - Concentrate for node-level scheduling
     * - For regional scheduling, Concentrate, Disperse.
     */
    @JvmName("otjweyoevqwsxnbo")
    public suspend fun schedulingStrategy(`value`: Output<String>) {
        this.schedulingStrategy = value
    }

    /**
     * @param value ID of the security group to which the instance belongs.
     */
    @JvmName("ncxptbtbvghftmhi")
    public suspend fun securityId(`value`: Output<String>) {
        this.securityId = value
    }

    /**
     * @param value Status of the instance.
     */
    @JvmName("egkntbhpuktorqxn")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
     */
    @JvmName("dhrrdonfqjtoqygk")
    public suspend fun systemDisk(`value`: Output<InstanceSystemDiskArgs>) {
        this.systemDisk = value
    }

    /**
     * @param value Indicates whether to add an ordered suffix to HostName and InstanceName. The ordered suffix starts from 001 and cannot exceed 999.
     */
    @JvmName("juqphohdlgmjrcrb")
    public suspend fun uniqueSuffix(`value`: Output<Boolean>) {
        this.uniqueSuffix = value
    }

    /**
     * @param value User-defined data, maximum support 16KB. You can pass in the UserData information. The UserData is encoded in Base64 format.
     */
    @JvmName("dybprnauajjvskgk")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value The ID of the vSwitch to which the instance belongs. Can only be used in node-level scheduling.
     */
    @JvmName("fsjshoopqrexypml")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The number of instances created, with a minimum of 1 and a maximum of 100.
     */
    @JvmName("pehrehwadxogxyvb")
    public suspend fun amount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amount = mapped
    }

    /**
     * @param value Whether to automatically renew the logo. The default value is false. This parameter is invalid when you pay by volume.
     */
    @JvmName("lswvvfqtxsbduukq")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Whether to use vouchers. The default is to use. Value:
     * - true (used)
     * - false (not used).
     */
    @JvmName("vynxjdeaggjgtqjv")
    public suspend fun autoUseCoupon(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUseCoupon = mapped
    }

    /**
     * @param value The billing cycle for instance computing resources. Only instance-level pay-as-you-go is supported. Value
     * - Hour: hourly billing
     * - Day: Daily billing
     * - Month: monthly billing.
     */
    @JvmName("omryvyelqkvvehwc")
    public suspend fun billingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingCycle = mapped
    }

    /**
     * @param value Operator, required for regional scheduling. Optional values:
     * - cmcc (mobile)
     * - unicom
     * - telecom.
     */
    @JvmName("dafbjsjvpcqgucqo")
    public suspend fun carrier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.carrier = mapped
    }

    /**
     * @param value Data disk specifications. See `data_disk` below.
     */
    @JvmName("cmktsneduphsjluy")
    public suspend fun dataDisks(`value`: List<InstanceDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument Data disk specifications. See `data_disk` below.
     */
    @JvmName("rldrqnicifjdinib")
    public suspend fun dataDisks(argument: List<suspend InstanceDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Data disk specifications. See `data_disk` below.
     */
    @JvmName("frmsoccthchfatpn")
    public suspend fun dataDisks(vararg argument: suspend InstanceDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument Data disk specifications. See `data_disk` below.
     */
    @JvmName("itsqmninclvththo")
    public suspend fun dataDisks(argument: suspend InstanceDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceDataDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values Data disk specifications. See `data_disk` below.
     */
    @JvmName("yvawhhtnnyxfnrdf")
    public suspend fun dataDisks(vararg values: InstanceDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value The node ID. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big,Middle,Small, EnsRegionId is invalid.
     */
    @JvmName("qcuptlabcpvraioj")
    public suspend fun ensRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ensRegionId = mapped
    }

    /**
     * @param value Whether to force the identity when operating the instance. Optional values:
     * - true: Force
     * - false (default): non-mandatory
     */
    @JvmName("muvqklrdsnlbkrlw")
    public suspend fun forceStop(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceStop = mapped
    }

    /**
     * @param value The host name of the instance. Example value: test-HostName.
     */
    @JvmName("hlguxyfuwrqaklwu")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The image ID of the instance. The arm version card cannot be filled in. Other specifications are required. Example value: m-5si16wo6simkt267p8b7h * * * *.
     */
    @JvmName("ktybieeognkwqxap")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value Whether the Payment type of the disk created with the instance is converted.
     */
    @JvmName("ltpumlydclafcdby")
    public suspend fun includeDataDisks(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeDataDisks = mapped
    }

    /**
     * @param value The instance billing policy. Optional values:
     * - instance: instance granularity (the subscription method does not support instance)
     * - user: user Dimension (user is not transmitted or supported in the prepaid mode).
     */
    @JvmName("nnjkunhrmudmnqmx")
    public suspend fun instanceChargeStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceChargeStrategy = mapped
    }

    /**
     * @param value The instance name. Example value: test-InstanceName. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-) The default value is the InstanceId of the instance. .
     */
    @JvmName("cvjevqsccedotgds")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The specification of the instance. Example value: ens.sn1.small.
     */
    @JvmName("jmmnehbgbcuwqxef")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Instance bandwidth billing method. If the billing method can be selected for the first purchase, the subsequent value of this field will be processed by default according to the billing method selected for the first time. Optional values:
     * - BandwidthByDay: Daily peak bandwidth
     * - 95bandwidthbymonth: 95 peak bandwidth.
     */
    @JvmName("ieffanubhlfbmclp")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value Maximum public network bandwidth. The field type is Long, and the precision may be lost during serialization/deserialization. Please note that the value must not be greater than 9007199254740991.
     */
    @JvmName("hypxhhmypoxijrak")
    public suspend fun internetMaxBandwidthOut(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthOut = mapped
    }

    /**
     * @param value The IP type. Value:
     * - ipv4 (default):IPv4
     * - ipv6:IPv6
     * - ipv4Andipv6:IPv4 and IPv6.
     */
    @JvmName("uedxsnetgjruhnle")
    public suspend fun ipType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipType = mapped
    }

    /**
     * @param value The area code. Example value: 350000. Required for regional-level scheduling, invalid for node-level scheduling.
     */
    @JvmName("rlncynqtvmamknue")
    public suspend fun netDistrictCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netDistrictCode = mapped
    }

    /**
     * @param value The network ID of the instance. Can only be used in node-level scheduling.
     */
    @JvmName("kbfuxipbduqobdqu")
    public suspend fun netWorkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netWorkId = mapped
    }

    /**
     * @param value The instance password. At least one of Password, KeyPairName, and PasswordInherit.
     */
    @JvmName("cukdaudpngivrdtg")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed.
     */
    @JvmName("onicxuljhbuhbsnb")
    public suspend fun passwordInherit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordInherit = mapped
    }

    /**
     * @param value Instance payment method. Optional values:
     * - Subscription: prepaid, annual and monthly
     * - PayAsYouGo: Pay by volume.
     */
    @JvmName("mcfkhssfaxdinpqo")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The duration of the resource purchase. Value method:
     * - If PeriodUnit is set to Day, Period can only be set to 3.
     * - If PeriodUnit is set to Month, Period can be set to 1-9,12.
     */
    @JvmName("qeuljutbqhyevcnf")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The unit of time for purchasing resources. Value:
     * - Month (default): purchase by Month
     * - Day: buy by Day.
     */
    @JvmName("yhoorgnpqyjkibig")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The private IP address. Can only be used for node-level scheduling. If a private IP address is specified, the number of instances can only be one, and both the private IP address and the vSwitch ID are not empty, the private IP address takes effect.
     */
    @JvmName("mvsbhvtwbfuxbarb")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value Whether to assign a public IP identifier. Value:
     * - true (default): Assign
     * - false: do not assign.
     */
    @JvmName("vuldogqobetdosoh")
    public suspend fun publicIpIdentification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpIdentification = mapped
    }

    /**
     * @param value Scheduling level, through which node-level scheduling or area scheduling is performed. Optional values:
     * - Node-level scheduling: Region
     * - Regional scheduling: Big (region),Middle (province),Small (city).
     */
    @JvmName("xjfutscdwlqripnl")
    public suspend fun scheduleAreaLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleAreaLevel = mapped
    }

    /**
     * @param value Scheduling price policy. If it is not filled in, the default priority is low price. Value:
     * - PriceLowPriority
     * - PriceLowPriority (priority low price).
     */
    @JvmName("eptbyokvrkewvntw")
    public suspend fun schedulingPriceStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulingPriceStrategy = mapped
    }

    /**
     * @param value Scheduling policy. Optional values:
     * - Concentrate for node-level scheduling
     * - For regional scheduling, Concentrate, Disperse.
     */
    @JvmName("hvsfyipdqdjebpmb")
    public suspend fun schedulingStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedulingStrategy = mapped
    }

    /**
     * @param value ID of the security group to which the instance belongs.
     */
    @JvmName("swgmsqguwujqwxqi")
    public suspend fun securityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityId = mapped
    }

    /**
     * @param value Status of the instance.
     */
    @JvmName("cnmussdofccvroqp")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
     */
    @JvmName("fsmhpmmtewwuvyrm")
    public suspend fun systemDisk(`value`: InstanceSystemDiskArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDisk = mapped
    }

    /**
     * @param argument System Disk Specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
     */
    @JvmName("kqhsoojdhgwjptlr")
    public suspend fun systemDisk(argument: suspend InstanceSystemDiskArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceSystemDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemDisk = mapped
    }

    /**
     * @param value Indicates whether to add an ordered suffix to HostName and InstanceName. The ordered suffix starts from 001 and cannot exceed 999.
     */
    @JvmName("sxgucejcsjnrbcjr")
    public suspend fun uniqueSuffix(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueSuffix = mapped
    }

    /**
     * @param value User-defined data, maximum support 16KB. You can pass in the UserData information. The UserData is encoded in Base64 format.
     */
    @JvmName("lpeynpavhxvsihhy")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value The ID of the vSwitch to which the instance belongs. Can only be used in node-level scheduling.
     */
    @JvmName("wxvlsnvisnwqpemv")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        amount = amount,
        autoRenew = autoRenew,
        autoUseCoupon = autoUseCoupon,
        billingCycle = billingCycle,
        carrier = carrier,
        dataDisks = dataDisks,
        ensRegionId = ensRegionId,
        forceStop = forceStop,
        hostName = hostName,
        imageId = imageId,
        includeDataDisks = includeDataDisks,
        instanceChargeStrategy = instanceChargeStrategy,
        instanceName = instanceName,
        instanceType = instanceType,
        internetChargeType = internetChargeType,
        internetMaxBandwidthOut = internetMaxBandwidthOut,
        ipType = ipType,
        netDistrictCode = netDistrictCode,
        netWorkId = netWorkId,
        password = password,
        passwordInherit = passwordInherit,
        paymentType = paymentType,
        period = period,
        periodUnit = periodUnit,
        privateIpAddress = privateIpAddress,
        publicIpIdentification = publicIpIdentification,
        scheduleAreaLevel = scheduleAreaLevel,
        schedulingPriceStrategy = schedulingPriceStrategy,
        schedulingStrategy = schedulingStrategy,
        securityId = securityId,
        status = status,
        systemDisk = systemDisk,
        uniqueSuffix = uniqueSuffix,
        userData = userData,
        vswitchId = vswitchId,
    )
}
