@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [KeyPair].
 */
@PulumiTagMarker
public class KeyPairResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyPairArgs = KeyPairArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyPairArgsBuilder.() -> Unit) {
        val builder = KeyPairArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KeyPair {
        val builtJavaResource = com.pulumi.alicloud.ens.KeyPair(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyPair(builtJavaResource)
    }
}

/**
 * Provides a ENS Key Pair resource.
 * For information about ENS Key Pair and how to use it, see [What is Key Pair](https://www.alibabacloud.com/help/en/ens/latest/createkeypair).
 * > **NOTE:** Available since v1.133.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const example = new alicloud.ens.KeyPair("example", {
 *     keyPairName: name,
 *     version: "2017-11-10",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * example = alicloud.ens.KeyPair("example",
 *     key_pair_name=name,
 *     version="2017-11-10")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var example = new AliCloud.Ens.KeyPair("example", new()
 *     {
 *         KeyPairName = name,
 *         Version = "2017-11-10",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewKeyPair(ctx, "example", &ens.KeyPairArgs{
 * 			KeyPairName: pulumi.String(name),
 * 			Version:     pulumi.String("2017-11-10"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.KeyPair;
 * import com.pulumi.alicloud.ens.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var example = new KeyPair("example", KeyPairArgs.builder()
 *             .keyPairName(name)
 *             .version("2017-11-10")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:ens:KeyPair
 *     properties:
 *       keyPairName: ${name}
 *       version: 2017-11-10
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Key Pair can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/keyPair:KeyPair example <key_pair_name>:<version>
 * ```
 */
public class KeyPair internal constructor(
    override val javaResource: com.pulumi.alicloud.ens.KeyPair,
) : KotlinCustomResource(javaResource, KeyPairMapper) {
    /**
     * The name of the key pair.
     */
    public val keyPairName: Output<String>
        get() = javaResource.keyPairName().applyValue({ args0 -> args0 })

    /**
     * The version number.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object KeyPairMapper : ResourceMapper<KeyPair> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ens.KeyPair::class == javaResource::class

    override fun map(javaResource: Resource): KeyPair = KeyPair(
        javaResource as
            com.pulumi.alicloud.ens.KeyPair,
    )
}

/**
 * @see [KeyPair].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyPair].
 */
public suspend fun keyPair(name: String, block: suspend KeyPairResourceBuilder.() -> Unit): KeyPair {
    val builder = KeyPairResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyPair].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyPair(name: String): KeyPair {
    val builder = KeyPairResourceBuilder()
    builder.name(name)
    return builder.build()
}
