@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.alicloud.ens.KeyPairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ENS Key Pair resource.
 * For information about ENS Key Pair and how to use it, see [What is Key Pair](https://www.alibabacloud.com/help/en/ens/latest/createkeypair).
 * > **NOTE:** Available since v1.133.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const example = new alicloud.ens.KeyPair("example", {
 *     keyPairName: name,
 *     version: "2017-11-10",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * example = alicloud.ens.KeyPair("example",
 *     key_pair_name=name,
 *     version="2017-11-10")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var example = new AliCloud.Ens.KeyPair("example", new()
 *     {
 *         KeyPairName = name,
 *         Version = "2017-11-10",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewKeyPair(ctx, "example", &ens.KeyPairArgs{
 * 			KeyPairName: pulumi.String(name),
 * 			Version:     pulumi.String("2017-11-10"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.KeyPair;
 * import com.pulumi.alicloud.ens.KeyPairArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var example = new KeyPair("example", KeyPairArgs.builder()
 *             .keyPairName(name)
 *             .version("2017-11-10")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   example:
 *     type: alicloud:ens:KeyPair
 *     properties:
 *       keyPairName: ${name}
 *       version: 2017-11-10
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Key Pair can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/keyPair:KeyPair example <key_pair_name>:<version>
 * ```
 * @property keyPairName The name of the key pair.
 * @property version The version number.
 */
public data class KeyPairArgs(
    public val keyPairName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ens.KeyPairArgs> {
    override fun toJava(): com.pulumi.alicloud.ens.KeyPairArgs =
        com.pulumi.alicloud.ens.KeyPairArgs.builder()
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyPairArgs].
 */
@PulumiTagMarker
public class KeyPairArgsBuilder internal constructor() {
    private var keyPairName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The name of the key pair.
     */
    @JvmName("vgrgcylpselypnjf")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value The version number.
     */
    @JvmName("qpwvssqqayafohxc")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The name of the key pair.
     */
    @JvmName("mvbdpenpfmwrxqfg")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value The version number.
     */
    @JvmName("gustfjffipdbtftj")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): KeyPairArgs = KeyPairArgs(
        keyPairName = keyPairName,
        version = version,
    )
}
