@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Network].
 */
@PulumiTagMarker
public class NetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkArgs = NetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkArgsBuilder.() -> Unit) {
        val builder = NetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Network {
        val builtJavaResource = com.pulumi.alicloud.ens.Network(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Network(builtJavaResource)
    }
}

/**
 * Provides a ENS Network resource.
 * For information about ENS Network and how to use it, see [What is Network](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createnetwork-1).
 * > **NOTE:** Available since v1.213.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ens.Network("default", {
 *     networkName: name,
 *     description: name,
 *     cidrBlock: "192.168.2.0/24",
 *     ensRegionId: "cn-chenzhou-telecom_unicom_cmcc",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ens.Network("default",
 *     network_name=name,
 *     description=name,
 *     cidr_block="192.168.2.0/24",
 *     ens_region_id="cn-chenzhou-telecom_unicom_cmcc")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ens.Network("default", new()
 *     {
 *         NetworkName = name,
 *         Description = name,
 *         CidrBlock = "192.168.2.0/24",
 *         EnsRegionId = "cn-chenzhou-telecom_unicom_cmcc",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewNetwork(ctx, "default", &ens.NetworkArgs{
 * 			NetworkName: pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.2.0/24"),
 * 			EnsRegionId: pulumi.String("cn-chenzhou-telecom_unicom_cmcc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.Network;
 * import com.pulumi.alicloud.ens.NetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Network("default", NetworkArgs.builder()
 *             .networkName(name)
 *             .description(name)
 *             .cidrBlock("192.168.2.0/24")
 *             .ensRegionId("cn-chenzhou-telecom_unicom_cmcc")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ens:Network
 *     properties:
 *       networkName: ${name}
 *       description: ${name}
 *       cidrBlock: 192.168.2.0/24
 *       ensRegionId: cn-chenzhou-telecom_unicom_cmcc
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Network can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/network:Network example <id>
 * ```
 */
public class Network internal constructor(
    override val javaResource: com.pulumi.alicloud.ens.Network,
) : KotlinCustomResource(javaResource, NetworkMapper) {
    /**
     * The network segment of the network. You can use the following network segments or a subset of them as the network segment: `10.0.0.0/8` (default), `172.16.0.0/12`, `192.168.0.0/16`.
     */
    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    /**
     * Creation time, timestamp (MS).
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Description information.Rules:It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`. Example value: this is my first network.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Ens node IDExample value: cn-beijing-telecom.
     */
    public val ensRegionId: Output<String>
        get() = javaResource.ensRegionId().applyValue({ args0 -> args0 })

    /**
     * Name of the network instanceThe naming rules are as follows: 1. Length is 2~128 English or Chinese characters; 2. It must start with a large or small letter or Chinese, not with `http://` and `https://`; 3. Can contain numbers, colons (:), underscores (_), or dashes (-).
     */
    public val networkName: Output<String>?
        get() = javaResource.networkName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the network instance. Pending: Configuring, Available: Available.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object NetworkMapper : ResourceMapper<Network> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ens.Network::class == javaResource::class

    override fun map(javaResource: Resource): Network = Network(
        javaResource as
            com.pulumi.alicloud.ens.Network,
    )
}

/**
 * @see [Network].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Network].
 */
public suspend fun network(name: String, block: suspend NetworkResourceBuilder.() -> Unit): Network {
    val builder = NetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Network].
 * @param name The _unique_ name of the resulting resource.
 */
public fun network(name: String): Network {
    val builder = NetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
