@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecurityGroup].
 */
@PulumiTagMarker
public class SecurityGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityGroupArgs = SecurityGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityGroupArgsBuilder.() -> Unit) {
        val builder = SecurityGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecurityGroup {
        val builtJavaResource = com.pulumi.alicloud.ens.SecurityGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityGroup(builtJavaResource)
    }
}

/**
 * Provides a ENS Security Group resource.
 * For information about ENS Security Group and how to use it, see [What is Security Group](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createsnapshot).
 * > **NOTE:** Available since v1.213.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ens.SecurityGroup("default", {
 *     description: name,
 *     securityGroupName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ens.SecurityGroup("default",
 *     description=name,
 *     security_group_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ens.SecurityGroup("default", new()
 *     {
 *         Description = name,
 *         SecurityGroupName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewSecurityGroup(ctx, "default", &ens.SecurityGroupArgs{
 * 			Description:       pulumi.String(name),
 * 			SecurityGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.SecurityGroup;
 * import com.pulumi.alicloud.ens.SecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new SecurityGroup("default", SecurityGroupArgs.builder()
 *             .description(name)
 *             .securityGroupName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ens:SecurityGroup
 *     properties:
 *       description: ${name}
 *       securityGroupName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Security Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/securityGroup:SecurityGroup example <id>
 * ```
 */
public class SecurityGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.ens.SecurityGroup,
) : KotlinCustomResource(javaResource, SecurityGroupMapper) {
    /**
     * Security group description informationIt must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Security group nameThe security group name. The length is 2~128 English or Chinese characters. It must start with an uppercase or lowcase letter or a Chinese character and cannot start with `http://` or `https`. Can contain digits, colons (:), underscores (_), or hyphens (-).
     */
    public val securityGroupName: Output<String>?
        get() = javaResource.securityGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object SecurityGroupMapper : ResourceMapper<SecurityGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ens.SecurityGroup::class == javaResource::class

    override fun map(javaResource: Resource): SecurityGroup = SecurityGroup(
        javaResource as
            com.pulumi.alicloud.ens.SecurityGroup,
    )
}

/**
 * @see [SecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityGroup].
 */
public suspend fun securityGroup(
    name: String,
    block: suspend SecurityGroupResourceBuilder.() -> Unit,
): SecurityGroup {
    val builder = SecurityGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityGroup(name: String): SecurityGroup {
    val builder = SecurityGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
