@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.alicloud.ens.SecurityGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ENS Security Group resource.
 * For information about ENS Security Group and how to use it, see [What is Security Group](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createsnapshot).
 * > **NOTE:** Available since v1.213.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ens.SecurityGroup("default", {
 *     description: name,
 *     securityGroupName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ens.SecurityGroup("default",
 *     description=name,
 *     security_group_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ens.SecurityGroup("default", new()
 *     {
 *         Description = name,
 *         SecurityGroupName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewSecurityGroup(ctx, "default", &ens.SecurityGroupArgs{
 * 			Description:       pulumi.String(name),
 * 			SecurityGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.SecurityGroup;
 * import com.pulumi.alicloud.ens.SecurityGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new SecurityGroup("default", SecurityGroupArgs.builder()
 *             .description(name)
 *             .securityGroupName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ens:SecurityGroup
 *     properties:
 *       description: ${name}
 *       securityGroupName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Security Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/securityGroup:SecurityGroup example <id>
 * ```
 * @property description Security group description informationIt must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
 * @property securityGroupName Security group nameThe security group name. The length is 2~128 English or Chinese characters. It must start with an uppercase or lowcase letter or a Chinese character and cannot start with `http://` or `https`. Can contain digits, colons (:), underscores (_), or hyphens (-).
 */
public data class SecurityGroupArgs(
    public val description: Output<String>? = null,
    public val securityGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ens.SecurityGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ens.SecurityGroupArgs =
        com.pulumi.alicloud.ens.SecurityGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .securityGroupName(securityGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityGroupArgs].
 */
@PulumiTagMarker
public class SecurityGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var securityGroupName: Output<String>? = null

    /**
     * @param value Security group description informationIt must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    @JvmName("ilytcsoqaxcbjeno")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Security group nameThe security group name. The length is 2~128 English or Chinese characters. It must start with an uppercase or lowcase letter or a Chinese character and cannot start with `http://` or `https`. Can contain digits, colons (:), underscores (_), or hyphens (-).
     */
    @JvmName("ygvfgcprbnfrlwlh")
    public suspend fun securityGroupName(`value`: Output<String>) {
        this.securityGroupName = value
    }

    /**
     * @param value Security group description informationIt must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
     */
    @JvmName("pqfdjhllrhfqpksw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Security group nameThe security group name. The length is 2~128 English or Chinese characters. It must start with an uppercase or lowcase letter or a Chinese character and cannot start with `http://` or `https`. Can contain digits, colons (:), underscores (_), or hyphens (-).
     */
    @JvmName("nihlpindkgydrqqc")
    public suspend fun securityGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupName = mapped
    }

    internal fun build(): SecurityGroupArgs = SecurityGroupArgs(
        description = description,
        securityGroupName = securityGroupName,
    )
}
