@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Snapshot].
 */
@PulumiTagMarker
public class SnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotArgs = SnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotArgsBuilder.() -> Unit) {
        val builder = SnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Snapshot {
        val builtJavaResource = com.pulumi.alicloud.ens.Snapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Snapshot(builtJavaResource)
    }
}

/**
 * Provides a ENS Snapshot resource. Snapshot. When you use it for the first time, please contact the product classmates to add a resource whitelist.
 * For information about ENS Snapshot and how to use it, see [What is Snapshot](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createsnapshot).
 * > **NOTE:** Available since v1.213.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const disk = new alicloud.ens.Disk("disk", {
 *     category: "cloud_efficiency",
 *     size: 20,
 *     paymentType: "PayAsYouGo",
 *     ensRegionId: "ch-zurich-1",
 * });
 * const _default = new alicloud.ens.Snapshot("default", {
 *     description: name,
 *     ensRegionId: "ch-zurich-1",
 *     snapshotName: name,
 *     diskId: disk.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * disk = alicloud.ens.Disk("disk",
 *     category="cloud_efficiency",
 *     size=20,
 *     payment_type="PayAsYouGo",
 *     ens_region_id="ch-zurich-1")
 * default = alicloud.ens.Snapshot("default",
 *     description=name,
 *     ens_region_id="ch-zurich-1",
 *     snapshot_name=name,
 *     disk_id=disk.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var disk = new AliCloud.Ens.Disk("disk", new()
 *     {
 *         Category = "cloud_efficiency",
 *         Size = 20,
 *         PaymentType = "PayAsYouGo",
 *         EnsRegionId = "ch-zurich-1",
 *     });
 *     var @default = new AliCloud.Ens.Snapshot("default", new()
 *     {
 *         Description = name,
 *         EnsRegionId = "ch-zurich-1",
 *         SnapshotName = name,
 *         DiskId = disk.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		disk, err := ens.NewDisk(ctx, "disk", &ens.DiskArgs{
 * 			Category:    pulumi.String("cloud_efficiency"),
 * 			Size:        pulumi.Int(20),
 * 			PaymentType: pulumi.String("PayAsYouGo"),
 * 			EnsRegionId: pulumi.String("ch-zurich-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ens.NewSnapshot(ctx, "default", &ens.SnapshotArgs{
 * 			Description:  pulumi.String(name),
 * 			EnsRegionId:  pulumi.String("ch-zurich-1"),
 * 			SnapshotName: pulumi.String(name),
 * 			DiskId:       disk.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.Disk;
 * import com.pulumi.alicloud.ens.DiskArgs;
 * import com.pulumi.alicloud.ens.Snapshot;
 * import com.pulumi.alicloud.ens.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .category("cloud_efficiency")
 *             .size("20")
 *             .paymentType("PayAsYouGo")
 *             .ensRegionId("ch-zurich-1")
 *             .build());
 *         var default_ = new Snapshot("default", SnapshotArgs.builder()
 *             .description(name)
 *             .ensRegionId("ch-zurich-1")
 *             .snapshotName(name)
 *             .diskId(disk.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   disk:
 *     type: alicloud:ens:Disk
 *     properties:
 *       category: cloud_efficiency
 *       size: '20'
 *       paymentType: PayAsYouGo
 *       ensRegionId: ch-zurich-1
 *   default:
 *     type: alicloud:ens:Snapshot
 *     properties:
 *       description: ${name}
 *       ensRegionId: ch-zurich-1
 *       snapshotName: ${name}
 *       diskId: ${disk.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Snapshot can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/snapshot:Snapshot example <id>
 * ```
 */
public class Snapshot internal constructor(
    override val javaResource: com.pulumi.alicloud.ens.Snapshot,
) : KotlinCustomResource(javaResource, SnapshotMapper) {
    /**
     * Instance creation timeIt is expressed in accordance with the ISO8601 standard and uses UTC +0 time in the format of yyyy-MM-ddTHH:mm:ssZ.Example value: 2020-08-20 T14:52:28Z.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Snapshot Description Information.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Cloud Disk ID.
     */
    public val diskId: Output<String>
        get() = javaResource.diskId().applyValue({ args0 -> args0 })

    /**
     * The node ID of ENS.
     */
    public val ensRegionId: Output<String>
        get() = javaResource.ensRegionId().applyValue({ args0 -> args0 })

    /**
     * Name of the snapshot instance.
     */
    public val snapshotName: Output<String>?
        get() = javaResource.snapshotName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Snapshot Status. Valid values: creating, available, deleting, error.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object SnapshotMapper : ResourceMapper<Snapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ens.Snapshot::class == javaResource::class

    override fun map(javaResource: Resource): Snapshot = Snapshot(
        javaResource as
            com.pulumi.alicloud.ens.Snapshot,
    )
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Snapshot].
 */
public suspend fun snapshot(name: String, block: suspend SnapshotResourceBuilder.() -> Unit): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshot(name: String): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
