@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.alicloud.ens.SnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ENS Snapshot resource. Snapshot. When you use it for the first time, please contact the product classmates to add a resource whitelist.
 * For information about ENS Snapshot and how to use it, see [What is Snapshot](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createsnapshot).
 * > **NOTE:** Available since v1.213.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const disk = new alicloud.ens.Disk("disk", {
 *     category: "cloud_efficiency",
 *     size: 20,
 *     paymentType: "PayAsYouGo",
 *     ensRegionId: "ch-zurich-1",
 * });
 * const _default = new alicloud.ens.Snapshot("default", {
 *     description: name,
 *     ensRegionId: "ch-zurich-1",
 *     snapshotName: name,
 *     diskId: disk.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * disk = alicloud.ens.Disk("disk",
 *     category="cloud_efficiency",
 *     size=20,
 *     payment_type="PayAsYouGo",
 *     ens_region_id="ch-zurich-1")
 * default = alicloud.ens.Snapshot("default",
 *     description=name,
 *     ens_region_id="ch-zurich-1",
 *     snapshot_name=name,
 *     disk_id=disk.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var disk = new AliCloud.Ens.Disk("disk", new()
 *     {
 *         Category = "cloud_efficiency",
 *         Size = 20,
 *         PaymentType = "PayAsYouGo",
 *         EnsRegionId = "ch-zurich-1",
 *     });
 *     var @default = new AliCloud.Ens.Snapshot("default", new()
 *     {
 *         Description = name,
 *         EnsRegionId = "ch-zurich-1",
 *         SnapshotName = name,
 *         DiskId = disk.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		disk, err := ens.NewDisk(ctx, "disk", &ens.DiskArgs{
 * 			Category:    pulumi.String("cloud_efficiency"),
 * 			Size:        pulumi.Int(20),
 * 			PaymentType: pulumi.String("PayAsYouGo"),
 * 			EnsRegionId: pulumi.String("ch-zurich-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ens.NewSnapshot(ctx, "default", &ens.SnapshotArgs{
 * 			Description:  pulumi.String(name),
 * 			EnsRegionId:  pulumi.String("ch-zurich-1"),
 * 			SnapshotName: pulumi.String(name),
 * 			DiskId:       disk.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.Disk;
 * import com.pulumi.alicloud.ens.DiskArgs;
 * import com.pulumi.alicloud.ens.Snapshot;
 * import com.pulumi.alicloud.ens.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .category("cloud_efficiency")
 *             .size("20")
 *             .paymentType("PayAsYouGo")
 *             .ensRegionId("ch-zurich-1")
 *             .build());
 *         var default_ = new Snapshot("default", SnapshotArgs.builder()
 *             .description(name)
 *             .ensRegionId("ch-zurich-1")
 *             .snapshotName(name)
 *             .diskId(disk.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   disk:
 *     type: alicloud:ens:Disk
 *     properties:
 *       category: cloud_efficiency
 *       size: '20'
 *       paymentType: PayAsYouGo
 *       ensRegionId: ch-zurich-1
 *   default:
 *     type: alicloud:ens:Snapshot
 *     properties:
 *       description: ${name}
 *       ensRegionId: ch-zurich-1
 *       snapshotName: ${name}
 *       diskId: ${disk.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Snapshot can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/snapshot:Snapshot example <id>
 * ```
 * @property description Snapshot Description Information.
 * @property diskId Cloud Disk ID.
 * @property ensRegionId The node ID of ENS.
 * @property snapshotName Name of the snapshot instance.
 */
public data class SnapshotArgs(
    public val description: Output<String>? = null,
    public val diskId: Output<String>? = null,
    public val ensRegionId: Output<String>? = null,
    public val snapshotName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ens.SnapshotArgs> {
    override fun toJava(): com.pulumi.alicloud.ens.SnapshotArgs =
        com.pulumi.alicloud.ens.SnapshotArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .ensRegionId(ensRegionId?.applyValue({ args0 -> args0 }))
            .snapshotName(snapshotName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotArgs].
 */
@PulumiTagMarker
public class SnapshotArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var diskId: Output<String>? = null

    private var ensRegionId: Output<String>? = null

    private var snapshotName: Output<String>? = null

    /**
     * @param value Snapshot Description Information.
     */
    @JvmName("uldjyydbsckghjio")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Cloud Disk ID.
     */
    @JvmName("iaicbpkvvbhvilyk")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value The node ID of ENS.
     */
    @JvmName("npyyxcgrotbfjprp")
    public suspend fun ensRegionId(`value`: Output<String>) {
        this.ensRegionId = value
    }

    /**
     * @param value Name of the snapshot instance.
     */
    @JvmName("bncgtwsmhwfsudsc")
    public suspend fun snapshotName(`value`: Output<String>) {
        this.snapshotName = value
    }

    /**
     * @param value Snapshot Description Information.
     */
    @JvmName("lgtwvopvvoyngjcw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Cloud Disk ID.
     */
    @JvmName("mcwtccyvksnmadgi")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value The node ID of ENS.
     */
    @JvmName("trqjruvkeyihgfhb")
    public suspend fun ensRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ensRegionId = mapped
    }

    /**
     * @param value Name of the snapshot instance.
     */
    @JvmName("vlkdlawiybnodmmk")
    public suspend fun snapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotName = mapped
    }

    internal fun build(): SnapshotArgs = SnapshotArgs(
        description = description,
        diskId = diskId,
        ensRegionId = ensRegionId,
        snapshotName = snapshotName,
    )
}
