@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Vswitch].
 */
@PulumiTagMarker
public class VswitchResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VswitchArgs = VswitchArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VswitchArgsBuilder.() -> Unit) {
        val builder = VswitchArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Vswitch {
        val builtJavaResource = com.pulumi.alicloud.ens.Vswitch(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vswitch(builtJavaResource)
    }
}

/**
 * Provides a ENS Vswitch resource.
 * For information about ENS Vswitch and how to use it, see [What is Vswitch](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createvswitch).
 * > **NOTE:** Available since v1.213.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ens.Network("default", {
 *     networkName: name,
 *     description: name,
 *     cidrBlock: "192.168.2.0/24",
 *     ensRegionId: "cn-chenzhou-telecom_unicom_cmcc",
 * });
 * const defaultVswitch = new alicloud.ens.Vswitch("default", {
 *     description: name,
 *     cidrBlock: "192.168.2.0/24",
 *     vswitchName: name,
 *     ensRegionId: "cn-chenzhou-telecom_unicom_cmcc",
 *     networkId: _default.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ens.Network("default",
 *     network_name=name,
 *     description=name,
 *     cidr_block="192.168.2.0/24",
 *     ens_region_id="cn-chenzhou-telecom_unicom_cmcc")
 * default_vswitch = alicloud.ens.Vswitch("default",
 *     description=name,
 *     cidr_block="192.168.2.0/24",
 *     vswitch_name=name,
 *     ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
 *     network_id=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ens.Network("default", new()
 *     {
 *         NetworkName = name,
 *         Description = name,
 *         CidrBlock = "192.168.2.0/24",
 *         EnsRegionId = "cn-chenzhou-telecom_unicom_cmcc",
 *     });
 *     var defaultVswitch = new AliCloud.Ens.Vswitch("default", new()
 *     {
 *         Description = name,
 *         CidrBlock = "192.168.2.0/24",
 *         VswitchName = name,
 *         EnsRegionId = "cn-chenzhou-telecom_unicom_cmcc",
 *         NetworkId = @default.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewNetwork(ctx, "default", &ens.NetworkArgs{
 * 			NetworkName: pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.2.0/24"),
 * 			EnsRegionId: pulumi.String("cn-chenzhou-telecom_unicom_cmcc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ens.NewVswitch(ctx, "default", &ens.VswitchArgs{
 * 			Description: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.2.0/24"),
 * 			VswitchName: pulumi.String(name),
 * 			EnsRegionId: pulumi.String("cn-chenzhou-telecom_unicom_cmcc"),
 * 			NetworkId:   _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.Network;
 * import com.pulumi.alicloud.ens.NetworkArgs;
 * import com.pulumi.alicloud.ens.Vswitch;
 * import com.pulumi.alicloud.ens.VswitchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Network("default", NetworkArgs.builder()
 *             .networkName(name)
 *             .description(name)
 *             .cidrBlock("192.168.2.0/24")
 *             .ensRegionId("cn-chenzhou-telecom_unicom_cmcc")
 *             .build());
 *         var defaultVswitch = new Vswitch("defaultVswitch", VswitchArgs.builder()
 *             .description(name)
 *             .cidrBlock("192.168.2.0/24")
 *             .vswitchName(name)
 *             .ensRegionId("cn-chenzhou-telecom_unicom_cmcc")
 *             .networkId(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ens:Network
 *     properties:
 *       networkName: ${name}
 *       description: ${name}
 *       cidrBlock: 192.168.2.0/24
 *       ensRegionId: cn-chenzhou-telecom_unicom_cmcc
 *   defaultVswitch:
 *     type: alicloud:ens:Vswitch
 *     name: default
 *     properties:
 *       description: ${name}
 *       cidrBlock: 192.168.2.0/24
 *       vswitchName: ${name}
 *       ensRegionId: cn-chenzhou-telecom_unicom_cmcc
 *       networkId: ${default.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Vswitch can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/vswitch:Vswitch example <id>
 * ```
 */
public class Vswitch internal constructor(
    override val javaResource: com.pulumi.alicloud.ens.Vswitch,
) : KotlinCustomResource(javaResource, VswitchMapper) {
    /**
     * IPv4 CIDR block of the VSwitch instance.
     */
    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    /**
     * The creation time of the VSwitch instance, in the UTC time format, yyyy-MM-ddTHH:mm:ssZ.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Description of the VSwitch Instance.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ENS Region ID.
     */
    public val ensRegionId: Output<String>
        get() = javaResource.ensRegionId().applyValue({ args0 -> args0 })

    /**
     * Network ID of the VSwitch instance.
     */
    public val networkId: Output<String>
        get() = javaResource.networkId().applyValue({ args0 -> args0 })

    /**
     * Status of the switch instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Name of the switch instance.
     */
    public val vswitchName: Output<String>?
        get() = javaResource.vswitchName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VswitchMapper : ResourceMapper<Vswitch> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ens.Vswitch::class == javaResource::class

    override fun map(javaResource: Resource): Vswitch = Vswitch(
        javaResource as
            com.pulumi.alicloud.ens.Vswitch,
    )
}

/**
 * @see [Vswitch].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vswitch].
 */
public suspend fun vswitch(name: String, block: suspend VswitchResourceBuilder.() -> Unit): Vswitch {
    val builder = VswitchResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vswitch].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vswitch(name: String): Vswitch {
    val builder = VswitchResourceBuilder()
    builder.name(name)
    return builder.build()
}
