@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin

import com.pulumi.alicloud.ens.VswitchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ENS Vswitch resource.
 * For information about ENS Vswitch and how to use it, see [What is Vswitch](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createvswitch).
 * > **NOTE:** Available since v1.213.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.ens.Network("default", {
 *     networkName: name,
 *     description: name,
 *     cidrBlock: "192.168.2.0/24",
 *     ensRegionId: "cn-chenzhou-telecom_unicom_cmcc",
 * });
 * const defaultVswitch = new alicloud.ens.Vswitch("default", {
 *     description: name,
 *     cidrBlock: "192.168.2.0/24",
 *     vswitchName: name,
 *     ensRegionId: "cn-chenzhou-telecom_unicom_cmcc",
 *     networkId: _default.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.ens.Network("default",
 *     network_name=name,
 *     description=name,
 *     cidr_block="192.168.2.0/24",
 *     ens_region_id="cn-chenzhou-telecom_unicom_cmcc")
 * default_vswitch = alicloud.ens.Vswitch("default",
 *     description=name,
 *     cidr_block="192.168.2.0/24",
 *     vswitch_name=name,
 *     ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
 *     network_id=default.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Ens.Network("default", new()
 *     {
 *         NetworkName = name,
 *         Description = name,
 *         CidrBlock = "192.168.2.0/24",
 *         EnsRegionId = "cn-chenzhou-telecom_unicom_cmcc",
 *     });
 *     var defaultVswitch = new AliCloud.Ens.Vswitch("default", new()
 *     {
 *         Description = name,
 *         CidrBlock = "192.168.2.0/24",
 *         VswitchName = name,
 *         EnsRegionId = "cn-chenzhou-telecom_unicom_cmcc",
 *         NetworkId = @default.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ens"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := ens.NewNetwork(ctx, "default", &ens.NetworkArgs{
 * 			NetworkName: pulumi.String(name),
 * 			Description: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.2.0/24"),
 * 			EnsRegionId: pulumi.String("cn-chenzhou-telecom_unicom_cmcc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ens.NewVswitch(ctx, "default", &ens.VswitchArgs{
 * 			Description: pulumi.String(name),
 * 			CidrBlock:   pulumi.String("192.168.2.0/24"),
 * 			VswitchName: pulumi.String(name),
 * 			EnsRegionId: pulumi.String("cn-chenzhou-telecom_unicom_cmcc"),
 * 			NetworkId:   _default.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ens.Network;
 * import com.pulumi.alicloud.ens.NetworkArgs;
 * import com.pulumi.alicloud.ens.Vswitch;
 * import com.pulumi.alicloud.ens.VswitchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Network("default", NetworkArgs.builder()
 *             .networkName(name)
 *             .description(name)
 *             .cidrBlock("192.168.2.0/24")
 *             .ensRegionId("cn-chenzhou-telecom_unicom_cmcc")
 *             .build());
 *         var defaultVswitch = new Vswitch("defaultVswitch", VswitchArgs.builder()
 *             .description(name)
 *             .cidrBlock("192.168.2.0/24")
 *             .vswitchName(name)
 *             .ensRegionId("cn-chenzhou-telecom_unicom_cmcc")
 *             .networkId(default_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:ens:Network
 *     properties:
 *       networkName: ${name}
 *       description: ${name}
 *       cidrBlock: 192.168.2.0/24
 *       ensRegionId: cn-chenzhou-telecom_unicom_cmcc
 *   defaultVswitch:
 *     type: alicloud:ens:Vswitch
 *     name: default
 *     properties:
 *       description: ${name}
 *       cidrBlock: 192.168.2.0/24
 *       vswitchName: ${name}
 *       ensRegionId: cn-chenzhou-telecom_unicom_cmcc
 *       networkId: ${default.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ENS Vswitch can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ens/vswitch:Vswitch example <id>
 * ```
 * @property cidrBlock IPv4 CIDR block of the VSwitch instance.
 * @property description Description of the VSwitch Instance.
 * @property ensRegionId ENS Region ID.
 * @property networkId Network ID of the VSwitch instance.
 * @property vswitchName Name of the switch instance.
 */
public data class VswitchArgs(
    public val cidrBlock: Output<String>? = null,
    public val description: Output<String>? = null,
    public val ensRegionId: Output<String>? = null,
    public val networkId: Output<String>? = null,
    public val vswitchName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ens.VswitchArgs> {
    override fun toJava(): com.pulumi.alicloud.ens.VswitchArgs =
        com.pulumi.alicloud.ens.VswitchArgs.builder()
            .cidrBlock(cidrBlock?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .ensRegionId(ensRegionId?.applyValue({ args0 -> args0 }))
            .networkId(networkId?.applyValue({ args0 -> args0 }))
            .vswitchName(vswitchName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VswitchArgs].
 */
@PulumiTagMarker
public class VswitchArgsBuilder internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var description: Output<String>? = null

    private var ensRegionId: Output<String>? = null

    private var networkId: Output<String>? = null

    private var vswitchName: Output<String>? = null

    /**
     * @param value IPv4 CIDR block of the VSwitch instance.
     */
    @JvmName("ktatbxgakqurinpi")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value Description of the VSwitch Instance.
     */
    @JvmName("llaialetyahfdadi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ENS Region ID.
     */
    @JvmName("ptexydoevgdoxtjt")
    public suspend fun ensRegionId(`value`: Output<String>) {
        this.ensRegionId = value
    }

    /**
     * @param value Network ID of the VSwitch instance.
     */
    @JvmName("npeehgkujoumsikw")
    public suspend fun networkId(`value`: Output<String>) {
        this.networkId = value
    }

    /**
     * @param value Name of the switch instance.
     */
    @JvmName("kfkqgpngfcrnotux")
    public suspend fun vswitchName(`value`: Output<String>) {
        this.vswitchName = value
    }

    /**
     * @param value IPv4 CIDR block of the VSwitch instance.
     */
    @JvmName("itjwbostkwnacqlv")
    public suspend fun cidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value Description of the VSwitch Instance.
     */
    @JvmName("rjtrmapdkdbqwgjm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ENS Region ID.
     */
    @JvmName("kdkvudyfwdblqjvl")
    public suspend fun ensRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ensRegionId = mapped
    }

    /**
     * @param value Network ID of the VSwitch instance.
     */
    @JvmName("mcypkgmwehvevqdq")
    public suspend fun networkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkId = mapped
    }

    /**
     * @param value Name of the switch instance.
     */
    @JvmName("hssiahpgmorumkwd")
    public suspend fun vswitchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchName = mapped
    }

    internal fun build(): VswitchArgs = VswitchArgs(
        cidrBlock = cidrBlock,
        description = description,
        ensRegionId = ensRegionId,
        networkId = networkId,
        vswitchName = vswitchName,
    )
}
