@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin.inputs

import com.pulumi.alicloud.ens.inputs.GetKeyPairsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKeyPairs.
 * @property keyPairName The name of the key pair.
 * @property nameRegex A regex string to filter results by Key Pair name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property version The version number.
 */
public data class GetKeyPairsPlainArgs(
    public val keyPairName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val version: String,
) : ConvertibleToJava<com.pulumi.alicloud.ens.inputs.GetKeyPairsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.ens.inputs.GetKeyPairsPlainArgs =
        com.pulumi.alicloud.ens.inputs.GetKeyPairsPlainArgs.builder()
            .keyPairName(keyPairName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .version(version.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKeyPairsPlainArgs].
 */
@PulumiTagMarker
public class GetKeyPairsPlainArgsBuilder internal constructor() {
    private var keyPairName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var version: String? = null

    /**
     * @param value The name of the key pair.
     */
    @JvmName("enntlhqnvxsckpso")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyPairName = mapped
    }

    /**
     * @param value A regex string to filter results by Key Pair name.
     */
    @JvmName("hpjkutioyfmcrmnn")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jwjrlddtbaganesf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The version number.
     */
    @JvmName("vbwivvvvaksuhabb")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetKeyPairsPlainArgs = GetKeyPairsPlainArgs(
        keyPairName = keyPairName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
