@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin.inputs

import com.pulumi.alicloud.ens.inputs.InstanceDataDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property category Data disk type. Optional values:
 * - cloud_efficiency: Ultra cloud disk
 * - cloud_ssd: Full Flash cloud disk
 * - local_hdd: local hdd disk
 * - local_ssd: local disk ssd.
 * @property size Data disk size, unit: GB.
 */
public data class InstanceDataDiskArgs(
    public val category: Output<String>? = null,
    public val size: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ens.inputs.InstanceDataDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ens.inputs.InstanceDataDiskArgs =
        com.pulumi.alicloud.ens.inputs.InstanceDataDiskArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceDataDiskArgs].
 */
@PulumiTagMarker
public class InstanceDataDiskArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var size: Output<Int>? = null

    /**
     * @param value Data disk type. Optional values:
     * - cloud_efficiency: Ultra cloud disk
     * - cloud_ssd: Full Flash cloud disk
     * - local_hdd: local hdd disk
     * - local_ssd: local disk ssd.
     */
    @JvmName("mjfculdothwpjmun")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value Data disk size, unit: GB.
     */
    @JvmName("xxoffgcfedhkksah")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value Data disk type. Optional values:
     * - cloud_efficiency: Ultra cloud disk
     * - cloud_ssd: Full Flash cloud disk
     * - local_hdd: local hdd disk
     * - local_ssd: local disk ssd.
     */
    @JvmName("cqvhnrwlcopnvana")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Data disk size, unit: GB.
     */
    @JvmName("nrjfvpvfhurtobdf")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): InstanceDataDiskArgs = InstanceDataDiskArgs(
        category = category,
        size = size,
    )
}
