@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin.inputs

import com.pulumi.alicloud.ens.inputs.InstanceSystemDiskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property category System disk type. Optional values:
 * - cloud_efficiency: Ultra cloud disk
 * - cloud_ssd: Full Flash cloud disk
 * - local_hdd: local hdd disk
 * - local_ssd: local disk ssd.
 * @property size System disk size, unit: GB.
 */
public data class InstanceSystemDiskArgs(
    public val category: Output<String>? = null,
    public val size: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ens.inputs.InstanceSystemDiskArgs> {
    override fun toJava(): com.pulumi.alicloud.ens.inputs.InstanceSystemDiskArgs =
        com.pulumi.alicloud.ens.inputs.InstanceSystemDiskArgs.builder()
            .category(category?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceSystemDiskArgs].
 */
@PulumiTagMarker
public class InstanceSystemDiskArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var size: Output<Int>? = null

    /**
     * @param value System disk type. Optional values:
     * - cloud_efficiency: Ultra cloud disk
     * - cloud_ssd: Full Flash cloud disk
     * - local_hdd: local hdd disk
     * - local_ssd: local disk ssd.
     */
    @JvmName("oygbotfubadrqbqt")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value System disk size, unit: GB.
     */
    @JvmName("tutyrsyqbrvuvytv")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value System disk type. Optional values:
     * - cloud_efficiency: Ultra cloud disk
     * - cloud_ssd: Full Flash cloud disk
     * - local_hdd: local hdd disk
     * - local_ssd: local disk ssd.
     */
    @JvmName("rbskueixhmsppywi")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value System disk size, unit: GB.
     */
    @JvmName("pdmauiguxblmnwpp")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    internal fun build(): InstanceSystemDiskArgs = InstanceSystemDiskArgs(
        category = category,
        size = size,
    )
}
