@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The creation time of the key pair. The date format is in accordance with ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
 * @property id The ID of the Key Pair.
 * @property keyPairFingerPrint Fingerprint of the key pair.
 * @property keyPairName The name of the key pair.
 * @property version The version number.
 */
public data class GetKeyPairsPair(
    public val createTime: String,
    public val id: String,
    public val keyPairFingerPrint: String,
    public val keyPairName: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ens.outputs.GetKeyPairsPair): GetKeyPairsPair = GetKeyPairsPair(
            createTime = javaType.createTime(),
            id = javaType.id(),
            keyPairFingerPrint = javaType.keyPairFingerPrint(),
            keyPairName = javaType.keyPairName(),
            version = javaType.version(),
        )
    }
}
