@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ens.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property category System disk type. Optional values:
 * - cloud_efficiency: Ultra cloud disk
 * - cloud_ssd: Full Flash cloud disk
 * - local_hdd: local hdd disk
 * - local_ssd: local disk ssd.
 * @property size System disk size, unit: GB.
 */
public data class InstanceSystemDisk(
    public val category: String? = null,
    public val size: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.ens.outputs.InstanceSystemDisk): InstanceSystemDisk = InstanceSystemDisk(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
        )
    }
}
