@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.kotlin.outputs.AlarmExpression
import com.pulumi.alicloud.ess.kotlin.outputs.AlarmExpression.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Alarm].
 */
@PulumiTagMarker
public class AlarmResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AlarmArgs = AlarmArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AlarmArgsBuilder.() -> Unit) {
        val builder = AlarmArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Alarm {
        val builtJavaResource = com.pulumi.alicloud.ess.Alarm(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Alarm(builtJavaResource)
    }
}

/**
 * Provides a ESS alarm task resource.
 * For information about ess alarm, see [CreateAlarm](https://www.alibabacloud.com/help/en/auto-scaling/latest/createalarm).
 * > **NOTE:** Available since v1.15.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const myName = `${name}-${defaultInteger.result}`;
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 2,
 *     memorySize: 4,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: myName,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: myName,
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: myName,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultSecurityGroupRule = new alicloud.ecs.SecurityGroupRule("default", {
 *     type: "ingress",
 *     ipProtocol: "tcp",
 *     nicType: "intranet",
 *     policy: "accept",
 *     portRange: "22/22",
 *     priority: 1,
 *     securityGroupId: defaultSecurityGroup.id,
 *     cidrIp: "172.16.0.0/24",
 * });
 * const default2 = new alicloud.vpc.Switch("default2", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.1.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: `${name}-bar`,
 * });
 * const defaultScalingGroup = new alicloud.ess.ScalingGroup("default", {
 *     minSize: 1,
 *     maxSize: 1,
 *     scalingGroupName: myName,
 *     defaultCooldown: 20,
 *     vswitchIds: [
 *         defaultSwitch.id,
 *         default2.id,
 *     ],
 *     removalPolicies: [
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 * });
 * const defaultScalingRule = new alicloud.ess.ScalingRule("default", {
 *     scalingRuleName: myName,
 *     scalingGroupId: defaultScalingGroup.id,
 *     adjustmentType: "TotalCapacity",
 *     adjustmentValue: 2,
 *     cooldown: 60,
 * });
 * const defaultAlarm = new alicloud.ess.Alarm("default", {
 *     name: myName,
 *     description: name,
 *     alarmActions: [defaultScalingRule&#46;ari],
 *     scalingGroupId: defaultScalingGroup.id,
 *     metricType: "system",
 *     metricName: "CpuUtilization",
 *     period: 300,
 *     statistics: "Average",
 *     threshold: "200.3",
 *     comparisonOperator: ">=",
 *     evaluationCount: 2,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * my_name = f"{name}-{default_integer['result']}"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=2,
 *     memory_size=4)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=my_name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=my_name)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=my_name,
 *     vpc_id=default_network.id)
 * default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
 *     type="ingress",
 *     ip_protocol="tcp",
 *     nic_type="intranet",
 *     policy="accept",
 *     port_range="22/22",
 *     priority=1,
 *     security_group_id=default_security_group.id,
 *     cidr_ip="172.16.0.0/24")
 * default2 = alicloud.vpc.Switch("default2",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.1.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=f"{name}-bar")
 * default_scaling_group = alicloud.ess.ScalingGroup("default",
 *     min_size=1,
 *     max_size=1,
 *     scaling_group_name=my_name,
 *     default_cooldown=20,
 *     vswitch_ids=[
 *         default_switch.id,
 *         default2.id,
 *     ],
 *     removal_policies=[
 *         "OldestInstance",
 *         "NewestInstance",
 *     ])
 * default_scaling_rule = alicloud.ess.ScalingRule("default",
 *     scaling_rule_name=my_name,
 *     scaling_group_id=default_scaling_group.id,
 *     adjustment_type="TotalCapacity",
 *     adjustment_value=2,
 *     cooldown=60)
 * default_alarm = alicloud.ess.Alarm("default",
 *     name=my_name,
 *     description=name,
 *     alarm_actions=[default_scaling_rule&#46;ari],
 *     scaling_group_id=default_scaling_group.id,
 *     metric_type="system",
 *     metric_name="CpuUtilization",
 *     period=300,
 *     statistics="Average",
 *     threshold="200.3",
 *     comparison_operator=">=",
 *     evaluation_count=2)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var myName = $"{name}-{defaultInteger.Result}";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 2,
 *         MemorySize = 4,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = myName,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = myName,
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = myName,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultSecurityGroupRule = new AliCloud.Ecs.SecurityGroupRule("default", new()
 *     {
 *         Type = "ingress",
 *         IpProtocol = "tcp",
 *         NicType = "intranet",
 *         Policy = "accept",
 *         PortRange = "22/22",
 *         Priority = 1,
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         CidrIp = "172.16.0.0/24",
 *     });
 *     var default2 = new AliCloud.Vpc.Switch("default2", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.1.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = $"{name}-bar",
 *     });
 *     var defaultScalingGroup = new AliCloud.Ess.ScalingGroup("default", new()
 *     {
 *         MinSize = 1,
 *         MaxSize = 1,
 *         ScalingGroupName = myName,
 *         DefaultCooldown = 20,
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *             default2.Id,
 *         },
 *         RemovalPolicies = new[]
 *         {
 *             "OldestInstance",
 *             "NewestInstance",
 *         },
 *     });
 *     var defaultScalingRule = new AliCloud.Ess.ScalingRule("default", new()
 *     {
 *         ScalingRuleName = myName,
 *         ScalingGroupId = defaultScalingGroup.Id,
 *         AdjustmentType = "TotalCapacity",
 *         AdjustmentValue = 2,
 *         Cooldown = 60,
 *     });
 *     var defaultAlarm = new AliCloud.Ess.Alarm("default", new()
 *     {
 *         Name = myName,
 *         Description = name,
 *         AlarmActions = new[]
 *         {
 *             defaultScalingRule.Ari,
 *         },
 *         ScalingGroupId = defaultScalingGroup.Id,
 *         MetricType = "system",
 *         MetricName = "CpuUtilization",
 *         Period = 300,
 *         Statistics = "Average",
 *         Threshold = "200.3",
 *         ComparisonOperator = ">=",
 *         EvaluationCount = 2,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myName := fmt.Sprintf("%v-%v", name, defaultInteger.Result)
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(2),
 * 			MemorySize:       pulumi.Float64Ref(4),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(myName),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(myName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(myName),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroupRule(ctx, "default", &ecs.SecurityGroupRuleArgs{
 * 			Type:            pulumi.String("ingress"),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			NicType:         pulumi.String("intranet"),
 * 			Policy:          pulumi.String("accept"),
 * 			PortRange:       pulumi.String("22/22"),
 * 			Priority:        pulumi.Int(1),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			CidrIp:          pulumi.String("172.16.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default2, err := vpc.NewSwitch(ctx, "default2", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.1.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.Sprintf("%v-bar", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultScalingGroup, err := ess.NewScalingGroup(ctx, "default", &ess.ScalingGroupArgs{
 * 			MinSize:          pulumi.Int(1),
 * 			MaxSize:          pulumi.Int(1),
 * 			ScalingGroupName: pulumi.String(myName),
 * 			DefaultCooldown:  pulumi.Int(20),
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 				default2.ID(),
 * 			},
 * 			RemovalPolicies: pulumi.StringArray{
 * 				pulumi.String("OldestInstance"),
 * 				pulumi.String("NewestInstance"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultScalingRule, err := ess.NewScalingRule(ctx, "default", &ess.ScalingRuleArgs{
 * 			ScalingRuleName: pulumi.String(myName),
 * 			ScalingGroupId:  defaultScalingGroup.ID(),
 * 			AdjustmentType:  pulumi.String("TotalCapacity"),
 * 			AdjustmentValue: pulumi.Int(2),
 * 			Cooldown:        pulumi.Int(60),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ess.NewAlarm(ctx, "default", &ess.AlarmArgs{
 * 			Name:        pulumi.String(myName),
 * 			Description: pulumi.String(name),
 * 			AlarmActions: pulumi.StringArray{
 * 				defaultScalingRule.Ari,
 * 			},
 * 			ScalingGroupId:     defaultScalingGroup.ID(),
 * 			MetricType:         pulumi.String("system"),
 * 			MetricName:         pulumi.String("CpuUtilization"),
 * 			Period:             pulumi.Int(300),
 * 			Statistics:         pulumi.String("Average"),
 * 			Threshold:          pulumi.String("200.3"),
 * 			ComparisonOperator: pulumi.String(">="),
 * 			EvaluationCount:    pulumi.Int(2),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroupRule;
 * import com.pulumi.alicloud.ecs.SecurityGroupRuleArgs;
 * import com.pulumi.alicloud.ess.ScalingGroup;
 * import com.pulumi.alicloud.ess.ScalingGroupArgs;
 * import com.pulumi.alicloud.ess.ScalingRule;
 * import com.pulumi.alicloud.ess.ScalingRuleArgs;
 * import com.pulumi.alicloud.ess.Alarm;
 * import com.pulumi.alicloud.ess.AlarmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var myName = String.format("%s-%s", name,defaultInteger.result());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(2)
 *             .memorySize(4)
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(myName)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(myName)
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(myName)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultSecurityGroupRule = new SecurityGroupRule("defaultSecurityGroupRule", SecurityGroupRuleArgs.builder()
 *             .type("ingress")
 *             .ipProtocol("tcp")
 *             .nicType("intranet")
 *             .policy("accept")
 *             .portRange("22/22")
 *             .priority(1)
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .cidrIp("172.16.0.0/24")
 *             .build());
 *         var default2 = new Switch("default2", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.1.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(String.format("%s-bar", name))
 *             .build());
 *         var defaultScalingGroup = new ScalingGroup("defaultScalingGroup", ScalingGroupArgs.builder()
 *             .minSize(1)
 *             .maxSize(1)
 *             .scalingGroupName(myName)
 *             .defaultCooldown(20)
 *             .vswitchIds(
 *                 defaultSwitch.id(),
 *                 default2.id())
 *             .removalPolicies(
 *                 "OldestInstance",
 *                 "NewestInstance")
 *             .build());
 *         var defaultScalingRule = new ScalingRule("defaultScalingRule", ScalingRuleArgs.builder()
 *             .scalingRuleName(myName)
 *             .scalingGroupId(defaultScalingGroup.id())
 *             .adjustmentType("TotalCapacity")
 *             .adjustmentValue(2)
 *             .cooldown(60)
 *             .build());
 *         var defaultAlarm = new Alarm("defaultAlarm", AlarmArgs.builder()
 *             .name(myName)
 *             .description(name)
 *             .alarmActions(defaultScalingRule.ari())
 *             .scalingGroupId(defaultScalingGroup.id())
 *             .metricType("system")
 *             .metricName("CpuUtilization")
 *             .period(300)
 *             .statistics("Average")
 *             .threshold(200.3)
 *             .comparisonOperator(">=")
 *             .evaluationCount(2)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${myName}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${myName}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${myName}
 *       vpcId: ${defaultNetwork.id}
 *   defaultSecurityGroupRule:
 *     type: alicloud:ecs:SecurityGroupRule
 *     name: default
 *     properties:
 *       type: ingress
 *       ipProtocol: tcp
 *       nicType: intranet
 *       policy: accept
 *       portRange: 22/22
 *       priority: 1
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       cidrIp: 172.16.0.0/24
 *   default2:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.1.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}-bar
 *   defaultScalingGroup:
 *     type: alicloud:ess:ScalingGroup
 *     name: default
 *     properties:
 *       minSize: 1
 *       maxSize: 1
 *       scalingGroupName: ${myName}
 *       defaultCooldown: 20
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 *         - ${default2.id}
 *       removalPolicies:
 *         - OldestInstance
 *         - NewestInstance
 *   defaultScalingRule:
 *     type: alicloud:ess:ScalingRule
 *     name: default
 *     properties:
 *       scalingRuleName: ${myName}
 *       scalingGroupId: ${defaultScalingGroup.id}
 *       adjustmentType: TotalCapacity
 *       adjustmentValue: 2
 *       cooldown: 60
 *   defaultAlarm:
 *     type: alicloud:ess:Alarm
 *     name: default
 *     properties:
 *       name: ${myName}
 *       description: ${name}
 *       alarmActions:
 *         - ${defaultScalingRule.ari}
 *       scalingGroupId: ${defaultScalingGroup.id}
 *       metricType: system
 *       metricName: CpuUtilization
 *       period: 300
 *       statistics: Average
 *       threshold: 200.3
 *       comparisonOperator: '>='
 *       evaluationCount: 2
 * variables:
 *   myName: ${name}-${defaultInteger.result}
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 2
 *         memorySize: 4
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use to the existing autoscaling-rule module
 * to create alarm task, different type rules and scheduled task one-click.
 * ## Import
 * Ess alarm can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/alarm:Alarm example asg-2ze500_045efffe-4d05
 * ```
 */
public class Alarm internal constructor(
    override val javaResource: com.pulumi.alicloud.ess.Alarm,
) : KotlinCustomResource(javaResource, AlarmMapper) {
    /**
     * The list of actions to execute when this alarm transition into an ALARM state. Each action is specified as ess scaling rule ari.
     */
    public val alarmActions: Output<List<String>>
        get() = javaResource.alarmActions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Defines the application group id defined by CMS which is assigned when you upload custom metric to CMS, only available for custom metirc.
     */
    public val cloudMonitorGroupId: Output<Int>?
        get() = javaResource.cloudMonitorGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Supported value: >=, <=, >, <. Defaults to >=.
     */
    public val comparisonOperator: Output<String>
        get() = javaResource.comparisonOperator().applyValue({ args0 -> args0 })

    /**
     * The description for the alarm.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The dimension map for the alarm's associated metric. For all metrics, you can not set the dimension key as "scaling_group" or "userId", which is set by default, the second dimension for metric, such as "device" for "PackagesNetIn", need to be set by users. See `dimensions` below.
     */
    public val dimensions: Output<Map<String, String>>
        get() = javaResource.dimensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Whether to enable specific ess alarm. Default to true.
     */
    public val enable: Output<Boolean>?
        get() = javaResource.enable().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The number of times that needs to satisfies comparison condition before transition into ALARM state. Defaults to 3.
     */
    public val evaluationCount: Output<Int>?
        get() = javaResource.evaluationCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Support multi alert rule. See `expressions` below for details.
     */
    public val expressions: Output<List<AlarmExpression>>
        get() = javaResource.expressions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The relationship between the trigger conditions in the multi-metric alert rule.
     */
    public val expressionsLogicOperator: Output<String>
        get() = javaResource.expressionsLogicOperator().applyValue({ args0 -> args0 })

    /**
     * The name for the alarm's associated metric. See `dimensions` below for details.
     */
    public val metricName: Output<String>
        get() = javaResource.metricName().applyValue({ args0 -> args0 })

    /**
     * The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
     */
    public val metricType: Output<String>?
        get() = javaResource.metricType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name for ess alarm.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The period in seconds over which the specified statistic is applied. Supported value: 60, 120, 300, 900. Defaults to 300.
     */
    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * The scaling group associated with this alarm, the 'ForceNew' attribute is available in 1.56.0+.
     */
    public val scalingGroupId: Output<String>
        get() = javaResource.scalingGroupId().applyValue({ args0 -> args0 })

    /**
     * The status of the event-triggered task. Valid values:
     * - ALARM: The alert condition is met and an alert is triggered.
     * - OK: The alert condition is not met.
     * - INSUFFICIENT_DATA: Auto Scaling cannot determine whether the alert condition is met due to insufficient data.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The statistic to apply to the alarm's associated metric. Supported value: Average, Minimum, Maximum. Defaults to Average.
     */
    public val statistics: Output<String>
        get() = javaResource.statistics().applyValue({ args0 -> args0 })

    /**
     * The value against which the specified statistics is compared.
     */
    public val threshold: Output<String>
        get() = javaResource.threshold().applyValue({ args0 -> args0 })
}

public object AlarmMapper : ResourceMapper<Alarm> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ess.Alarm::class == javaResource::class

    override fun map(javaResource: Resource): Alarm = Alarm(
        javaResource as
            com.pulumi.alicloud.ess.Alarm,
    )
}

/**
 * @see [Alarm].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Alarm].
 */
public suspend fun alarm(name: String, block: suspend AlarmResourceBuilder.() -> Unit): Alarm {
    val builder = AlarmResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Alarm].
 * @param name The _unique_ name of the resulting resource.
 */
public fun alarm(name: String): Alarm {
    val builder = AlarmResourceBuilder()
    builder.name(name)
    return builder.build()
}
