@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.AlarmArgs.builder
import com.pulumi.alicloud.ess.kotlin.inputs.AlarmExpressionArgs
import com.pulumi.alicloud.ess.kotlin.inputs.AlarmExpressionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ESS alarm task resource.
 * For information about ess alarm, see [CreateAlarm](https://www.alibabacloud.com/help/en/auto-scaling/latest/createalarm).
 * > **NOTE:** Available since v1.15.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const myName = `${name}-${defaultInteger.result}`;
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 2,
 *     memorySize: 4,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: myName,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: myName,
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: myName,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultSecurityGroupRule = new alicloud.ecs.SecurityGroupRule("default", {
 *     type: "ingress",
 *     ipProtocol: "tcp",
 *     nicType: "intranet",
 *     policy: "accept",
 *     portRange: "22/22",
 *     priority: 1,
 *     securityGroupId: defaultSecurityGroup.id,
 *     cidrIp: "172.16.0.0/24",
 * });
 * const default2 = new alicloud.vpc.Switch("default2", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.1.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: `${name}-bar`,
 * });
 * const defaultScalingGroup = new alicloud.ess.ScalingGroup("default", {
 *     minSize: 1,
 *     maxSize: 1,
 *     scalingGroupName: myName,
 *     defaultCooldown: 20,
 *     vswitchIds: [
 *         defaultSwitch.id,
 *         default2.id,
 *     ],
 *     removalPolicies: [
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 * });
 * const defaultScalingRule = new alicloud.ess.ScalingRule("default", {
 *     scalingRuleName: myName,
 *     scalingGroupId: defaultScalingGroup.id,
 *     adjustmentType: "TotalCapacity",
 *     adjustmentValue: 2,
 *     cooldown: 60,
 * });
 * const defaultAlarm = new alicloud.ess.Alarm("default", {
 *     name: myName,
 *     description: name,
 *     alarmActions: [defaultScalingRule&#46;ari],
 *     scalingGroupId: defaultScalingGroup.id,
 *     metricType: "system",
 *     metricName: "CpuUtilization",
 *     period: 300,
 *     statistics: "Average",
 *     threshold: "200.3",
 *     comparisonOperator: ">=",
 *     evaluationCount: 2,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * my_name = f"{name}-{default_integer['result']}"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=2,
 *     memory_size=4)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=my_name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=my_name)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=my_name,
 *     vpc_id=default_network.id)
 * default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
 *     type="ingress",
 *     ip_protocol="tcp",
 *     nic_type="intranet",
 *     policy="accept",
 *     port_range="22/22",
 *     priority=1,
 *     security_group_id=default_security_group.id,
 *     cidr_ip="172.16.0.0/24")
 * default2 = alicloud.vpc.Switch("default2",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.1.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=f"{name}-bar")
 * default_scaling_group = alicloud.ess.ScalingGroup("default",
 *     min_size=1,
 *     max_size=1,
 *     scaling_group_name=my_name,
 *     default_cooldown=20,
 *     vswitch_ids=[
 *         default_switch.id,
 *         default2.id,
 *     ],
 *     removal_policies=[
 *         "OldestInstance",
 *         "NewestInstance",
 *     ])
 * default_scaling_rule = alicloud.ess.ScalingRule("default",
 *     scaling_rule_name=my_name,
 *     scaling_group_id=default_scaling_group.id,
 *     adjustment_type="TotalCapacity",
 *     adjustment_value=2,
 *     cooldown=60)
 * default_alarm = alicloud.ess.Alarm("default",
 *     name=my_name,
 *     description=name,
 *     alarm_actions=[default_scaling_rule&#46;ari],
 *     scaling_group_id=default_scaling_group.id,
 *     metric_type="system",
 *     metric_name="CpuUtilization",
 *     period=300,
 *     statistics="Average",
 *     threshold="200.3",
 *     comparison_operator=">=",
 *     evaluation_count=2)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var myName = $"{name}-{defaultInteger.Result}";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 2,
 *         MemorySize = 4,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = myName,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = myName,
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = myName,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultSecurityGroupRule = new AliCloud.Ecs.SecurityGroupRule("default", new()
 *     {
 *         Type = "ingress",
 *         IpProtocol = "tcp",
 *         NicType = "intranet",
 *         Policy = "accept",
 *         PortRange = "22/22",
 *         Priority = 1,
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         CidrIp = "172.16.0.0/24",
 *     });
 *     var default2 = new AliCloud.Vpc.Switch("default2", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.1.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = $"{name}-bar",
 *     });
 *     var defaultScalingGroup = new AliCloud.Ess.ScalingGroup("default", new()
 *     {
 *         MinSize = 1,
 *         MaxSize = 1,
 *         ScalingGroupName = myName,
 *         DefaultCooldown = 20,
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *             default2.Id,
 *         },
 *         RemovalPolicies = new[]
 *         {
 *             "OldestInstance",
 *             "NewestInstance",
 *         },
 *     });
 *     var defaultScalingRule = new AliCloud.Ess.ScalingRule("default", new()
 *     {
 *         ScalingRuleName = myName,
 *         ScalingGroupId = defaultScalingGroup.Id,
 *         AdjustmentType = "TotalCapacity",
 *         AdjustmentValue = 2,
 *         Cooldown = 60,
 *     });
 *     var defaultAlarm = new AliCloud.Ess.Alarm("default", new()
 *     {
 *         Name = myName,
 *         Description = name,
 *         AlarmActions = new[]
 *         {
 *             defaultScalingRule.Ari,
 *         },
 *         ScalingGroupId = defaultScalingGroup.Id,
 *         MetricType = "system",
 *         MetricName = "CpuUtilization",
 *         Period = 300,
 *         Statistics = "Average",
 *         Threshold = "200.3",
 *         ComparisonOperator = ">=",
 *         EvaluationCount = 2,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myName := fmt.Sprintf("%v-%v", name, defaultInteger.Result)
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(2),
 * 			MemorySize:       pulumi.Float64Ref(4),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(myName),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(myName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(myName),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroupRule(ctx, "default", &ecs.SecurityGroupRuleArgs{
 * 			Type:            pulumi.String("ingress"),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			NicType:         pulumi.String("intranet"),
 * 			Policy:          pulumi.String("accept"),
 * 			PortRange:       pulumi.String("22/22"),
 * 			Priority:        pulumi.Int(1),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			CidrIp:          pulumi.String("172.16.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default2, err := vpc.NewSwitch(ctx, "default2", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.1.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.Sprintf("%v-bar", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultScalingGroup, err := ess.NewScalingGroup(ctx, "default", &ess.ScalingGroupArgs{
 * 			MinSize:          pulumi.Int(1),
 * 			MaxSize:          pulumi.Int(1),
 * 			ScalingGroupName: pulumi.String(myName),
 * 			DefaultCooldown:  pulumi.Int(20),
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 				default2.ID(),
 * 			},
 * 			RemovalPolicies: pulumi.StringArray{
 * 				pulumi.String("OldestInstance"),
 * 				pulumi.String("NewestInstance"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultScalingRule, err := ess.NewScalingRule(ctx, "default", &ess.ScalingRuleArgs{
 * 			ScalingRuleName: pulumi.String(myName),
 * 			ScalingGroupId:  defaultScalingGroup.ID(),
 * 			AdjustmentType:  pulumi.String("TotalCapacity"),
 * 			AdjustmentValue: pulumi.Int(2),
 * 			Cooldown:        pulumi.Int(60),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ess.NewAlarm(ctx, "default", &ess.AlarmArgs{
 * 			Name:        pulumi.String(myName),
 * 			Description: pulumi.String(name),
 * 			AlarmActions: pulumi.StringArray{
 * 				defaultScalingRule.Ari,
 * 			},
 * 			ScalingGroupId:     defaultScalingGroup.ID(),
 * 			MetricType:         pulumi.String("system"),
 * 			MetricName:         pulumi.String("CpuUtilization"),
 * 			Period:             pulumi.Int(300),
 * 			Statistics:         pulumi.String("Average"),
 * 			Threshold:          pulumi.String("200.3"),
 * 			ComparisonOperator: pulumi.String(">="),
 * 			EvaluationCount:    pulumi.Int(2),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroupRule;
 * import com.pulumi.alicloud.ecs.SecurityGroupRuleArgs;
 * import com.pulumi.alicloud.ess.ScalingGroup;
 * import com.pulumi.alicloud.ess.ScalingGroupArgs;
 * import com.pulumi.alicloud.ess.ScalingRule;
 * import com.pulumi.alicloud.ess.ScalingRuleArgs;
 * import com.pulumi.alicloud.ess.Alarm;
 * import com.pulumi.alicloud.ess.AlarmArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var myName = String.format("%s-%s", name,defaultInteger.result());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(2)
 *             .memorySize(4)
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(myName)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(myName)
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(myName)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultSecurityGroupRule = new SecurityGroupRule("defaultSecurityGroupRule", SecurityGroupRuleArgs.builder()
 *             .type("ingress")
 *             .ipProtocol("tcp")
 *             .nicType("intranet")
 *             .policy("accept")
 *             .portRange("22/22")
 *             .priority(1)
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .cidrIp("172.16.0.0/24")
 *             .build());
 *         var default2 = new Switch("default2", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.1.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(String.format("%s-bar", name))
 *             .build());
 *         var defaultScalingGroup = new ScalingGroup("defaultScalingGroup", ScalingGroupArgs.builder()
 *             .minSize(1)
 *             .maxSize(1)
 *             .scalingGroupName(myName)
 *             .defaultCooldown(20)
 *             .vswitchIds(
 *                 defaultSwitch.id(),
 *                 default2.id())
 *             .removalPolicies(
 *                 "OldestInstance",
 *                 "NewestInstance")
 *             .build());
 *         var defaultScalingRule = new ScalingRule("defaultScalingRule", ScalingRuleArgs.builder()
 *             .scalingRuleName(myName)
 *             .scalingGroupId(defaultScalingGroup.id())
 *             .adjustmentType("TotalCapacity")
 *             .adjustmentValue(2)
 *             .cooldown(60)
 *             .build());
 *         var defaultAlarm = new Alarm("defaultAlarm", AlarmArgs.builder()
 *             .name(myName)
 *             .description(name)
 *             .alarmActions(defaultScalingRule.ari())
 *             .scalingGroupId(defaultScalingGroup.id())
 *             .metricType("system")
 *             .metricName("CpuUtilization")
 *             .period(300)
 *             .statistics("Average")
 *             .threshold(200.3)
 *             .comparisonOperator(">=")
 *             .evaluationCount(2)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${myName}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${myName}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${myName}
 *       vpcId: ${defaultNetwork.id}
 *   defaultSecurityGroupRule:
 *     type: alicloud:ecs:SecurityGroupRule
 *     name: default
 *     properties:
 *       type: ingress
 *       ipProtocol: tcp
 *       nicType: intranet
 *       policy: accept
 *       portRange: 22/22
 *       priority: 1
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       cidrIp: 172.16.0.0/24
 *   default2:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.1.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}-bar
 *   defaultScalingGroup:
 *     type: alicloud:ess:ScalingGroup
 *     name: default
 *     properties:
 *       minSize: 1
 *       maxSize: 1
 *       scalingGroupName: ${myName}
 *       defaultCooldown: 20
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 *         - ${default2.id}
 *       removalPolicies:
 *         - OldestInstance
 *         - NewestInstance
 *   defaultScalingRule:
 *     type: alicloud:ess:ScalingRule
 *     name: default
 *     properties:
 *       scalingRuleName: ${myName}
 *       scalingGroupId: ${defaultScalingGroup.id}
 *       adjustmentType: TotalCapacity
 *       adjustmentValue: 2
 *       cooldown: 60
 *   defaultAlarm:
 *     type: alicloud:ess:Alarm
 *     name: default
 *     properties:
 *       name: ${myName}
 *       description: ${name}
 *       alarmActions:
 *         - ${defaultScalingRule.ari}
 *       scalingGroupId: ${defaultScalingGroup.id}
 *       metricType: system
 *       metricName: CpuUtilization
 *       period: 300
 *       statistics: Average
 *       threshold: 200.3
 *       comparisonOperator: '>='
 *       evaluationCount: 2
 * variables:
 *   myName: ${name}-${defaultInteger.result}
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 2
 *         memorySize: 4
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use to the existing autoscaling-rule module
 * to create alarm task, different type rules and scheduled task one-click.
 * ## Import
 * Ess alarm can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/alarm:Alarm example asg-2ze500_045efffe-4d05
 * ```
 * @property alarmActions The list of actions to execute when this alarm transition into an ALARM state. Each action is specified as ess scaling rule ari.
 * @property cloudMonitorGroupId Defines the application group id defined by CMS which is assigned when you upload custom metric to CMS, only available for custom metirc.
 * @property comparisonOperator The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Supported value: >=, <=, >, <. Defaults to >=.
 * @property description The description for the alarm.
 * @property dimensions The dimension map for the alarm's associated metric. For all metrics, you can not set the dimension key as "scaling_group" or "userId", which is set by default, the second dimension for metric, such as "device" for "PackagesNetIn", need to be set by users. See `dimensions` below.
 * @property enable Whether to enable specific ess alarm. Default to true.
 * @property evaluationCount The number of times that needs to satisfies comparison condition before transition into ALARM state. Defaults to 3.
 * @property expressions Support multi alert rule. See `expressions` below for details.
 * @property expressionsLogicOperator The relationship between the trigger conditions in the multi-metric alert rule.
 * @property metricName The name for the alarm's associated metric. See `dimensions` below for details.
 * @property metricType The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
 * @property name The name for ess alarm.
 * @property period The period in seconds over which the specified statistic is applied. Supported value: 60, 120, 300, 900. Defaults to 300.
 * @property scalingGroupId The scaling group associated with this alarm, the 'ForceNew' attribute is available in 1.56.0+.
 * @property statistics The statistic to apply to the alarm's associated metric. Supported value: Average, Minimum, Maximum. Defaults to Average.
 * @property threshold The value against which the specified statistics is compared.
 */
public data class AlarmArgs(
    public val alarmActions: Output<List<String>>? = null,
    public val cloudMonitorGroupId: Output<Int>? = null,
    public val comparisonOperator: Output<String>? = null,
    public val description: Output<String>? = null,
    public val dimensions: Output<Map<String, String>>? = null,
    public val enable: Output<Boolean>? = null,
    public val evaluationCount: Output<Int>? = null,
    public val expressions: Output<List<AlarmExpressionArgs>>? = null,
    public val expressionsLogicOperator: Output<String>? = null,
    public val metricName: Output<String>? = null,
    public val metricType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val scalingGroupId: Output<String>? = null,
    public val statistics: Output<String>? = null,
    public val threshold: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.AlarmArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.AlarmArgs =
        com.pulumi.alicloud.ess.AlarmArgs.builder()
            .alarmActions(alarmActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cloudMonitorGroupId(cloudMonitorGroupId?.applyValue({ args0 -> args0 }))
            .comparisonOperator(comparisonOperator?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .enable(enable?.applyValue({ args0 -> args0 }))
            .evaluationCount(evaluationCount?.applyValue({ args0 -> args0 }))
            .expressions(
                expressions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .expressionsLogicOperator(expressionsLogicOperator?.applyValue({ args0 -> args0 }))
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .metricType(metricType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .scalingGroupId(scalingGroupId?.applyValue({ args0 -> args0 }))
            .statistics(statistics?.applyValue({ args0 -> args0 }))
            .threshold(threshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlarmArgs].
 */
@PulumiTagMarker
public class AlarmArgsBuilder internal constructor() {
    private var alarmActions: Output<List<String>>? = null

    private var cloudMonitorGroupId: Output<Int>? = null

    private var comparisonOperator: Output<String>? = null

    private var description: Output<String>? = null

    private var dimensions: Output<Map<String, String>>? = null

    private var enable: Output<Boolean>? = null

    private var evaluationCount: Output<Int>? = null

    private var expressions: Output<List<AlarmExpressionArgs>>? = null

    private var expressionsLogicOperator: Output<String>? = null

    private var metricName: Output<String>? = null

    private var metricType: Output<String>? = null

    private var name: Output<String>? = null

    private var period: Output<Int>? = null

    private var scalingGroupId: Output<String>? = null

    private var statistics: Output<String>? = null

    private var threshold: Output<String>? = null

    /**
     * @param value The list of actions to execute when this alarm transition into an ALARM state. Each action is specified as ess scaling rule ari.
     */
    @JvmName("kwapvrkvnbatlfng")
    public suspend fun alarmActions(`value`: Output<List<String>>) {
        this.alarmActions = value
    }

    @JvmName("fxpfgbehmwdpnipa")
    public suspend fun alarmActions(vararg values: Output<String>) {
        this.alarmActions = Output.all(values.asList())
    }

    /**
     * @param values The list of actions to execute when this alarm transition into an ALARM state. Each action is specified as ess scaling rule ari.
     */
    @JvmName("unhsxsigwkfvrfws")
    public suspend fun alarmActions(values: List<Output<String>>) {
        this.alarmActions = Output.all(values)
    }

    /**
     * @param value Defines the application group id defined by CMS which is assigned when you upload custom metric to CMS, only available for custom metirc.
     */
    @JvmName("ljhdhpeffprwmsrd")
    public suspend fun cloudMonitorGroupId(`value`: Output<Int>) {
        this.cloudMonitorGroupId = value
    }

    /**
     * @param value The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Supported value: >=, <=, >, <. Defaults to >=.
     */
    @JvmName("jldhpkkfrkqmufgi")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value The description for the alarm.
     */
    @JvmName("skwskimyicxyabpl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The dimension map for the alarm's associated metric. For all metrics, you can not set the dimension key as "scaling_group" or "userId", which is set by default, the second dimension for metric, such as "device" for "PackagesNetIn", need to be set by users. See `dimensions` below.
     */
    @JvmName("mhxxwubysnescxkk")
    public suspend fun dimensions(`value`: Output<Map<String, String>>) {
        this.dimensions = value
    }

    /**
     * @param value Whether to enable specific ess alarm. Default to true.
     */
    @JvmName("otrdhntnijjfxqvs")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The number of times that needs to satisfies comparison condition before transition into ALARM state. Defaults to 3.
     */
    @JvmName("arprspyrnojtcsnw")
    public suspend fun evaluationCount(`value`: Output<Int>) {
        this.evaluationCount = value
    }

    /**
     * @param value Support multi alert rule. See `expressions` below for details.
     */
    @JvmName("ndvvhggoltqxphec")
    public suspend fun expressions(`value`: Output<List<AlarmExpressionArgs>>) {
        this.expressions = value
    }

    @JvmName("oiikghjpfdvhkkok")
    public suspend fun expressions(vararg values: Output<AlarmExpressionArgs>) {
        this.expressions = Output.all(values.asList())
    }

    /**
     * @param values Support multi alert rule. See `expressions` below for details.
     */
    @JvmName("fdaejrujlatvtnte")
    public suspend fun expressions(values: List<Output<AlarmExpressionArgs>>) {
        this.expressions = Output.all(values)
    }

    /**
     * @param value The relationship between the trigger conditions in the multi-metric alert rule.
     */
    @JvmName("akupmbqruisuaped")
    public suspend fun expressionsLogicOperator(`value`: Output<String>) {
        this.expressionsLogicOperator = value
    }

    /**
     * @param value The name for the alarm's associated metric. See `dimensions` below for details.
     */
    @JvmName("hudcvlemililmouo")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
     */
    @JvmName("nksqymxtutneyhwq")
    public suspend fun metricType(`value`: Output<String>) {
        this.metricType = value
    }

    /**
     * @param value The name for ess alarm.
     */
    @JvmName("cgopdrobyjfckipt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The period in seconds over which the specified statistic is applied. Supported value: 60, 120, 300, 900. Defaults to 300.
     */
    @JvmName("cprlxxmlunfcksme")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The scaling group associated with this alarm, the 'ForceNew' attribute is available in 1.56.0+.
     */
    @JvmName("hrgtubuntbnsdqms")
    public suspend fun scalingGroupId(`value`: Output<String>) {
        this.scalingGroupId = value
    }

    /**
     * @param value The statistic to apply to the alarm's associated metric. Supported value: Average, Minimum, Maximum. Defaults to Average.
     */
    @JvmName("ebabtgdpavrllblo")
    public suspend fun statistics(`value`: Output<String>) {
        this.statistics = value
    }

    /**
     * @param value The value against which the specified statistics is compared.
     */
    @JvmName("kmnfplhrcrrwstmx")
    public suspend fun threshold(`value`: Output<String>) {
        this.threshold = value
    }

    /**
     * @param value The list of actions to execute when this alarm transition into an ALARM state. Each action is specified as ess scaling rule ari.
     */
    @JvmName("uggceuceopmdhjsn")
    public suspend fun alarmActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarmActions = mapped
    }

    /**
     * @param values The list of actions to execute when this alarm transition into an ALARM state. Each action is specified as ess scaling rule ari.
     */
    @JvmName("xtgbpphhoipahiar")
    public suspend fun alarmActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarmActions = mapped
    }

    /**
     * @param value Defines the application group id defined by CMS which is assigned when you upload custom metric to CMS, only available for custom metirc.
     */
    @JvmName("bwxmunoixervgrkd")
    public suspend fun cloudMonitorGroupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudMonitorGroupId = mapped
    }

    /**
     * @param value The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Supported value: >=, <=, >, <. Defaults to >=.
     */
    @JvmName("svwidygrcnqlqsem")
    public suspend fun comparisonOperator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value The description for the alarm.
     */
    @JvmName("khfcbkkvxyexamkt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The dimension map for the alarm's associated metric. For all metrics, you can not set the dimension key as "scaling_group" or "userId", which is set by default, the second dimension for metric, such as "device" for "PackagesNetIn", need to be set by users. See `dimensions` below.
     */
    @JvmName("maqkspwwqhxmpadg")
    public suspend fun dimensions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param values The dimension map for the alarm's associated metric. For all metrics, you can not set the dimension key as "scaling_group" or "userId", which is set by default, the second dimension for metric, such as "device" for "PackagesNetIn", need to be set by users. See `dimensions` below.
     */
    @JvmName("yhevgcyfvhwnixmd")
    public fun dimensions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value Whether to enable specific ess alarm. Default to true.
     */
    @JvmName("mennxdkewxcbyfaq")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The number of times that needs to satisfies comparison condition before transition into ALARM state. Defaults to 3.
     */
    @JvmName("rakvkycohbsijxrj")
    public suspend fun evaluationCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationCount = mapped
    }

    /**
     * @param value Support multi alert rule. See `expressions` below for details.
     */
    @JvmName("skxcaevmydsouubj")
    public suspend fun expressions(`value`: List<AlarmExpressionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressions = mapped
    }

    /**
     * @param argument Support multi alert rule. See `expressions` below for details.
     */
    @JvmName("clrbqrlmsaqbmqhb")
    public suspend fun expressions(argument: List<suspend AlarmExpressionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AlarmExpressionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.expressions = mapped
    }

    /**
     * @param argument Support multi alert rule. See `expressions` below for details.
     */
    @JvmName("rmwfrfoasrpumqua")
    public suspend fun expressions(vararg argument: suspend AlarmExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AlarmExpressionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.expressions = mapped
    }

    /**
     * @param argument Support multi alert rule. See `expressions` below for details.
     */
    @JvmName("frulbroiubojraxg")
    public suspend fun expressions(argument: suspend AlarmExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AlarmExpressionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.expressions = mapped
    }

    /**
     * @param values Support multi alert rule. See `expressions` below for details.
     */
    @JvmName("dobokmkfwgfswsvm")
    public suspend fun expressions(vararg values: AlarmExpressionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expressions = mapped
    }

    /**
     * @param value The relationship between the trigger conditions in the multi-metric alert rule.
     */
    @JvmName("lfncjcwauymabadm")
    public suspend fun expressionsLogicOperator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressionsLogicOperator = mapped
    }

    /**
     * @param value The name for the alarm's associated metric. See `dimensions` below for details.
     */
    @JvmName("sovdbrujnyhykpjt")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
     */
    @JvmName("kykgjtcuvfibmrvg")
    public suspend fun metricType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricType = mapped
    }

    /**
     * @param value The name for ess alarm.
     */
    @JvmName("ohvejmkmnxtvseod")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The period in seconds over which the specified statistic is applied. Supported value: 60, 120, 300, 900. Defaults to 300.
     */
    @JvmName("qkavfwuhjggkealk")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The scaling group associated with this alarm, the 'ForceNew' attribute is available in 1.56.0+.
     */
    @JvmName("daoulbojnplqmwsv")
    public suspend fun scalingGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingGroupId = mapped
    }

    /**
     * @param value The statistic to apply to the alarm's associated metric. Supported value: Average, Minimum, Maximum. Defaults to Average.
     */
    @JvmName("ddexqtnjyhyffqfq")
    public suspend fun statistics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statistics = mapped
    }

    /**
     * @param value The value against which the specified statistics is compared.
     */
    @JvmName("jkeivdnosixalwkl")
    public suspend fun threshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    internal fun build(): AlarmArgs = AlarmArgs(
        alarmActions = alarmActions,
        cloudMonitorGroupId = cloudMonitorGroupId,
        comparisonOperator = comparisonOperator,
        description = description,
        dimensions = dimensions,
        enable = enable,
        evaluationCount = evaluationCount,
        expressions = expressions,
        expressionsLogicOperator = expressionsLogicOperator,
        metricName = metricName,
        metricType = metricType,
        name = name,
        period = period,
        scalingGroupId = scalingGroupId,
        statistics = statistics,
        threshold = threshold,
    )
}
