@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.AlbServerGroupAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches/Detaches alb server group to a specified scaling group.
 * For information about alb server group attachment, see [AttachAlbServerGroups](https://www.alibabacloud.com/help/en/doc-detail/266800.html).
 * > **NOTE:** If scaling group's network type is `VPC`, the alb server groups must be in the same `VPC`.
 * > **NOTE:** Alb server group attachment is defined uniquely by `scaling_group_id`, `alb_server_group_id`, `port`.
 * > **NOTE:** Resource `alicloud.ess.AlbServerGroupAttachment` don't support modification.
 * > **NOTE:** Available since v1.158.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const myName = `${name}-${defaultInteger.result}`;
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 2,
 *     memorySize: 4,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: myName,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: myName,
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: myName,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultScalingGroup = new alicloud.ess.ScalingGroup("default", {
 *     minSize: 0,
 *     maxSize: 2,
 *     scalingGroupName: myName,
 *     defaultCooldown: 200,
 *     removalPolicies: ["OldestInstance"],
 *     vswitchIds: [defaultSwitch&#46;id],
 * });
 * const defaultScalingConfiguration = new alicloud.ess.ScalingConfiguration("default", {
 *     scalingGroupId: defaultScalingGroup.id,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     securityGroupId: defaultSecurityGroup.id,
 *     forceDelete: true,
 *     active: true,
 *     enable: true,
 * });
 * const defaultServerGroup = new alicloud.alb.ServerGroup("default", {
 *     serverGroupName: myName,
 *     vpcId: defaultNetwork.id,
 *     healthCheckConfig: {
 *         healthCheckEnabled: false,
 *     },
 *     stickySessionConfig: {
 *         stickySessionEnabled: true,
 *         cookie: "tf-example",
 *         stickySessionType: "Server",
 *     },
 * });
 * const defaultAlbServerGroupAttachment = new alicloud.ess.AlbServerGroupAttachment("default", {
 *     scalingGroupId: defaultScalingConfiguration.scalingGroupId,
 *     albServerGroupId: defaultServerGroup.id,
 *     port: 9000,
 *     weight: 50,
 *     forceAttach: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * my_name = f"{name}-{default_integer['result']}"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=2,
 *     memory_size=4)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=my_name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=my_name)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=my_name,
 *     vpc_id=default_network.id)
 * default_scaling_group = alicloud.ess.ScalingGroup("default",
 *     min_size=0,
 *     max_size=2,
 *     scaling_group_name=my_name,
 *     default_cooldown=200,
 *     removal_policies=["OldestInstance"],
 *     vswitch_ids=[default_switch&#46;id])
 * default_scaling_configuration = alicloud.ess.ScalingConfiguration("default",
 *     scaling_group_id=default_scaling_group.id,
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     security_group_id=default_security_group.id,
 *     force_delete=True,
 *     active=True,
 *     enable=True)
 * default_server_group = alicloud.alb.ServerGroup("default",
 *     server_group_name=my_name,
 *     vpc_id=default_network.id,
 *     health_check_config={
 *         "health_check_enabled": False,
 *     },
 *     sticky_session_config={
 *         "sticky_session_enabled": True,
 *         "cookie": "tf-example",
 *         "sticky_session_type": "Server",
 *     })
 * default_alb_server_group_attachment = alicloud.ess.AlbServerGroupAttachment("default",
 *     scaling_group_id=default_scaling_configuration.scaling_group_id,
 *     alb_server_group_id=default_server_group.id,
 *     port=9000,
 *     weight=50,
 *     force_attach=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var myName = $"{name}-{defaultInteger.Result}";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 2,
 *         MemorySize = 4,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = myName,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = myName,
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = myName,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultScalingGroup = new AliCloud.Ess.ScalingGroup("default", new()
 *     {
 *         MinSize = 0,
 *         MaxSize = 2,
 *         ScalingGroupName = myName,
 *         DefaultCooldown = 200,
 *         RemovalPolicies = new[]
 *         {
 *             "OldestInstance",
 *         },
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *     });
 *     var defaultScalingConfiguration = new AliCloud.Ess.ScalingConfiguration("default", new()
 *     {
 *         ScalingGroupId = defaultScalingGroup.Id,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         ForceDelete = true,
 *         Active = true,
 *         Enable = true,
 *     });
 *     var defaultServerGroup = new AliCloud.Alb.ServerGroup("default", new()
 *     {
 *         ServerGroupName = myName,
 *         VpcId = defaultNetwork.Id,
 *         HealthCheckConfig = new AliCloud.Alb.Inputs.ServerGroupHealthCheckConfigArgs
 *         {
 *             HealthCheckEnabled = false,
 *         },
 *         StickySessionConfig = new AliCloud.Alb.Inputs.ServerGroupStickySessionConfigArgs
 *         {
 *             StickySessionEnabled = true,
 *             Cookie = "tf-example",
 *             StickySessionType = "Server",
 *         },
 *     });
 *     var defaultAlbServerGroupAttachment = new AliCloud.Ess.AlbServerGroupAttachment("default", new()
 *     {
 *         ScalingGroupId = defaultScalingConfiguration.ScalingGroupId,
 *         AlbServerGroupId = defaultServerGroup.Id,
 *         Port = 9000,
 *         Weight = 50,
 *         ForceAttach = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/alb"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myName := fmt.Sprintf("%v-%v", name, defaultInteger.Result)
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(2),
 * 			MemorySize:       pulumi.Float64Ref(4),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(myName),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(myName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(myName),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultScalingGroup, err := ess.NewScalingGroup(ctx, "default", &ess.ScalingGroupArgs{
 * 			MinSize:          pulumi.Int(0),
 * 			MaxSize:          pulumi.Int(2),
 * 			ScalingGroupName: pulumi.String(myName),
 * 			DefaultCooldown:  pulumi.Int(200),
 * 			RemovalPolicies: pulumi.StringArray{
 * 				pulumi.String("OldestInstance"),
 * 			},
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultScalingConfiguration, err := ess.NewScalingConfiguration(ctx, "default", &ess.ScalingConfigurationArgs{
 * 			ScalingGroupId:  defaultScalingGroup.ID(),
 * 			ImageId:         pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceType:    pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			ForceDelete:     pulumi.Bool(true),
 * 			Active:          pulumi.Bool(true),
 * 			Enable:          pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultServerGroup, err := alb.NewServerGroup(ctx, "default", &alb.ServerGroupArgs{
 * 			ServerGroupName: pulumi.String(myName),
 * 			VpcId:           defaultNetwork.ID(),
 * 			HealthCheckConfig: &alb.ServerGroupHealthCheckConfigArgs{
 * 				HealthCheckEnabled: pulumi.Bool(false),
 * 			},
 * 			StickySessionConfig: &alb.ServerGroupStickySessionConfigArgs{
 * 				StickySessionEnabled: pulumi.Bool(true),
 * 				Cookie:               pulumi.String("tf-example"),
 * 				StickySessionType:    pulumi.String("Server"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ess.NewAlbServerGroupAttachment(ctx, "default", &ess.AlbServerGroupAttachmentArgs{
 * 			ScalingGroupId:   defaultScalingConfiguration.ScalingGroupId,
 * 			AlbServerGroupId: defaultServerGroup.ID(),
 * 			Port:             pulumi.Int(9000),
 * 			Weight:           pulumi.Int(50),
 * 			ForceAttach:      pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ess.ScalingGroup;
 * import com.pulumi.alicloud.ess.ScalingGroupArgs;
 * import com.pulumi.alicloud.ess.ScalingConfiguration;
 * import com.pulumi.alicloud.ess.ScalingConfigurationArgs;
 * import com.pulumi.alicloud.alb.ServerGroup;
 * import com.pulumi.alicloud.alb.ServerGroupArgs;
 * import com.pulumi.alicloud.alb.inputs.ServerGroupHealthCheckConfigArgs;
 * import com.pulumi.alicloud.alb.inputs.ServerGroupStickySessionConfigArgs;
 * import com.pulumi.alicloud.ess.AlbServerGroupAttachment;
 * import com.pulumi.alicloud.ess.AlbServerGroupAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var myName = String.format("%s-%s", name,defaultInteger.result());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(2)
 *             .memorySize(4)
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(myName)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(myName)
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(myName)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultScalingGroup = new ScalingGroup("defaultScalingGroup", ScalingGroupArgs.builder()
 *             .minSize("0")
 *             .maxSize("2")
 *             .scalingGroupName(myName)
 *             .defaultCooldown(200)
 *             .removalPolicies("OldestInstance")
 *             .vswitchIds(defaultSwitch.id())
 *             .build());
 *         var defaultScalingConfiguration = new ScalingConfiguration("defaultScalingConfiguration", ScalingConfigurationArgs.builder()
 *             .scalingGroupId(defaultScalingGroup.id())
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .forceDelete(true)
 *             .active(true)
 *             .enable(true)
 *             .build());
 *         var defaultServerGroup = new ServerGroup("defaultServerGroup", ServerGroupArgs.builder()
 *             .serverGroupName(myName)
 *             .vpcId(defaultNetwork.id())
 *             .healthCheckConfig(ServerGroupHealthCheckConfigArgs.builder()
 *                 .healthCheckEnabled("false")
 *                 .build())
 *             .stickySessionConfig(ServerGroupStickySessionConfigArgs.builder()
 *                 .stickySessionEnabled(true)
 *                 .cookie("tf-example")
 *                 .stickySessionType("Server")
 *                 .build())
 *             .build());
 *         var defaultAlbServerGroupAttachment = new AlbServerGroupAttachment("defaultAlbServerGroupAttachment", AlbServerGroupAttachmentArgs.builder()
 *             .scalingGroupId(defaultScalingConfiguration.scalingGroupId())
 *             .albServerGroupId(defaultServerGroup.id())
 *             .port(9000)
 *             .weight(50)
 *             .forceAttach(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${myName}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${myName}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${myName}
 *       vpcId: ${defaultNetwork.id}
 *   defaultScalingGroup:
 *     type: alicloud:ess:ScalingGroup
 *     name: default
 *     properties:
 *       minSize: '0'
 *       maxSize: '2'
 *       scalingGroupName: ${myName}
 *       defaultCooldown: 200
 *       removalPolicies:
 *         - OldestInstance
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 *   defaultScalingConfiguration:
 *     type: alicloud:ess:ScalingConfiguration
 *     name: default
 *     properties:
 *       scalingGroupId: ${defaultScalingGroup.id}
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       forceDelete: true
 *       active: true
 *       enable: true
 *   defaultServerGroup:
 *     type: alicloud:alb:ServerGroup
 *     name: default
 *     properties:
 *       serverGroupName: ${myName}
 *       vpcId: ${defaultNetwork.id}
 *       healthCheckConfig:
 *         healthCheckEnabled: 'false'
 *       stickySessionConfig:
 *         stickySessionEnabled: true
 *         cookie: tf-example
 *         stickySessionType: Server
 *   defaultAlbServerGroupAttachment:
 *     type: alicloud:ess:AlbServerGroupAttachment
 *     name: default
 *     properties:
 *       scalingGroupId: ${defaultScalingConfiguration.scalingGroupId}
 *       albServerGroupId: ${defaultServerGroup.id}
 *       port: 9000
 *       weight: 50
 *       forceAttach: true
 * variables:
 *   myName: ${name}-${defaultInteger.result}
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 2
 *         memorySize: 4
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ESS alb server groups can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/albServerGroupAttachment:AlbServerGroupAttachment example asg-xxx:sgp-xxx:5000
 * ```
 * @property albServerGroupId ID of Alb Server Group.
 * @property forceAttach If instances of scaling group are attached/removed from slb backend server when attach/detach alb
 * server group from scaling group. Default to false.
 * @property port The port will be used for Alb Server Group backend server.
 * @property scalingGroupId ID of the scaling group.
 * @property weight The weight of an ECS instance attached to the Alb Server Group.
 */
public data class AlbServerGroupAttachmentArgs(
    public val albServerGroupId: Output<String>? = null,
    public val forceAttach: Output<Boolean>? = null,
    public val port: Output<Int>? = null,
    public val scalingGroupId: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.AlbServerGroupAttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.AlbServerGroupAttachmentArgs =
        com.pulumi.alicloud.ess.AlbServerGroupAttachmentArgs.builder()
            .albServerGroupId(albServerGroupId?.applyValue({ args0 -> args0 }))
            .forceAttach(forceAttach?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .scalingGroupId(scalingGroupId?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlbServerGroupAttachmentArgs].
 */
@PulumiTagMarker
public class AlbServerGroupAttachmentArgsBuilder internal constructor() {
    private var albServerGroupId: Output<String>? = null

    private var forceAttach: Output<Boolean>? = null

    private var port: Output<Int>? = null

    private var scalingGroupId: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value ID of Alb Server Group.
     */
    @JvmName("minosojqbflmpvot")
    public suspend fun albServerGroupId(`value`: Output<String>) {
        this.albServerGroupId = value
    }

    /**
     * @param value If instances of scaling group are attached/removed from slb backend server when attach/detach alb
     * server group from scaling group. Default to false.
     */
    @JvmName("giqcwbkcjakyuxap")
    public suspend fun forceAttach(`value`: Output<Boolean>) {
        this.forceAttach = value
    }

    /**
     * @param value The port will be used for Alb Server Group backend server.
     */
    @JvmName("gmjuqmvpgbdbekmd")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value ID of the scaling group.
     */
    @JvmName("cpewmrwaxqxfgfke")
    public suspend fun scalingGroupId(`value`: Output<String>) {
        this.scalingGroupId = value
    }

    /**
     * @param value The weight of an ECS instance attached to the Alb Server Group.
     */
    @JvmName("gdcflnydvxiuecor")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value ID of Alb Server Group.
     */
    @JvmName("bhfvbtcyvjnklbpp")
    public suspend fun albServerGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.albServerGroupId = mapped
    }

    /**
     * @param value If instances of scaling group are attached/removed from slb backend server when attach/detach alb
     * server group from scaling group. Default to false.
     */
    @JvmName("veybraqywcgtepwy")
    public suspend fun forceAttach(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceAttach = mapped
    }

    /**
     * @param value The port will be used for Alb Server Group backend server.
     */
    @JvmName("ailyukkiewbtadtm")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value ID of the scaling group.
     */
    @JvmName("hworwxlekvtwdbip")
    public suspend fun scalingGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingGroupId = mapped
    }

    /**
     * @param value The weight of an ECS instance attached to the Alb Server Group.
     */
    @JvmName("wcfrqjrmtvuveojh")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): AlbServerGroupAttachmentArgs = AlbServerGroupAttachmentArgs(
        albServerGroupId = albServerGroupId,
        forceAttach = forceAttach,
        port = port,
        scalingGroupId = scalingGroupId,
        weight = weight,
    )
}
