@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.AttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Attaches several ECS instances to a specified scaling group or remove them from it.
 * > **NOTE:** ECS instances can be attached or remove only when the scaling group is active, and it has no scaling activity in progress.
 * > **NOTE:** There are two types ECS instances in a scaling group: "AutoCreated" and "Attached". The total number of them can not larger than the scaling group "MaxSize".
 * > **NOTE:** Available since v1.6.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const myName = `${name}-${defaultInteger.result}`;
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 2,
 *     memorySize: 4,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultGetNetworks = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultGetSwitches = Promise.all([defaultGetNetworks, _default])&#46;then(([defaultGetNetworks, _default]) => alicloud.vpc.getSwitches({
 *     cidrBlock: "10.4.0.0/24",
 *     vpcId: defaultGetNetworks.ids?.[0],
 *     zoneId: _default.zones?.[0]?.id,
 * }));
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {vpcId: defaultGetNetworks.then(defaultGetNetworks => defaultGetNetworks.ids?.[0])});
 * const defaultSecurityGroupRule = new alicloud.ecs.SecurityGroupRule("default", {
 *     type: "ingress",
 *     ipProtocol: "tcp",
 *     nicType: "intranet",
 *     policy: "accept",
 *     portRange: "22/22",
 *     priority: 1,
 *     securityGroupId: defaultSecurityGroup.id,
 *     cidrIp: "172.16.0.0/24",
 * });
 * const defaultScalingGroup = new alicloud.ess.ScalingGroup("default", {
 *     minSize: 0,
 *     maxSize: 2,
 *     scalingGroupName: myName,
 *     removalPolicies: [
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 *     vswitchIds: [defaultGetSwitches&#46;then(defaultGetSwitches => defaultGetSwitches&#46;ids?&#46;[0])],
 * });
 * const defaultScalingConfiguration = new alicloud.ess.ScalingConfiguration("default", {
 *     scalingGroupId: defaultScalingGroup.id,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     securityGroupId: defaultSecurityGroup.id,
 *     forceDelete: true,
 *     active: true,
 *     enable: true,
 * });
 * const defaultInstance: alicloud.ecs.Instance[] = [];
 * for (const range = {value: 0}; range.value < 2; range.value++) {
 *     defaultInstance.push(new alicloud.ecs.Instance(`default-${range.value}`, {
 *         imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *         instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *         securityGroups: [defaultSecurityGroup&#46;id],
 *         internetChargeType: "PayByTraffic",
 *         internetMaxBandwidthOut: 10,
 *         instanceChargeType: "PostPaid",
 *         systemDiskCategory: "cloud_efficiency",
 *         vswitchId: defaultGetSwitches.then(defaultGetSwitches => defaultGetSwitches.ids?.[0]),
 *         instanceName: name,
 *     }));
 * }
 * const defaultAttachment = new alicloud.ess.Attachment("default", {
 *     scalingGroupId: defaultScalingGroup.id,
 *     instanceIds: [
 *         defaultInstance[0].id,
 *         defaultInstance[1].id,
 *     ],
 *     force: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * my_name = f"{name}-{default_integer['result']}"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=2,
 *     memory_size=4)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_get_networks = alicloud.vpc.get_networks(name_regex="^default-NODELETING$",
 *     cidr_block="10.4.0.0/16")
 * default_get_switches = alicloud.vpc.get_switches(cidr_block="10.4.0.0/24",
 *     vpc_id=default_get_networks.ids[0],
 *     zone_id=default.zones[0].id)
 * default_security_group = alicloud.ecs.SecurityGroup("default", vpc_id=default_get_networks.ids[0])
 * default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
 *     type="ingress",
 *     ip_protocol="tcp",
 *     nic_type="intranet",
 *     policy="accept",
 *     port_range="22/22",
 *     priority=1,
 *     security_group_id=default_security_group.id,
 *     cidr_ip="172.16.0.0/24")
 * default_scaling_group = alicloud.ess.ScalingGroup("default",
 *     min_size=0,
 *     max_size=2,
 *     scaling_group_name=my_name,
 *     removal_policies=[
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 *     vswitch_ids=[default_get_switches&#46;ids[0]])
 * default_scaling_configuration = alicloud.ess.ScalingConfiguration("default",
 *     scaling_group_id=default_scaling_group.id,
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     security_group_id=default_security_group.id,
 *     force_delete=True,
 *     active=True,
 *     enable=True)
 * default_instance = []
 * for range in [{"value": i} for i in range(0, 2)]:
 *     default_instance.append(alicloud.ecs.Instance(f"default-{range['value']}",
 *         image_id=default_get_images.images[0].id,
 *         instance_type=default_get_instance_types.instance_types[0].id,
 *         security_groups=[default_security_group&#46;id],
 *         internet_charge_type="PayByTraffic",
 *         internet_max_bandwidth_out=10,
 *         instance_charge_type="PostPaid",
 *         system_disk_category="cloud_efficiency",
 *         vswitch_id=default_get_switches.ids[0],
 *         instance_name=name))
 * default_attachment = alicloud.ess.Attachment("default",
 *     scaling_group_id=default_scaling_group.id,
 *     instance_ids=[
 *         default_instance[0].id,
 *         default_instance[1].id,
 *     ],
 *     force=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var myName = $"{name}-{defaultInteger.Result}";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 2,
 *         MemorySize = 4,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultGetNetworks = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         CidrBlock = "10.4.0.0/24",
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         VpcId = defaultGetNetworks.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *     });
 *     var defaultSecurityGroupRule = new AliCloud.Ecs.SecurityGroupRule("default", new()
 *     {
 *         Type = "ingress",
 *         IpProtocol = "tcp",
 *         NicType = "intranet",
 *         Policy = "accept",
 *         PortRange = "22/22",
 *         Priority = 1,
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         CidrIp = "172.16.0.0/24",
 *     });
 *     var defaultScalingGroup = new AliCloud.Ess.ScalingGroup("default", new()
 *     {
 *         MinSize = 0,
 *         MaxSize = 2,
 *         ScalingGroupName = myName,
 *         RemovalPolicies = new[]
 *         {
 *             "OldestInstance",
 *             "NewestInstance",
 *         },
 *         VswitchIds = new[]
 *         {
 *             defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         },
 *     });
 *     var defaultScalingConfiguration = new AliCloud.Ess.ScalingConfiguration("default", new()
 *     {
 *         ScalingGroupId = defaultScalingGroup.Id,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         ForceDelete = true,
 *         Active = true,
 *         Enable = true,
 *     });
 *     var defaultInstance = new List<AliCloud.Ecs.Instance>();
 *     for (var rangeIndex = 0; rangeIndex < 2; rangeIndex++)
 *     {
 *         var range = new { Value = rangeIndex };
 *         defaultInstance.Add(new AliCloud.Ecs.Instance($"default-{range.Value}", new()
 *         {
 *             ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *             InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *             SecurityGroups = new[]
 *             {
 *                 defaultSecurityGroup.Id,
 *             },
 *             InternetChargeType = "PayByTraffic",
 *             InternetMaxBandwidthOut = 10,
 *             InstanceChargeType = "PostPaid",
 *             SystemDiskCategory = "cloud_efficiency",
 *             VswitchId = defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *             InstanceName = name,
 *         }));
 *     }
 *     var defaultAttachment = new AliCloud.Ess.Attachment("default", new()
 *     {
 *         ScalingGroupId = defaultScalingGroup.Id,
 *         InstanceIds = new[]
 *         {
 *             defaultInstance[0].Id,
 *             defaultInstance[1].Id,
 *         },
 *         Force = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myName := fmt.Sprintf("%v-%v", name, defaultInteger.Result)
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(2),
 * 			MemorySize:       pulumi.Float64Ref(4),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNetworks, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 			CidrBlock: pulumi.StringRef("10.4.0.0/16"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			CidrBlock: pulumi.StringRef("10.4.0.0/24"),
 * 			VpcId:     pulumi.StringRef(defaultGetNetworks.Ids[0]),
 * 			ZoneId:    pulumi.StringRef(_default.Zones[0].Id),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			VpcId: pulumi.String(defaultGetNetworks.Ids[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroupRule(ctx, "default", &ecs.SecurityGroupRuleArgs{
 * 			Type:            pulumi.String("ingress"),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			NicType:         pulumi.String("intranet"),
 * 			Policy:          pulumi.String("accept"),
 * 			PortRange:       pulumi.String("22/22"),
 * 			Priority:        pulumi.Int(1),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			CidrIp:          pulumi.String("172.16.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultScalingGroup, err := ess.NewScalingGroup(ctx, "default", &ess.ScalingGroupArgs{
 * 			MinSize:          pulumi.Int(0),
 * 			MaxSize:          pulumi.Int(2),
 * 			ScalingGroupName: pulumi.String(myName),
 * 			RemovalPolicies: pulumi.StringArray{
 * 				pulumi.String("OldestInstance"),
 * 				pulumi.String("NewestInstance"),
 * 			},
 * 			VswitchIds: pulumi.StringArray{
 * 				pulumi.String(defaultGetSwitches.Ids[0]),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ess.NewScalingConfiguration(ctx, "default", &ess.ScalingConfigurationArgs{
 * 			ScalingGroupId:  defaultScalingGroup.ID(),
 * 			ImageId:         pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceType:    pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			ForceDelete:     pulumi.Bool(true),
 * 			Active:          pulumi.Bool(true),
 * 			Enable:          pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		var defaultInstance []*ecs.Instance
 * 		for index := 0; index < 2; index++ {
 * 			key0 := index
 * 			_ := index
 * 			__res, err := ecs.NewInstance(ctx, fmt.Sprintf("default-%v", key0), &ecs.InstanceArgs{
 * 				ImageId:      pulumi.String(defaultGetImages.Images[0].Id),
 * 				InstanceType: pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 				SecurityGroups: pulumi.StringArray{
 * 					defaultSecurityGroup.ID(),
 * 				},
 * 				InternetChargeType:      pulumi.String("PayByTraffic"),
 * 				InternetMaxBandwidthOut: pulumi.Int(10),
 * 				InstanceChargeType:      pulumi.String("PostPaid"),
 * 				SystemDiskCategory:      pulumi.String("cloud_efficiency"),
 * 				VswitchId:               pulumi.String(defaultGetSwitches.Ids[0]),
 * 				InstanceName:            pulumi.String(name),
 * 			})
 * 			if err != nil {
 * 				return err
 * 			}
 * 			defaultInstance = append(defaultInstance, __res)
 * 		}
 * 		_, err = ess.NewAttachment(ctx, "default", &ess.AttachmentArgs{
 * 			ScalingGroupId: defaultScalingGroup.ID(),
 * 			InstanceIds: pulumi.StringArray{
 * 				defaultInstance[0].ID(),
 * 				defaultInstance[1].ID(),
 * 			},
 * 			Force: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroupRule;
 * import com.pulumi.alicloud.ecs.SecurityGroupRuleArgs;
 * import com.pulumi.alicloud.ess.ScalingGroup;
 * import com.pulumi.alicloud.ess.ScalingGroupArgs;
 * import com.pulumi.alicloud.ess.ScalingConfiguration;
 * import com.pulumi.alicloud.ess.ScalingConfigurationArgs;
 * import com.pulumi.alicloud.ecs.Instance;
 * import com.pulumi.alicloud.ecs.InstanceArgs;
 * import com.pulumi.alicloud.ess.Attachment;
 * import com.pulumi.alicloud.ess.AttachmentArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var myName = String.format("%s-%s", name,defaultInteger.result());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(2)
 *             .memorySize(4)
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         final var defaultGetNetworks = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .cidrBlock("10.4.0.0/24")
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .zoneId(default_.zones()[0].id())
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .vpcId(defaultGetNetworks.applyValue(getNetworksResult -> getNetworksResult.ids()[0]))
 *             .build());
 *         var defaultSecurityGroupRule = new SecurityGroupRule("defaultSecurityGroupRule", SecurityGroupRuleArgs.builder()
 *             .type("ingress")
 *             .ipProtocol("tcp")
 *             .nicType("intranet")
 *             .policy("accept")
 *             .portRange("22/22")
 *             .priority(1)
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .cidrIp("172.16.0.0/24")
 *             .build());
 *         var defaultScalingGroup = new ScalingGroup("defaultScalingGroup", ScalingGroupArgs.builder()
 *             .minSize(0)
 *             .maxSize(2)
 *             .scalingGroupName(myName)
 *             .removalPolicies(
 *                 "OldestInstance",
 *                 "NewestInstance")
 *             .vswitchIds(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .build());
 *         var defaultScalingConfiguration = new ScalingConfiguration("defaultScalingConfiguration", ScalingConfigurationArgs.builder()
 *             .scalingGroupId(defaultScalingGroup.id())
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .forceDelete(true)
 *             .active(true)
 *             .enable(true)
 *             .build());
 *         for (var i = 0; i < 2; i++) {
 *             new Instance("defaultInstance-" + i, InstanceArgs.builder()
 *                 .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *                 .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *                 .securityGroups(defaultSecurityGroup.id())
 *                 .internetChargeType("PayByTraffic")
 *                 .internetMaxBandwidthOut("10")
 *                 .instanceChargeType("PostPaid")
 *                 .systemDiskCategory("cloud_efficiency")
 *                 .vswitchId(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *                 .instanceName(name)
 *                 .build());
 * }
 *         var defaultAttachment = new Attachment("defaultAttachment", AttachmentArgs.builder()
 *             .scalingGroupId(defaultScalingGroup.id())
 *             .instanceIds(
 *                 defaultInstance[0].id(),
 *                 defaultInstance[1].id())
 *             .force(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       vpcId: ${defaultGetNetworks.ids[0]}
 *   defaultSecurityGroupRule:
 *     type: alicloud:ecs:SecurityGroupRule
 *     name: default
 *     properties:
 *       type: ingress
 *       ipProtocol: tcp
 *       nicType: intranet
 *       policy: accept
 *       portRange: 22/22
 *       priority: 1
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       cidrIp: 172.16.0.0/24
 *   defaultScalingGroup:
 *     type: alicloud:ess:ScalingGroup
 *     name: default
 *     properties:
 *       minSize: 0
 *       maxSize: 2
 *       scalingGroupName: ${myName}
 *       removalPolicies:
 *         - OldestInstance
 *         - NewestInstance
 *       vswitchIds:
 *         - ${defaultGetSwitches.ids[0]}
 *   defaultScalingConfiguration:
 *     type: alicloud:ess:ScalingConfiguration
 *     name: default
 *     properties:
 *       scalingGroupId: ${defaultScalingGroup.id}
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       forceDelete: true
 *       active: true
 *       enable: true
 *   defaultInstance:
 *     type: alicloud:ecs:Instance
 *     name: default
 *     properties:
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       securityGroups:
 *         - ${defaultSecurityGroup.id}
 *       internetChargeType: PayByTraffic
 *       internetMaxBandwidthOut: '10'
 *       instanceChargeType: PostPaid
 *       systemDiskCategory: cloud_efficiency
 *       vswitchId: ${defaultGetSwitches.ids[0]}
 *       instanceName: ${name}
 *     options: {}
 *   defaultAttachment:
 *     type: alicloud:ess:Attachment
 *     name: default
 *     properties:
 *       scalingGroupId: ${defaultScalingGroup.id}
 *       instanceIds:
 *         - ${defaultInstance[0].id}
 *         - ${defaultInstance[1].id}
 *       force: true
 * variables:
 *   myName: ${name}-${defaultInteger.result}
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 2
 *         memorySize: 4
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 *   defaultGetNetworks:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *         cidrBlock: 10.4.0.0/16
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         cidrBlock: 10.4.0.0/24
 *         vpcId: ${defaultGetNetworks.ids[0]}
 *         zoneId: ${default.zones[0].id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ESS attachment can be imported using the id or scaling group id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/attachment:Attachment example asg-abc123456
 * ```
 * @property entrusted Specifies whether the scaling group manages the lifecycles of the instances that are manually added to the scaling group.
 * @property force Whether to remove forcibly "AutoCreated" ECS instances in order to release scaling group capacity "MaxSize" for attaching ECS instances. Default to false.
 * @property instanceIds ID of the ECS instance to be attached to the scaling group. You can input up to 20 IDs.
 * @property lifecycleHook Specifies whether to trigger a lifecycle hook for the scaling group to which instances are being added.
 * @property loadBalancerWeights The weight of ECS instance N or elastic container instance N as a backend server of the associated Server Load Balancer (SLB) instance. Valid values of N: 1 to 20. Valid values of this parameter: 1 to 100.
 * > **NOTE:** "AutoCreated" ECS instance will be deleted after it is removed from scaling group, but "Attached" will be not.
 * > **NOTE:** Restrictions on attaching ECS instances:
 * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
 * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
 * - The attached ECS instances must in the running state.
 * - The attached ECS instances has not been attached to other scaling groups.
 * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
 * @property scalingGroupId ID of the scaling group of a scaling configuration.
 */
public data class AttachmentArgs(
    public val entrusted: Output<Boolean>? = null,
    public val force: Output<Boolean>? = null,
    public val instanceIds: Output<List<String>>? = null,
    public val lifecycleHook: Output<Boolean>? = null,
    public val loadBalancerWeights: Output<List<Int>>? = null,
    public val scalingGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.AttachmentArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.AttachmentArgs =
        com.pulumi.alicloud.ess.AttachmentArgs.builder()
            .entrusted(entrusted?.applyValue({ args0 -> args0 }))
            .force(force?.applyValue({ args0 -> args0 }))
            .instanceIds(instanceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .lifecycleHook(lifecycleHook?.applyValue({ args0 -> args0 }))
            .loadBalancerWeights(loadBalancerWeights?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .scalingGroupId(scalingGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AttachmentArgs].
 */
@PulumiTagMarker
public class AttachmentArgsBuilder internal constructor() {
    private var entrusted: Output<Boolean>? = null

    private var force: Output<Boolean>? = null

    private var instanceIds: Output<List<String>>? = null

    private var lifecycleHook: Output<Boolean>? = null

    private var loadBalancerWeights: Output<List<Int>>? = null

    private var scalingGroupId: Output<String>? = null

    /**
     * @param value Specifies whether the scaling group manages the lifecycles of the instances that are manually added to the scaling group.
     */
    @JvmName("kgyeonrjejbgamvf")
    public suspend fun entrusted(`value`: Output<Boolean>) {
        this.entrusted = value
    }

    /**
     * @param value Whether to remove forcibly "AutoCreated" ECS instances in order to release scaling group capacity "MaxSize" for attaching ECS instances. Default to false.
     */
    @JvmName("wrudvphfvmdnpnns")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value ID of the ECS instance to be attached to the scaling group. You can input up to 20 IDs.
     */
    @JvmName("ggxqhgfhxtjlmnoa")
    public suspend fun instanceIds(`value`: Output<List<String>>) {
        this.instanceIds = value
    }

    @JvmName("natuwvokwpyqhefl")
    public suspend fun instanceIds(vararg values: Output<String>) {
        this.instanceIds = Output.all(values.asList())
    }

    /**
     * @param values ID of the ECS instance to be attached to the scaling group. You can input up to 20 IDs.
     */
    @JvmName("dsnserbbynxrmska")
    public suspend fun instanceIds(values: List<Output<String>>) {
        this.instanceIds = Output.all(values)
    }

    /**
     * @param value Specifies whether to trigger a lifecycle hook for the scaling group to which instances are being added.
     */
    @JvmName("qwuhxndobaimnubb")
    public suspend fun lifecycleHook(`value`: Output<Boolean>) {
        this.lifecycleHook = value
    }

    /**
     * @param value The weight of ECS instance N or elastic container instance N as a backend server of the associated Server Load Balancer (SLB) instance. Valid values of N: 1 to 20. Valid values of this parameter: 1 to 100.
     * > **NOTE:** "AutoCreated" ECS instance will be deleted after it is removed from scaling group, but "Attached" will be not.
     * > **NOTE:** Restrictions on attaching ECS instances:
     * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
     * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
     * - The attached ECS instances must in the running state.
     * - The attached ECS instances has not been attached to other scaling groups.
     * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
     */
    @JvmName("gwrqeeccxleinxmc")
    public suspend fun loadBalancerWeights(`value`: Output<List<Int>>) {
        this.loadBalancerWeights = value
    }

    @JvmName("lbltoqofrehjeqgr")
    public suspend fun loadBalancerWeights(vararg values: Output<Int>) {
        this.loadBalancerWeights = Output.all(values.asList())
    }

    /**
     * @param values The weight of ECS instance N or elastic container instance N as a backend server of the associated Server Load Balancer (SLB) instance. Valid values of N: 1 to 20. Valid values of this parameter: 1 to 100.
     * > **NOTE:** "AutoCreated" ECS instance will be deleted after it is removed from scaling group, but "Attached" will be not.
     * > **NOTE:** Restrictions on attaching ECS instances:
     * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
     * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
     * - The attached ECS instances must in the running state.
     * - The attached ECS instances has not been attached to other scaling groups.
     * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
     */
    @JvmName("bvfarowxadiprfyq")
    public suspend fun loadBalancerWeights(values: List<Output<Int>>) {
        this.loadBalancerWeights = Output.all(values)
    }

    /**
     * @param value ID of the scaling group of a scaling configuration.
     */
    @JvmName("xbfgdwftvwmtrvko")
    public suspend fun scalingGroupId(`value`: Output<String>) {
        this.scalingGroupId = value
    }

    /**
     * @param value Specifies whether the scaling group manages the lifecycles of the instances that are manually added to the scaling group.
     */
    @JvmName("fkbcdkfbogggviur")
    public suspend fun entrusted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entrusted = mapped
    }

    /**
     * @param value Whether to remove forcibly "AutoCreated" ECS instances in order to release scaling group capacity "MaxSize" for attaching ECS instances. Default to false.
     */
    @JvmName("mvhyjhtmsmcwoehx")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value ID of the ECS instance to be attached to the scaling group. You can input up to 20 IDs.
     */
    @JvmName("guhepwcofdyfxkty")
    public suspend fun instanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param values ID of the ECS instance to be attached to the scaling group. You can input up to 20 IDs.
     */
    @JvmName("poalmlchmesnahdj")
    public suspend fun instanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param value Specifies whether to trigger a lifecycle hook for the scaling group to which instances are being added.
     */
    @JvmName("pcjworqqlmcjwfyu")
    public suspend fun lifecycleHook(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleHook = mapped
    }

    /**
     * @param value The weight of ECS instance N or elastic container instance N as a backend server of the associated Server Load Balancer (SLB) instance. Valid values of N: 1 to 20. Valid values of this parameter: 1 to 100.
     * > **NOTE:** "AutoCreated" ECS instance will be deleted after it is removed from scaling group, but "Attached" will be not.
     * > **NOTE:** Restrictions on attaching ECS instances:
     * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
     * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
     * - The attached ECS instances must in the running state.
     * - The attached ECS instances has not been attached to other scaling groups.
     * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
     */
    @JvmName("ffjbasrgcirbhaxi")
    public suspend fun loadBalancerWeights(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerWeights = mapped
    }

    /**
     * @param values The weight of ECS instance N or elastic container instance N as a backend server of the associated Server Load Balancer (SLB) instance. Valid values of N: 1 to 20. Valid values of this parameter: 1 to 100.
     * > **NOTE:** "AutoCreated" ECS instance will be deleted after it is removed from scaling group, but "Attached" will be not.
     * > **NOTE:** Restrictions on attaching ECS instances:
     * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
     * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
     * - The attached ECS instances must in the running state.
     * - The attached ECS instances has not been attached to other scaling groups.
     * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
     */
    @JvmName("ugnnensglmxmdbts")
    public suspend fun loadBalancerWeights(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerWeights = mapped
    }

    /**
     * @param value ID of the scaling group of a scaling configuration.
     */
    @JvmName("wsxytnrhngpcriue")
    public suspend fun scalingGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingGroupId = mapped
    }

    internal fun build(): AttachmentArgs = AttachmentArgs(
        entrusted = entrusted,
        force = force,
        instanceIds = instanceIds,
        lifecycleHook = lifecycleHook,
        loadBalancerWeights = loadBalancerWeights,
        scalingGroupId = scalingGroupId,
    )
}
