@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationAcrRegistryInfo
import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationContainer
import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationHostAlias
import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationImageRegistryCredential
import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationInitContainer
import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationVolume
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationAcrRegistryInfo.Companion.toKotlin as eciScalingConfigurationAcrRegistryInfoToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationContainer.Companion.toKotlin as eciScalingConfigurationContainerToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationHostAlias.Companion.toKotlin as eciScalingConfigurationHostAliasToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationImageRegistryCredential.Companion.toKotlin as eciScalingConfigurationImageRegistryCredentialToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationInitContainer.Companion.toKotlin as eciScalingConfigurationInitContainerToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.EciScalingConfigurationVolume.Companion.toKotlin as eciScalingConfigurationVolumeToKotlin

/**
 * Builder for [EciScalingConfiguration].
 */
@PulumiTagMarker
public class EciScalingConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EciScalingConfigurationArgs = EciScalingConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EciScalingConfigurationArgsBuilder.() -> Unit) {
        val builder = EciScalingConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EciScalingConfiguration {
        val builtJavaResource = com.pulumi.alicloud.ess.EciScalingConfiguration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EciScalingConfiguration(builtJavaResource)
    }
}

/**
 * Provides a ESS eci scaling configuration resource.
 * For information about ess eci scaling configuration, see [CreateEciScalingConfiguration](https://www.alibabacloud.com/help/en/auto-scaling/latest/create-eci-scaling-configuration).
 * > **NOTE:** Available since v1.164.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const myName = `${name}-${defaultInteger.result}`;
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: myName,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: myName,
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: myName,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultScalingGroup = new alicloud.ess.ScalingGroup("default", {
 *     minSize: 0,
 *     maxSize: 1,
 *     scalingGroupName: myName,
 *     removalPolicies: [
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 *     vswitchIds: [defaultSwitch&#46;id],
 *     groupType: "ECI",
 * });
 * const defaultEciScalingConfiguration = new alicloud.ess.EciScalingConfiguration("default", {
 *     scalingGroupId: defaultScalingGroup.id,
 *     cpu: 2,
 *     memory: 4,
 *     securityGroupId: defaultSecurityGroup.id,
 *     forceDelete: true,
 *     active: true,
 *     containerGroupName: "container-group-1649839595174",
 *     containers: [{
 *         name: "container-1",
 *         image: "registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * my_name = f"{name}-{default_integer['result']}"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=my_name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=my_name)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=my_name,
 *     vpc_id=default_network.id)
 * default_scaling_group = alicloud.ess.ScalingGroup("default",
 *     min_size=0,
 *     max_size=1,
 *     scaling_group_name=my_name,
 *     removal_policies=[
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 *     vswitch_ids=[default_switch&#46;id],
 *     group_type="ECI")
 * default_eci_scaling_configuration = alicloud.ess.EciScalingConfiguration("default",
 *     scaling_group_id=default_scaling_group.id,
 *     cpu=2,
 *     memory=4,
 *     security_group_id=default_security_group.id,
 *     force_delete=True,
 *     active=True,
 *     container_group_name="container-group-1649839595174",
 *     containers=[{
 *         "name": "container-1",
 *         "image": "registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var myName = $"{name}-{defaultInteger.Result}";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = myName,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = myName,
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = myName,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultScalingGroup = new AliCloud.Ess.ScalingGroup("default", new()
 *     {
 *         MinSize = 0,
 *         MaxSize = 1,
 *         ScalingGroupName = myName,
 *         RemovalPolicies = new[]
 *         {
 *             "OldestInstance",
 *             "NewestInstance",
 *         },
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *         GroupType = "ECI",
 *     });
 *     var defaultEciScalingConfiguration = new AliCloud.Ess.EciScalingConfiguration("default", new()
 *     {
 *         ScalingGroupId = defaultScalingGroup.Id,
 *         Cpu = 2,
 *         Memory = 4,
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         ForceDelete = true,
 *         Active = true,
 *         ContainerGroupName = "container-group-1649839595174",
 *         Containers = new[]
 *         {
 *             new AliCloud.Ess.Inputs.EciScalingConfigurationContainerArgs
 *             {
 *                 Name = "container-1",
 *                 Image = "registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myName := fmt.Sprintf("%v-%v", name, defaultInteger.Result)
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(myName),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(myName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(myName),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultScalingGroup, err := ess.NewScalingGroup(ctx, "default", &ess.ScalingGroupArgs{
 * 			MinSize:          pulumi.Int(0),
 * 			MaxSize:          pulumi.Int(1),
 * 			ScalingGroupName: pulumi.String(myName),
 * 			RemovalPolicies: pulumi.StringArray{
 * 				pulumi.String("OldestInstance"),
 * 				pulumi.String("NewestInstance"),
 * 			},
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 			GroupType: pulumi.String("ECI"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ess.NewEciScalingConfiguration(ctx, "default", &ess.EciScalingConfigurationArgs{
 * 			ScalingGroupId:     defaultScalingGroup.ID(),
 * 			Cpu:                pulumi.Float64(2),
 * 			Memory:             pulumi.Float64(4),
 * 			SecurityGroupId:    defaultSecurityGroup.ID(),
 * 			ForceDelete:        pulumi.Bool(true),
 * 			Active:             pulumi.Bool(true),
 * 			ContainerGroupName: pulumi.String("container-group-1649839595174"),
 * 			Containers: ess.EciScalingConfigurationContainerArray{
 * 				&ess.EciScalingConfigurationContainerArgs{
 * 					Name:  pulumi.String("container-1"),
 * 					Image: pulumi.String("registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ess.ScalingGroup;
 * import com.pulumi.alicloud.ess.ScalingGroupArgs;
 * import com.pulumi.alicloud.ess.EciScalingConfiguration;
 * import com.pulumi.alicloud.ess.EciScalingConfigurationArgs;
 * import com.pulumi.alicloud.ess.inputs.EciScalingConfigurationContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var myName = String.format("%s-%s", name,defaultInteger.result());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(myName)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(myName)
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(myName)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultScalingGroup = new ScalingGroup("defaultScalingGroup", ScalingGroupArgs.builder()
 *             .minSize(0)
 *             .maxSize(1)
 *             .scalingGroupName(myName)
 *             .removalPolicies(
 *                 "OldestInstance",
 *                 "NewestInstance")
 *             .vswitchIds(defaultSwitch.id())
 *             .groupType("ECI")
 *             .build());
 *         var defaultEciScalingConfiguration = new EciScalingConfiguration("defaultEciScalingConfiguration", EciScalingConfigurationArgs.builder()
 *             .scalingGroupId(defaultScalingGroup.id())
 *             .cpu(2)
 *             .memory(4)
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .forceDelete(true)
 *             .active(true)
 *             .containerGroupName("container-group-1649839595174")
 *             .containers(EciScalingConfigurationContainerArgs.builder()
 *                 .name("container-1")
 *                 .image("registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${myName}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${myName}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${myName}
 *       vpcId: ${defaultNetwork.id}
 *   defaultScalingGroup:
 *     type: alicloud:ess:ScalingGroup
 *     name: default
 *     properties:
 *       minSize: 0
 *       maxSize: 1
 *       scalingGroupName: ${myName}
 *       removalPolicies:
 *         - OldestInstance
 *         - NewestInstance
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 *       groupType: ECI
 *   defaultEciScalingConfiguration:
 *     type: alicloud:ess:EciScalingConfiguration
 *     name: default
 *     properties:
 *       scalingGroupId: ${defaultScalingGroup.id}
 *       cpu: 2
 *       memory: 4
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       forceDelete: true
 *       active: true
 *       containerGroupName: container-group-1649839595174
 *       containers:
 *         - name: container-1
 *           image: registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5
 * variables:
 *   myName: ${name}-${defaultInteger.result}
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ESS eci scaling configuration can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/eciScalingConfiguration:EciScalingConfiguration example asc-abc123456
 * ```
 */
public class EciScalingConfiguration internal constructor(
    override val javaResource: com.pulumi.alicloud.ess.EciScalingConfiguration,
) : KotlinCustomResource(javaResource, EciScalingConfigurationMapper) {
    /**
     * Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
     */
    public val acrRegistryInfos: Output<List<EciScalingConfigurationAcrRegistryInfo>>?
        get() = javaResource.acrRegistryInfos().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eciScalingConfigurationAcrRegistryInfoToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Whether active current eci scaling configuration in the specified scaling group. Note that only
     * one configuration can be active. Default to `false`.
     */
    public val active: Output<Boolean>?
        get() = javaResource.active().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The duration in seconds relative to the startTime that the job may be active before the system tries to terminate it.
     */
    public val activeDeadlineSeconds: Output<Int>?
        get() = javaResource.activeDeadlineSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether create eip automatically.
     */
    public val autoCreateEip: Output<Boolean>?
        get() = javaResource.autoCreateEip().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to automatically match the image cache.
     */
    public val autoMatchImageCache: Output<Boolean>?
        get() = javaResource.autoMatchImageCache().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the container group. which must contain 2-128 characters (
     * English), starting with numbers, English lowercase letters , and can contain number, and hypens `-`.
     */
    public val containerGroupName: Output<String>?
        get() = javaResource.containerGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of containers. See `containers` below for details.
     */
    public val containers: Output<List<EciScalingConfigurationContainer>>?
        get() = javaResource.containers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> eciScalingConfigurationContainerToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The amount of CPU resources allocated to the container group.
     */
    public val cpu: Output<Double>?
        get() = javaResource.cpu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The number of physical CPU cores. You can specify this parameter for only specific instance types.
     */
    public val cpuOptionsCore: Output<Int>?
        get() = javaResource.cpuOptionsCore().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of threads per core. You can specify this parameter for only specific instance types. If you set this parameter to 1, Hyper-Threading is disabled.
     */
    public val cpuOptionsThreadsPerCore: Output<Int>?
        get() = javaResource.cpuOptionsThreadsPerCore().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
     * 256 characters in length and cannot start with http:// or https://.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * dns policy of contain group.
     */
    public val dnsPolicy: Output<String>?
        get() = javaResource.dnsPolicy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * egress bandwidth.
     */
    public val egressBandwidth: Output<Int>?
        get() = javaResource.egressBandwidth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Eip bandwidth.
     */
    public val eipBandwidth: Output<Int>?
        get() = javaResource.eipBandwidth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable sls log service.
     */
    public val enableSls: Output<Boolean>?
        get() = javaResource.enableSls().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The size of ephemeral storage.
     */
    public val ephemeralStorage: Output<Int>?
        get() = javaResource.ephemeralStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The eci scaling configuration will be deleted forcibly with deleting its scaling group.
     * Default to false.
     */
    public val forceDelete: Output<Boolean>?
        get() = javaResource.forceDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * HostAliases. See `host_aliases` below.
     */
    public val hostAliases: Output<List<EciScalingConfigurationHostAlias>>?
        get() = javaResource.hostAliases().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> eciScalingConfigurationHostAliasToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Hostname of an ECI instance.
     */
    public val hostName: Output<String>?
        get() = javaResource.hostName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The image registry credential.   See `image_registry_credentials` below for
     * details.
     */
    public val imageRegistryCredentials: Output<List<EciScalingConfigurationImageRegistryCredential>>?
        get() = javaResource.imageRegistryCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eciScalingConfigurationImageRegistryCredentialToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The ID of image cache.
     */
    public val imageSnapshotId: Output<String>?
        get() = javaResource.imageSnapshotId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Ingress bandwidth.
     */
    public val ingressBandwidth: Output<Int>?
        get() = javaResource.ingressBandwidth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of initContainers. See `init_containers` below for details.
     */
    public val initContainers: Output<List<EciScalingConfigurationInitContainer>>?
        get() = javaResource.initContainers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eciScalingConfigurationInitContainerToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The specified ECS instance types. You can specify up to five ECS instance types.
     */
    public val instanceTypes: Output<List<String>>?
        get() = javaResource.instanceTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Number of IPv6 addresses.
     */
    public val ipv6AddressCount: Output<Int>?
        get() = javaResource.ipv6AddressCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The weight of an ECI instance attached to the Server Group.
     */
    public val loadBalancerWeight: Output<Int>?
        get() = javaResource.loadBalancerWeight().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The amount of memory resources allocated to the container group.
     */
    public val memory: Output<Double>?
        get() = javaResource.memory().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The RAM role that the container group assumes. ECI and ECS share the same RAM role.
     */
    public val ramRoleName: Output<String>?
        get() = javaResource.ramRoleName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID of resource group.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The restart policy of the container group. Default to `Always`.
     */
    public val restartPolicy: Output<String>?
        get() = javaResource.restartPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name shown for the scheduled task. which must contain 2-64 characters (
     * English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
     * underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
     * EciScalingConfigurationId.
     */
    public val scalingConfigurationName: Output<String>
        get() = javaResource.scalingConfigurationName().applyValue({ args0 -> args0 })

    /**
     * ID of the scaling group of a eci scaling configuration.
     */
    public val scalingGroupId: Output<String>
        get() = javaResource.scalingGroupId().applyValue({ args0 -> args0 })

    /**
     * ID of the security group used to create new instance. It is conflict
     * with `security_group_ids`.
     */
    public val securityGroupId: Output<String>?
        get() = javaResource.securityGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum price hourly for spot instance.
     */
    public val spotPriceLimit: Output<Double>?
        get() = javaResource.spotPriceLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
     * , `SpotWithPriceLimit`.
     */
    public val spotStrategy: Output<String>?
        get() = javaResource.spotStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
     * be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
     * a null string.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The program's buffering time before closing.
     */
    public val terminationGracePeriodSeconds: Output<Int>?
        get() = javaResource.terminationGracePeriodSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of volumes. See `volumes` below for details.
     */
    public val volumes: Output<List<EciScalingConfigurationVolume>>?
        get() = javaResource.volumes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> eciScalingConfigurationVolumeToKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object EciScalingConfigurationMapper : ResourceMapper<EciScalingConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ess.EciScalingConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): EciScalingConfiguration =
        EciScalingConfiguration(javaResource as com.pulumi.alicloud.ess.EciScalingConfiguration)
}

/**
 * @see [EciScalingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EciScalingConfiguration].
 */
public suspend fun eciScalingConfiguration(
    name: String,
    block: suspend EciScalingConfigurationResourceBuilder.() -> Unit,
): EciScalingConfiguration {
    val builder = EciScalingConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EciScalingConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eciScalingConfiguration(name: String): EciScalingConfiguration {
    val builder = EciScalingConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
