@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.EciScalingConfigurationArgs.builder
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationAcrRegistryInfoArgs
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationAcrRegistryInfoArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationContainerArgs
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationContainerArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationHostAliasArgs
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationHostAliasArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationImageRegistryCredentialArgs
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationImageRegistryCredentialArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationInitContainerArgs
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationInitContainerArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationVolumeArgs
import com.pulumi.alicloud.ess.kotlin.inputs.EciScalingConfigurationVolumeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ESS eci scaling configuration resource.
 * For information about ess eci scaling configuration, see [CreateEciScalingConfiguration](https://www.alibabacloud.com/help/en/auto-scaling/latest/create-eci-scaling-configuration).
 * > **NOTE:** Available since v1.164.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const myName = `${name}-${defaultInteger.result}`;
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: myName,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: myName,
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: myName,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultScalingGroup = new alicloud.ess.ScalingGroup("default", {
 *     minSize: 0,
 *     maxSize: 1,
 *     scalingGroupName: myName,
 *     removalPolicies: [
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 *     vswitchIds: [defaultSwitch&#46;id],
 *     groupType: "ECI",
 * });
 * const defaultEciScalingConfiguration = new alicloud.ess.EciScalingConfiguration("default", {
 *     scalingGroupId: defaultScalingGroup.id,
 *     cpu: 2,
 *     memory: 4,
 *     securityGroupId: defaultSecurityGroup.id,
 *     forceDelete: true,
 *     active: true,
 *     containerGroupName: "container-group-1649839595174",
 *     containers: [{
 *         name: "container-1",
 *         image: "registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * my_name = f"{name}-{default_integer['result']}"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=my_name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=my_name)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=my_name,
 *     vpc_id=default_network.id)
 * default_scaling_group = alicloud.ess.ScalingGroup("default",
 *     min_size=0,
 *     max_size=1,
 *     scaling_group_name=my_name,
 *     removal_policies=[
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 *     vswitch_ids=[default_switch&#46;id],
 *     group_type="ECI")
 * default_eci_scaling_configuration = alicloud.ess.EciScalingConfiguration("default",
 *     scaling_group_id=default_scaling_group.id,
 *     cpu=2,
 *     memory=4,
 *     security_group_id=default_security_group.id,
 *     force_delete=True,
 *     active=True,
 *     container_group_name="container-group-1649839595174",
 *     containers=[{
 *         "name": "container-1",
 *         "image": "registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var myName = $"{name}-{defaultInteger.Result}";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = myName,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = myName,
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = myName,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultScalingGroup = new AliCloud.Ess.ScalingGroup("default", new()
 *     {
 *         MinSize = 0,
 *         MaxSize = 1,
 *         ScalingGroupName = myName,
 *         RemovalPolicies = new[]
 *         {
 *             "OldestInstance",
 *             "NewestInstance",
 *         },
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *         GroupType = "ECI",
 *     });
 *     var defaultEciScalingConfiguration = new AliCloud.Ess.EciScalingConfiguration("default", new()
 *     {
 *         ScalingGroupId = defaultScalingGroup.Id,
 *         Cpu = 2,
 *         Memory = 4,
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         ForceDelete = true,
 *         Active = true,
 *         ContainerGroupName = "container-group-1649839595174",
 *         Containers = new[]
 *         {
 *             new AliCloud.Ess.Inputs.EciScalingConfigurationContainerArgs
 *             {
 *                 Name = "container-1",
 *                 Image = "registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myName := fmt.Sprintf("%v-%v", name, defaultInteger.Result)
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(myName),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(myName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(myName),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultScalingGroup, err := ess.NewScalingGroup(ctx, "default", &ess.ScalingGroupArgs{
 * 			MinSize:          pulumi.Int(0),
 * 			MaxSize:          pulumi.Int(1),
 * 			ScalingGroupName: pulumi.String(myName),
 * 			RemovalPolicies: pulumi.StringArray{
 * 				pulumi.String("OldestInstance"),
 * 				pulumi.String("NewestInstance"),
 * 			},
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 			GroupType: pulumi.String("ECI"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ess.NewEciScalingConfiguration(ctx, "default", &ess.EciScalingConfigurationArgs{
 * 			ScalingGroupId:     defaultScalingGroup.ID(),
 * 			Cpu:                pulumi.Float64(2),
 * 			Memory:             pulumi.Float64(4),
 * 			SecurityGroupId:    defaultSecurityGroup.ID(),
 * 			ForceDelete:        pulumi.Bool(true),
 * 			Active:             pulumi.Bool(true),
 * 			ContainerGroupName: pulumi.String("container-group-1649839595174"),
 * 			Containers: ess.EciScalingConfigurationContainerArray{
 * 				&ess.EciScalingConfigurationContainerArgs{
 * 					Name:  pulumi.String("container-1"),
 * 					Image: pulumi.String("registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ess.ScalingGroup;
 * import com.pulumi.alicloud.ess.ScalingGroupArgs;
 * import com.pulumi.alicloud.ess.EciScalingConfiguration;
 * import com.pulumi.alicloud.ess.EciScalingConfigurationArgs;
 * import com.pulumi.alicloud.ess.inputs.EciScalingConfigurationContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var myName = String.format("%s-%s", name,defaultInteger.result());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(myName)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(myName)
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(myName)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultScalingGroup = new ScalingGroup("defaultScalingGroup", ScalingGroupArgs.builder()
 *             .minSize(0)
 *             .maxSize(1)
 *             .scalingGroupName(myName)
 *             .removalPolicies(
 *                 "OldestInstance",
 *                 "NewestInstance")
 *             .vswitchIds(defaultSwitch.id())
 *             .groupType("ECI")
 *             .build());
 *         var defaultEciScalingConfiguration = new EciScalingConfiguration("defaultEciScalingConfiguration", EciScalingConfigurationArgs.builder()
 *             .scalingGroupId(defaultScalingGroup.id())
 *             .cpu(2)
 *             .memory(4)
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .forceDelete(true)
 *             .active(true)
 *             .containerGroupName("container-group-1649839595174")
 *             .containers(EciScalingConfigurationContainerArgs.builder()
 *                 .name("container-1")
 *                 .image("registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${myName}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${myName}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${myName}
 *       vpcId: ${defaultNetwork.id}
 *   defaultScalingGroup:
 *     type: alicloud:ess:ScalingGroup
 *     name: default
 *     properties:
 *       minSize: 0
 *       maxSize: 1
 *       scalingGroupName: ${myName}
 *       removalPolicies:
 *         - OldestInstance
 *         - NewestInstance
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 *       groupType: ECI
 *   defaultEciScalingConfiguration:
 *     type: alicloud:ess:EciScalingConfiguration
 *     name: default
 *     properties:
 *       scalingGroupId: ${defaultScalingGroup.id}
 *       cpu: 2
 *       memory: 4
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       forceDelete: true
 *       active: true
 *       containerGroupName: container-group-1649839595174
 *       containers:
 *         - name: container-1
 *           image: registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5
 * variables:
 *   myName: ${name}-${defaultInteger.result}
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ESS eci scaling configuration can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/eciScalingConfiguration:EciScalingConfiguration example asc-abc123456
 * ```
 * @property acrRegistryInfos Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
 * @property active Whether active current eci scaling configuration in the specified scaling group. Note that only
 * one configuration can be active. Default to `false`.
 * @property activeDeadlineSeconds The duration in seconds relative to the startTime that the job may be active before the system tries to terminate it.
 * @property autoCreateEip Whether create eip automatically.
 * @property autoMatchImageCache Whether to automatically match the image cache.
 * @property containerGroupName The name of the container group. which must contain 2-128 characters (
 * English), starting with numbers, English lowercase letters , and can contain number, and hypens `-`.
 * @property containers The list of containers. See `containers` below for details.
 * @property cpu The amount of CPU resources allocated to the container group.
 * @property cpuOptionsCore The number of physical CPU cores. You can specify this parameter for only specific instance types.
 * @property cpuOptionsThreadsPerCore The number of threads per core. You can specify this parameter for only specific instance types. If you set this parameter to 1, Hyper-Threading is disabled.
 * @property description The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
 * 256 characters in length and cannot start with http:// or https://.
 * @property dnsPolicy dns policy of contain group.
 * @property egressBandwidth egress bandwidth.
 * @property eipBandwidth Eip bandwidth.
 * @property enableSls Enable sls log service.
 * @property ephemeralStorage The size of ephemeral storage.
 * @property forceDelete The eci scaling configuration will be deleted forcibly with deleting its scaling group.
 * Default to false.
 * @property hostAliases HostAliases. See `host_aliases` below.
 * @property hostName Hostname of an ECI instance.
 * @property imageRegistryCredentials The image registry credential.   See `image_registry_credentials` below for
 * details.
 * @property imageSnapshotId The ID of image cache.
 * @property ingressBandwidth Ingress bandwidth.
 * @property initContainers The list of initContainers. See `init_containers` below for details.
 * @property instanceTypes The specified ECS instance types. You can specify up to five ECS instance types.
 * @property ipv6AddressCount Number of IPv6 addresses.
 * @property loadBalancerWeight The weight of an ECI instance attached to the Server Group.
 * @property memory The amount of memory resources allocated to the container group.
 * @property ramRoleName The RAM role that the container group assumes. ECI and ECS share the same RAM role.
 * @property resourceGroupId ID of resource group.
 * @property restartPolicy The restart policy of the container group. Default to `Always`.
 * @property scalingConfigurationName Name shown for the scheduled task. which must contain 2-64 characters (
 * English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
 * underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
 * EciScalingConfigurationId.
 * @property scalingGroupId ID of the scaling group of a eci scaling configuration.
 * @property securityGroupId ID of the security group used to create new instance. It is conflict
 * with `security_group_ids`.
 * @property spotPriceLimit The maximum price hourly for spot instance.
 * @property spotStrategy The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
 * , `SpotWithPriceLimit`.
 * @property tags A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
 * be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
 * a null string.
 * @property terminationGracePeriodSeconds The program's buffering time before closing.
 * @property volumes The list of volumes. See `volumes` below for details.
 */
public data class EciScalingConfigurationArgs(
    public val acrRegistryInfos: Output<List<EciScalingConfigurationAcrRegistryInfoArgs>>? = null,
    public val active: Output<Boolean>? = null,
    public val activeDeadlineSeconds: Output<Int>? = null,
    public val autoCreateEip: Output<Boolean>? = null,
    public val autoMatchImageCache: Output<Boolean>? = null,
    public val containerGroupName: Output<String>? = null,
    public val containers: Output<List<EciScalingConfigurationContainerArgs>>? = null,
    public val cpu: Output<Double>? = null,
    public val cpuOptionsCore: Output<Int>? = null,
    public val cpuOptionsThreadsPerCore: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val dnsPolicy: Output<String>? = null,
    public val egressBandwidth: Output<Int>? = null,
    public val eipBandwidth: Output<Int>? = null,
    public val enableSls: Output<Boolean>? = null,
    public val ephemeralStorage: Output<Int>? = null,
    public val forceDelete: Output<Boolean>? = null,
    public val hostAliases: Output<List<EciScalingConfigurationHostAliasArgs>>? = null,
    public val hostName: Output<String>? = null,
    public val imageRegistryCredentials: Output<List<EciScalingConfigurationImageRegistryCredentialArgs>>? = null,
    public val imageSnapshotId: Output<String>? = null,
    public val ingressBandwidth: Output<Int>? = null,
    public val initContainers: Output<List<EciScalingConfigurationInitContainerArgs>>? = null,
    public val instanceTypes: Output<List<String>>? = null,
    public val ipv6AddressCount: Output<Int>? = null,
    public val loadBalancerWeight: Output<Int>? = null,
    public val memory: Output<Double>? = null,
    public val ramRoleName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val restartPolicy: Output<String>? = null,
    public val scalingConfigurationName: Output<String>? = null,
    public val scalingGroupId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val spotPriceLimit: Output<Double>? = null,
    public val spotStrategy: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val terminationGracePeriodSeconds: Output<Int>? = null,
    public val volumes: Output<List<EciScalingConfigurationVolumeArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.EciScalingConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.EciScalingConfigurationArgs =
        com.pulumi.alicloud.ess.EciScalingConfigurationArgs.builder()
            .acrRegistryInfos(
                acrRegistryInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .active(active?.applyValue({ args0 -> args0 }))
            .activeDeadlineSeconds(activeDeadlineSeconds?.applyValue({ args0 -> args0 }))
            .autoCreateEip(autoCreateEip?.applyValue({ args0 -> args0 }))
            .autoMatchImageCache(autoMatchImageCache?.applyValue({ args0 -> args0 }))
            .containerGroupName(containerGroupName?.applyValue({ args0 -> args0 }))
            .containers(
                containers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .cpuOptionsCore(cpuOptionsCore?.applyValue({ args0 -> args0 }))
            .cpuOptionsThreadsPerCore(cpuOptionsThreadsPerCore?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .dnsPolicy(dnsPolicy?.applyValue({ args0 -> args0 }))
            .egressBandwidth(egressBandwidth?.applyValue({ args0 -> args0 }))
            .eipBandwidth(eipBandwidth?.applyValue({ args0 -> args0 }))
            .enableSls(enableSls?.applyValue({ args0 -> args0 }))
            .ephemeralStorage(ephemeralStorage?.applyValue({ args0 -> args0 }))
            .forceDelete(forceDelete?.applyValue({ args0 -> args0 }))
            .hostAliases(
                hostAliases?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .imageRegistryCredentials(
                imageRegistryCredentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .imageSnapshotId(imageSnapshotId?.applyValue({ args0 -> args0 }))
            .ingressBandwidth(ingressBandwidth?.applyValue({ args0 -> args0 }))
            .initContainers(
                initContainers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .instanceTypes(instanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6AddressCount(ipv6AddressCount?.applyValue({ args0 -> args0 }))
            .loadBalancerWeight(loadBalancerWeight?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 }))
            .ramRoleName(ramRoleName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .restartPolicy(restartPolicy?.applyValue({ args0 -> args0 }))
            .scalingConfigurationName(scalingConfigurationName?.applyValue({ args0 -> args0 }))
            .scalingGroupId(scalingGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .spotPriceLimit(spotPriceLimit?.applyValue({ args0 -> args0 }))
            .spotStrategy(spotStrategy?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .terminationGracePeriodSeconds(terminationGracePeriodSeconds?.applyValue({ args0 -> args0 }))
            .volumes(
                volumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EciScalingConfigurationArgs].
 */
@PulumiTagMarker
public class EciScalingConfigurationArgsBuilder internal constructor() {
    private var acrRegistryInfos: Output<List<EciScalingConfigurationAcrRegistryInfoArgs>>? = null

    private var active: Output<Boolean>? = null

    private var activeDeadlineSeconds: Output<Int>? = null

    private var autoCreateEip: Output<Boolean>? = null

    private var autoMatchImageCache: Output<Boolean>? = null

    private var containerGroupName: Output<String>? = null

    private var containers: Output<List<EciScalingConfigurationContainerArgs>>? = null

    private var cpu: Output<Double>? = null

    private var cpuOptionsCore: Output<Int>? = null

    private var cpuOptionsThreadsPerCore: Output<Int>? = null

    private var description: Output<String>? = null

    private var dnsPolicy: Output<String>? = null

    private var egressBandwidth: Output<Int>? = null

    private var eipBandwidth: Output<Int>? = null

    private var enableSls: Output<Boolean>? = null

    private var ephemeralStorage: Output<Int>? = null

    private var forceDelete: Output<Boolean>? = null

    private var hostAliases: Output<List<EciScalingConfigurationHostAliasArgs>>? = null

    private var hostName: Output<String>? = null

    private var imageRegistryCredentials:
        Output<List<EciScalingConfigurationImageRegistryCredentialArgs>>? = null

    private var imageSnapshotId: Output<String>? = null

    private var ingressBandwidth: Output<Int>? = null

    private var initContainers: Output<List<EciScalingConfigurationInitContainerArgs>>? = null

    private var instanceTypes: Output<List<String>>? = null

    private var ipv6AddressCount: Output<Int>? = null

    private var loadBalancerWeight: Output<Int>? = null

    private var memory: Output<Double>? = null

    private var ramRoleName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var restartPolicy: Output<String>? = null

    private var scalingConfigurationName: Output<String>? = null

    private var scalingGroupId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var spotPriceLimit: Output<Double>? = null

    private var spotStrategy: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var terminationGracePeriodSeconds: Output<Int>? = null

    private var volumes: Output<List<EciScalingConfigurationVolumeArgs>>? = null

    /**
     * @param value Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
     */
    @JvmName("ffvfakkbblxgkqxe")
    public suspend fun acrRegistryInfos(`value`: Output<List<EciScalingConfigurationAcrRegistryInfoArgs>>) {
        this.acrRegistryInfos = value
    }

    @JvmName("kbwamxaxfahfiecr")
    public suspend fun acrRegistryInfos(vararg values: Output<EciScalingConfigurationAcrRegistryInfoArgs>) {
        this.acrRegistryInfos = Output.all(values.asList())
    }

    /**
     * @param values Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
     */
    @JvmName("thpctqiwheudpumo")
    public suspend fun acrRegistryInfos(values: List<Output<EciScalingConfigurationAcrRegistryInfoArgs>>) {
        this.acrRegistryInfos = Output.all(values)
    }

    /**
     * @param value Whether active current eci scaling configuration in the specified scaling group. Note that only
     * one configuration can be active. Default to `false`.
     */
    @JvmName("opqsogwhwhffqqwn")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value The duration in seconds relative to the startTime that the job may be active before the system tries to terminate it.
     */
    @JvmName("avsvywtdclnmodgx")
    public suspend fun activeDeadlineSeconds(`value`: Output<Int>) {
        this.activeDeadlineSeconds = value
    }

    /**
     * @param value Whether create eip automatically.
     */
    @JvmName("pbuplotfwncppjhd")
    public suspend fun autoCreateEip(`value`: Output<Boolean>) {
        this.autoCreateEip = value
    }

    /**
     * @param value Whether to automatically match the image cache.
     */
    @JvmName("ppkatwdxneakmcdo")
    public suspend fun autoMatchImageCache(`value`: Output<Boolean>) {
        this.autoMatchImageCache = value
    }

    /**
     * @param value The name of the container group. which must contain 2-128 characters (
     * English), starting with numbers, English lowercase letters , and can contain number, and hypens `-`.
     */
    @JvmName("bhcockjvuramnsnr")
    public suspend fun containerGroupName(`value`: Output<String>) {
        this.containerGroupName = value
    }

    /**
     * @param value The list of containers. See `containers` below for details.
     */
    @JvmName("eybuhntnrrstulsf")
    public suspend fun containers(`value`: Output<List<EciScalingConfigurationContainerArgs>>) {
        this.containers = value
    }

    @JvmName("fjsaejqscxfdyknh")
    public suspend fun containers(vararg values: Output<EciScalingConfigurationContainerArgs>) {
        this.containers = Output.all(values.asList())
    }

    /**
     * @param values The list of containers. See `containers` below for details.
     */
    @JvmName("hxjigljbdyphwlrn")
    public suspend fun containers(values: List<Output<EciScalingConfigurationContainerArgs>>) {
        this.containers = Output.all(values)
    }

    /**
     * @param value The amount of CPU resources allocated to the container group.
     */
    @JvmName("mqxbecjjqlnrkmeb")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value The number of physical CPU cores. You can specify this parameter for only specific instance types.
     */
    @JvmName("rdogprjjapbxwlpq")
    public suspend fun cpuOptionsCore(`value`: Output<Int>) {
        this.cpuOptionsCore = value
    }

    /**
     * @param value The number of threads per core. You can specify this parameter for only specific instance types. If you set this parameter to 1, Hyper-Threading is disabled.
     */
    @JvmName("yhfekbnjwojlnxvn")
    public suspend fun cpuOptionsThreadsPerCore(`value`: Output<Int>) {
        this.cpuOptionsThreadsPerCore = value
    }

    /**
     * @param value The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
     * 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("qbygqkjkhlfqhkro")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value dns policy of contain group.
     */
    @JvmName("smfmigvyufotqkti")
    public suspend fun dnsPolicy(`value`: Output<String>) {
        this.dnsPolicy = value
    }

    /**
     * @param value egress bandwidth.
     */
    @JvmName("yjxantcrpfwvukeh")
    public suspend fun egressBandwidth(`value`: Output<Int>) {
        this.egressBandwidth = value
    }

    /**
     * @param value Eip bandwidth.
     */
    @JvmName("mktqxucyqyovncae")
    public suspend fun eipBandwidth(`value`: Output<Int>) {
        this.eipBandwidth = value
    }

    /**
     * @param value Enable sls log service.
     */
    @JvmName("kkudkqsuobramcdi")
    public suspend fun enableSls(`value`: Output<Boolean>) {
        this.enableSls = value
    }

    /**
     * @param value The size of ephemeral storage.
     */
    @JvmName("ehdiokmfhswtgrup")
    public suspend fun ephemeralStorage(`value`: Output<Int>) {
        this.ephemeralStorage = value
    }

    /**
     * @param value The eci scaling configuration will be deleted forcibly with deleting its scaling group.
     * Default to false.
     */
    @JvmName("tuvgdpririyhgljf")
    public suspend fun forceDelete(`value`: Output<Boolean>) {
        this.forceDelete = value
    }

    /**
     * @param value HostAliases. See `host_aliases` below.
     */
    @JvmName("trpmrlubtpchqrcw")
    public suspend fun hostAliases(`value`: Output<List<EciScalingConfigurationHostAliasArgs>>) {
        this.hostAliases = value
    }

    @JvmName("hhvtcwrujlxatkah")
    public suspend fun hostAliases(vararg values: Output<EciScalingConfigurationHostAliasArgs>) {
        this.hostAliases = Output.all(values.asList())
    }

    /**
     * @param values HostAliases. See `host_aliases` below.
     */
    @JvmName("ahomoujnsvgdxwul")
    public suspend fun hostAliases(values: List<Output<EciScalingConfigurationHostAliasArgs>>) {
        this.hostAliases = Output.all(values)
    }

    /**
     * @param value Hostname of an ECI instance.
     */
    @JvmName("okntdksrjxbydxdw")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value The image registry credential.   See `image_registry_credentials` below for
     * details.
     */
    @JvmName("qptjuhrsdhxlkmhn")
    public suspend fun imageRegistryCredentials(`value`: Output<List<EciScalingConfigurationImageRegistryCredentialArgs>>) {
        this.imageRegistryCredentials = value
    }

    @JvmName("kvdiymoqnjylcmfw")
    public suspend fun imageRegistryCredentials(vararg values: Output<EciScalingConfigurationImageRegistryCredentialArgs>) {
        this.imageRegistryCredentials = Output.all(values.asList())
    }

    /**
     * @param values The image registry credential.   See `image_registry_credentials` below for
     * details.
     */
    @JvmName("wgvalabdfrhflqxf")
    public suspend fun imageRegistryCredentials(values: List<Output<EciScalingConfigurationImageRegistryCredentialArgs>>) {
        this.imageRegistryCredentials = Output.all(values)
    }

    /**
     * @param value The ID of image cache.
     */
    @JvmName("ptnnblyridwakbor")
    public suspend fun imageSnapshotId(`value`: Output<String>) {
        this.imageSnapshotId = value
    }

    /**
     * @param value Ingress bandwidth.
     */
    @JvmName("hkfimaeobniwtltj")
    public suspend fun ingressBandwidth(`value`: Output<Int>) {
        this.ingressBandwidth = value
    }

    /**
     * @param value The list of initContainers. See `init_containers` below for details.
     */
    @JvmName("lxstxspxbgiepqxm")
    public suspend fun initContainers(`value`: Output<List<EciScalingConfigurationInitContainerArgs>>) {
        this.initContainers = value
    }

    @JvmName("ausdgskphrfpxijh")
    public suspend fun initContainers(vararg values: Output<EciScalingConfigurationInitContainerArgs>) {
        this.initContainers = Output.all(values.asList())
    }

    /**
     * @param values The list of initContainers. See `init_containers` below for details.
     */
    @JvmName("magqaxonxboobqtk")
    public suspend fun initContainers(values: List<Output<EciScalingConfigurationInitContainerArgs>>) {
        this.initContainers = Output.all(values)
    }

    /**
     * @param value The specified ECS instance types. You can specify up to five ECS instance types.
     */
    @JvmName("lhdkgrhfeaeximbe")
    public suspend fun instanceTypes(`value`: Output<List<String>>) {
        this.instanceTypes = value
    }

    @JvmName("rweuwfvwpyxmrrvx")
    public suspend fun instanceTypes(vararg values: Output<String>) {
        this.instanceTypes = Output.all(values.asList())
    }

    /**
     * @param values The specified ECS instance types. You can specify up to five ECS instance types.
     */
    @JvmName("dcatoyxcjlnojjmo")
    public suspend fun instanceTypes(values: List<Output<String>>) {
        this.instanceTypes = Output.all(values)
    }

    /**
     * @param value Number of IPv6 addresses.
     */
    @JvmName("jwopkaqydgkbgxpk")
    public suspend fun ipv6AddressCount(`value`: Output<Int>) {
        this.ipv6AddressCount = value
    }

    /**
     * @param value The weight of an ECI instance attached to the Server Group.
     */
    @JvmName("sfrmuomqqypluobo")
    public suspend fun loadBalancerWeight(`value`: Output<Int>) {
        this.loadBalancerWeight = value
    }

    /**
     * @param value The amount of memory resources allocated to the container group.
     */
    @JvmName("haigyhusdumtmcyi")
    public suspend fun memory(`value`: Output<Double>) {
        this.memory = value
    }

    /**
     * @param value The RAM role that the container group assumes. ECI and ECS share the same RAM role.
     */
    @JvmName("vphxtorldvtqyvmo")
    public suspend fun ramRoleName(`value`: Output<String>) {
        this.ramRoleName = value
    }

    /**
     * @param value ID of resource group.
     */
    @JvmName("koqoophlcvbwnjop")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The restart policy of the container group. Default to `Always`.
     */
    @JvmName("lbcientqtdhquoxx")
    public suspend fun restartPolicy(`value`: Output<String>) {
        this.restartPolicy = value
    }

    /**
     * @param value Name shown for the scheduled task. which must contain 2-64 characters (
     * English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
     * underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
     * EciScalingConfigurationId.
     */
    @JvmName("pmanjdpiurwwjqcj")
    public suspend fun scalingConfigurationName(`value`: Output<String>) {
        this.scalingConfigurationName = value
    }

    /**
     * @param value ID of the scaling group of a eci scaling configuration.
     */
    @JvmName("aabgboysisswmpej")
    public suspend fun scalingGroupId(`value`: Output<String>) {
        this.scalingGroupId = value
    }

    /**
     * @param value ID of the security group used to create new instance. It is conflict
     * with `security_group_ids`.
     */
    @JvmName("fovyardwnibhmrwx")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value The maximum price hourly for spot instance.
     */
    @JvmName("rlwnuttpnpbkghoe")
    public suspend fun spotPriceLimit(`value`: Output<Double>) {
        this.spotPriceLimit = value
    }

    /**
     * @param value The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
     * , `SpotWithPriceLimit`.
     */
    @JvmName("epoyvkgkqbjhtoil")
    public suspend fun spotStrategy(`value`: Output<String>) {
        this.spotStrategy = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
     * be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
     * a null string.
     */
    @JvmName("oppxuyappfiimehi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The program's buffering time before closing.
     */
    @JvmName("cmrxkfdldxkgtgpq")
    public suspend fun terminationGracePeriodSeconds(`value`: Output<Int>) {
        this.terminationGracePeriodSeconds = value
    }

    /**
     * @param value The list of volumes. See `volumes` below for details.
     */
    @JvmName("dtmjrkfntokhyewm")
    public suspend fun volumes(`value`: Output<List<EciScalingConfigurationVolumeArgs>>) {
        this.volumes = value
    }

    @JvmName("eeljreyddabgickx")
    public suspend fun volumes(vararg values: Output<EciScalingConfigurationVolumeArgs>) {
        this.volumes = Output.all(values.asList())
    }

    /**
     * @param values The list of volumes. See `volumes` below for details.
     */
    @JvmName("ghkbitetgkhdqhui")
    public suspend fun volumes(values: List<Output<EciScalingConfigurationVolumeArgs>>) {
        this.volumes = Output.all(values)
    }

    /**
     * @param value Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
     */
    @JvmName("lwnxhstdmdhcissj")
    public suspend fun acrRegistryInfos(`value`: List<EciScalingConfigurationAcrRegistryInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrRegistryInfos = mapped
    }

    /**
     * @param argument Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
     */
    @JvmName("ienclwidmoabljcm")
    public suspend fun acrRegistryInfos(argument: List<suspend EciScalingConfigurationAcrRegistryInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationAcrRegistryInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.acrRegistryInfos = mapped
    }

    /**
     * @param argument Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
     */
    @JvmName("glfmajgcfgqfjfmd")
    public suspend fun acrRegistryInfos(vararg argument: suspend EciScalingConfigurationAcrRegistryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationAcrRegistryInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.acrRegistryInfos = mapped
    }

    /**
     * @param argument Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
     */
    @JvmName("wbjwkrirrsksmhyk")
    public suspend fun acrRegistryInfos(argument: suspend EciScalingConfigurationAcrRegistryInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EciScalingConfigurationAcrRegistryInfoArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.acrRegistryInfos = mapped
    }

    /**
     * @param values Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
     */
    @JvmName("ktgltasuajbulnqd")
    public suspend fun acrRegistryInfos(vararg values: EciScalingConfigurationAcrRegistryInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acrRegistryInfos = mapped
    }

    /**
     * @param value Whether active current eci scaling configuration in the specified scaling group. Note that only
     * one configuration can be active. Default to `false`.
     */
    @JvmName("ooqbuxogmsddhovj")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value The duration in seconds relative to the startTime that the job may be active before the system tries to terminate it.
     */
    @JvmName("hrpctlumskmkwanc")
    public suspend fun activeDeadlineSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDeadlineSeconds = mapped
    }

    /**
     * @param value Whether create eip automatically.
     */
    @JvmName("kvsusshyyrsyntjw")
    public suspend fun autoCreateEip(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoCreateEip = mapped
    }

    /**
     * @param value Whether to automatically match the image cache.
     */
    @JvmName("bggaoiwffiivjupa")
    public suspend fun autoMatchImageCache(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoMatchImageCache = mapped
    }

    /**
     * @param value The name of the container group. which must contain 2-128 characters (
     * English), starting with numbers, English lowercase letters , and can contain number, and hypens `-`.
     */
    @JvmName("fcrxygwgimnpefrm")
    public suspend fun containerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerGroupName = mapped
    }

    /**
     * @param value The list of containers. See `containers` below for details.
     */
    @JvmName("jiuaywmpwhnamhfb")
    public suspend fun containers(`value`: List<EciScalingConfigurationContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param argument The list of containers. See `containers` below for details.
     */
    @JvmName("fjvqqlwkrgscclxy")
    public suspend fun containers(argument: List<suspend EciScalingConfigurationContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument The list of containers. See `containers` below for details.
     */
    @JvmName("rfyrdekximmamqjo")
    public suspend fun containers(vararg argument: suspend EciScalingConfigurationContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument The list of containers. See `containers` below for details.
     */
    @JvmName("xgrvlifhiyrnldyp")
    public suspend fun containers(argument: suspend EciScalingConfigurationContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EciScalingConfigurationContainerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param values The list of containers. See `containers` below for details.
     */
    @JvmName("jbhkfvdldmeavwjw")
    public suspend fun containers(vararg values: EciScalingConfigurationContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param value The amount of CPU resources allocated to the container group.
     */
    @JvmName("mwuarokfqhsusock")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The number of physical CPU cores. You can specify this parameter for only specific instance types.
     */
    @JvmName("pxgsdpvrbqkvxygh")
    public suspend fun cpuOptionsCore(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuOptionsCore = mapped
    }

    /**
     * @param value The number of threads per core. You can specify this parameter for only specific instance types. If you set this parameter to 1, Hyper-Threading is disabled.
     */
    @JvmName("mvvswvemujuvdcil")
    public suspend fun cpuOptionsThreadsPerCore(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuOptionsThreadsPerCore = mapped
    }

    /**
     * @param value The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
     * 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("dgyqprbibbublqao")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value dns policy of contain group.
     */
    @JvmName("enfiwsgmsstllxkx")
    public suspend fun dnsPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsPolicy = mapped
    }

    /**
     * @param value egress bandwidth.
     */
    @JvmName("jgauqofuveqfqdjs")
    public suspend fun egressBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egressBandwidth = mapped
    }

    /**
     * @param value Eip bandwidth.
     */
    @JvmName("qqupxvtvllgyqgid")
    public suspend fun eipBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eipBandwidth = mapped
    }

    /**
     * @param value Enable sls log service.
     */
    @JvmName("wqmlrujfparahjei")
    public suspend fun enableSls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSls = mapped
    }

    /**
     * @param value The size of ephemeral storage.
     */
    @JvmName("wlhsfagimkvnljns")
    public suspend fun ephemeralStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralStorage = mapped
    }

    /**
     * @param value The eci scaling configuration will be deleted forcibly with deleting its scaling group.
     * Default to false.
     */
    @JvmName("ddhepyluxnxhruob")
    public suspend fun forceDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDelete = mapped
    }

    /**
     * @param value HostAliases. See `host_aliases` below.
     */
    @JvmName("vglvflceiudxaxvn")
    public suspend fun hostAliases(`value`: List<EciScalingConfigurationHostAliasArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostAliases = mapped
    }

    /**
     * @param argument HostAliases. See `host_aliases` below.
     */
    @JvmName("ubhjluallmcnwics")
    public suspend fun hostAliases(argument: List<suspend EciScalingConfigurationHostAliasArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationHostAliasArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.hostAliases = mapped
    }

    /**
     * @param argument HostAliases. See `host_aliases` below.
     */
    @JvmName("eemtajjpstxvgqsf")
    public suspend fun hostAliases(vararg argument: suspend EciScalingConfigurationHostAliasArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationHostAliasArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.hostAliases = mapped
    }

    /**
     * @param argument HostAliases. See `host_aliases` below.
     */
    @JvmName("jrhvqkyxrrtaotxn")
    public suspend fun hostAliases(argument: suspend EciScalingConfigurationHostAliasArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EciScalingConfigurationHostAliasArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.hostAliases = mapped
    }

    /**
     * @param values HostAliases. See `host_aliases` below.
     */
    @JvmName("utpqttbkuttjoksw")
    public suspend fun hostAliases(vararg values: EciScalingConfigurationHostAliasArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostAliases = mapped
    }

    /**
     * @param value Hostname of an ECI instance.
     */
    @JvmName("kqoduolidpivbvks")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value The image registry credential.   See `image_registry_credentials` below for
     * details.
     */
    @JvmName("nkgyotusilninvlu")
    public suspend fun imageRegistryCredentials(`value`: List<EciScalingConfigurationImageRegistryCredentialArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The image registry credential.   See `image_registry_credentials` below for
     * details.
     */
    @JvmName("jtcdgedbhtejpqqe")
    public suspend fun imageRegistryCredentials(argument: List<suspend EciScalingConfigurationImageRegistryCredentialArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationImageRegistryCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The image registry credential.   See `image_registry_credentials` below for
     * details.
     */
    @JvmName("nwhjyniqygdmnere")
    public suspend fun imageRegistryCredentials(vararg argument: suspend EciScalingConfigurationImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationImageRegistryCredentialArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The image registry credential.   See `image_registry_credentials` below for
     * details.
     */
    @JvmName("crqduqhjhxhyrxpd")
    public suspend fun imageRegistryCredentials(argument: suspend EciScalingConfigurationImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EciScalingConfigurationImageRegistryCredentialArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param values The image registry credential.   See `image_registry_credentials` below for
     * details.
     */
    @JvmName("hnetlgsodmetlmpn")
    public suspend fun imageRegistryCredentials(vararg values: EciScalingConfigurationImageRegistryCredentialArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param value The ID of image cache.
     */
    @JvmName("edgxcmobwytofhfm")
    public suspend fun imageSnapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageSnapshotId = mapped
    }

    /**
     * @param value Ingress bandwidth.
     */
    @JvmName("nerhxdgfwpltxqfn")
    public suspend fun ingressBandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingressBandwidth = mapped
    }

    /**
     * @param value The list of initContainers. See `init_containers` below for details.
     */
    @JvmName("rlddpkdffyjbnxgm")
    public suspend fun initContainers(`value`: List<EciScalingConfigurationInitContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initContainers = mapped
    }

    /**
     * @param argument The list of initContainers. See `init_containers` below for details.
     */
    @JvmName("iapxcawumbrqqand")
    public suspend fun initContainers(argument: List<suspend EciScalingConfigurationInitContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationInitContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param argument The list of initContainers. See `init_containers` below for details.
     */
    @JvmName("ylkacilmnabyxokc")
    public suspend fun initContainers(vararg argument: suspend EciScalingConfigurationInitContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationInitContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param argument The list of initContainers. See `init_containers` below for details.
     */
    @JvmName("jclniksytjxubbav")
    public suspend fun initContainers(argument: suspend EciScalingConfigurationInitContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EciScalingConfigurationInitContainerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param values The list of initContainers. See `init_containers` below for details.
     */
    @JvmName("pvgjlaevavorhgts")
    public suspend fun initContainers(vararg values: EciScalingConfigurationInitContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initContainers = mapped
    }

    /**
     * @param value The specified ECS instance types. You can specify up to five ECS instance types.
     */
    @JvmName("wtqoaqjgnxhhmebw")
    public suspend fun instanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param values The specified ECS instance types. You can specify up to five ECS instance types.
     */
    @JvmName("grbqfhykdnbqoiaq")
    public suspend fun instanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param value Number of IPv6 addresses.
     */
    @JvmName("jprefymeakthcvdh")
    public suspend fun ipv6AddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressCount = mapped
    }

    /**
     * @param value The weight of an ECI instance attached to the Server Group.
     */
    @JvmName("hoehmdrgtvjkulug")
    public suspend fun loadBalancerWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerWeight = mapped
    }

    /**
     * @param value The amount of memory resources allocated to the container group.
     */
    @JvmName("mcoifmdbpbhrqnad")
    public suspend fun memory(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param value The RAM role that the container group assumes. ECI and ECS share the same RAM role.
     */
    @JvmName("xraealnafhghalub")
    public suspend fun ramRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramRoleName = mapped
    }

    /**
     * @param value ID of resource group.
     */
    @JvmName("udhljuiapovsbanx")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The restart policy of the container group. Default to `Always`.
     */
    @JvmName("kymcraptsgvdwkso")
    public suspend fun restartPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartPolicy = mapped
    }

    /**
     * @param value Name shown for the scheduled task. which must contain 2-64 characters (
     * English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
     * underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
     * EciScalingConfigurationId.
     */
    @JvmName("xdetumuuplyuptvf")
    public suspend fun scalingConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingConfigurationName = mapped
    }

    /**
     * @param value ID of the scaling group of a eci scaling configuration.
     */
    @JvmName("ksuwxtblncnvjvfx")
    public suspend fun scalingGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingGroupId = mapped
    }

    /**
     * @param value ID of the security group used to create new instance. It is conflict
     * with `security_group_ids`.
     */
    @JvmName("yesxxcnknnbxxxij")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value The maximum price hourly for spot instance.
     */
    @JvmName("lupxdkhrnkwwfjqi")
    public suspend fun spotPriceLimit(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPriceLimit = mapped
    }

    /**
     * @param value The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
     * , `SpotWithPriceLimit`.
     */
    @JvmName("iedhrgbamjicghee")
    public suspend fun spotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotStrategy = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
     * be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
     * a null string.
     */
    @JvmName("dbmumaanhpiunwxu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
     * be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
     * a null string.
     */
    @JvmName("mslrjyxqlfwiyedm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The program's buffering time before closing.
     */
    @JvmName("gkisdhnuieyrlhsd")
    public suspend fun terminationGracePeriodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminationGracePeriodSeconds = mapped
    }

    /**
     * @param value The list of volumes. See `volumes` below for details.
     */
    @JvmName("eoqelkwxqvnvexdy")
    public suspend fun volumes(`value`: List<EciScalingConfigurationVolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param argument The list of volumes. See `volumes` below for details.
     */
    @JvmName("sbfuyyjqggoxocvn")
    public suspend fun volumes(argument: List<suspend EciScalingConfigurationVolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationVolumeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument The list of volumes. See `volumes` below for details.
     */
    @JvmName("auctmjmjxtroshdc")
    public suspend fun volumes(vararg argument: suspend EciScalingConfigurationVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationVolumeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument The list of volumes. See `volumes` below for details.
     */
    @JvmName("vowqppdsoqlysxxd")
    public suspend fun volumes(argument: suspend EciScalingConfigurationVolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EciScalingConfigurationVolumeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param values The list of volumes. See `volumes` below for details.
     */
    @JvmName("oogmanynhdhiwifu")
    public suspend fun volumes(vararg values: EciScalingConfigurationVolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    internal fun build(): EciScalingConfigurationArgs = EciScalingConfigurationArgs(
        acrRegistryInfos = acrRegistryInfos,
        active = active,
        activeDeadlineSeconds = activeDeadlineSeconds,
        autoCreateEip = autoCreateEip,
        autoMatchImageCache = autoMatchImageCache,
        containerGroupName = containerGroupName,
        containers = containers,
        cpu = cpu,
        cpuOptionsCore = cpuOptionsCore,
        cpuOptionsThreadsPerCore = cpuOptionsThreadsPerCore,
        description = description,
        dnsPolicy = dnsPolicy,
        egressBandwidth = egressBandwidth,
        eipBandwidth = eipBandwidth,
        enableSls = enableSls,
        ephemeralStorage = ephemeralStorage,
        forceDelete = forceDelete,
        hostAliases = hostAliases,
        hostName = hostName,
        imageRegistryCredentials = imageRegistryCredentials,
        imageSnapshotId = imageSnapshotId,
        ingressBandwidth = ingressBandwidth,
        initContainers = initContainers,
        instanceTypes = instanceTypes,
        ipv6AddressCount = ipv6AddressCount,
        loadBalancerWeight = loadBalancerWeight,
        memory = memory,
        ramRoleName = ramRoleName,
        resourceGroupId = resourceGroupId,
        restartPolicy = restartPolicy,
        scalingConfigurationName = scalingConfigurationName,
        scalingGroupId = scalingGroupId,
        securityGroupId = securityGroupId,
        spotPriceLimit = spotPriceLimit,
        spotStrategy = spotStrategy,
        tags = tags,
        terminationGracePeriodSeconds = terminationGracePeriodSeconds,
        volumes = volumes,
    )
}
