@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.EssFunctions.getAlarmsPlain
import com.pulumi.alicloud.ess.EssFunctions.getLifecycleHooksPlain
import com.pulumi.alicloud.ess.EssFunctions.getNotificationsPlain
import com.pulumi.alicloud.ess.EssFunctions.getScalingConfigurationsPlain
import com.pulumi.alicloud.ess.EssFunctions.getScalingGroupsPlain
import com.pulumi.alicloud.ess.EssFunctions.getScalingRulesPlain
import com.pulumi.alicloud.ess.EssFunctions.getScheduledTasksPlain
import com.pulumi.alicloud.ess.kotlin.inputs.GetAlarmsPlainArgs
import com.pulumi.alicloud.ess.kotlin.inputs.GetAlarmsPlainArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.GetLifecycleHooksPlainArgs
import com.pulumi.alicloud.ess.kotlin.inputs.GetLifecycleHooksPlainArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.GetNotificationsPlainArgs
import com.pulumi.alicloud.ess.kotlin.inputs.GetNotificationsPlainArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.GetScalingConfigurationsPlainArgs
import com.pulumi.alicloud.ess.kotlin.inputs.GetScalingConfigurationsPlainArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.GetScalingGroupsPlainArgs
import com.pulumi.alicloud.ess.kotlin.inputs.GetScalingGroupsPlainArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.GetScalingRulesPlainArgs
import com.pulumi.alicloud.ess.kotlin.inputs.GetScalingRulesPlainArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.GetScheduledTasksPlainArgs
import com.pulumi.alicloud.ess.kotlin.inputs.GetScheduledTasksPlainArgsBuilder
import com.pulumi.alicloud.ess.kotlin.outputs.GetAlarmsResult
import com.pulumi.alicloud.ess.kotlin.outputs.GetLifecycleHooksResult
import com.pulumi.alicloud.ess.kotlin.outputs.GetNotificationsResult
import com.pulumi.alicloud.ess.kotlin.outputs.GetScalingConfigurationsResult
import com.pulumi.alicloud.ess.kotlin.outputs.GetScalingGroupsResult
import com.pulumi.alicloud.ess.kotlin.outputs.GetScalingRulesResult
import com.pulumi.alicloud.ess.kotlin.outputs.GetScheduledTasksResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.ess.kotlin.outputs.GetAlarmsResult.Companion.toKotlin as getAlarmsResultToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.GetLifecycleHooksResult.Companion.toKotlin as getLifecycleHooksResultToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.GetNotificationsResult.Companion.toKotlin as getNotificationsResultToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.GetScalingConfigurationsResult.Companion.toKotlin as getScalingConfigurationsResultToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.GetScalingGroupsResult.Companion.toKotlin as getScalingGroupsResultToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.GetScalingRulesResult.Companion.toKotlin as getScalingRulesResultToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.GetScheduledTasksResult.Companion.toKotlin as getScheduledTasksResultToKotlin

public object EssFunctions {
    /**
     * This data source provides available alarm resources.
     * > **NOTE** Available in 1.72.0+
     * @param argument A collection of arguments for invoking getAlarms.
     * @return A collection of values returned by getAlarms.
     */
    public suspend fun getAlarms(argument: GetAlarmsPlainArgs): GetAlarmsResult =
        getAlarmsResultToKotlin(getAlarmsPlain(argument.toJava()).await())

    /**
     * @see [getAlarms].
     * @param ids A list of alarm IDs.
     * @param metricType The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
     * @param nameRegex A regex string to filter resulting alarms by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param scalingGroupId Scaling group id the alarms belong to.
     * @return A collection of values returned by getAlarms.
     */
    public suspend fun getAlarms(
        ids: List<String>? = null,
        metricType: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        scalingGroupId: String? = null,
    ): GetAlarmsResult {
        val argument = GetAlarmsPlainArgs(
            ids = ids,
            metricType = metricType,
            nameRegex = nameRegex,
            outputFile = outputFile,
            scalingGroupId = scalingGroupId,
        )
        return getAlarmsResultToKotlin(getAlarmsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAlarms].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ess&#46;kotlin&#46;inputs&#46;GetAlarmsPlainArgs].
     * @return A collection of values returned by getAlarms.
     */
    public suspend fun getAlarms(argument: suspend GetAlarmsPlainArgsBuilder.() -> Unit): GetAlarmsResult {
        val builder = GetAlarmsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAlarmsResultToKotlin(getAlarmsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides available lifecycle hook resources.
     * > **NOTE:** Available in 1.72.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ds = alicloud.ess.getLifecycleHooks({
     *     scalingGroupId: "scaling_group_id",
     *     nameRegex: "lifecyclehook_name",
     * });
     * export const firstLifecycleHook = ds.then(ds => ds.hooks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ds = alicloud.ess.get_lifecycle_hooks(scaling_group_id="scaling_group_id",
     *     name_regex="lifecyclehook_name")
     * pulumi.export("firstLifecycleHook", ds.hooks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ds = AliCloud.Ess.GetLifecycleHooks.Invoke(new()
     *     {
     *         ScalingGroupId = "scaling_group_id",
     *         NameRegex = "lifecyclehook_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstLifecycleHook"] = ds&#46;Apply(getLifecycleHooksResult => getLifecycleHooksResult&#46;Hooks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ds, err := ess.GetLifecycleHooks(ctx, &ess.GetLifecycleHooksArgs{
     * 			ScalingGroupId: pulumi.StringRef("scaling_group_id"),
     * 			NameRegex:      pulumi.StringRef("lifecyclehook_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstLifecycleHook", ds.Hooks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ess.EssFunctions;
     * import com.pulumi.alicloud.ess.inputs.GetLifecycleHooksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ds = EssFunctions.getLifecycleHooks(GetLifecycleHooksArgs.builder()
     *             .scalingGroupId("scaling_group_id")
     *             .nameRegex("lifecyclehook_name")
     *             .build());
     *         ctx.export("firstLifecycleHook", ds.applyValue(getLifecycleHooksResult -> getLifecycleHooksResult.hooks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ds:
     *     fn::invoke:
     *       Function: alicloud:ess:getLifecycleHooks
     *       Arguments:
     *         scalingGroupId: scaling_group_id
     *         nameRegex: lifecyclehook_name
     * outputs:
     *   firstLifecycleHook: ${ds.hooks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getLifecycleHooks.
     * @return A collection of values returned by getLifecycleHooks.
     */
    public suspend fun getLifecycleHooks(argument: GetLifecycleHooksPlainArgs): GetLifecycleHooksResult =
        getLifecycleHooksResultToKotlin(getLifecycleHooksPlain(argument.toJava()).await())

    /**
     * @see [getLifecycleHooks].
     * @param ids A list of lifecycle hook IDs.
     * @param nameRegex A regex string to filter resulting lifecycle hook by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param scalingGroupId Scaling group id the lifecycle hooks belong to.
     * @return A collection of values returned by getLifecycleHooks.
     */
    public suspend fun getLifecycleHooks(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        scalingGroupId: String? = null,
    ): GetLifecycleHooksResult {
        val argument = GetLifecycleHooksPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            scalingGroupId = scalingGroupId,
        )
        return getLifecycleHooksResultToKotlin(getLifecycleHooksPlain(argument.toJava()).await())
    }

    /**
     * @see [getLifecycleHooks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ess&#46;kotlin&#46;inputs&#46;GetLifecycleHooksPlainArgs].
     * @return A collection of values returned by getLifecycleHooks.
     */
    public suspend fun getLifecycleHooks(argument: suspend GetLifecycleHooksPlainArgsBuilder.() -> Unit): GetLifecycleHooksResult {
        val builder = GetLifecycleHooksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLifecycleHooksResultToKotlin(getLifecycleHooksPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides available notification resources.
     * > **NOTE:** Available in 1.72.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ds = alicloud.ess.getNotifications({
     *     scalingGroupId: "scaling_group_id",
     * });
     * export const firstNotification = ds.then(ds => ds.notifications?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ds = alicloud.ess.get_notifications(scaling_group_id="scaling_group_id")
     * pulumi.export("firstNotification", ds.notifications[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ds = AliCloud.Ess.GetNotifications.Invoke(new()
     *     {
     *         ScalingGroupId = "scaling_group_id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstNotification"] = ds&#46;Apply(getNotificationsResult => getNotificationsResult&#46;Notifications[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ds, err := ess.GetNotifications(ctx, &ess.GetNotificationsArgs{
     * 			ScalingGroupId: "scaling_group_id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstNotification", ds.Notifications[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ess.EssFunctions;
     * import com.pulumi.alicloud.ess.inputs.GetNotificationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ds = EssFunctions.getNotifications(GetNotificationsArgs.builder()
     *             .scalingGroupId("scaling_group_id")
     *             .build());
     *         ctx.export("firstNotification", ds.applyValue(getNotificationsResult -> getNotificationsResult.notifications()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ds:
     *     fn::invoke:
     *       Function: alicloud:ess:getNotifications
     *       Arguments:
     *         scalingGroupId: scaling_group_id
     * outputs:
     *   firstNotification: ${ds.notifications[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNotifications.
     * @return A collection of values returned by getNotifications.
     */
    public suspend fun getNotifications(argument: GetNotificationsPlainArgs): GetNotificationsResult =
        getNotificationsResultToKotlin(getNotificationsPlain(argument.toJava()).await())

    /**
     * @see [getNotifications].
     * @param ids A list of notification ids.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param scalingGroupId Scaling group id the notifications belong to.
     * @return A collection of values returned by getNotifications.
     */
    public suspend fun getNotifications(
        ids: List<String>? = null,
        outputFile: String? = null,
        scalingGroupId: String,
    ): GetNotificationsResult {
        val argument = GetNotificationsPlainArgs(
            ids = ids,
            outputFile = outputFile,
            scalingGroupId = scalingGroupId,
        )
        return getNotificationsResultToKotlin(getNotificationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getNotifications].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ess&#46;kotlin&#46;inputs&#46;GetNotificationsPlainArgs].
     * @return A collection of values returned by getNotifications.
     */
    public suspend fun getNotifications(argument: suspend GetNotificationsPlainArgsBuilder.() -> Unit): GetNotificationsResult {
        val builder = GetNotificationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNotificationsResultToKotlin(getNotificationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides available scaling configuration resources.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const scalingconfigurationsDs = alicloud.ess.getScalingConfigurations({
     *     scalingGroupId: "scaling_group_id",
     *     ids: [
     *         "scaling_configuration_id1",
     *         "scaling_configuration_id2",
     *     ],
     *     nameRegex: "scaling_configuration_name",
     * });
     * export const firstScalingRule = scalingconfigurationsDs.then(scalingconfigurationsDs => scalingconfigurationsDs.configurations?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * scalingconfigurations_ds = alicloud.ess.get_scaling_configurations(scaling_group_id="scaling_group_id",
     *     ids=[
     *         "scaling_configuration_id1",
     *         "scaling_configuration_id2",
     *     ],
     *     name_regex="scaling_configuration_name")
     * pulumi.export("firstScalingRule", scalingconfigurations_ds.configurations[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var scalingconfigurationsDs = AliCloud.Ess.GetScalingConfigurations.Invoke(new()
     *     {
     *         ScalingGroupId = "scaling_group_id",
     *         Ids = new[]
     *         {
     *             "scaling_configuration_id1",
     *             "scaling_configuration_id2",
     *         },
     *         NameRegex = "scaling_configuration_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstScalingRule"] = scalingconfigurationsDs&#46;Apply(getScalingConfigurationsResult => getScalingConfigurationsResult&#46;Configurations[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		scalingconfigurationsDs, err := ess.GetScalingConfigurations(ctx, &ess.GetScalingConfigurationsArgs{
     * 			ScalingGroupId: pulumi.StringRef("scaling_group_id"),
     * 			Ids: []string{
     * 				"scaling_configuration_id1",
     * 				"scaling_configuration_id2",
     * 			},
     * 			NameRegex: pulumi.StringRef("scaling_configuration_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstScalingRule", scalingconfigurationsDs.Configurations[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ess.EssFunctions;
     * import com.pulumi.alicloud.ess.inputs.GetScalingConfigurationsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var scalingconfigurationsDs = EssFunctions.getScalingConfigurations(GetScalingConfigurationsArgs.builder()
     *             .scalingGroupId("scaling_group_id")
     *             .ids(
     *                 "scaling_configuration_id1",
     *                 "scaling_configuration_id2")
     *             .nameRegex("scaling_configuration_name")
     *             .build());
     *         ctx.export("firstScalingRule", scalingconfigurationsDs.applyValue(getScalingConfigurationsResult -> getScalingConfigurationsResult.configurations()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   scalingconfigurationsDs:
     *     fn::invoke:
     *       Function: alicloud:ess:getScalingConfigurations
     *       Arguments:
     *         scalingGroupId: scaling_group_id
     *         ids:
     *           - scaling_configuration_id1
     *           - scaling_configuration_id2
     *         nameRegex: scaling_configuration_name
     * outputs:
     *   firstScalingRule: ${scalingconfigurationsDs.configurations[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getScalingConfigurations.
     * @return A collection of values returned by getScalingConfigurations.
     */
    public suspend fun getScalingConfigurations(argument: GetScalingConfigurationsPlainArgs): GetScalingConfigurationsResult =
        getScalingConfigurationsResultToKotlin(getScalingConfigurationsPlain(argument.toJava()).await())

    /**
     * @see [getScalingConfigurations].
     * @param ids A list of scaling configuration IDs.
     * @param nameRegex A regex string to filter resulting scaling configurations by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param scalingGroupId Scaling group id the scaling configurations belong to.
     * @return A collection of values returned by getScalingConfigurations.
     */
    public suspend fun getScalingConfigurations(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        scalingGroupId: String? = null,
    ): GetScalingConfigurationsResult {
        val argument = GetScalingConfigurationsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            scalingGroupId = scalingGroupId,
        )
        return getScalingConfigurationsResultToKotlin(getScalingConfigurationsPlain(argument.toJava()).await())
    }

    /**
     * @see [getScalingConfigurations].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ess&#46;kotlin&#46;inputs&#46;GetScalingConfigurationsPlainArgs].
     * @return A collection of values returned by getScalingConfigurations.
     */
    public suspend fun getScalingConfigurations(argument: suspend GetScalingConfigurationsPlainArgsBuilder.() -> Unit): GetScalingConfigurationsResult {
        val builder = GetScalingConfigurationsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScalingConfigurationsResultToKotlin(getScalingConfigurationsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides available scaling group resources.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const scalinggroupsDs = alicloud.ess.getScalingGroups({
     *     ids: [
     *         "scaling_group_id1",
     *         "scaling_group_id2",
     *     ],
     *     nameRegex: "scaling_group_name",
     * });
     * export const firstScalingGroup = scalinggroupsDs.then(scalinggroupsDs => scalinggroupsDs.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * scalinggroups_ds = alicloud.ess.get_scaling_groups(ids=[
     *         "scaling_group_id1",
     *         "scaling_group_id2",
     *     ],
     *     name_regex="scaling_group_name")
     * pulumi.export("firstScalingGroup", scalinggroups_ds.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var scalinggroupsDs = AliCloud.Ess.GetScalingGroups.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "scaling_group_id1",
     *             "scaling_group_id2",
     *         },
     *         NameRegex = "scaling_group_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstScalingGroup"] = scalinggroupsDs&#46;Apply(getScalingGroupsResult => getScalingGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		scalinggroupsDs, err := ess.GetScalingGroups(ctx, &ess.GetScalingGroupsArgs{
     * 			Ids: []string{
     * 				"scaling_group_id1",
     * 				"scaling_group_id2",
     * 			},
     * 			NameRegex: pulumi.StringRef("scaling_group_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstScalingGroup", scalinggroupsDs.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ess.EssFunctions;
     * import com.pulumi.alicloud.ess.inputs.GetScalingGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var scalinggroupsDs = EssFunctions.getScalingGroups(GetScalingGroupsArgs.builder()
     *             .ids(
     *                 "scaling_group_id1",
     *                 "scaling_group_id2")
     *             .nameRegex("scaling_group_name")
     *             .build());
     *         ctx.export("firstScalingGroup", scalinggroupsDs.applyValue(getScalingGroupsResult -> getScalingGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   scalinggroupsDs:
     *     fn::invoke:
     *       Function: alicloud:ess:getScalingGroups
     *       Arguments:
     *         ids:
     *           - scaling_group_id1
     *           - scaling_group_id2
     *         nameRegex: scaling_group_name
     * outputs:
     *   firstScalingGroup: ${scalinggroupsDs.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getScalingGroups.
     * @return A collection of values returned by getScalingGroups.
     */
    public suspend fun getScalingGroups(argument: GetScalingGroupsPlainArgs): GetScalingGroupsResult =
        getScalingGroupsResultToKotlin(getScalingGroupsPlain(argument.toJava()).await())

    /**
     * @see [getScalingGroups].
     * @param ids A list of scaling group IDs.
     * @param nameRegex A regex string to filter resulting scaling groups by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getScalingGroups.
     */
    public suspend fun getScalingGroups(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetScalingGroupsResult {
        val argument = GetScalingGroupsPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getScalingGroupsResultToKotlin(getScalingGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getScalingGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ess&#46;kotlin&#46;inputs&#46;GetScalingGroupsPlainArgs].
     * @return A collection of values returned by getScalingGroups.
     */
    public suspend fun getScalingGroups(argument: suspend GetScalingGroupsPlainArgsBuilder.() -> Unit): GetScalingGroupsResult {
        val builder = GetScalingGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScalingGroupsResultToKotlin(getScalingGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides available scaling rule resources.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const scalingrulesDs = alicloud.ess.getScalingRules({
     *     scalingGroupId: "scaling_group_id",
     *     ids: [
     *         "scaling_rule_id1",
     *         "scaling_rule_id2",
     *     ],
     *     nameRegex: "scaling_rule_name",
     * });
     * export const firstScalingRule = scalingrulesDs.then(scalingrulesDs => scalingrulesDs.rules?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * scalingrules_ds = alicloud.ess.get_scaling_rules(scaling_group_id="scaling_group_id",
     *     ids=[
     *         "scaling_rule_id1",
     *         "scaling_rule_id2",
     *     ],
     *     name_regex="scaling_rule_name")
     * pulumi.export("firstScalingRule", scalingrules_ds.rules[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var scalingrulesDs = AliCloud.Ess.GetScalingRules.Invoke(new()
     *     {
     *         ScalingGroupId = "scaling_group_id",
     *         Ids = new[]
     *         {
     *             "scaling_rule_id1",
     *             "scaling_rule_id2",
     *         },
     *         NameRegex = "scaling_rule_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstScalingRule"] = scalingrulesDs&#46;Apply(getScalingRulesResult => getScalingRulesResult&#46;Rules[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		scalingrulesDs, err := ess.GetScalingRules(ctx, &ess.GetScalingRulesArgs{
     * 			ScalingGroupId: pulumi.StringRef("scaling_group_id"),
     * 			Ids: []string{
     * 				"scaling_rule_id1",
     * 				"scaling_rule_id2",
     * 			},
     * 			NameRegex: pulumi.StringRef("scaling_rule_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstScalingRule", scalingrulesDs.Rules[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ess.EssFunctions;
     * import com.pulumi.alicloud.ess.inputs.GetScalingRulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var scalingrulesDs = EssFunctions.getScalingRules(GetScalingRulesArgs.builder()
     *             .scalingGroupId("scaling_group_id")
     *             .ids(
     *                 "scaling_rule_id1",
     *                 "scaling_rule_id2")
     *             .nameRegex("scaling_rule_name")
     *             .build());
     *         ctx.export("firstScalingRule", scalingrulesDs.applyValue(getScalingRulesResult -> getScalingRulesResult.rules()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   scalingrulesDs:
     *     fn::invoke:
     *       Function: alicloud:ess:getScalingRules
     *       Arguments:
     *         scalingGroupId: scaling_group_id
     *         ids:
     *           - scaling_rule_id1
     *           - scaling_rule_id2
     *         nameRegex: scaling_rule_name
     * outputs:
     *   firstScalingRule: ${scalingrulesDs.rules[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getScalingRules.
     * @return A collection of values returned by getScalingRules.
     */
    public suspend fun getScalingRules(argument: GetScalingRulesPlainArgs): GetScalingRulesResult =
        getScalingRulesResultToKotlin(getScalingRulesPlain(argument.toJava()).await())

    /**
     * @see [getScalingRules].
     * @param ids A list of scaling rule IDs.
     * @param nameRegex A regex string to filter resulting scaling rules by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param scalingGroupId Scaling group id the scaling rules belong to.
     * @param type Type of scaling rule.
     * @return A collection of values returned by getScalingRules.
     */
    public suspend fun getScalingRules(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        scalingGroupId: String? = null,
        type: String? = null,
    ): GetScalingRulesResult {
        val argument = GetScalingRulesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            scalingGroupId = scalingGroupId,
            type = type,
        )
        return getScalingRulesResultToKotlin(getScalingRulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getScalingRules].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ess&#46;kotlin&#46;inputs&#46;GetScalingRulesPlainArgs].
     * @return A collection of values returned by getScalingRules.
     */
    public suspend fun getScalingRules(argument: suspend GetScalingRulesPlainArgsBuilder.() -> Unit): GetScalingRulesResult {
        val builder = GetScalingRulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScalingRulesResultToKotlin(getScalingRulesPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides available scheduled task resources.
     * > **NOTE:** Available in 1.72.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ds = alicloud.ess.getScheduledTasks({
     *     scheduledTaskId: "scheduled_task_id",
     *     nameRegex: "scheduled_task_name",
     * });
     * export const firstScheduledTask = ds.then(ds => ds.tasks?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ds = alicloud.ess.get_scheduled_tasks(scheduled_task_id="scheduled_task_id",
     *     name_regex="scheduled_task_name")
     * pulumi.export("firstScheduledTask", ds.tasks[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ds = AliCloud.Ess.GetScheduledTasks.Invoke(new()
     *     {
     *         ScheduledTaskId = "scheduled_task_id",
     *         NameRegex = "scheduled_task_name",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstScheduledTask"] = ds&#46;Apply(getScheduledTasksResult => getScheduledTasksResult&#46;Tasks[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ds, err := ess.GetScheduledTasks(ctx, &ess.GetScheduledTasksArgs{
     * 			ScheduledTaskId: pulumi.StringRef("scheduled_task_id"),
     * 			NameRegex:       pulumi.StringRef("scheduled_task_name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstScheduledTask", ds.Tasks[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.ess.EssFunctions;
     * import com.pulumi.alicloud.ess.inputs.GetScheduledTasksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ds = EssFunctions.getScheduledTasks(GetScheduledTasksArgs.builder()
     *             .scheduledTaskId("scheduled_task_id")
     *             .nameRegex("scheduled_task_name")
     *             .build());
     *         ctx.export("firstScheduledTask", ds.applyValue(getScheduledTasksResult -> getScheduledTasksResult.tasks()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ds:
     *     fn::invoke:
     *       Function: alicloud:ess:getScheduledTasks
     *       Arguments:
     *         scheduledTaskId: scheduled_task_id
     *         nameRegex: scheduled_task_name
     * outputs:
     *   firstScheduledTask: ${ds.tasks[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getScheduledTasks.
     * @return A collection of values returned by getScheduledTasks.
     */
    public suspend fun getScheduledTasks(argument: GetScheduledTasksPlainArgs): GetScheduledTasksResult =
        getScheduledTasksResultToKotlin(getScheduledTasksPlain(argument.toJava()).await())

    /**
     * @see [getScheduledTasks].
     * @param ids A list of scheduled task IDs.
     * @param nameRegex A regex string to filter resulting scheduled tasks by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param scheduledAction The operation to be performed when a scheduled task is triggered.
     * @param scheduledTaskId The id of the scheduled task.
     * @return A collection of values returned by getScheduledTasks.
     */
    public suspend fun getScheduledTasks(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        scheduledAction: String? = null,
        scheduledTaskId: String? = null,
    ): GetScheduledTasksResult {
        val argument = GetScheduledTasksPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            scheduledAction = scheduledAction,
            scheduledTaskId = scheduledTaskId,
        )
        return getScheduledTasksResultToKotlin(getScheduledTasksPlain(argument.toJava()).await())
    }

    /**
     * @see [getScheduledTasks].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;ess&#46;kotlin&#46;inputs&#46;GetScheduledTasksPlainArgs].
     * @return A collection of values returned by getScheduledTasks.
     */
    public suspend fun getScheduledTasks(argument: suspend GetScheduledTasksPlainArgsBuilder.() -> Unit): GetScheduledTasksResult {
        val builder = GetScheduledTasksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScheduledTasksResultToKotlin(getScheduledTasksPlain(builtArgument.toJava()).await())
    }
}
