@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.ScalingConfigurationArgs.builder
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingConfigurationDataDiskArgs
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingConfigurationDataDiskArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingConfigurationInstancePatternInfoArgs
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingConfigurationInstancePatternInfoArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingConfigurationInstanceTypeOverrideArgs
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingConfigurationInstanceTypeOverrideArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingConfigurationSpotPriceLimitArgs
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingConfigurationSpotPriceLimitArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ESS scaling configuration resource.
 * > **NOTE:** Several instance types have outdated in some regions and availability zones, such as `ecs.t1.*`, `ecs.s2.*`, `ecs.n1.*` and so on. If you want to keep them, you should set `is_outdated` to true. For more about the upgraded instance type, refer to `alicloud.ecs.getInstanceTypes` datasource.
 * > **NOTE:** Available since v1.39.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const myName = `${name}-${defaultInteger.result}`;
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 2,
 *     memorySize: 4,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: myName,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: myName,
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: myName,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultSecurityGroupRule = new alicloud.ecs.SecurityGroupRule("default", {
 *     type: "ingress",
 *     ipProtocol: "tcp",
 *     nicType: "intranet",
 *     policy: "accept",
 *     portRange: "22/22",
 *     priority: 1,
 *     securityGroupId: defaultSecurityGroup.id,
 *     cidrIp: "172.16.0.0/24",
 * });
 * const defaultScalingGroup = new alicloud.ess.ScalingGroup("default", {
 *     minSize: 1,
 *     maxSize: 1,
 *     scalingGroupName: myName,
 *     removalPolicies: [
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 *     vswitchIds: [defaultSwitch&#46;id],
 * });
 * const defaultScalingConfiguration = new alicloud.ess.ScalingConfiguration("default", {
 *     scalingGroupId: defaultScalingGroup.id,
 *     imageId: defaultGetImages.then(defaultGetImages => defaultGetImages.images?.[0]?.id),
 *     instanceType: defaultGetInstanceTypes.then(defaultGetInstanceTypes => defaultGetInstanceTypes.instanceTypes?.[0]?.id),
 *     securityGroupId: defaultSecurityGroup.id,
 *     forceDelete: true,
 *     active: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * my_name = f"{name}-{default_integer['result']}"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=2,
 *     memory_size=4)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=my_name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=my_name)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=my_name,
 *     vpc_id=default_network.id)
 * default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
 *     type="ingress",
 *     ip_protocol="tcp",
 *     nic_type="intranet",
 *     policy="accept",
 *     port_range="22/22",
 *     priority=1,
 *     security_group_id=default_security_group.id,
 *     cidr_ip="172.16.0.0/24")
 * default_scaling_group = alicloud.ess.ScalingGroup("default",
 *     min_size=1,
 *     max_size=1,
 *     scaling_group_name=my_name,
 *     removal_policies=[
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 *     vswitch_ids=[default_switch&#46;id])
 * default_scaling_configuration = alicloud.ess.ScalingConfiguration("default",
 *     scaling_group_id=default_scaling_group.id,
 *     image_id=default_get_images.images[0].id,
 *     instance_type=default_get_instance_types.instance_types[0].id,
 *     security_group_id=default_security_group.id,
 *     force_delete=True,
 *     active=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var myName = $"{name}-{defaultInteger.Result}";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 2,
 *         MemorySize = 4,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = myName,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = myName,
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = myName,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultSecurityGroupRule = new AliCloud.Ecs.SecurityGroupRule("default", new()
 *     {
 *         Type = "ingress",
 *         IpProtocol = "tcp",
 *         NicType = "intranet",
 *         Policy = "accept",
 *         PortRange = "22/22",
 *         Priority = 1,
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         CidrIp = "172.16.0.0/24",
 *     });
 *     var defaultScalingGroup = new AliCloud.Ess.ScalingGroup("default", new()
 *     {
 *         MinSize = 1,
 *         MaxSize = 1,
 *         ScalingGroupName = myName,
 *         RemovalPolicies = new[]
 *         {
 *             "OldestInstance",
 *             "NewestInstance",
 *         },
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *         },
 *     });
 *     var defaultScalingConfiguration = new AliCloud.Ess.ScalingConfiguration("default", new()
 *     {
 *         ScalingGroupId = defaultScalingGroup.Id,
 *         ImageId = defaultGetImages.Apply(getImagesResult => getImagesResult.Images[0]?.Id),
 *         InstanceType = defaultGetInstanceTypes.Apply(getInstanceTypesResult => getInstanceTypesResult.InstanceTypes[0]?.Id),
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         ForceDelete = true,
 *         Active = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myName := fmt.Sprintf("%v-%v", name, defaultInteger.Result)
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetInstanceTypes, err := ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(2),
 * 			MemorySize:       pulumi.Float64Ref(4),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetImages, err := ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(myName),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(myName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(myName),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroupRule(ctx, "default", &ecs.SecurityGroupRuleArgs{
 * 			Type:            pulumi.String("ingress"),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			NicType:         pulumi.String("intranet"),
 * 			Policy:          pulumi.String("accept"),
 * 			PortRange:       pulumi.String("22/22"),
 * 			Priority:        pulumi.Int(1),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			CidrIp:          pulumi.String("172.16.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultScalingGroup, err := ess.NewScalingGroup(ctx, "default", &ess.ScalingGroupArgs{
 * 			MinSize:          pulumi.Int(1),
 * 			MaxSize:          pulumi.Int(1),
 * 			ScalingGroupName: pulumi.String(myName),
 * 			RemovalPolicies: pulumi.StringArray{
 * 				pulumi.String("OldestInstance"),
 * 				pulumi.String("NewestInstance"),
 * 			},
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ess.NewScalingConfiguration(ctx, "default", &ess.ScalingConfigurationArgs{
 * 			ScalingGroupId:  defaultScalingGroup.ID(),
 * 			ImageId:         pulumi.String(defaultGetImages.Images[0].Id),
 * 			InstanceType:    pulumi.String(defaultGetInstanceTypes.InstanceTypes[0].Id),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			ForceDelete:     pulumi.Bool(true),
 * 			Active:          pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroupRule;
 * import com.pulumi.alicloud.ecs.SecurityGroupRuleArgs;
 * import com.pulumi.alicloud.ess.ScalingGroup;
 * import com.pulumi.alicloud.ess.ScalingGroupArgs;
 * import com.pulumi.alicloud.ess.ScalingConfiguration;
 * import com.pulumi.alicloud.ess.ScalingConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var myName = String.format("%s-%s", name,defaultInteger.result());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(2)
 *             .memorySize(4)
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(myName)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(myName)
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(myName)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultSecurityGroupRule = new SecurityGroupRule("defaultSecurityGroupRule", SecurityGroupRuleArgs.builder()
 *             .type("ingress")
 *             .ipProtocol("tcp")
 *             .nicType("intranet")
 *             .policy("accept")
 *             .portRange("22/22")
 *             .priority(1)
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .cidrIp("172.16.0.0/24")
 *             .build());
 *         var defaultScalingGroup = new ScalingGroup("defaultScalingGroup", ScalingGroupArgs.builder()
 *             .minSize(1)
 *             .maxSize(1)
 *             .scalingGroupName(myName)
 *             .removalPolicies(
 *                 "OldestInstance",
 *                 "NewestInstance")
 *             .vswitchIds(defaultSwitch.id())
 *             .build());
 *         var defaultScalingConfiguration = new ScalingConfiguration("defaultScalingConfiguration", ScalingConfigurationArgs.builder()
 *             .scalingGroupId(defaultScalingGroup.id())
 *             .imageId(defaultGetImages.applyValue(getImagesResult -> getImagesResult.images()[0].id()))
 *             .instanceType(defaultGetInstanceTypes.applyValue(getInstanceTypesResult -> getInstanceTypesResult.instanceTypes()[0].id()))
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .forceDelete(true)
 *             .active(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${myName}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${myName}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${myName}
 *       vpcId: ${defaultNetwork.id}
 *   defaultSecurityGroupRule:
 *     type: alicloud:ecs:SecurityGroupRule
 *     name: default
 *     properties:
 *       type: ingress
 *       ipProtocol: tcp
 *       nicType: intranet
 *       policy: accept
 *       portRange: 22/22
 *       priority: 1
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       cidrIp: 172.16.0.0/24
 *   defaultScalingGroup:
 *     type: alicloud:ess:ScalingGroup
 *     name: default
 *     properties:
 *       minSize: 1
 *       maxSize: 1
 *       scalingGroupName: ${myName}
 *       removalPolicies:
 *         - OldestInstance
 *         - NewestInstance
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 *   defaultScalingConfiguration:
 *     type: alicloud:ess:ScalingConfiguration
 *     name: default
 *     properties:
 *       scalingGroupId: ${defaultScalingGroup.id}
 *       imageId: ${defaultGetImages.images[0].id}
 *       instanceType: ${defaultGetInstanceTypes.instanceTypes[0].id}
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       forceDelete: true
 *       active: true
 * variables:
 *   myName: ${name}-${defaultInteger.result}
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 2
 *         memorySize: 4
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use to the existing autoscaling module
 * to create a configuration, scaling group and lifecycle hook one-click.
 * ## Import
 * ESS scaling configuration can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/scalingConfiguration:ScalingConfiguration example asg-abc123456
 * ```
 * @property active Whether active current scaling configuration in the specified scaling group. Default to `false`.
 * @property creditSpecification Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
 * @property dataDisks DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
 * @property enable Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
 * @property forceDelete The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
 * @property hostName Hostname of an ECS instance.
 * @property imageId ID of an image file, indicating the image resource selected when an instance is enabled.
 * @property imageName Name of an image file, indicating the image resource selected when an instance is enabled.
 * @property instanceIds It has been deprecated from version 1.6.0. New resource `alicloud.ess.Attachment` replaces it.
 * @property instanceName Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
 * @property instancePatternInfos intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
 * @property instanceType Resource type of an ECS instance.
 * @property instanceTypeOverrides specify the weight of instance type.  See `instance_type_override` below for details.
 * @property instanceTypes Resource types of an ECS instance.
 * @property internetChargeType Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
 * @property internetMaxBandwidthIn Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). The value range is [1,200].
 * @property internetMaxBandwidthOut Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
 * @property ioOptimized It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
 * @property isOutdated Whether to use outdated instance type. Default to false.
 * @property keyName The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
 * @property kmsEncryptedPassword An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
 * @property kmsEncryptionContext An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
 * @property override Indicates whether to overwrite the existing data. Default to false.
 * @property password The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
 * @property passwordInherit Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
 * @property resourceGroupId ID of resource group.
 * @property roleName Instance RAM role name. The name is provided and maintained by RAM. You can use `alicloud.ram.Role` to create a new one.
 * @property scalingConfigurationName Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
 * @property scalingGroupId ID of the scaling group of a scaling configuration.
 * @property securityGroupId ID of the security group used to create new instance. It is conflict with `security_group_ids`.
 * @property securityGroupIds List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
 * @property spotPriceLimits Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
 * > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
 * > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
 * > **NOTE:** Restrictions on attaching ECS instances:
 * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
 * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
 * - The attached ECS instances must in the running state.
 * - The attached ECS instances has not been attached to other scaling groups.
 * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
 * > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
 * @property spotStrategy The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
 * @property substitute The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
 * @property systemDiskAutoSnapshotPolicyId The id of auto snapshot policy for system disk.
 * @property systemDiskCategory Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
 * @property systemDiskDescription The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
 * @property systemDiskEncrypted Whether to encrypt the system disk.
 * @property systemDiskName The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
 * @property systemDiskPerformanceLevel The performance level of the ESSD used as the system disk.
 * @property systemDiskSize Size of system disk, in GiB. Optional values: cloud: 20-500, cloud_efficiency: 20-500, cloud_ssd: 20-500, ephemeral_ssd: 20-500 The default value is max{40, ImageSize}. If this parameter is set, the system disk size must be greater than or equal to max{40, ImageSize}.
 * @property tags A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
 * @property userData User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
 */
public data class ScalingConfigurationArgs(
    public val active: Output<Boolean>? = null,
    public val creditSpecification: Output<String>? = null,
    public val dataDisks: Output<List<ScalingConfigurationDataDiskArgs>>? = null,
    public val enable: Output<Boolean>? = null,
    public val forceDelete: Output<Boolean>? = null,
    public val hostName: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val imageName: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource
      'alicloud_ess_attachment' replaces it.
  """,
    )
    public val instanceIds: Output<List<String>>? = null,
    public val instanceName: Output<String>? = null,
    public val instancePatternInfos: Output<List<ScalingConfigurationInstancePatternInfoArgs>>? =
        null,
    public val instanceType: Output<String>? = null,
    public val instanceTypeOverrides: Output<List<ScalingConfigurationInstanceTypeOverrideArgs>>? =
        null,
    public val instanceTypes: Output<List<String>>? = null,
    public val internetChargeType: Output<String>? = null,
    public val internetMaxBandwidthIn: Output<Int>? = null,
    public val internetMaxBandwidthOut: Output<Int>? = null,
    @Deprecated(
        message = """
  Attribute io_optimized has been deprecated on instance resource. All the launched alicloud
      instances will be IO optimized. Suggest to remove it from your template.
  """,
    )
    public val ioOptimized: Output<String>? = null,
    public val isOutdated: Output<Boolean>? = null,
    public val keyName: Output<String>? = null,
    public val kmsEncryptedPassword: Output<String>? = null,
    public val kmsEncryptionContext: Output<Map<String, String>>? = null,
    public val `override`: Output<Boolean>? = null,
    public val password: Output<String>? = null,
    public val passwordInherit: Output<Boolean>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val roleName: Output<String>? = null,
    public val scalingConfigurationName: Output<String>? = null,
    public val scalingGroupId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val spotPriceLimits: Output<List<ScalingConfigurationSpotPriceLimitArgs>>? = null,
    public val spotStrategy: Output<String>? = null,
    public val substitute: Output<String>? = null,
    public val systemDiskAutoSnapshotPolicyId: Output<String>? = null,
    public val systemDiskCategory: Output<String>? = null,
    public val systemDiskDescription: Output<String>? = null,
    public val systemDiskEncrypted: Output<Boolean>? = null,
    public val systemDiskName: Output<String>? = null,
    public val systemDiskPerformanceLevel: Output<String>? = null,
    public val systemDiskSize: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.ScalingConfigurationArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.ScalingConfigurationArgs =
        com.pulumi.alicloud.ess.ScalingConfigurationArgs.builder()
            .active(active?.applyValue({ args0 -> args0 }))
            .creditSpecification(creditSpecification?.applyValue({ args0 -> args0 }))
            .dataDisks(
                dataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enable(enable?.applyValue({ args0 -> args0 }))
            .forceDelete(forceDelete?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .instanceIds(instanceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instancePatternInfos(
                instancePatternInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .instanceTypeOverrides(
                instanceTypeOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .instanceTypes(instanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthIn(internetMaxBandwidthIn?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthOut(internetMaxBandwidthOut?.applyValue({ args0 -> args0 }))
            .ioOptimized(ioOptimized?.applyValue({ args0 -> args0 }))
            .isOutdated(isOutdated?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .kmsEncryptedPassword(kmsEncryptedPassword?.applyValue({ args0 -> args0 }))
            .kmsEncryptionContext(
                kmsEncryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .`override`(`override`?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .passwordInherit(passwordInherit?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .roleName(roleName?.applyValue({ args0 -> args0 }))
            .scalingConfigurationName(scalingConfigurationName?.applyValue({ args0 -> args0 }))
            .scalingGroupId(scalingGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .spotPriceLimits(
                spotPriceLimits?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .spotStrategy(spotStrategy?.applyValue({ args0 -> args0 }))
            .substitute(substitute?.applyValue({ args0 -> args0 }))
            .systemDiskAutoSnapshotPolicyId(systemDiskAutoSnapshotPolicyId?.applyValue({ args0 -> args0 }))
            .systemDiskCategory(systemDiskCategory?.applyValue({ args0 -> args0 }))
            .systemDiskDescription(systemDiskDescription?.applyValue({ args0 -> args0 }))
            .systemDiskEncrypted(systemDiskEncrypted?.applyValue({ args0 -> args0 }))
            .systemDiskName(systemDiskName?.applyValue({ args0 -> args0 }))
            .systemDiskPerformanceLevel(systemDiskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .systemDiskSize(systemDiskSize?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userData(userData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingConfigurationArgs].
 */
@PulumiTagMarker
public class ScalingConfigurationArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var creditSpecification: Output<String>? = null

    private var dataDisks: Output<List<ScalingConfigurationDataDiskArgs>>? = null

    private var enable: Output<Boolean>? = null

    private var forceDelete: Output<Boolean>? = null

    private var hostName: Output<String>? = null

    private var imageId: Output<String>? = null

    private var imageName: Output<String>? = null

    private var instanceIds: Output<List<String>>? = null

    private var instanceName: Output<String>? = null

    private var instancePatternInfos: Output<List<ScalingConfigurationInstancePatternInfoArgs>>? =
        null

    private var instanceType: Output<String>? = null

    private var instanceTypeOverrides: Output<List<ScalingConfigurationInstanceTypeOverrideArgs>>? =
        null

    private var instanceTypes: Output<List<String>>? = null

    private var internetChargeType: Output<String>? = null

    private var internetMaxBandwidthIn: Output<Int>? = null

    private var internetMaxBandwidthOut: Output<Int>? = null

    private var ioOptimized: Output<String>? = null

    private var isOutdated: Output<Boolean>? = null

    private var keyName: Output<String>? = null

    private var kmsEncryptedPassword: Output<String>? = null

    private var kmsEncryptionContext: Output<Map<String, String>>? = null

    private var `override`: Output<Boolean>? = null

    private var password: Output<String>? = null

    private var passwordInherit: Output<Boolean>? = null

    private var resourceGroupId: Output<String>? = null

    private var roleName: Output<String>? = null

    private var scalingConfigurationName: Output<String>? = null

    private var scalingGroupId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var spotPriceLimits: Output<List<ScalingConfigurationSpotPriceLimitArgs>>? = null

    private var spotStrategy: Output<String>? = null

    private var substitute: Output<String>? = null

    private var systemDiskAutoSnapshotPolicyId: Output<String>? = null

    private var systemDiskCategory: Output<String>? = null

    private var systemDiskDescription: Output<String>? = null

    private var systemDiskEncrypted: Output<Boolean>? = null

    private var systemDiskName: Output<String>? = null

    private var systemDiskPerformanceLevel: Output<String>? = null

    private var systemDiskSize: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    /**
     * @param value Whether active current scaling configuration in the specified scaling group. Default to `false`.
     */
    @JvmName("xikmwgsbansbgitc")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
     */
    @JvmName("vfhuuxscicdpjdsy")
    public suspend fun creditSpecification(`value`: Output<String>) {
        this.creditSpecification = value
    }

    /**
     * @param value DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
     */
    @JvmName("ycjgnnvyelongpdi")
    public suspend fun dataDisks(`value`: Output<List<ScalingConfigurationDataDiskArgs>>) {
        this.dataDisks = value
    }

    @JvmName("vmyannnclmscxkbk")
    public suspend fun dataDisks(vararg values: Output<ScalingConfigurationDataDiskArgs>) {
        this.dataDisks = Output.all(values.asList())
    }

    /**
     * @param values DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
     */
    @JvmName("tlabvdvojowsvftw")
    public suspend fun dataDisks(values: List<Output<ScalingConfigurationDataDiskArgs>>) {
        this.dataDisks = Output.all(values)
    }

    /**
     * @param value Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
     */
    @JvmName("hphkcbhvtskslbyj")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
     */
    @JvmName("oraludniqhjuesyq")
    public suspend fun forceDelete(`value`: Output<Boolean>) {
        this.forceDelete = value
    }

    /**
     * @param value Hostname of an ECS instance.
     */
    @JvmName("qhnkxlucrteaohdb")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value ID of an image file, indicating the image resource selected when an instance is enabled.
     */
    @JvmName("irphfxqqsgxehpyi")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value Name of an image file, indicating the image resource selected when an instance is enabled.
     */
    @JvmName("iuyonybojatjmlwo")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value It has been deprecated from version 1.6.0. New resource `alicloud.ess.Attachment` replaces it.
     */
    @Deprecated(
        message = """
  Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource
      'alicloud_ess_attachment' replaces it.
  """,
    )
    @JvmName("tobgvssocxrehemr")
    public suspend fun instanceIds(`value`: Output<List<String>>) {
        this.instanceIds = value
    }

    @JvmName("bypvnhioqjfwldbw")
    public suspend fun instanceIds(vararg values: Output<String>) {
        this.instanceIds = Output.all(values.asList())
    }

    /**
     * @param values It has been deprecated from version 1.6.0. New resource `alicloud.ess.Attachment` replaces it.
     */
    @Deprecated(
        message = """
  Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource
      'alicloud_ess_attachment' replaces it.
  """,
    )
    @JvmName("rkqukagwnudppglm")
    public suspend fun instanceIds(values: List<Output<String>>) {
        this.instanceIds = Output.all(values)
    }

    /**
     * @param value Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
     */
    @JvmName("akjcqjjeprfatgyn")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
     */
    @JvmName("utjqnrsywpvcyqqe")
    public suspend fun instancePatternInfos(`value`: Output<List<ScalingConfigurationInstancePatternInfoArgs>>) {
        this.instancePatternInfos = value
    }

    @JvmName("ajdjkyngdkwhykrh")
    public suspend fun instancePatternInfos(vararg values: Output<ScalingConfigurationInstancePatternInfoArgs>) {
        this.instancePatternInfos = Output.all(values.asList())
    }

    /**
     * @param values intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
     */
    @JvmName("aeedcddgkkroniei")
    public suspend fun instancePatternInfos(values: List<Output<ScalingConfigurationInstancePatternInfoArgs>>) {
        this.instancePatternInfos = Output.all(values)
    }

    /**
     * @param value Resource type of an ECS instance.
     */
    @JvmName("fepwtrkpnidsyyou")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value specify the weight of instance type.  See `instance_type_override` below for details.
     */
    @JvmName("tirykgxpqydhtxvv")
    public suspend fun instanceTypeOverrides(`value`: Output<List<ScalingConfigurationInstanceTypeOverrideArgs>>) {
        this.instanceTypeOverrides = value
    }

    @JvmName("xolniqdsjkajdawj")
    public suspend fun instanceTypeOverrides(vararg values: Output<ScalingConfigurationInstanceTypeOverrideArgs>) {
        this.instanceTypeOverrides = Output.all(values.asList())
    }

    /**
     * @param values specify the weight of instance type.  See `instance_type_override` below for details.
     */
    @JvmName("oxqhdptnmliqihwd")
    public suspend fun instanceTypeOverrides(values: List<Output<ScalingConfigurationInstanceTypeOverrideArgs>>) {
        this.instanceTypeOverrides = Output.all(values)
    }

    /**
     * @param value Resource types of an ECS instance.
     */
    @JvmName("qkvrnmpjtfbxxavk")
    public suspend fun instanceTypes(`value`: Output<List<String>>) {
        this.instanceTypes = value
    }

    @JvmName("psybymnymeqtvxxx")
    public suspend fun instanceTypes(vararg values: Output<String>) {
        this.instanceTypes = Output.all(values.asList())
    }

    /**
     * @param values Resource types of an ECS instance.
     */
    @JvmName("pukjhrmhjgowtano")
    public suspend fun instanceTypes(values: List<Output<String>>) {
        this.instanceTypes = Output.all(values)
    }

    /**
     * @param value Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
     */
    @JvmName("qjisrdxjjuulyhsu")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). The value range is [1,200].
     */
    @JvmName("olltkidnrhtyhwns")
    public suspend fun internetMaxBandwidthIn(`value`: Output<Int>) {
        this.internetMaxBandwidthIn = value
    }

    /**
     * @param value Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
     */
    @JvmName("rqeotijmvvbattkv")
    public suspend fun internetMaxBandwidthOut(`value`: Output<Int>) {
        this.internetMaxBandwidthOut = value
    }

    /**
     * @param value It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
     */
    @Deprecated(
        message = """
  Attribute io_optimized has been deprecated on instance resource. All the launched alicloud
      instances will be IO optimized. Suggest to remove it from your template.
  """,
    )
    @JvmName("gbwpnydpnuimjjyp")
    public suspend fun ioOptimized(`value`: Output<String>) {
        this.ioOptimized = value
    }

    /**
     * @param value Whether to use outdated instance type. Default to false.
     */
    @JvmName("ihrcbyimritkydla")
    public suspend fun isOutdated(`value`: Output<Boolean>) {
        this.isOutdated = value
    }

    /**
     * @param value The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
     */
    @JvmName("hguenhewcncfdnoo")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
     */
    @JvmName("eofnthxlcsbqtkak")
    public suspend fun kmsEncryptedPassword(`value`: Output<String>) {
        this.kmsEncryptedPassword = value
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("jmdrinilvkmgkqyr")
    public suspend fun kmsEncryptionContext(`value`: Output<Map<String, String>>) {
        this.kmsEncryptionContext = value
    }

    /**
     * @param value Indicates whether to overwrite the existing data. Default to false.
     */
    @JvmName("gjrqmrwuxaeoqhaa")
    public suspend fun `override`(`value`: Output<Boolean>) {
        this.`override` = value
    }

    /**
     * @param value The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
     */
    @JvmName("ndhhgdkjjwowujkl")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
     */
    @JvmName("ngymicroscumkkng")
    public suspend fun passwordInherit(`value`: Output<Boolean>) {
        this.passwordInherit = value
    }

    /**
     * @param value ID of resource group.
     */
    @JvmName("nfmrjjdhyhomuagt")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Instance RAM role name. The name is provided and maintained by RAM. You can use `alicloud.ram.Role` to create a new one.
     */
    @JvmName("ohwsjaypgowcltni")
    public suspend fun roleName(`value`: Output<String>) {
        this.roleName = value
    }

    /**
     * @param value Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
     */
    @JvmName("amcmsymeuitjoxcu")
    public suspend fun scalingConfigurationName(`value`: Output<String>) {
        this.scalingConfigurationName = value
    }

    /**
     * @param value ID of the scaling group of a scaling configuration.
     */
    @JvmName("jrnwvqgquaqqhrjc")
    public suspend fun scalingGroupId(`value`: Output<String>) {
        this.scalingGroupId = value
    }

    /**
     * @param value ID of the security group used to create new instance. It is conflict with `security_group_ids`.
     */
    @JvmName("grhtydkqnqxeqhhx")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
     */
    @JvmName("hqtywddokftvjlrs")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("osaclaocgmenquqg")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
     */
    @JvmName("jatvmkyhmvhjhrba")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
     * > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
     * > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
     * > **NOTE:** Restrictions on attaching ECS instances:
     * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
     * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
     * - The attached ECS instances must in the running state.
     * - The attached ECS instances has not been attached to other scaling groups.
     * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
     * > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
     */
    @JvmName("ojurvdgxvydnnyvj")
    public suspend fun spotPriceLimits(`value`: Output<List<ScalingConfigurationSpotPriceLimitArgs>>) {
        this.spotPriceLimits = value
    }

    @JvmName("qdhyennxdkciprup")
    public suspend fun spotPriceLimits(vararg values: Output<ScalingConfigurationSpotPriceLimitArgs>) {
        this.spotPriceLimits = Output.all(values.asList())
    }

    /**
     * @param values Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
     * > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
     * > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
     * > **NOTE:** Restrictions on attaching ECS instances:
     * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
     * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
     * - The attached ECS instances must in the running state.
     * - The attached ECS instances has not been attached to other scaling groups.
     * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
     * > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
     */
    @JvmName("awnssygrkeeijolv")
    public suspend fun spotPriceLimits(values: List<Output<ScalingConfigurationSpotPriceLimitArgs>>) {
        this.spotPriceLimits = Output.all(values)
    }

    /**
     * @param value The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
     */
    @JvmName("lksyqlgbogiuwscm")
    public suspend fun spotStrategy(`value`: Output<String>) {
        this.spotStrategy = value
    }

    /**
     * @param value The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
     */
    @JvmName("fbfnxjcvnpvmvprq")
    public suspend fun substitute(`value`: Output<String>) {
        this.substitute = value
    }

    /**
     * @param value The id of auto snapshot policy for system disk.
     */
    @JvmName("gbxqhojqgdeqhckr")
    public suspend fun systemDiskAutoSnapshotPolicyId(`value`: Output<String>) {
        this.systemDiskAutoSnapshotPolicyId = value
    }

    /**
     * @param value Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
     */
    @JvmName("ivrxgtvorehggcjd")
    public suspend fun systemDiskCategory(`value`: Output<String>) {
        this.systemDiskCategory = value
    }

    /**
     * @param value The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("mylqyfuhodsqaycf")
    public suspend fun systemDiskDescription(`value`: Output<String>) {
        this.systemDiskDescription = value
    }

    /**
     * @param value Whether to encrypt the system disk.
     */
    @JvmName("ffggqqaistfskfal")
    public suspend fun systemDiskEncrypted(`value`: Output<Boolean>) {
        this.systemDiskEncrypted = value
    }

    /**
     * @param value The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
     */
    @JvmName("ctvvoitttksrbtcy")
    public suspend fun systemDiskName(`value`: Output<String>) {
        this.systemDiskName = value
    }

    /**
     * @param value The performance level of the ESSD used as the system disk.
     */
    @JvmName("rpdmalvikqmearjt")
    public suspend fun systemDiskPerformanceLevel(`value`: Output<String>) {
        this.systemDiskPerformanceLevel = value
    }

    /**
     * @param value Size of system disk, in GiB. Optional values: cloud: 20-500, cloud_efficiency: 20-500, cloud_ssd: 20-500, ephemeral_ssd: 20-500 The default value is max{40, ImageSize}. If this parameter is set, the system disk size must be greater than or equal to max{40, ImageSize}.
     */
    @JvmName("eavlbcdjoubrsaxh")
    public suspend fun systemDiskSize(`value`: Output<Int>) {
        this.systemDiskSize = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
     */
    @JvmName("xwveucbpsqdxdoml")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
     */
    @JvmName("jxlrtjjbnvysgbxr")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value Whether active current scaling configuration in the specified scaling group. Default to `false`.
     */
    @JvmName("hrviqvhisvinuhrn")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
     */
    @JvmName("udayuisavyyddtdq")
    public suspend fun creditSpecification(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creditSpecification = mapped
    }

    /**
     * @param value DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
     */
    @JvmName("ngqjrvolxqjhaeoh")
    public suspend fun dataDisks(`value`: List<ScalingConfigurationDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param argument DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
     */
    @JvmName("xieidmsimovnduas")
    public suspend fun dataDisks(argument: List<suspend ScalingConfigurationDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingConfigurationDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
     */
    @JvmName("lmykpejyyhimysgg")
    public suspend fun dataDisks(vararg argument: suspend ScalingConfigurationDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingConfigurationDataDiskArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param argument DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
     */
    @JvmName("oafncrqylxshvecm")
    public suspend fun dataDisks(argument: suspend ScalingConfigurationDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScalingConfigurationDataDiskArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataDisks = mapped
    }

    /**
     * @param values DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
     */
    @JvmName("adqnhyltggpxtnnp")
    public suspend fun dataDisks(vararg values: ScalingConfigurationDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDisks = mapped
    }

    /**
     * @param value Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
     */
    @JvmName("knjxdcpkichoqigh")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
     */
    @JvmName("cuhcdcygmskqapns")
    public suspend fun forceDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDelete = mapped
    }

    /**
     * @param value Hostname of an ECS instance.
     */
    @JvmName("fysjorckfhknyuax")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value ID of an image file, indicating the image resource selected when an instance is enabled.
     */
    @JvmName("gtoyivrrtdeajwcj")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value Name of an image file, indicating the image resource selected when an instance is enabled.
     */
    @JvmName("ikxgrytcuphnogrf")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value It has been deprecated from version 1.6.0. New resource `alicloud.ess.Attachment` replaces it.
     */
    @Deprecated(
        message = """
  Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource
      'alicloud_ess_attachment' replaces it.
  """,
    )
    @JvmName("cuoxrrlrpvhnykom")
    public suspend fun instanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param values It has been deprecated from version 1.6.0. New resource `alicloud.ess.Attachment` replaces it.
     */
    @Deprecated(
        message = """
  Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource
      'alicloud_ess_attachment' replaces it.
  """,
    )
    @JvmName("ymmkqtpobukitylq")
    public suspend fun instanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceIds = mapped
    }

    /**
     * @param value Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
     */
    @JvmName("uexbapiiannqhwuw")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
     */
    @JvmName("schqlsculirkwjgs")
    public suspend fun instancePatternInfos(`value`: List<ScalingConfigurationInstancePatternInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instancePatternInfos = mapped
    }

    /**
     * @param argument intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
     */
    @JvmName("rxkymeymdnkcpngj")
    public suspend fun instancePatternInfos(argument: List<suspend ScalingConfigurationInstancePatternInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingConfigurationInstancePatternInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instancePatternInfos = mapped
    }

    /**
     * @param argument intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
     */
    @JvmName("utuylenlajrmewnd")
    public suspend fun instancePatternInfos(vararg argument: suspend ScalingConfigurationInstancePatternInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingConfigurationInstancePatternInfoArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instancePatternInfos = mapped
    }

    /**
     * @param argument intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
     */
    @JvmName("yhddgmhurmwybull")
    public suspend fun instancePatternInfos(argument: suspend ScalingConfigurationInstancePatternInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScalingConfigurationInstancePatternInfoArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instancePatternInfos = mapped
    }

    /**
     * @param values intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
     */
    @JvmName("phorlmnwbkrrqabp")
    public suspend fun instancePatternInfos(vararg values: ScalingConfigurationInstancePatternInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instancePatternInfos = mapped
    }

    /**
     * @param value Resource type of an ECS instance.
     */
    @JvmName("nkppuhlpfpditetb")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value specify the weight of instance type.  See `instance_type_override` below for details.
     */
    @JvmName("gcbrkhixafbigqyv")
    public suspend fun instanceTypeOverrides(`value`: List<ScalingConfigurationInstanceTypeOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypeOverrides = mapped
    }

    /**
     * @param argument specify the weight of instance type.  See `instance_type_override` below for details.
     */
    @JvmName("llwlohiitscevsjp")
    public suspend fun instanceTypeOverrides(argument: List<suspend ScalingConfigurationInstanceTypeOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingConfigurationInstanceTypeOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceTypeOverrides = mapped
    }

    /**
     * @param argument specify the weight of instance type.  See `instance_type_override` below for details.
     */
    @JvmName("wdfhdughbpgkgwhm")
    public suspend fun instanceTypeOverrides(vararg argument: suspend ScalingConfigurationInstanceTypeOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingConfigurationInstanceTypeOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceTypeOverrides = mapped
    }

    /**
     * @param argument specify the weight of instance type.  See `instance_type_override` below for details.
     */
    @JvmName("jywfqxmjrhfofpcm")
    public suspend fun instanceTypeOverrides(argument: suspend ScalingConfigurationInstanceTypeOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScalingConfigurationInstanceTypeOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instanceTypeOverrides = mapped
    }

    /**
     * @param values specify the weight of instance type.  See `instance_type_override` below for details.
     */
    @JvmName("ngcmudmcnrwgmmie")
    public suspend fun instanceTypeOverrides(vararg values: ScalingConfigurationInstanceTypeOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypeOverrides = mapped
    }

    /**
     * @param value Resource types of an ECS instance.
     */
    @JvmName("pxujwdrvbwrecasl")
    public suspend fun instanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param values Resource types of an ECS instance.
     */
    @JvmName("cgemviralckmjrfa")
    public suspend fun instanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param value Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
     */
    @JvmName("rtfxrpqsbyrjbggy")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). The value range is [1,200].
     */
    @JvmName("upbnbgmwoactgpxy")
    public suspend fun internetMaxBandwidthIn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthIn = mapped
    }

    /**
     * @param value Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
     */
    @JvmName("tnbmgbpsninqblok")
    public suspend fun internetMaxBandwidthOut(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthOut = mapped
    }

    /**
     * @param value It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
     */
    @Deprecated(
        message = """
  Attribute io_optimized has been deprecated on instance resource. All the launched alicloud
      instances will be IO optimized. Suggest to remove it from your template.
  """,
    )
    @JvmName("bqsnjoflogymllrj")
    public suspend fun ioOptimized(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ioOptimized = mapped
    }

    /**
     * @param value Whether to use outdated instance type. Default to false.
     */
    @JvmName("gdwalxjikmlstgmj")
    public suspend fun isOutdated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isOutdated = mapped
    }

    /**
     * @param value The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
     */
    @JvmName("mlcpcwhjcsxcykpt")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
     */
    @JvmName("jewvtlbmvocsiwjo")
    public suspend fun kmsEncryptedPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptedPassword = mapped
    }

    /**
     * @param value An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("tbnbcjdlmgxanpam")
    public suspend fun kmsEncryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param values An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
     */
    @JvmName("oefwpaguyewnauan")
    public fun kmsEncryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsEncryptionContext = mapped
    }

    /**
     * @param value Indicates whether to overwrite the existing data. Default to false.
     */
    @JvmName("ajdjoqbtdwkedqqu")
    public suspend fun `override`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`override` = mapped
    }

    /**
     * @param value The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
     */
    @JvmName("ncwccoikapyxahmg")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
     */
    @JvmName("teqmsoqvxbchexjs")
    public suspend fun passwordInherit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordInherit = mapped
    }

    /**
     * @param value ID of resource group.
     */
    @JvmName("shwubbwqwekoygqv")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Instance RAM role name. The name is provided and maintained by RAM. You can use `alicloud.ram.Role` to create a new one.
     */
    @JvmName("ebqitixmjxexmdaw")
    public suspend fun roleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleName = mapped
    }

    /**
     * @param value Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
     */
    @JvmName("aydcchehvgrsiqsk")
    public suspend fun scalingConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingConfigurationName = mapped
    }

    /**
     * @param value ID of the scaling group of a scaling configuration.
     */
    @JvmName("ewjujxycpgdkeupo")
    public suspend fun scalingGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingGroupId = mapped
    }

    /**
     * @param value ID of the security group used to create new instance. It is conflict with `security_group_ids`.
     */
    @JvmName("bghupwooodpvmjvt")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
     */
    @JvmName("cxmlhyptimvyifam")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
     */
    @JvmName("ggvyipombbcwjefo")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
     * > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
     * > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
     * > **NOTE:** Restrictions on attaching ECS instances:
     * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
     * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
     * - The attached ECS instances must in the running state.
     * - The attached ECS instances has not been attached to other scaling groups.
     * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
     * > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
     */
    @JvmName("baerwoenbmrklfet")
    public suspend fun spotPriceLimits(`value`: List<ScalingConfigurationSpotPriceLimitArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPriceLimits = mapped
    }

    /**
     * @param argument Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
     * > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
     * > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
     * > **NOTE:** Restrictions on attaching ECS instances:
     * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
     * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
     * - The attached ECS instances must in the running state.
     * - The attached ECS instances has not been attached to other scaling groups.
     * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
     * > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
     */
    @JvmName("ingwqehhodydligv")
    public suspend fun spotPriceLimits(argument: List<suspend ScalingConfigurationSpotPriceLimitArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingConfigurationSpotPriceLimitArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.spotPriceLimits = mapped
    }

    /**
     * @param argument Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
     * > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
     * > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
     * > **NOTE:** Restrictions on attaching ECS instances:
     * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
     * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
     * - The attached ECS instances must in the running state.
     * - The attached ECS instances has not been attached to other scaling groups.
     * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
     * > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
     */
    @JvmName("rpfiibkupeaojtto")
    public suspend fun spotPriceLimits(vararg argument: suspend ScalingConfigurationSpotPriceLimitArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingConfigurationSpotPriceLimitArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.spotPriceLimits = mapped
    }

    /**
     * @param argument Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
     * > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
     * > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
     * > **NOTE:** Restrictions on attaching ECS instances:
     * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
     * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
     * - The attached ECS instances must in the running state.
     * - The attached ECS instances has not been attached to other scaling groups.
     * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
     * > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
     */
    @JvmName("gbqitmypyvywpykw")
    public suspend fun spotPriceLimits(argument: suspend ScalingConfigurationSpotPriceLimitArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScalingConfigurationSpotPriceLimitArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.spotPriceLimits = mapped
    }

    /**
     * @param values Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
     * > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
     * > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
     * > **NOTE:** Restrictions on attaching ECS instances:
     * - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
     * - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
     * - The attached ECS instances must in the running state.
     * - The attached ECS instances has not been attached to other scaling groups.
     * - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
     * > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
     */
    @JvmName("kguopiicanlctsus")
    public suspend fun spotPriceLimits(vararg values: ScalingConfigurationSpotPriceLimitArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spotPriceLimits = mapped
    }

    /**
     * @param value The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
     */
    @JvmName("wxcmridstmnfwfsw")
    public suspend fun spotStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotStrategy = mapped
    }

    /**
     * @param value The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
     */
    @JvmName("xnmpobwjgdpjliaa")
    public suspend fun substitute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.substitute = mapped
    }

    /**
     * @param value The id of auto snapshot policy for system disk.
     */
    @JvmName("uloepbqoxlrpdplf")
    public suspend fun systemDiskAutoSnapshotPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskAutoSnapshotPolicyId = mapped
    }

    /**
     * @param value Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
     */
    @JvmName("osjbdfynotxflrfr")
    public suspend fun systemDiskCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskCategory = mapped
    }

    /**
     * @param value The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
     */
    @JvmName("dbfyjpjirttsmlue")
    public suspend fun systemDiskDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskDescription = mapped
    }

    /**
     * @param value Whether to encrypt the system disk.
     */
    @JvmName("npotqnutasdouika")
    public suspend fun systemDiskEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskEncrypted = mapped
    }

    /**
     * @param value The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
     */
    @JvmName("kxhocpxbvmhluyyp")
    public suspend fun systemDiskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskName = mapped
    }

    /**
     * @param value The performance level of the ESSD used as the system disk.
     */
    @JvmName("qmqkdyistvaloacd")
    public suspend fun systemDiskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskPerformanceLevel = mapped
    }

    /**
     * @param value Size of system disk, in GiB. Optional values: cloud: 20-500, cloud_efficiency: 20-500, cloud_ssd: 20-500, ephemeral_ssd: 20-500 The default value is max{40, ImageSize}. If this parameter is set, the system disk size must be greater than or equal to max{40, ImageSize}.
     */
    @JvmName("jrdiufwpvvrkleim")
    public suspend fun systemDiskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskSize = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
     */
    @JvmName("tljsqnemjyvcwycx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
     */
    @JvmName("lhmosfllmlwjxiyu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
     */
    @JvmName("tefqheuwgbmpjnkv")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    internal fun build(): ScalingConfigurationArgs = ScalingConfigurationArgs(
        active = active,
        creditSpecification = creditSpecification,
        dataDisks = dataDisks,
        enable = enable,
        forceDelete = forceDelete,
        hostName = hostName,
        imageId = imageId,
        imageName = imageName,
        instanceIds = instanceIds,
        instanceName = instanceName,
        instancePatternInfos = instancePatternInfos,
        instanceType = instanceType,
        instanceTypeOverrides = instanceTypeOverrides,
        instanceTypes = instanceTypes,
        internetChargeType = internetChargeType,
        internetMaxBandwidthIn = internetMaxBandwidthIn,
        internetMaxBandwidthOut = internetMaxBandwidthOut,
        ioOptimized = ioOptimized,
        isOutdated = isOutdated,
        keyName = keyName,
        kmsEncryptedPassword = kmsEncryptedPassword,
        kmsEncryptionContext = kmsEncryptionContext,
        `override` = `override`,
        password = password,
        passwordInherit = passwordInherit,
        resourceGroupId = resourceGroupId,
        roleName = roleName,
        scalingConfigurationName = scalingConfigurationName,
        scalingGroupId = scalingGroupId,
        securityGroupId = securityGroupId,
        securityGroupIds = securityGroupIds,
        spotPriceLimits = spotPriceLimits,
        spotStrategy = spotStrategy,
        substitute = substitute,
        systemDiskAutoSnapshotPolicyId = systemDiskAutoSnapshotPolicyId,
        systemDiskCategory = systemDiskCategory,
        systemDiskDescription = systemDiskDescription,
        systemDiskEncrypted = systemDiskEncrypted,
        systemDiskName = systemDiskName,
        systemDiskPerformanceLevel = systemDiskPerformanceLevel,
        systemDiskSize = systemDiskSize,
        tags = tags,
        userData = userData,
    )
}
