@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.kotlin.outputs.ScalingGroupAlbServerGroup
import com.pulumi.alicloud.ess.kotlin.outputs.ScalingGroupLaunchTemplateOverride
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.ess.kotlin.outputs.ScalingGroupAlbServerGroup.Companion.toKotlin as scalingGroupAlbServerGroupToKotlin
import com.pulumi.alicloud.ess.kotlin.outputs.ScalingGroupLaunchTemplateOverride.Companion.toKotlin as scalingGroupLaunchTemplateOverrideToKotlin

/**
 * Builder for [ScalingGroup].
 */
@PulumiTagMarker
public class ScalingGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScalingGroupArgs = ScalingGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScalingGroupArgsBuilder.() -> Unit) {
        val builder = ScalingGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScalingGroup {
        val builtJavaResource = com.pulumi.alicloud.ess.ScalingGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ScalingGroup(builtJavaResource)
    }
}

/**
 * Provides a ESS scaling group resource which is a collection of ECS instances with the same application scenarios.
 * It defines the maximum and minimum numbers of ECS instances in the group, and their associated Server Load Balancer instances, RDS instances, and other attributes.
 * > **NOTE:** You can launch an ESS scaling group for a VPC network via specifying parameter `vswitch_ids`.
 * For information about ess scaling rule, see [CreateScalingGroup](https://www.alibabacloud.com/help/en/auto-scaling/latest/createscalinggroup).
 * > **NOTE:** Available since v1.39.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const myName = `${name}-${defaultInteger.result}`;
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 2,
 *     memorySize: 4,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: myName,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: myName,
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: myName,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultSecurityGroupRule = new alicloud.ecs.SecurityGroupRule("default", {
 *     type: "ingress",
 *     ipProtocol: "tcp",
 *     nicType: "intranet",
 *     policy: "accept",
 *     portRange: "22/22",
 *     priority: 1,
 *     securityGroupId: defaultSecurityGroup.id,
 *     cidrIp: "172.16.0.0/24",
 * });
 * const default2 = new alicloud.vpc.Switch("default2", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.1.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: `${name}-bar`,
 * });
 * const defaultScalingGroup = new alicloud.ess.ScalingGroup("default", {
 *     minSize: 1,
 *     maxSize: 1,
 *     scalingGroupName: myName,
 *     defaultCooldown: 20,
 *     vswitchIds: [
 *         defaultSwitch.id,
 *         default2.id,
 *     ],
 *     removalPolicies: [
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * my_name = f"{name}-{default_integer['result']}"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=2,
 *     memory_size=4)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=my_name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=my_name)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=my_name,
 *     vpc_id=default_network.id)
 * default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
 *     type="ingress",
 *     ip_protocol="tcp",
 *     nic_type="intranet",
 *     policy="accept",
 *     port_range="22/22",
 *     priority=1,
 *     security_group_id=default_security_group.id,
 *     cidr_ip="172.16.0.0/24")
 * default2 = alicloud.vpc.Switch("default2",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.1.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=f"{name}-bar")
 * default_scaling_group = alicloud.ess.ScalingGroup("default",
 *     min_size=1,
 *     max_size=1,
 *     scaling_group_name=my_name,
 *     default_cooldown=20,
 *     vswitch_ids=[
 *         default_switch.id,
 *         default2.id,
 *     ],
 *     removal_policies=[
 *         "OldestInstance",
 *         "NewestInstance",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var myName = $"{name}-{defaultInteger.Result}";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 2,
 *         MemorySize = 4,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = myName,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = myName,
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = myName,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultSecurityGroupRule = new AliCloud.Ecs.SecurityGroupRule("default", new()
 *     {
 *         Type = "ingress",
 *         IpProtocol = "tcp",
 *         NicType = "intranet",
 *         Policy = "accept",
 *         PortRange = "22/22",
 *         Priority = 1,
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         CidrIp = "172.16.0.0/24",
 *     });
 *     var default2 = new AliCloud.Vpc.Switch("default2", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.1.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = $"{name}-bar",
 *     });
 *     var defaultScalingGroup = new AliCloud.Ess.ScalingGroup("default", new()
 *     {
 *         MinSize = 1,
 *         MaxSize = 1,
 *         ScalingGroupName = myName,
 *         DefaultCooldown = 20,
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *             default2.Id,
 *         },
 *         RemovalPolicies = new[]
 *         {
 *             "OldestInstance",
 *             "NewestInstance",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myName := fmt.Sprintf("%v-%v", name, defaultInteger.Result)
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(2),
 * 			MemorySize:       pulumi.Float64Ref(4),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(myName),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(myName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(myName),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroupRule(ctx, "default", &ecs.SecurityGroupRuleArgs{
 * 			Type:            pulumi.String("ingress"),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			NicType:         pulumi.String("intranet"),
 * 			Policy:          pulumi.String("accept"),
 * 			PortRange:       pulumi.String("22/22"),
 * 			Priority:        pulumi.Int(1),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			CidrIp:          pulumi.String("172.16.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default2, err := vpc.NewSwitch(ctx, "default2", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.1.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.Sprintf("%v-bar", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ess.NewScalingGroup(ctx, "default", &ess.ScalingGroupArgs{
 * 			MinSize:          pulumi.Int(1),
 * 			MaxSize:          pulumi.Int(1),
 * 			ScalingGroupName: pulumi.String(myName),
 * 			DefaultCooldown:  pulumi.Int(20),
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 				default2.ID(),
 * 			},
 * 			RemovalPolicies: pulumi.StringArray{
 * 				pulumi.String("OldestInstance"),
 * 				pulumi.String("NewestInstance"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroupRule;
 * import com.pulumi.alicloud.ecs.SecurityGroupRuleArgs;
 * import com.pulumi.alicloud.ess.ScalingGroup;
 * import com.pulumi.alicloud.ess.ScalingGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var myName = String.format("%s-%s", name,defaultInteger.result());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(2)
 *             .memorySize(4)
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(myName)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(myName)
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(myName)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultSecurityGroupRule = new SecurityGroupRule("defaultSecurityGroupRule", SecurityGroupRuleArgs.builder()
 *             .type("ingress")
 *             .ipProtocol("tcp")
 *             .nicType("intranet")
 *             .policy("accept")
 *             .portRange("22/22")
 *             .priority(1)
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .cidrIp("172.16.0.0/24")
 *             .build());
 *         var default2 = new Switch("default2", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.1.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(String.format("%s-bar", name))
 *             .build());
 *         var defaultScalingGroup = new ScalingGroup("defaultScalingGroup", ScalingGroupArgs.builder()
 *             .minSize(1)
 *             .maxSize(1)
 *             .scalingGroupName(myName)
 *             .defaultCooldown(20)
 *             .vswitchIds(
 *                 defaultSwitch.id(),
 *                 default2.id())
 *             .removalPolicies(
 *                 "OldestInstance",
 *                 "NewestInstance")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${myName}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${myName}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${myName}
 *       vpcId: ${defaultNetwork.id}
 *   defaultSecurityGroupRule:
 *     type: alicloud:ecs:SecurityGroupRule
 *     name: default
 *     properties:
 *       type: ingress
 *       ipProtocol: tcp
 *       nicType: intranet
 *       policy: accept
 *       portRange: 22/22
 *       priority: 1
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       cidrIp: 172.16.0.0/24
 *   default2:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.1.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}-bar
 *   defaultScalingGroup:
 *     type: alicloud:ess:ScalingGroup
 *     name: default
 *     properties:
 *       minSize: 1
 *       maxSize: 1
 *       scalingGroupName: ${myName}
 *       defaultCooldown: 20
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 *         - ${default2.id}
 *       removalPolicies:
 *         - OldestInstance
 *         - NewestInstance
 * variables:
 *   myName: ${name}-${defaultInteger.result}
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 2
 *         memorySize: 4
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use to the existing autoscaling module
 * to create a scaling group, configuration and lifecycle hook one-click.
 * ## Import
 * ESS scaling group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/scalingGroup:ScalingGroup example asg-abc123456
 * ```
 */
public class ScalingGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.ess.ScalingGroup,
) : KotlinCustomResource(javaResource, ScalingGroupMapper) {
    /**
     * If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
     */
    public val albServerGroups: Output<List<ScalingGroupAlbServerGroup>>?
        get() = javaResource.albServerGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        scalingGroupAlbServerGroupToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
     */
    public val allocationStrategy: Output<String>
        get() = javaResource.allocationStrategy().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
     */
    public val azBalance: Output<Boolean>?
        get() = javaResource.azBalance().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
     * - The specified RDS instance must be in running status.
     * - The specified RDS instance’s whitelist must have room for more IP addresses.
     */
    public val dbInstanceIds: Output<List<String>>?
        get() = javaResource.dbInstanceIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
     */
    public val defaultCooldown: Output<Int>?
        get() = javaResource.defaultCooldown().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
     */
    public val desiredCapacity: Output<Int>?
        get() = javaResource.desiredCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
     */
    public val groupDeletionProtection: Output<Boolean>?
        get() = javaResource.groupDeletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
     */
    public val groupType: Output<String>
        get() = javaResource.groupType().applyValue({ args0 -> args0 })

    /**
     * Resource type within scaling group. Optional values: ECS, ECI, NONE, LOAD_BALANCER. Default to ECS.
     */
    public val healthCheckType: Output<String>
        get() = javaResource.healthCheckType().applyValue({ args0 -> args0 })

    /**
     * The health check modes of the scaling group. Valid values: ECS, ECI, NONE, LOAD_BALANCER.
     */
    public val healthCheckTypes: Output<List<String>>?
        get() = javaResource.healthCheckTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The ID of the instance from which Auto Scaling obtains the required configuration information and uses the information to automatically create a scaling configuration.
     */
    public val instanceId: Output<String>?
        get() = javaResource.instanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
     */
    public val launchTemplateId: Output<String>?
        get() = javaResource.launchTemplateId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
     */
    public val launchTemplateOverrides: Output<List<ScalingGroupLaunchTemplateOverride>>?
        get() = javaResource.launchTemplateOverrides().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        scalingGroupLaunchTemplateOverrideToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
     */
    public val launchTemplateVersion: Output<String>?
        get() = javaResource.launchTemplateVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
     * - The Server Load Balancer instance must be enabled.
     * - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
     * targeting your `alicloud.slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
     * - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
     * - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
     */
    public val loadbalancerIds: Output<List<String>>?
        get() = javaResource.loadbalancerIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The maximum life span of an instance in the scaling group. Unit: seconds.
     */
    public val maxInstanceLifetime: Output<Int>?
        get() = javaResource.maxInstanceLifetime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
     * **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
     */
    public val maxSize: Output<Int>
        get() = javaResource.maxSize().applyValue({ args0 -> args0 })

    /**
     * Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
     * **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
     */
    public val minSize: Output<Int>
        get() = javaResource.minSize().applyValue({ args0 -> args0 })

    /**
     * Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, COMPOSABLE, BALANCE or COST_OPTIMIZED(Available since v1.54.0).
     */
    public val multiAzPolicy: Output<String>?
        get() = javaResource.multiAzPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
     */
    public val onDemandBaseCapacity: Output<Int>
        get() = javaResource.onDemandBaseCapacity().applyValue({ args0 -> args0 })

    /**
     * Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
     */
    public val onDemandPercentageAboveBaseCapacity: Output<Int>
        get() = javaResource.onDemandPercentageAboveBaseCapacity().applyValue({ args0 -> args0 })

    /**
     * Set or unset instances within group into protected status.
     */
    public val protectedInstances: Output<List<String>>?
        get() = javaResource.protectedInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
     * - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
     * - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
     * - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
     * - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
     */
    public val removalPolicies: Output<List<String>>
        get() = javaResource.removalPolicies().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ID of the resource group to which you want to add the scaling group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
     */
    public val scalingGroupName: Output<String>?
        get() = javaResource.scalingGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The reclaim mode of the scaling group. Optional values: recycle, release, forceRecycle, forceRelease.
     */
    public val scalingPolicy: Output<String>
        get() = javaResource.scalingPolicy().applyValue({ args0 -> args0 })

    /**
     * The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy for preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
     */
    public val spotAllocationStrategy: Output<String>
        get() = javaResource.spotAllocationStrategy().applyValue({ args0 -> args0 })

    /**
     * The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
     */
    public val spotInstancePools: Output<Int>
        get() = javaResource.spotInstancePools().applyValue({ args0 -> args0 })

    /**
     * Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
     */
    public val spotInstanceRemedy: Output<Boolean>
        get() = javaResource.spotInstanceRemedy().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
     */
    @Deprecated(
        message = """
  Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids'
      can replace it.
  """,
    )
    public val vswitchId: Output<String>?
        get() = javaResource.vswitchId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of virtual switch IDs in which the ecs instances to be launched.
     */
    public val vswitchIds: Output<List<String>>?
        get() = javaResource.vswitchIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object ScalingGroupMapper : ResourceMapper<ScalingGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ess.ScalingGroup::class == javaResource::class

    override fun map(javaResource: Resource): ScalingGroup = ScalingGroup(
        javaResource as
            com.pulumi.alicloud.ess.ScalingGroup,
    )
}

/**
 * @see [ScalingGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScalingGroup].
 */
public suspend fun scalingGroup(
    name: String,
    block: suspend ScalingGroupResourceBuilder.() -> Unit,
): ScalingGroup {
    val builder = ScalingGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScalingGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scalingGroup(name: String): ScalingGroup {
    val builder = ScalingGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
