@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.ScalingGroupArgs.builder
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingGroupAlbServerGroupArgs
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingGroupAlbServerGroupArgsBuilder
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingGroupLaunchTemplateOverrideArgs
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingGroupLaunchTemplateOverrideArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a ESS scaling group resource which is a collection of ECS instances with the same application scenarios.
 * It defines the maximum and minimum numbers of ECS instances in the group, and their associated Server Load Balancer instances, RDS instances, and other attributes.
 * > **NOTE:** You can launch an ESS scaling group for a VPC network via specifying parameter `vswitch_ids`.
 * For information about ess scaling rule, see [CreateScalingGroup](https://www.alibabacloud.com/help/en/auto-scaling/latest/createscalinggroup).
 * > **NOTE:** Available since v1.39.0.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const defaultInteger = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const myName = `${name}-${defaultInteger.result}`;
 * const default = alicloud.getZones({
 *     availableDiskCategory: "cloud_efficiency",
 *     availableResourceCreation: "VSwitch",
 * });
 * const defaultGetInstanceTypes = _default.then(_default => alicloud.ecs.getInstanceTypes({
 *     availabilityZone: _default.zones?.[0]?.id,
 *     cpuCoreCount: 2,
 *     memorySize: 4,
 * }));
 * const defaultGetImages = alicloud.ecs.getImages({
 *     nameRegex: "^ubuntu_18.*64",
 *     mostRecent: true,
 *     owners: "system",
 * });
 * const defaultNetwork = new alicloud.vpc.Network("default", {
 *     vpcName: myName,
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultSwitch = new alicloud.vpc.Switch("default", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.0.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: myName,
 * });
 * const defaultSecurityGroup = new alicloud.ecs.SecurityGroup("default", {
 *     name: myName,
 *     vpcId: defaultNetwork.id,
 * });
 * const defaultSecurityGroupRule = new alicloud.ecs.SecurityGroupRule("default", {
 *     type: "ingress",
 *     ipProtocol: "tcp",
 *     nicType: "intranet",
 *     policy: "accept",
 *     portRange: "22/22",
 *     priority: 1,
 *     securityGroupId: defaultSecurityGroup.id,
 *     cidrIp: "172.16.0.0/24",
 * });
 * const default2 = new alicloud.vpc.Switch("default2", {
 *     vpcId: defaultNetwork.id,
 *     cidrBlock: "172.16.1.0/24",
 *     zoneId: _default.then(_default => _default.zones?.[0]?.id),
 *     vswitchName: `${name}-bar`,
 * });
 * const defaultScalingGroup = new alicloud.ess.ScalingGroup("default", {
 *     minSize: 1,
 *     maxSize: 1,
 *     scalingGroupName: myName,
 *     defaultCooldown: 20,
 *     vswitchIds: [
 *         defaultSwitch.id,
 *         default2.id,
 *     ],
 *     removalPolicies: [
 *         "OldestInstance",
 *         "NewestInstance",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default_integer = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * my_name = f"{name}-{default_integer['result']}"
 * default = alicloud.get_zones(available_disk_category="cloud_efficiency",
 *     available_resource_creation="VSwitch")
 * default_get_instance_types = alicloud.ecs.get_instance_types(availability_zone=default.zones[0].id,
 *     cpu_core_count=2,
 *     memory_size=4)
 * default_get_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
 *     most_recent=True,
 *     owners="system")
 * default_network = alicloud.vpc.Network("default",
 *     vpc_name=my_name,
 *     cidr_block="172.16.0.0/16")
 * default_switch = alicloud.vpc.Switch("default",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.0.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=my_name)
 * default_security_group = alicloud.ecs.SecurityGroup("default",
 *     name=my_name,
 *     vpc_id=default_network.id)
 * default_security_group_rule = alicloud.ecs.SecurityGroupRule("default",
 *     type="ingress",
 *     ip_protocol="tcp",
 *     nic_type="intranet",
 *     policy="accept",
 *     port_range="22/22",
 *     priority=1,
 *     security_group_id=default_security_group.id,
 *     cidr_ip="172.16.0.0/24")
 * default2 = alicloud.vpc.Switch("default2",
 *     vpc_id=default_network.id,
 *     cidr_block="172.16.1.0/24",
 *     zone_id=default.zones[0].id,
 *     vswitch_name=f"{name}-bar")
 * default_scaling_group = alicloud.ess.ScalingGroup("default",
 *     min_size=1,
 *     max_size=1,
 *     scaling_group_name=my_name,
 *     default_cooldown=20,
 *     vswitch_ids=[
 *         default_switch.id,
 *         default2.id,
 *     ],
 *     removal_policies=[
 *         "OldestInstance",
 *         "NewestInstance",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var myName = $"{name}-{defaultInteger.Result}";
 *     var @default = AliCloud.GetZones.Invoke(new()
 *     {
 *         AvailableDiskCategory = "cloud_efficiency",
 *         AvailableResourceCreation = "VSwitch",
 *     });
 *     var defaultGetInstanceTypes = AliCloud.Ecs.GetInstanceTypes.Invoke(new()
 *     {
 *         AvailabilityZone = @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
 *         CpuCoreCount = 2,
 *         MemorySize = 4,
 *     });
 *     var defaultGetImages = AliCloud.Ecs.GetImages.Invoke(new()
 *     {
 *         NameRegex = "^ubuntu_18.*64",
 *         MostRecent = true,
 *         Owners = "system",
 *     });
 *     var defaultNetwork = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = myName,
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultSwitch = new AliCloud.Vpc.Switch("default", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.0.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = myName,
 *     });
 *     var defaultSecurityGroup = new AliCloud.Ecs.SecurityGroup("default", new()
 *     {
 *         Name = myName,
 *         VpcId = defaultNetwork.Id,
 *     });
 *     var defaultSecurityGroupRule = new AliCloud.Ecs.SecurityGroupRule("default", new()
 *     {
 *         Type = "ingress",
 *         IpProtocol = "tcp",
 *         NicType = "intranet",
 *         Policy = "accept",
 *         PortRange = "22/22",
 *         Priority = 1,
 *         SecurityGroupId = defaultSecurityGroup.Id,
 *         CidrIp = "172.16.0.0/24",
 *     });
 *     var default2 = new AliCloud.Vpc.Switch("default2", new()
 *     {
 *         VpcId = defaultNetwork.Id,
 *         CidrBlock = "172.16.1.0/24",
 *         ZoneId = @default.Apply(@default => @default.Apply(getZonesResult => getZonesResult.Zones[0]?.Id)),
 *         VswitchName = $"{name}-bar",
 *     });
 *     var defaultScalingGroup = new AliCloud.Ess.ScalingGroup("default", new()
 *     {
 *         MinSize = 1,
 *         MaxSize = 1,
 *         ScalingGroupName = myName,
 *         DefaultCooldown = 20,
 *         VswitchIds = new[]
 *         {
 *             defaultSwitch.Id,
 *             default2.Id,
 *         },
 *         RemovalPolicies = new[]
 *         {
 *             "OldestInstance",
 *             "NewestInstance",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ecs"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ess"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		myName := fmt.Sprintf("%v-%v", name, defaultInteger.Result)
 * 		_default, err := alicloud.GetZones(ctx, &alicloud.GetZonesArgs{
 * 			AvailableDiskCategory:     pulumi.StringRef("cloud_efficiency"),
 * 			AvailableResourceCreation: pulumi.StringRef("VSwitch"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.GetInstanceTypes(ctx, &ecs.GetInstanceTypesArgs{
 * 			AvailabilityZone: pulumi.StringRef(_default.Zones[0].Id),
 * 			CpuCoreCount:     pulumi.IntRef(2),
 * 			MemorySize:       pulumi.Float64Ref(4),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.GetImages(ctx, &ecs.GetImagesArgs{
 * 			NameRegex:  pulumi.StringRef("^ubuntu_18.*64"),
 * 			MostRecent: pulumi.BoolRef(true),
 * 			Owners:     pulumi.StringRef("system"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultNetwork, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(myName),
 * 			CidrBlock: pulumi.String("172.16.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSwitch, err := vpc.NewSwitch(ctx, "default", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.0.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.String(myName),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultSecurityGroup, err := ecs.NewSecurityGroup(ctx, "default", &ecs.SecurityGroupArgs{
 * 			Name:  pulumi.String(myName),
 * 			VpcId: defaultNetwork.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ecs.NewSecurityGroupRule(ctx, "default", &ecs.SecurityGroupRuleArgs{
 * 			Type:            pulumi.String("ingress"),
 * 			IpProtocol:      pulumi.String("tcp"),
 * 			NicType:         pulumi.String("intranet"),
 * 			Policy:          pulumi.String("accept"),
 * 			PortRange:       pulumi.String("22/22"),
 * 			Priority:        pulumi.Int(1),
 * 			SecurityGroupId: defaultSecurityGroup.ID(),
 * 			CidrIp:          pulumi.String("172.16.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		default2, err := vpc.NewSwitch(ctx, "default2", &vpc.SwitchArgs{
 * 			VpcId:       defaultNetwork.ID(),
 * 			CidrBlock:   pulumi.String("172.16.1.0/24"),
 * 			ZoneId:      pulumi.String(_default.Zones[0].Id),
 * 			VswitchName: pulumi.Sprintf("%v-bar", name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ess.NewScalingGroup(ctx, "default", &ess.ScalingGroupArgs{
 * 			MinSize:          pulumi.Int(1),
 * 			MaxSize:          pulumi.Int(1),
 * 			ScalingGroupName: pulumi.String(myName),
 * 			DefaultCooldown:  pulumi.Int(20),
 * 			VswitchIds: pulumi.StringArray{
 * 				defaultSwitch.ID(),
 * 				default2.ID(),
 * 			},
 * 			RemovalPolicies: pulumi.StringArray{
 * 				pulumi.String("OldestInstance"),
 * 				pulumi.String("NewestInstance"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetZonesArgs;
 * import com.pulumi.alicloud.ecs.EcsFunctions;
 * import com.pulumi.alicloud.ecs.inputs.GetInstanceTypesArgs;
 * import com.pulumi.alicloud.ecs.inputs.GetImagesArgs;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.vpc.Switch;
 * import com.pulumi.alicloud.vpc.SwitchArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroup;
 * import com.pulumi.alicloud.ecs.SecurityGroupArgs;
 * import com.pulumi.alicloud.ecs.SecurityGroupRule;
 * import com.pulumi.alicloud.ecs.SecurityGroupRuleArgs;
 * import com.pulumi.alicloud.ess.ScalingGroup;
 * import com.pulumi.alicloud.ess.ScalingGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         final var myName = String.format("%s-%s", name,defaultInteger.result());
 *         final var default = AlicloudFunctions.getZones(GetZonesArgs.builder()
 *             .availableDiskCategory("cloud_efficiency")
 *             .availableResourceCreation("VSwitch")
 *             .build());
 *         final var defaultGetInstanceTypes = EcsFunctions.getInstanceTypes(GetInstanceTypesArgs.builder()
 *             .availabilityZone(default_.zones()[0].id())
 *             .cpuCoreCount(2)
 *             .memorySize(4)
 *             .build());
 *         final var defaultGetImages = EcsFunctions.getImages(GetImagesArgs.builder()
 *             .nameRegex("^ubuntu_18.*64")
 *             .mostRecent(true)
 *             .owners("system")
 *             .build());
 *         var defaultNetwork = new Network("defaultNetwork", NetworkArgs.builder()
 *             .vpcName(myName)
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         var defaultSwitch = new Switch("defaultSwitch", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.0.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(myName)
 *             .build());
 *         var defaultSecurityGroup = new SecurityGroup("defaultSecurityGroup", SecurityGroupArgs.builder()
 *             .name(myName)
 *             .vpcId(defaultNetwork.id())
 *             .build());
 *         var defaultSecurityGroupRule = new SecurityGroupRule("defaultSecurityGroupRule", SecurityGroupRuleArgs.builder()
 *             .type("ingress")
 *             .ipProtocol("tcp")
 *             .nicType("intranet")
 *             .policy("accept")
 *             .portRange("22/22")
 *             .priority(1)
 *             .securityGroupId(defaultSecurityGroup.id())
 *             .cidrIp("172.16.0.0/24")
 *             .build());
 *         var default2 = new Switch("default2", SwitchArgs.builder()
 *             .vpcId(defaultNetwork.id())
 *             .cidrBlock("172.16.1.0/24")
 *             .zoneId(default_.zones()[0].id())
 *             .vswitchName(String.format("%s-bar", name))
 *             .build());
 *         var defaultScalingGroup = new ScalingGroup("defaultScalingGroup", ScalingGroupArgs.builder()
 *             .minSize(1)
 *             .maxSize(1)
 *             .scalingGroupName(myName)
 *             .defaultCooldown(20)
 *             .vswitchIds(
 *                 defaultSwitch.id(),
 *                 default2.id())
 *             .removalPolicies(
 *                 "OldestInstance",
 *                 "NewestInstance")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultNetwork:
 *     type: alicloud:vpc:Network
 *     name: default
 *     properties:
 *       vpcName: ${myName}
 *       cidrBlock: 172.16.0.0/16
 *   defaultSwitch:
 *     type: alicloud:vpc:Switch
 *     name: default
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.0.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${myName}
 *   defaultSecurityGroup:
 *     type: alicloud:ecs:SecurityGroup
 *     name: default
 *     properties:
 *       name: ${myName}
 *       vpcId: ${defaultNetwork.id}
 *   defaultSecurityGroupRule:
 *     type: alicloud:ecs:SecurityGroupRule
 *     name: default
 *     properties:
 *       type: ingress
 *       ipProtocol: tcp
 *       nicType: intranet
 *       policy: accept
 *       portRange: 22/22
 *       priority: 1
 *       securityGroupId: ${defaultSecurityGroup.id}
 *       cidrIp: 172.16.0.0/24
 *   default2:
 *     type: alicloud:vpc:Switch
 *     properties:
 *       vpcId: ${defaultNetwork.id}
 *       cidrBlock: 172.16.1.0/24
 *       zoneId: ${default.zones[0].id}
 *       vswitchName: ${name}-bar
 *   defaultScalingGroup:
 *     type: alicloud:ess:ScalingGroup
 *     name: default
 *     properties:
 *       minSize: 1
 *       maxSize: 1
 *       scalingGroupName: ${myName}
 *       defaultCooldown: 20
 *       vswitchIds:
 *         - ${defaultSwitch.id}
 *         - ${default2.id}
 *       removalPolicies:
 *         - OldestInstance
 *         - NewestInstance
 * variables:
 *   myName: ${name}-${defaultInteger.result}
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getZones
 *       Arguments:
 *         availableDiskCategory: cloud_efficiency
 *         availableResourceCreation: VSwitch
 *   defaultGetInstanceTypes:
 *     fn::invoke:
 *       Function: alicloud:ecs:getInstanceTypes
 *       Arguments:
 *         availabilityZone: ${default.zones[0].id}
 *         cpuCoreCount: 2
 *         memorySize: 4
 *   defaultGetImages:
 *     fn::invoke:
 *       Function: alicloud:ecs:getImages
 *       Arguments:
 *         nameRegex: ^ubuntu_18.*64
 *         mostRecent: true
 *         owners: system
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Module Support
 * You can use to the existing autoscaling module
 * to create a scaling group, configuration and lifecycle hook one-click.
 * ## Import
 * ESS scaling group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/scalingGroup:ScalingGroup example asg-abc123456
 * ```
 * @property albServerGroups If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
 * @property allocationStrategy The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
 * @property azBalance Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
 * @property dbInstanceIds If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
 * - The specified RDS instance must be in running status.
 * - The specified RDS instance’s whitelist must have room for more IP addresses.
 * @property defaultCooldown Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
 * @property desiredCapacity Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
 * @property groupDeletionProtection Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
 * @property groupType Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
 * @property healthCheckType Resource type within scaling group. Optional values: ECS, ECI, NONE, LOAD_BALANCER. Default to ECS.
 * @property healthCheckTypes The health check modes of the scaling group. Valid values: ECS, ECI, NONE, LOAD_BALANCER.
 * @property instanceId The ID of the instance from which Auto Scaling obtains the required configuration information and uses the information to automatically create a scaling configuration.
 * @property launchTemplateId Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
 * @property launchTemplateOverrides The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
 * @property launchTemplateVersion The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
 * @property loadbalancerIds If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
 * - The Server Load Balancer instance must be enabled.
 * - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
 * targeting your `alicloud.slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
 * - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
 * - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
 * @property maxInstanceLifetime The maximum life span of an instance in the scaling group. Unit: seconds.
 * @property maxSize Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
 * **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
 * @property minSize Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
 * **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
 * @property multiAzPolicy Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, COMPOSABLE, BALANCE or COST_OPTIMIZED(Available since v1.54.0).
 * @property onDemandBaseCapacity The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
 * @property onDemandPercentageAboveBaseCapacity Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
 * @property protectedInstances Set or unset instances within group into protected status.
 * @property removalPolicies RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
 * - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
 * - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
 * - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
 * - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
 * @property resourceGroupId The ID of the resource group to which you want to add the scaling group.
 * @property scalingGroupName Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
 * @property scalingPolicy The reclaim mode of the scaling group. Optional values: recycle, release, forceRecycle, forceRelease.
 * @property spotAllocationStrategy The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy for preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
 * @property spotInstancePools The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
 * @property spotInstanceRemedy Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
 * @property tags A mapping of tags to assign to the resource.
 * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
 * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
 * @property vswitchId It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
 * @property vswitchIds List of virtual switch IDs in which the ecs instances to be launched.
 */
public data class ScalingGroupArgs(
    public val albServerGroups: Output<List<ScalingGroupAlbServerGroupArgs>>? = null,
    public val allocationStrategy: Output<String>? = null,
    public val azBalance: Output<Boolean>? = null,
    public val dbInstanceIds: Output<List<String>>? = null,
    public val defaultCooldown: Output<Int>? = null,
    public val desiredCapacity: Output<Int>? = null,
    public val groupDeletionProtection: Output<Boolean>? = null,
    public val groupType: Output<String>? = null,
    public val healthCheckType: Output<String>? = null,
    public val healthCheckTypes: Output<List<String>>? = null,
    public val instanceId: Output<String>? = null,
    public val launchTemplateId: Output<String>? = null,
    public val launchTemplateOverrides: Output<List<ScalingGroupLaunchTemplateOverrideArgs>>? = null,
    public val launchTemplateVersion: Output<String>? = null,
    public val loadbalancerIds: Output<List<String>>? = null,
    public val maxInstanceLifetime: Output<Int>? = null,
    public val maxSize: Output<Int>? = null,
    public val minSize: Output<Int>? = null,
    public val multiAzPolicy: Output<String>? = null,
    public val onDemandBaseCapacity: Output<Int>? = null,
    public val onDemandPercentageAboveBaseCapacity: Output<Int>? = null,
    public val protectedInstances: Output<List<String>>? = null,
    public val removalPolicies: Output<List<String>>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val scalingGroupName: Output<String>? = null,
    public val scalingPolicy: Output<String>? = null,
    public val spotAllocationStrategy: Output<String>? = null,
    public val spotInstancePools: Output<Int>? = null,
    public val spotInstanceRemedy: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    @Deprecated(
        message = """
  Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids'
      can replace it.
  """,
    )
    public val vswitchId: Output<String>? = null,
    public val vswitchIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.ScalingGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.ScalingGroupArgs =
        com.pulumi.alicloud.ess.ScalingGroupArgs.builder()
            .albServerGroups(
                albServerGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .allocationStrategy(allocationStrategy?.applyValue({ args0 -> args0 }))
            .azBalance(azBalance?.applyValue({ args0 -> args0 }))
            .dbInstanceIds(dbInstanceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .defaultCooldown(defaultCooldown?.applyValue({ args0 -> args0 }))
            .desiredCapacity(desiredCapacity?.applyValue({ args0 -> args0 }))
            .groupDeletionProtection(groupDeletionProtection?.applyValue({ args0 -> args0 }))
            .groupType(groupType?.applyValue({ args0 -> args0 }))
            .healthCheckType(healthCheckType?.applyValue({ args0 -> args0 }))
            .healthCheckTypes(healthCheckTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .launchTemplateId(launchTemplateId?.applyValue({ args0 -> args0 }))
            .launchTemplateOverrides(
                launchTemplateOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .launchTemplateVersion(launchTemplateVersion?.applyValue({ args0 -> args0 }))
            .loadbalancerIds(loadbalancerIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxInstanceLifetime(maxInstanceLifetime?.applyValue({ args0 -> args0 }))
            .maxSize(maxSize?.applyValue({ args0 -> args0 }))
            .minSize(minSize?.applyValue({ args0 -> args0 }))
            .multiAzPolicy(multiAzPolicy?.applyValue({ args0 -> args0 }))
            .onDemandBaseCapacity(onDemandBaseCapacity?.applyValue({ args0 -> args0 }))
            .onDemandPercentageAboveBaseCapacity(
                onDemandPercentageAboveBaseCapacity?.applyValue({ args0 ->
                    args0
                }),
            )
            .protectedInstances(protectedInstances?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .removalPolicies(removalPolicies?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .scalingGroupName(scalingGroupName?.applyValue({ args0 -> args0 }))
            .scalingPolicy(scalingPolicy?.applyValue({ args0 -> args0 }))
            .spotAllocationStrategy(spotAllocationStrategy?.applyValue({ args0 -> args0 }))
            .spotInstancePools(spotInstancePools?.applyValue({ args0 -> args0 }))
            .spotInstanceRemedy(spotInstanceRemedy?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .vswitchIds(vswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ScalingGroupArgs].
 */
@PulumiTagMarker
public class ScalingGroupArgsBuilder internal constructor() {
    private var albServerGroups: Output<List<ScalingGroupAlbServerGroupArgs>>? = null

    private var allocationStrategy: Output<String>? = null

    private var azBalance: Output<Boolean>? = null

    private var dbInstanceIds: Output<List<String>>? = null

    private var defaultCooldown: Output<Int>? = null

    private var desiredCapacity: Output<Int>? = null

    private var groupDeletionProtection: Output<Boolean>? = null

    private var groupType: Output<String>? = null

    private var healthCheckType: Output<String>? = null

    private var healthCheckTypes: Output<List<String>>? = null

    private var instanceId: Output<String>? = null

    private var launchTemplateId: Output<String>? = null

    private var launchTemplateOverrides: Output<List<ScalingGroupLaunchTemplateOverrideArgs>>? = null

    private var launchTemplateVersion: Output<String>? = null

    private var loadbalancerIds: Output<List<String>>? = null

    private var maxInstanceLifetime: Output<Int>? = null

    private var maxSize: Output<Int>? = null

    private var minSize: Output<Int>? = null

    private var multiAzPolicy: Output<String>? = null

    private var onDemandBaseCapacity: Output<Int>? = null

    private var onDemandPercentageAboveBaseCapacity: Output<Int>? = null

    private var protectedInstances: Output<List<String>>? = null

    private var removalPolicies: Output<List<String>>? = null

    private var resourceGroupId: Output<String>? = null

    private var scalingGroupName: Output<String>? = null

    private var scalingPolicy: Output<String>? = null

    private var spotAllocationStrategy: Output<String>? = null

    private var spotInstancePools: Output<Int>? = null

    private var spotInstanceRemedy: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    private var vswitchIds: Output<List<String>>? = null

    /**
     * @param value If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
     */
    @JvmName("bbnhicpbabbpxmnq")
    public suspend fun albServerGroups(`value`: Output<List<ScalingGroupAlbServerGroupArgs>>) {
        this.albServerGroups = value
    }

    @JvmName("wkggpevfrcrhceii")
    public suspend fun albServerGroups(vararg values: Output<ScalingGroupAlbServerGroupArgs>) {
        this.albServerGroups = Output.all(values.asList())
    }

    /**
     * @param values If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
     */
    @JvmName("eadqqecjwcvalkwg")
    public suspend fun albServerGroups(values: List<Output<ScalingGroupAlbServerGroupArgs>>) {
        this.albServerGroups = Output.all(values)
    }

    /**
     * @param value The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
     */
    @JvmName("wplradydowtldiub")
    public suspend fun allocationStrategy(`value`: Output<String>) {
        this.allocationStrategy = value
    }

    /**
     * @param value Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
     */
    @JvmName("rfrgriwmgygtxnwb")
    public suspend fun azBalance(`value`: Output<Boolean>) {
        this.azBalance = value
    }

    /**
     * @param value If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
     * - The specified RDS instance must be in running status.
     * - The specified RDS instance’s whitelist must have room for more IP addresses.
     */
    @JvmName("hlvscvwyxsjnkjuh")
    public suspend fun dbInstanceIds(`value`: Output<List<String>>) {
        this.dbInstanceIds = value
    }

    @JvmName("dgeksycqocawxqwe")
    public suspend fun dbInstanceIds(vararg values: Output<String>) {
        this.dbInstanceIds = Output.all(values.asList())
    }

    /**
     * @param values If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
     * - The specified RDS instance must be in running status.
     * - The specified RDS instance’s whitelist must have room for more IP addresses.
     */
    @JvmName("wawopsgwncicmxnb")
    public suspend fun dbInstanceIds(values: List<Output<String>>) {
        this.dbInstanceIds = Output.all(values)
    }

    /**
     * @param value Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
     */
    @JvmName("unoxlymbdcttkmbc")
    public suspend fun defaultCooldown(`value`: Output<Int>) {
        this.defaultCooldown = value
    }

    /**
     * @param value Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
     */
    @JvmName("mfcdfmxwgcwecftn")
    public suspend fun desiredCapacity(`value`: Output<Int>) {
        this.desiredCapacity = value
    }

    /**
     * @param value Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
     */
    @JvmName("rbgbltagecqlhapl")
    public suspend fun groupDeletionProtection(`value`: Output<Boolean>) {
        this.groupDeletionProtection = value
    }

    /**
     * @param value Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
     */
    @JvmName("txdactehvtrravwl")
    public suspend fun groupType(`value`: Output<String>) {
        this.groupType = value
    }

    /**
     * @param value Resource type within scaling group. Optional values: ECS, ECI, NONE, LOAD_BALANCER. Default to ECS.
     */
    @JvmName("hbwuhkhumahjfpte")
    public suspend fun healthCheckType(`value`: Output<String>) {
        this.healthCheckType = value
    }

    /**
     * @param value The health check modes of the scaling group. Valid values: ECS, ECI, NONE, LOAD_BALANCER.
     */
    @JvmName("tuvwnglptujeguis")
    public suspend fun healthCheckTypes(`value`: Output<List<String>>) {
        this.healthCheckTypes = value
    }

    @JvmName("jrgmmeqfxcbhwpph")
    public suspend fun healthCheckTypes(vararg values: Output<String>) {
        this.healthCheckTypes = Output.all(values.asList())
    }

    /**
     * @param values The health check modes of the scaling group. Valid values: ECS, ECI, NONE, LOAD_BALANCER.
     */
    @JvmName("oegtgigmuvgxvqwy")
    public suspend fun healthCheckTypes(values: List<Output<String>>) {
        this.healthCheckTypes = Output.all(values)
    }

    /**
     * @param value The ID of the instance from which Auto Scaling obtains the required configuration information and uses the information to automatically create a scaling configuration.
     */
    @JvmName("wtnwfsrxcqtobujc")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
     */
    @JvmName("rxmgarvdbgtfvyhf")
    public suspend fun launchTemplateId(`value`: Output<String>) {
        this.launchTemplateId = value
    }

    /**
     * @param value The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
     */
    @JvmName("lncvfpofmhairrtr")
    public suspend fun launchTemplateOverrides(`value`: Output<List<ScalingGroupLaunchTemplateOverrideArgs>>) {
        this.launchTemplateOverrides = value
    }

    @JvmName("wakkanpabsnprlyh")
    public suspend fun launchTemplateOverrides(vararg values: Output<ScalingGroupLaunchTemplateOverrideArgs>) {
        this.launchTemplateOverrides = Output.all(values.asList())
    }

    /**
     * @param values The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
     */
    @JvmName("yflrbseylalvjisw")
    public suspend fun launchTemplateOverrides(values: List<Output<ScalingGroupLaunchTemplateOverrideArgs>>) {
        this.launchTemplateOverrides = Output.all(values)
    }

    /**
     * @param value The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
     */
    @JvmName("qiyxjqggaqjvwelc")
    public suspend fun launchTemplateVersion(`value`: Output<String>) {
        this.launchTemplateVersion = value
    }

    /**
     * @param value If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
     * - The Server Load Balancer instance must be enabled.
     * - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
     * targeting your `alicloud.slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
     * - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
     * - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
     */
    @JvmName("cvbavxpogufbtunr")
    public suspend fun loadbalancerIds(`value`: Output<List<String>>) {
        this.loadbalancerIds = value
    }

    @JvmName("ysnkqwowqliucuxq")
    public suspend fun loadbalancerIds(vararg values: Output<String>) {
        this.loadbalancerIds = Output.all(values.asList())
    }

    /**
     * @param values If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
     * - The Server Load Balancer instance must be enabled.
     * - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
     * targeting your `alicloud.slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
     * - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
     * - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
     */
    @JvmName("nkqdertgonbhmjun")
    public suspend fun loadbalancerIds(values: List<Output<String>>) {
        this.loadbalancerIds = Output.all(values)
    }

    /**
     * @param value The maximum life span of an instance in the scaling group. Unit: seconds.
     */
    @JvmName("slrpewiakmqlfjgf")
    public suspend fun maxInstanceLifetime(`value`: Output<Int>) {
        this.maxInstanceLifetime = value
    }

    /**
     * @param value Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
     * **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
     */
    @JvmName("qjbqtpwwcngapcst")
    public suspend fun maxSize(`value`: Output<Int>) {
        this.maxSize = value
    }

    /**
     * @param value Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
     * **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
     */
    @JvmName("chbnsghqidhnsnxw")
    public suspend fun minSize(`value`: Output<Int>) {
        this.minSize = value
    }

    /**
     * @param value Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, COMPOSABLE, BALANCE or COST_OPTIMIZED(Available since v1.54.0).
     */
    @JvmName("jirfhrlxpuflqgib")
    public suspend fun multiAzPolicy(`value`: Output<String>) {
        this.multiAzPolicy = value
    }

    /**
     * @param value The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
     */
    @JvmName("dnketollolkaytat")
    public suspend fun onDemandBaseCapacity(`value`: Output<Int>) {
        this.onDemandBaseCapacity = value
    }

    /**
     * @param value Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
     */
    @JvmName("unslkncaycjkwrup")
    public suspend fun onDemandPercentageAboveBaseCapacity(`value`: Output<Int>) {
        this.onDemandPercentageAboveBaseCapacity = value
    }

    /**
     * @param value Set or unset instances within group into protected status.
     */
    @JvmName("ykaaeyvwwggpkjrt")
    public suspend fun protectedInstances(`value`: Output<List<String>>) {
        this.protectedInstances = value
    }

    @JvmName("qdbtuqfiybmjbybc")
    public suspend fun protectedInstances(vararg values: Output<String>) {
        this.protectedInstances = Output.all(values.asList())
    }

    /**
     * @param values Set or unset instances within group into protected status.
     */
    @JvmName("stfanplxrhvtfgon")
    public suspend fun protectedInstances(values: List<Output<String>>) {
        this.protectedInstances = Output.all(values)
    }

    /**
     * @param value RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
     * - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
     * - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
     * - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
     * - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
     */
    @JvmName("bkkcdtqxhtnymmae")
    public suspend fun removalPolicies(`value`: Output<List<String>>) {
        this.removalPolicies = value
    }

    @JvmName("alcdqhlmqkbtvpgr")
    public suspend fun removalPolicies(vararg values: Output<String>) {
        this.removalPolicies = Output.all(values.asList())
    }

    /**
     * @param values RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
     * - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
     * - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
     * - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
     * - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
     */
    @JvmName("ylnogitbnchgclyt")
    public suspend fun removalPolicies(values: List<Output<String>>) {
        this.removalPolicies = Output.all(values)
    }

    /**
     * @param value The ID of the resource group to which you want to add the scaling group.
     */
    @JvmName("yvdqvykgcypyynxc")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
     */
    @JvmName("rocwbhxgotwujfyb")
    public suspend fun scalingGroupName(`value`: Output<String>) {
        this.scalingGroupName = value
    }

    /**
     * @param value The reclaim mode of the scaling group. Optional values: recycle, release, forceRecycle, forceRelease.
     */
    @JvmName("xvpeuvhxvyoawtbp")
    public suspend fun scalingPolicy(`value`: Output<String>) {
        this.scalingPolicy = value
    }

    /**
     * @param value The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy for preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
     */
    @JvmName("uakfuggjvvrxadcj")
    public suspend fun spotAllocationStrategy(`value`: Output<String>) {
        this.spotAllocationStrategy = value
    }

    /**
     * @param value The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
     */
    @JvmName("udbpwgnsppshkuib")
    public suspend fun spotInstancePools(`value`: Output<Int>) {
        this.spotInstancePools = value
    }

    /**
     * @param value Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
     */
    @JvmName("svfdphyxeouwigkd")
    public suspend fun spotInstanceRemedy(`value`: Output<Boolean>) {
        this.spotInstanceRemedy = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("gqxagffrmlcvaufh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
     */
    @Deprecated(
        message = """
  Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids'
      can replace it.
  """,
    )
    @JvmName("vstlkqtgxjwvhbmo")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value List of virtual switch IDs in which the ecs instances to be launched.
     */
    @JvmName("abitaordadkmwsqy")
    public suspend fun vswitchIds(`value`: Output<List<String>>) {
        this.vswitchIds = value
    }

    @JvmName("ppjqcgplsqqroxbg")
    public suspend fun vswitchIds(vararg values: Output<String>) {
        this.vswitchIds = Output.all(values.asList())
    }

    /**
     * @param values List of virtual switch IDs in which the ecs instances to be launched.
     */
    @JvmName("lwwiukuwkbplwcvf")
    public suspend fun vswitchIds(values: List<Output<String>>) {
        this.vswitchIds = Output.all(values)
    }

    /**
     * @param value If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
     */
    @JvmName("htoucxcurbfujicp")
    public suspend fun albServerGroups(`value`: List<ScalingGroupAlbServerGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.albServerGroups = mapped
    }

    /**
     * @param argument If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
     */
    @JvmName("danqkwofmtxpcvjp")
    public suspend fun albServerGroups(argument: List<suspend ScalingGroupAlbServerGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingGroupAlbServerGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.albServerGroups = mapped
    }

    /**
     * @param argument If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
     */
    @JvmName("xhvbemptxiynswox")
    public suspend fun albServerGroups(vararg argument: suspend ScalingGroupAlbServerGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingGroupAlbServerGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.albServerGroups = mapped
    }

    /**
     * @param argument If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
     */
    @JvmName("bgkpefdoqghkbhos")
    public suspend fun albServerGroups(argument: suspend ScalingGroupAlbServerGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScalingGroupAlbServerGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.albServerGroups = mapped
    }

    /**
     * @param values If a Serve ALB instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server ALB instance.  See `alb_server_group` below for details.
     */
    @JvmName("tmwaamvbblttqadq")
    public suspend fun albServerGroups(vararg values: ScalingGroupAlbServerGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.albServerGroups = mapped
    }

    /**
     * @param value The allocation policy of instances. Auto Scaling selects instance types based on the allocation policy to create instances. The policy can be applied to pay-as-you-go instances and preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
     */
    @JvmName("rnpvubikjeukeqps")
    public suspend fun allocationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    /**
     * @param value Specifies whether to evenly distribute instances in the scaling group across multiple zones. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
     */
    @JvmName("dqdrijcyaoqskdrt")
    public suspend fun azBalance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azBalance = mapped
    }

    /**
     * @param value If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
     * - The specified RDS instance must be in running status.
     * - The specified RDS instance’s whitelist must have room for more IP addresses.
     */
    @JvmName("pjjkvpaxwksxwqee")
    public suspend fun dbInstanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIds = mapped
    }

    /**
     * @param values If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
     * - The specified RDS instance must be in running status.
     * - The specified RDS instance’s whitelist must have room for more IP addresses.
     */
    @JvmName("akgmnydyjboaswsq")
    public suspend fun dbInstanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dbInstanceIds = mapped
    }

    /**
     * @param value Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
     */
    @JvmName("foudumqyrvjiysja")
    public suspend fun defaultCooldown(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultCooldown = mapped
    }

    /**
     * @param value Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
     */
    @JvmName("cnxfjjnumdewdfat")
    public suspend fun desiredCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredCapacity = mapped
    }

    /**
     * @param value Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
     */
    @JvmName("mgnnlqwfsfgemfxs")
    public suspend fun groupDeletionProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupDeletionProtection = mapped
    }

    /**
     * @param value Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
     */
    @JvmName("wvnjkrvbxtakjfsy")
    public suspend fun groupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    /**
     * @param value Resource type within scaling group. Optional values: ECS, ECI, NONE, LOAD_BALANCER. Default to ECS.
     */
    @JvmName("kucxwpdraxaxtkkt")
    public suspend fun healthCheckType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckType = mapped
    }

    /**
     * @param value The health check modes of the scaling group. Valid values: ECS, ECI, NONE, LOAD_BALANCER.
     */
    @JvmName("yygxwiowncqirtew")
    public suspend fun healthCheckTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckTypes = mapped
    }

    /**
     * @param values The health check modes of the scaling group. Valid values: ECS, ECI, NONE, LOAD_BALANCER.
     */
    @JvmName("sbunrswbgmhbmssy")
    public suspend fun healthCheckTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthCheckTypes = mapped
    }

    /**
     * @param value The ID of the instance from which Auto Scaling obtains the required configuration information and uses the information to automatically create a scaling configuration.
     */
    @JvmName("pnkwdwdlcedmdyqw")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
     */
    @JvmName("tvcqwiegrdpbbcwt")
    public suspend fun launchTemplateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateId = mapped
    }

    /**
     * @param value The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
     */
    @JvmName("qcbcqgetmnyekfqh")
    public suspend fun launchTemplateOverrides(`value`: List<ScalingGroupLaunchTemplateOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateOverrides = mapped
    }

    /**
     * @param argument The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
     */
    @JvmName("uyfgxrqfhxktkedn")
    public suspend fun launchTemplateOverrides(argument: List<suspend ScalingGroupLaunchTemplateOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingGroupLaunchTemplateOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateOverrides = mapped
    }

    /**
     * @param argument The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
     */
    @JvmName("cjrcffduyohfagte")
    public suspend fun launchTemplateOverrides(vararg argument: suspend ScalingGroupLaunchTemplateOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingGroupLaunchTemplateOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateOverrides = mapped
    }

    /**
     * @param argument The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
     */
    @JvmName("aceldkptbaldhfgj")
    public suspend fun launchTemplateOverrides(argument: suspend ScalingGroupLaunchTemplateOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScalingGroupLaunchTemplateOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.launchTemplateOverrides = mapped
    }

    /**
     * @param values The details of the instance types that are specified by using the Extend Instance Type of Launch Template feature.  See `launch_template_override` below for details.
     */
    @JvmName("svrxcfgumaumuatw")
    public suspend fun launchTemplateOverrides(vararg values: ScalingGroupLaunchTemplateOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchTemplateOverrides = mapped
    }

    /**
     * @param value The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
     */
    @JvmName("dhxjajlfpfiijfha")
    public suspend fun launchTemplateVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateVersion = mapped
    }

    /**
     * @param value If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
     * - The Server Load Balancer instance must be enabled.
     * - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
     * targeting your `alicloud.slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
     * - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
     * - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
     */
    @JvmName("pckuugyfmpnkjnsh")
    public suspend fun loadbalancerIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadbalancerIds = mapped
    }

    /**
     * @param values If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
     * - The Server Load Balancer instance must be enabled.
     * - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
     * targeting your `alicloud.slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
     * - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
     * - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
     */
    @JvmName("hrvboaxkyxapscob")
    public suspend fun loadbalancerIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadbalancerIds = mapped
    }

    /**
     * @param value The maximum life span of an instance in the scaling group. Unit: seconds.
     */
    @JvmName("iwrbiupmohssyrok")
    public suspend fun maxInstanceLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxInstanceLifetime = mapped
    }

    /**
     * @param value Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
     * **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
     */
    @JvmName("ejiqpymxdrkbfkcj")
    public suspend fun maxSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSize = mapped
    }

    /**
     * @param value Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
     * **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
     */
    @JvmName("pbkgthjnexmjqgdj")
    public suspend fun minSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSize = mapped
    }

    /**
     * @param value Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, COMPOSABLE, BALANCE or COST_OPTIMIZED(Available since v1.54.0).
     */
    @JvmName("amgfufpbfocfaprk")
    public suspend fun multiAzPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiAzPolicy = mapped
    }

    /**
     * @param value The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
     */
    @JvmName("luxugmxgqesfonkc")
    public suspend fun onDemandBaseCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandBaseCapacity = mapped
    }

    /**
     * @param value Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
     */
    @JvmName("rxydhwlmlrvhktcu")
    public suspend fun onDemandPercentageAboveBaseCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandPercentageAboveBaseCapacity = mapped
    }

    /**
     * @param value Set or unset instances within group into protected status.
     */
    @JvmName("byoxqtrfrxvyjxse")
    public suspend fun protectedInstances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedInstances = mapped
    }

    /**
     * @param values Set or unset instances within group into protected status.
     */
    @JvmName("norbtotjxyptwlfh")
    public suspend fun protectedInstances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedInstances = mapped
    }

    /**
     * @param value RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
     * - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
     * - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
     * - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
     * - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
     */
    @JvmName("fbweooeuoweohtkn")
    public suspend fun removalPolicies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.removalPolicies = mapped
    }

    /**
     * @param values RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
     * - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
     * - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
     * - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
     * - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
     */
    @JvmName("tjeqvgiqggnlgywx")
    public suspend fun removalPolicies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.removalPolicies = mapped
    }

    /**
     * @param value The ID of the resource group to which you want to add the scaling group.
     */
    @JvmName("klvceycckxfdbknb")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
     */
    @JvmName("fvrwisiqhvaapdvu")
    public suspend fun scalingGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingGroupName = mapped
    }

    /**
     * @param value The reclaim mode of the scaling group. Optional values: recycle, release, forceRecycle, forceRelease.
     */
    @JvmName("ltuuccsnlaafmlef")
    public suspend fun scalingPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPolicy = mapped
    }

    /**
     * @param value The allocation policy of preemptible instances. You can use this parameter to individually specify the allocation policy for preemptible instances. This parameter takes effect only if you set MultiAZPolicy to COMPOSABLE.
     */
    @JvmName("skxpfldjblemutlk")
    public suspend fun spotAllocationStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotAllocationStrategy = mapped
    }

    /**
     * @param value The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
     */
    @JvmName("rwrhltqxweqisqai")
    public suspend fun spotInstancePools(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotInstancePools = mapped
    }

    /**
     * @param value Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
     */
    @JvmName("gmhuulacbtuefntm")
    public suspend fun spotInstanceRemedy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotInstanceRemedy = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("wkhjethxkkjxllyk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     * - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
     * - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
     */
    @JvmName("bmgehldiuewbccai")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
     */
    @Deprecated(
        message = """
  Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids'
      can replace it.
  """,
    )
    @JvmName("rfakmtixgnvwigqq")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value List of virtual switch IDs in which the ecs instances to be launched.
     */
    @JvmName("morjtxcuwdfrsays")
    public suspend fun vswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param values List of virtual switch IDs in which the ecs instances to be launched.
     */
    @JvmName("lxsfciywvuqrkkrv")
    public suspend fun vswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    internal fun build(): ScalingGroupArgs = ScalingGroupArgs(
        albServerGroups = albServerGroups,
        allocationStrategy = allocationStrategy,
        azBalance = azBalance,
        dbInstanceIds = dbInstanceIds,
        defaultCooldown = defaultCooldown,
        desiredCapacity = desiredCapacity,
        groupDeletionProtection = groupDeletionProtection,
        groupType = groupType,
        healthCheckType = healthCheckType,
        healthCheckTypes = healthCheckTypes,
        instanceId = instanceId,
        launchTemplateId = launchTemplateId,
        launchTemplateOverrides = launchTemplateOverrides,
        launchTemplateVersion = launchTemplateVersion,
        loadbalancerIds = loadbalancerIds,
        maxInstanceLifetime = maxInstanceLifetime,
        maxSize = maxSize,
        minSize = minSize,
        multiAzPolicy = multiAzPolicy,
        onDemandBaseCapacity = onDemandBaseCapacity,
        onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity,
        protectedInstances = protectedInstances,
        removalPolicies = removalPolicies,
        resourceGroupId = resourceGroupId,
        scalingGroupName = scalingGroupName,
        scalingPolicy = scalingPolicy,
        spotAllocationStrategy = spotAllocationStrategy,
        spotInstancePools = spotInstancePools,
        spotInstanceRemedy = spotInstanceRemedy,
        tags = tags,
        vswitchId = vswitchId,
        vswitchIds = vswitchIds,
    )
}
