@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.kotlin.outputs.ScalingGroupVServerGroupsVserverGroup
import com.pulumi.alicloud.ess.kotlin.outputs.ScalingGroupVServerGroupsVserverGroup.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ScalingGroupVServerGroups].
 */
@PulumiTagMarker
public class ScalingGroupVServerGroupsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScalingGroupVServerGroupsArgs = ScalingGroupVServerGroupsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScalingGroupVServerGroupsArgsBuilder.() -> Unit) {
        val builder = ScalingGroupVServerGroupsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScalingGroupVServerGroups {
        val builtJavaResource =
            com.pulumi.alicloud.ess.ScalingGroupVServerGroups(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScalingGroupVServerGroups(builtJavaResource)
    }
}

/**
 * Attaches/Detaches vserver groups to a specified scaling group.
 * > **NOTE:** The load balancer of which vserver groups belongs to must be in `active` status.
 * > **NOTE:** If scaling group's network type is `VPC`, the vserver groups must be in the same `VPC`.
 * > **NOTE:** A scaling group can have at most 5 vserver groups attached by default.
 * > **NOTE:** Vserver groups and the default group of loadbalancer share the same backend server quota.
 * > **NOTE:** When attach vserver groups to scaling group, existing ECS instances will be added to vserver groups; Instead, ECS instances will be removed from vserver group when detach.
 * > **NOTE:** Detach action will be executed before attach action.
 * > **NOTE:** Vserver group is defined uniquely by `loadbalancer_id`, `vserver_group_id`, `port`.
 * > **NOTE:** Modifing `weight` attribute means detach vserver group first and then, attach with new weight parameter.
 * > **NOTE:** Available since v1.53.0.
 * ## Import
 * ESS vserver groups can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/scalingGroupVServerGroups:ScalingGroupVServerGroups example abc123456
 * ```
 */
public class ScalingGroupVServerGroups internal constructor(
    override val javaResource: com.pulumi.alicloud.ess.ScalingGroupVServerGroups,
) : KotlinCustomResource(javaResource, ScalingGroupVServerGroupsMapper) {
    /**
     * If instances of scaling group are attached/removed from slb backend server when attach/detach vserver group from scaling group. Default to true.
     */
    public val force: Output<Boolean>?
        get() = javaResource.force().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ID of the scaling group.
     */
    public val scalingGroupId: Output<String>
        get() = javaResource.scalingGroupId().applyValue({ args0 -> args0 })

    /**
     * A list of vserver groups attached on scaling group. See `vserver_groups` below.
     */
    public val vserverGroups: Output<List<ScalingGroupVServerGroupsVserverGroup>>
        get() = javaResource.vserverGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })
}

public object ScalingGroupVServerGroupsMapper : ResourceMapper<ScalingGroupVServerGroups> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ess.ScalingGroupVServerGroups::class == javaResource::class

    override fun map(javaResource: Resource): ScalingGroupVServerGroups =
        ScalingGroupVServerGroups(javaResource as com.pulumi.alicloud.ess.ScalingGroupVServerGroups)
}

/**
 * @see [ScalingGroupVServerGroups].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScalingGroupVServerGroups].
 */
public suspend fun scalingGroupVServerGroups(
    name: String,
    block: suspend ScalingGroupVServerGroupsResourceBuilder.() -> Unit,
): ScalingGroupVServerGroups {
    val builder = ScalingGroupVServerGroupsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScalingGroupVServerGroups].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scalingGroupVServerGroups(name: String): ScalingGroupVServerGroups {
    val builder = ScalingGroupVServerGroupsResourceBuilder()
    builder.name(name)
    return builder.build()
}
