@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.ScalingGroupVServerGroupsArgs.builder
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingGroupVServerGroupsVserverGroupArgs
import com.pulumi.alicloud.ess.kotlin.inputs.ScalingGroupVServerGroupsVserverGroupArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Attaches/Detaches vserver groups to a specified scaling group.
 * > **NOTE:** The load balancer of which vserver groups belongs to must be in `active` status.
 * > **NOTE:** If scaling group's network type is `VPC`, the vserver groups must be in the same `VPC`.
 * > **NOTE:** A scaling group can have at most 5 vserver groups attached by default.
 * > **NOTE:** Vserver groups and the default group of loadbalancer share the same backend server quota.
 * > **NOTE:** When attach vserver groups to scaling group, existing ECS instances will be added to vserver groups; Instead, ECS instances will be removed from vserver group when detach.
 * > **NOTE:** Detach action will be executed before attach action.
 * > **NOTE:** Vserver group is defined uniquely by `loadbalancer_id`, `vserver_group_id`, `port`.
 * > **NOTE:** Modifing `weight` attribute means detach vserver group first and then, attach with new weight parameter.
 * > **NOTE:** Available since v1.53.0.
 * ## Import
 * ESS vserver groups can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/scalingGroupVServerGroups:ScalingGroupVServerGroups example abc123456
 * ```
 * @property force If instances of scaling group are attached/removed from slb backend server when attach/detach vserver group from scaling group. Default to true.
 * @property scalingGroupId ID of the scaling group.
 * @property vserverGroups A list of vserver groups attached on scaling group. See `vserver_groups` below.
 */
public data class ScalingGroupVServerGroupsArgs(
    public val force: Output<Boolean>? = null,
    public val scalingGroupId: Output<String>? = null,
    public val vserverGroups: Output<List<ScalingGroupVServerGroupsVserverGroupArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.ScalingGroupVServerGroupsArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.ScalingGroupVServerGroupsArgs =
        com.pulumi.alicloud.ess.ScalingGroupVServerGroupsArgs.builder()
            .force(force?.applyValue({ args0 -> args0 }))
            .scalingGroupId(scalingGroupId?.applyValue({ args0 -> args0 }))
            .vserverGroups(
                vserverGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ScalingGroupVServerGroupsArgs].
 */
@PulumiTagMarker
public class ScalingGroupVServerGroupsArgsBuilder internal constructor() {
    private var force: Output<Boolean>? = null

    private var scalingGroupId: Output<String>? = null

    private var vserverGroups: Output<List<ScalingGroupVServerGroupsVserverGroupArgs>>? = null

    /**
     * @param value If instances of scaling group are attached/removed from slb backend server when attach/detach vserver group from scaling group. Default to true.
     */
    @JvmName("qlthcevjgjmupmht")
    public suspend fun force(`value`: Output<Boolean>) {
        this.force = value
    }

    /**
     * @param value ID of the scaling group.
     */
    @JvmName("dvywqoehigbdmucw")
    public suspend fun scalingGroupId(`value`: Output<String>) {
        this.scalingGroupId = value
    }

    /**
     * @param value A list of vserver groups attached on scaling group. See `vserver_groups` below.
     */
    @JvmName("bwacbeoxfhdhsxns")
    public suspend fun vserverGroups(`value`: Output<List<ScalingGroupVServerGroupsVserverGroupArgs>>) {
        this.vserverGroups = value
    }

    @JvmName("ultnatrekfkcljnh")
    public suspend fun vserverGroups(vararg values: Output<ScalingGroupVServerGroupsVserverGroupArgs>) {
        this.vserverGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of vserver groups attached on scaling group. See `vserver_groups` below.
     */
    @JvmName("manrjqourmucsguo")
    public suspend fun vserverGroups(values: List<Output<ScalingGroupVServerGroupsVserverGroupArgs>>) {
        this.vserverGroups = Output.all(values)
    }

    /**
     * @param value If instances of scaling group are attached/removed from slb backend server when attach/detach vserver group from scaling group. Default to true.
     */
    @JvmName("fprwqnogrkttnnbq")
    public suspend fun force(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.force = mapped
    }

    /**
     * @param value ID of the scaling group.
     */
    @JvmName("fshcmvmhdblnykqf")
    public suspend fun scalingGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingGroupId = mapped
    }

    /**
     * @param value A list of vserver groups attached on scaling group. See `vserver_groups` below.
     */
    @JvmName("isaqnggyavxyqnnh")
    public suspend fun vserverGroups(`value`: List<ScalingGroupVServerGroupsVserverGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vserverGroups = mapped
    }

    /**
     * @param argument A list of vserver groups attached on scaling group. See `vserver_groups` below.
     */
    @JvmName("vihdhmenvlonlwfa")
    public suspend fun vserverGroups(argument: List<suspend ScalingGroupVServerGroupsVserverGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingGroupVServerGroupsVserverGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vserverGroups = mapped
    }

    /**
     * @param argument A list of vserver groups attached on scaling group. See `vserver_groups` below.
     */
    @JvmName("nlkrhqfaekienaqb")
    public suspend fun vserverGroups(vararg argument: suspend ScalingGroupVServerGroupsVserverGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingGroupVServerGroupsVserverGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vserverGroups = mapped
    }

    /**
     * @param argument A list of vserver groups attached on scaling group. See `vserver_groups` below.
     */
    @JvmName("lhlpotklmivyybup")
    public suspend fun vserverGroups(argument: suspend ScalingGroupVServerGroupsVserverGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ScalingGroupVServerGroupsVserverGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vserverGroups = mapped
    }

    /**
     * @param values A list of vserver groups attached on scaling group. See `vserver_groups` below.
     */
    @JvmName("rgjuuvynamqkxtqy")
    public suspend fun vserverGroups(vararg values: ScalingGroupVServerGroupsVserverGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vserverGroups = mapped
    }

    internal fun build(): ScalingGroupVServerGroupsArgs = ScalingGroupVServerGroupsArgs(
        force = force,
        scalingGroupId = scalingGroupId,
        vserverGroups = vserverGroups,
    )
}
