@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Schedule].
 */
@PulumiTagMarker
public class ScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduleArgs = ScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduleArgsBuilder.() -> Unit) {
        val builder = ScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Schedule {
        val builtJavaResource = com.pulumi.alicloud.ess.Schedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schedule(builtJavaResource)
    }
}

/**
 * > **NOTE:** This resource has been deprecated from v1.45.0. New resource `alicloud.ess.ScheduledTask` will replace.
 */
public class Schedule internal constructor(
    override val javaResource: com.pulumi.alicloud.ess.Schedule,
) : KotlinCustomResource(javaResource, ScheduleMapper) {
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    public val desiredCapacity: Output<Int>?
        get() = javaResource.desiredCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val launchExpirationTime: Output<Int>?
        get() = javaResource.launchExpirationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val launchTime: Output<String>?
        get() = javaResource.launchTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val maxValue: Output<Int>?
        get() = javaResource.maxValue().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val minValue: Output<Int>?
        get() = javaResource.minValue().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val recurrenceEndTime: Output<String>
        get() = javaResource.recurrenceEndTime().applyValue({ args0 -> args0 })

    public val recurrenceType: Output<String>
        get() = javaResource.recurrenceType().applyValue({ args0 -> args0 })

    public val recurrenceValue: Output<String>
        get() = javaResource.recurrenceValue().applyValue({ args0 -> args0 })

    public val scalingGroupId: Output<String>
        get() = javaResource.scalingGroupId().applyValue({ args0 -> args0 })

    public val scheduledAction: Output<String>?
        get() = javaResource.scheduledAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val scheduledTaskName: Output<String>?
        get() = javaResource.scheduledTaskName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val taskEnabled: Output<Boolean>?
        get() = javaResource.taskEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ScheduleMapper : ResourceMapper<Schedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ess.Schedule::class == javaResource::class

    override fun map(javaResource: Resource): Schedule = Schedule(
        javaResource as
            com.pulumi.alicloud.ess.Schedule,
    )
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schedule].
 */
public suspend fun schedule(name: String, block: suspend ScheduleResourceBuilder.() -> Unit): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schedule(name: String): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
