@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.ScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **NOTE:** This resource has been deprecated from v1.45.0. New resource `alicloud.ess.ScheduledTask` will replace.
 * @property description
 * @property desiredCapacity
 * @property launchExpirationTime
 * @property launchTime
 * @property maxValue
 * @property minValue
 * @property recurrenceEndTime
 * @property recurrenceType
 * @property recurrenceValue
 * @property scalingGroupId
 * @property scheduledAction
 * @property scheduledTaskName
 * @property taskEnabled
 */
public data class ScheduleArgs(
    public val description: Output<String>? = null,
    public val desiredCapacity: Output<Int>? = null,
    public val launchExpirationTime: Output<Int>? = null,
    public val launchTime: Output<String>? = null,
    public val maxValue: Output<Int>? = null,
    public val minValue: Output<Int>? = null,
    public val recurrenceEndTime: Output<String>? = null,
    public val recurrenceType: Output<String>? = null,
    public val recurrenceValue: Output<String>? = null,
    public val scalingGroupId: Output<String>? = null,
    public val scheduledAction: Output<String>? = null,
    public val scheduledTaskName: Output<String>? = null,
    public val taskEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.ScheduleArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.ScheduleArgs =
        com.pulumi.alicloud.ess.ScheduleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .desiredCapacity(desiredCapacity?.applyValue({ args0 -> args0 }))
            .launchExpirationTime(launchExpirationTime?.applyValue({ args0 -> args0 }))
            .launchTime(launchTime?.applyValue({ args0 -> args0 }))
            .maxValue(maxValue?.applyValue({ args0 -> args0 }))
            .minValue(minValue?.applyValue({ args0 -> args0 }))
            .recurrenceEndTime(recurrenceEndTime?.applyValue({ args0 -> args0 }))
            .recurrenceType(recurrenceType?.applyValue({ args0 -> args0 }))
            .recurrenceValue(recurrenceValue?.applyValue({ args0 -> args0 }))
            .scalingGroupId(scalingGroupId?.applyValue({ args0 -> args0 }))
            .scheduledAction(scheduledAction?.applyValue({ args0 -> args0 }))
            .scheduledTaskName(scheduledTaskName?.applyValue({ args0 -> args0 }))
            .taskEnabled(taskEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var desiredCapacity: Output<Int>? = null

    private var launchExpirationTime: Output<Int>? = null

    private var launchTime: Output<String>? = null

    private var maxValue: Output<Int>? = null

    private var minValue: Output<Int>? = null

    private var recurrenceEndTime: Output<String>? = null

    private var recurrenceType: Output<String>? = null

    private var recurrenceValue: Output<String>? = null

    private var scalingGroupId: Output<String>? = null

    private var scheduledAction: Output<String>? = null

    private var scheduledTaskName: Output<String>? = null

    private var taskEnabled: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("pmcyclxgkcqtcgtq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("pggdqmpgxohgqmtp")
    public suspend fun desiredCapacity(`value`: Output<Int>) {
        this.desiredCapacity = value
    }

    /**
     * @param value
     */
    @JvmName("dpsvegcacnwgpkkn")
    public suspend fun launchExpirationTime(`value`: Output<Int>) {
        this.launchExpirationTime = value
    }

    /**
     * @param value
     */
    @JvmName("ogqaisvfipqohrqg")
    public suspend fun launchTime(`value`: Output<String>) {
        this.launchTime = value
    }

    /**
     * @param value
     */
    @JvmName("mvjtcuxuratnyjtt")
    public suspend fun maxValue(`value`: Output<Int>) {
        this.maxValue = value
    }

    /**
     * @param value
     */
    @JvmName("plppicemasnqpyhl")
    public suspend fun minValue(`value`: Output<Int>) {
        this.minValue = value
    }

    /**
     * @param value
     */
    @JvmName("mtjmywdqdwmiajag")
    public suspend fun recurrenceEndTime(`value`: Output<String>) {
        this.recurrenceEndTime = value
    }

    /**
     * @param value
     */
    @JvmName("ihdfwjsrrswqmbin")
    public suspend fun recurrenceType(`value`: Output<String>) {
        this.recurrenceType = value
    }

    /**
     * @param value
     */
    @JvmName("kkxqmjofoslmrynd")
    public suspend fun recurrenceValue(`value`: Output<String>) {
        this.recurrenceValue = value
    }

    /**
     * @param value
     */
    @JvmName("nieiexsqgoykauem")
    public suspend fun scalingGroupId(`value`: Output<String>) {
        this.scalingGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("guhyoioetausogfd")
    public suspend fun scheduledAction(`value`: Output<String>) {
        this.scheduledAction = value
    }

    /**
     * @param value
     */
    @JvmName("ntekjoceqwmwsfej")
    public suspend fun scheduledTaskName(`value`: Output<String>) {
        this.scheduledTaskName = value
    }

    /**
     * @param value
     */
    @JvmName("qyoxplxwaksrhvmm")
    public suspend fun taskEnabled(`value`: Output<Boolean>) {
        this.taskEnabled = value
    }

    /**
     * @param value
     */
    @JvmName("fdhompeyubxnsjhl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("qarmnekcdflrplrw")
    public suspend fun desiredCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredCapacity = mapped
    }

    /**
     * @param value
     */
    @JvmName("bxklablsfqnyyytr")
    public suspend fun launchExpirationTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchExpirationTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("nxekbkxmtvnkexfl")
    public suspend fun launchTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("tlqnnohtnrpcvpxe")
    public suspend fun maxValue(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxValue = mapped
    }

    /**
     * @param value
     */
    @JvmName("gywedmoiusajeiqg")
    public suspend fun minValue(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minValue = mapped
    }

    /**
     * @param value
     */
    @JvmName("jbwejenvtgrgddlh")
    public suspend fun recurrenceEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrenceEndTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("jeufpyankouepjal")
    public suspend fun recurrenceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrenceType = mapped
    }

    /**
     * @param value
     */
    @JvmName("crahyqajkvlpdtny")
    public suspend fun recurrenceValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrenceValue = mapped
    }

    /**
     * @param value
     */
    @JvmName("ttmaxvwvbjsookwj")
    public suspend fun scalingGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("kmdhtrtxadiamilt")
    public suspend fun scheduledAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledAction = mapped
    }

    /**
     * @param value
     */
    @JvmName("rytoxycdqvdreevl")
    public suspend fun scheduledTaskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledTaskName = mapped
    }

    /**
     * @param value
     */
    @JvmName("beyitlgddwyhtdee")
    public suspend fun taskEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskEnabled = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        description = description,
        desiredCapacity = desiredCapacity,
        launchExpirationTime = launchExpirationTime,
        launchTime = launchTime,
        maxValue = maxValue,
        minValue = minValue,
        recurrenceEndTime = recurrenceEndTime,
        recurrenceType = recurrenceType,
        recurrenceValue = recurrenceValue,
        scalingGroupId = scalingGroupId,
        scheduledAction = scheduledAction,
        scheduledTaskName = scheduledTaskName,
        taskEnabled = taskEnabled,
    )
}
