@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ScheduledTask].
 */
@PulumiTagMarker
public class ScheduledTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduledTaskArgs = ScheduledTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduledTaskArgsBuilder.() -> Unit) {
        val builder = ScheduledTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScheduledTask {
        val builtJavaResource = com.pulumi.alicloud.ess.ScheduledTask(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ScheduledTask(builtJavaResource)
    }
}

/**
 * Provides a ESS schedule resource.
 * For information about ess schedule task, see [Scheduled Tasks](https://www.alibabacloud.com/help/en/auto-scaling/latest/createscheduledtask).
 * > **NOTE:** Available since v1.60.0.
 * ## Import
 * ESS schedule task can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/scheduledTask:ScheduledTask example abc123456
 * ```
 */
public class ScheduledTask internal constructor(
    override val javaResource: com.pulumi.alicloud.ess.ScheduledTask,
) : KotlinCustomResource(javaResource, ScheduledTaskMapper) {
    /**
     * Description of the scheduled task, which is 2-200 characters (English or Chinese) long.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The expected number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group. **NOTE:** You must specify the `DesiredCapacity` parameter when you create the scaling group.
     */
    public val desiredCapacity: Output<Int>?
        get() = javaResource.desiredCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time period during which a failed scheduled task is retried. Unit: seconds. Valid values: 0 to 21600. Default value: 600
     */
    public val launchExpirationTime: Output<Int>?
        get() = javaResource.launchExpirationTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time at which the scheduled task is triggered. Specify the time in the ISO 8601 standard in the YYYY-MM-DDThh:mmZ format.
     * The time must be in UTC. You cannot enter a time point later than 90 days from the date of scheduled task creation.
     * If the `recurrence_type` parameter is specified, the task is executed repeatedly at the time specified by LaunchTime.
     * Otherwise, the task is only executed once at the date and time specified by LaunchTime.
     */
    public val launchTime: Output<String>?
        get() = javaResource.launchTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group.
     */
    public val maxValue: Output<Int>?
        get() = javaResource.maxValue().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The minimum number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group.
     */
    public val minValue: Output<Int>?
        get() = javaResource.minValue().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the end time after which the scheduled task is no longer repeated. Specify the time in the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format.
     * The time must be in UTC. You cannot enter a time point later than 365 days from the date of scheduled task creation. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time.
     */
    public val recurrenceEndTime: Output<String>
        get() = javaResource.recurrenceEndTime().applyValue({ args0 -> args0 })

    /**
     * Specifies the recurrence type of the scheduled task. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time. Valid values:
     * - Daily: The scheduled task is executed once every specified number of days.
     * - Weekly: The scheduled task is executed on each specified day of a week.
     * - Monthly: The scheduled task is executed on each specified day of a month.
     * - Cron: (Available in 1.60.0+) The scheduled task is executed based on the specified cron expression.
     */
    public val recurrenceType: Output<String>
        get() = javaResource.recurrenceType().applyValue({ args0 -> args0 })

    /**
     * Specifies how often a scheduled task recurs. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time. The valid value depends on `recurrence_type`
     * - Daily: You can enter one value. Valid values: 1 to 31.
     * - Weekly: You can enter multiple values and separate them with commas (,). For example, the values 0 to 6 correspond to the days of the week in sequence from Sunday to Saturday.
     * - Monthly: You can enter two values in A-B format. Valid values of A and B: 1 to 31. The value of B must be greater than or equal to the value of A.
     * - Cron: You can enter a cron expression which is written in UTC and consists of five fields: minute, hour, day of month (date), month, and day of week. The expression can contain wildcard characters including commas (,), question marks (?), hyphens (-), asterisks (*), number signs (#), forward slashes (/), and the L and W letters.
     */
    public val recurrenceValue: Output<String>
        get() = javaResource.recurrenceValue().applyValue({ args0 -> args0 })

    /**
     * The ID of the scaling group where the number of instances is modified when the scheduled task is triggered. After the `ScalingGroupId` parameter is specified, the scaling method of the scheduled task is to specify the number of instances in a scaling group. You must specify at least one of the following parameters: `MinValue`, `MaxValue`, and `DesiredCapacity`. **NOTE:** You cannot specify `scheduled_action` and `scaling_group_id` at the same time.
     */
    public val scalingGroupId: Output<String>
        get() = javaResource.scalingGroupId().applyValue({ args0 -> args0 })

    /**
     * The operation to be performed when a scheduled task is triggered. Enter the unique identifier of a scaling rule. **NOTE:** You cannot specify `scheduled_action` and `scaling_group_id` at the same time.
     */
    public val scheduledAction: Output<String>?
        get() = javaResource.scheduledAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Display name of the scheduled task, which must be 2-40 characters (English or Chinese) long.
     */
    public val scheduledTaskName: Output<String>?
        get() = javaResource.scheduledTaskName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to start the scheduled task. Default to true.
     */
    public val taskEnabled: Output<Boolean>?
        get() = javaResource.taskEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ScheduledTaskMapper : ResourceMapper<ScheduledTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ess.ScheduledTask::class == javaResource::class

    override fun map(javaResource: Resource): ScheduledTask = ScheduledTask(
        javaResource as
            com.pulumi.alicloud.ess.ScheduledTask,
    )
}

/**
 * @see [ScheduledTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScheduledTask].
 */
public suspend fun scheduledTask(
    name: String,
    block: suspend ScheduledTaskResourceBuilder.() -> Unit,
): ScheduledTask {
    val builder = ScheduledTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScheduledTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scheduledTask(name: String): ScheduledTask {
    val builder = ScheduledTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
