@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin

import com.pulumi.alicloud.ess.ScheduledTaskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ESS schedule resource.
 * For information about ess schedule task, see [Scheduled Tasks](https://www.alibabacloud.com/help/en/auto-scaling/latest/createscheduledtask).
 * > **NOTE:** Available since v1.60.0.
 * ## Import
 * ESS schedule task can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ess/scheduledTask:ScheduledTask example abc123456
 * ```
 * @property description Description of the scheduled task, which is 2-200 characters (English or Chinese) long.
 * @property desiredCapacity The expected number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group. **NOTE:** You must specify the `DesiredCapacity` parameter when you create the scaling group.
 * @property launchExpirationTime The time period during which a failed scheduled task is retried. Unit: seconds. Valid values: 0 to 21600. Default value: 600
 * @property launchTime The time at which the scheduled task is triggered. Specify the time in the ISO 8601 standard in the YYYY-MM-DDThh:mmZ format.
 * The time must be in UTC. You cannot enter a time point later than 90 days from the date of scheduled task creation.
 * If the `recurrence_type` parameter is specified, the task is executed repeatedly at the time specified by LaunchTime.
 * Otherwise, the task is only executed once at the date and time specified by LaunchTime.
 * @property maxValue The maximum number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group.
 * @property minValue The minimum number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group.
 * @property recurrenceEndTime Specifies the end time after which the scheduled task is no longer repeated. Specify the time in the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format.
 * The time must be in UTC. You cannot enter a time point later than 365 days from the date of scheduled task creation. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time.
 * @property recurrenceType Specifies the recurrence type of the scheduled task. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time. Valid values:
 * - Daily: The scheduled task is executed once every specified number of days.
 * - Weekly: The scheduled task is executed on each specified day of a week.
 * - Monthly: The scheduled task is executed on each specified day of a month.
 * - Cron: (Available in 1.60.0+) The scheduled task is executed based on the specified cron expression.
 * @property recurrenceValue Specifies how often a scheduled task recurs. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time. The valid value depends on `recurrence_type`
 * - Daily: You can enter one value. Valid values: 1 to 31.
 * - Weekly: You can enter multiple values and separate them with commas (,). For example, the values 0 to 6 correspond to the days of the week in sequence from Sunday to Saturday.
 * - Monthly: You can enter two values in A-B format. Valid values of A and B: 1 to 31. The value of B must be greater than or equal to the value of A.
 * - Cron: You can enter a cron expression which is written in UTC and consists of five fields: minute, hour, day of month (date), month, and day of week. The expression can contain wildcard characters including commas (,), question marks (?), hyphens (-), asterisks (*), number signs (#), forward slashes (/), and the L and W letters.
 * @property scalingGroupId The ID of the scaling group where the number of instances is modified when the scheduled task is triggered. After the `ScalingGroupId` parameter is specified, the scaling method of the scheduled task is to specify the number of instances in a scaling group. You must specify at least one of the following parameters: `MinValue`, `MaxValue`, and `DesiredCapacity`. **NOTE:** You cannot specify `scheduled_action` and `scaling_group_id` at the same time.
 * @property scheduledAction The operation to be performed when a scheduled task is triggered. Enter the unique identifier of a scaling rule. **NOTE:** You cannot specify `scheduled_action` and `scaling_group_id` at the same time.
 * @property scheduledTaskName Display name of the scheduled task, which must be 2-40 characters (English or Chinese) long.
 * @property taskEnabled Specifies whether to start the scheduled task. Default to true.
 */
public data class ScheduledTaskArgs(
    public val description: Output<String>? = null,
    public val desiredCapacity: Output<Int>? = null,
    public val launchExpirationTime: Output<Int>? = null,
    public val launchTime: Output<String>? = null,
    public val maxValue: Output<Int>? = null,
    public val minValue: Output<Int>? = null,
    public val recurrenceEndTime: Output<String>? = null,
    public val recurrenceType: Output<String>? = null,
    public val recurrenceValue: Output<String>? = null,
    public val scalingGroupId: Output<String>? = null,
    public val scheduledAction: Output<String>? = null,
    public val scheduledTaskName: Output<String>? = null,
    public val taskEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.ScheduledTaskArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.ScheduledTaskArgs =
        com.pulumi.alicloud.ess.ScheduledTaskArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .desiredCapacity(desiredCapacity?.applyValue({ args0 -> args0 }))
            .launchExpirationTime(launchExpirationTime?.applyValue({ args0 -> args0 }))
            .launchTime(launchTime?.applyValue({ args0 -> args0 }))
            .maxValue(maxValue?.applyValue({ args0 -> args0 }))
            .minValue(minValue?.applyValue({ args0 -> args0 }))
            .recurrenceEndTime(recurrenceEndTime?.applyValue({ args0 -> args0 }))
            .recurrenceType(recurrenceType?.applyValue({ args0 -> args0 }))
            .recurrenceValue(recurrenceValue?.applyValue({ args0 -> args0 }))
            .scalingGroupId(scalingGroupId?.applyValue({ args0 -> args0 }))
            .scheduledAction(scheduledAction?.applyValue({ args0 -> args0 }))
            .scheduledTaskName(scheduledTaskName?.applyValue({ args0 -> args0 }))
            .taskEnabled(taskEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduledTaskArgs].
 */
@PulumiTagMarker
public class ScheduledTaskArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var desiredCapacity: Output<Int>? = null

    private var launchExpirationTime: Output<Int>? = null

    private var launchTime: Output<String>? = null

    private var maxValue: Output<Int>? = null

    private var minValue: Output<Int>? = null

    private var recurrenceEndTime: Output<String>? = null

    private var recurrenceType: Output<String>? = null

    private var recurrenceValue: Output<String>? = null

    private var scalingGroupId: Output<String>? = null

    private var scheduledAction: Output<String>? = null

    private var scheduledTaskName: Output<String>? = null

    private var taskEnabled: Output<Boolean>? = null

    /**
     * @param value Description of the scheduled task, which is 2-200 characters (English or Chinese) long.
     */
    @JvmName("rlolveysgjxykiyp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The expected number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group. **NOTE:** You must specify the `DesiredCapacity` parameter when you create the scaling group.
     */
    @JvmName("ocfoyeogqsghgijx")
    public suspend fun desiredCapacity(`value`: Output<Int>) {
        this.desiredCapacity = value
    }

    /**
     * @param value The time period during which a failed scheduled task is retried. Unit: seconds. Valid values: 0 to 21600. Default value: 600
     */
    @JvmName("clfyegbvkgfteqxi")
    public suspend fun launchExpirationTime(`value`: Output<Int>) {
        this.launchExpirationTime = value
    }

    /**
     * @param value The time at which the scheduled task is triggered. Specify the time in the ISO 8601 standard in the YYYY-MM-DDThh:mmZ format.
     * The time must be in UTC. You cannot enter a time point later than 90 days from the date of scheduled task creation.
     * If the `recurrence_type` parameter is specified, the task is executed repeatedly at the time specified by LaunchTime.
     * Otherwise, the task is only executed once at the date and time specified by LaunchTime.
     */
    @JvmName("ilrgmxkytoemqvqx")
    public suspend fun launchTime(`value`: Output<String>) {
        this.launchTime = value
    }

    /**
     * @param value The maximum number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group.
     */
    @JvmName("tvxaqbibsqcsolyn")
    public suspend fun maxValue(`value`: Output<Int>) {
        this.maxValue = value
    }

    /**
     * @param value The minimum number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group.
     */
    @JvmName("ibxuttlxgbhxbstf")
    public suspend fun minValue(`value`: Output<Int>) {
        this.minValue = value
    }

    /**
     * @param value Specifies the end time after which the scheduled task is no longer repeated. Specify the time in the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format.
     * The time must be in UTC. You cannot enter a time point later than 365 days from the date of scheduled task creation. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time.
     */
    @JvmName("fyxydbmjjxecdcgn")
    public suspend fun recurrenceEndTime(`value`: Output<String>) {
        this.recurrenceEndTime = value
    }

    /**
     * @param value Specifies the recurrence type of the scheduled task. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time. Valid values:
     * - Daily: The scheduled task is executed once every specified number of days.
     * - Weekly: The scheduled task is executed on each specified day of a week.
     * - Monthly: The scheduled task is executed on each specified day of a month.
     * - Cron: (Available in 1.60.0+) The scheduled task is executed based on the specified cron expression.
     */
    @JvmName("xxekkmyhefnnraih")
    public suspend fun recurrenceType(`value`: Output<String>) {
        this.recurrenceType = value
    }

    /**
     * @param value Specifies how often a scheduled task recurs. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time. The valid value depends on `recurrence_type`
     * - Daily: You can enter one value. Valid values: 1 to 31.
     * - Weekly: You can enter multiple values and separate them with commas (,). For example, the values 0 to 6 correspond to the days of the week in sequence from Sunday to Saturday.
     * - Monthly: You can enter two values in A-B format. Valid values of A and B: 1 to 31. The value of B must be greater than or equal to the value of A.
     * - Cron: You can enter a cron expression which is written in UTC and consists of five fields: minute, hour, day of month (date), month, and day of week. The expression can contain wildcard characters including commas (,), question marks (?), hyphens (-), asterisks (*), number signs (#), forward slashes (/), and the L and W letters.
     */
    @JvmName("iwuksuksumpsgfhn")
    public suspend fun recurrenceValue(`value`: Output<String>) {
        this.recurrenceValue = value
    }

    /**
     * @param value The ID of the scaling group where the number of instances is modified when the scheduled task is triggered. After the `ScalingGroupId` parameter is specified, the scaling method of the scheduled task is to specify the number of instances in a scaling group. You must specify at least one of the following parameters: `MinValue`, `MaxValue`, and `DesiredCapacity`. **NOTE:** You cannot specify `scheduled_action` and `scaling_group_id` at the same time.
     */
    @JvmName("dcssqrcipeckvlej")
    public suspend fun scalingGroupId(`value`: Output<String>) {
        this.scalingGroupId = value
    }

    /**
     * @param value The operation to be performed when a scheduled task is triggered. Enter the unique identifier of a scaling rule. **NOTE:** You cannot specify `scheduled_action` and `scaling_group_id` at the same time.
     */
    @JvmName("oopirtlcmlmvslpe")
    public suspend fun scheduledAction(`value`: Output<String>) {
        this.scheduledAction = value
    }

    /**
     * @param value Display name of the scheduled task, which must be 2-40 characters (English or Chinese) long.
     */
    @JvmName("qxjmgqwuyhasmthh")
    public suspend fun scheduledTaskName(`value`: Output<String>) {
        this.scheduledTaskName = value
    }

    /**
     * @param value Specifies whether to start the scheduled task. Default to true.
     */
    @JvmName("xfmmbircdmowyhrk")
    public suspend fun taskEnabled(`value`: Output<Boolean>) {
        this.taskEnabled = value
    }

    /**
     * @param value Description of the scheduled task, which is 2-200 characters (English or Chinese) long.
     */
    @JvmName("eqjvqgredyfdiycf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The expected number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group. **NOTE:** You must specify the `DesiredCapacity` parameter when you create the scaling group.
     */
    @JvmName("noaftwtfgccvsxvr")
    public suspend fun desiredCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredCapacity = mapped
    }

    /**
     * @param value The time period during which a failed scheduled task is retried. Unit: seconds. Valid values: 0 to 21600. Default value: 600
     */
    @JvmName("wlkvayrkirarypps")
    public suspend fun launchExpirationTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchExpirationTime = mapped
    }

    /**
     * @param value The time at which the scheduled task is triggered. Specify the time in the ISO 8601 standard in the YYYY-MM-DDThh:mmZ format.
     * The time must be in UTC. You cannot enter a time point later than 90 days from the date of scheduled task creation.
     * If the `recurrence_type` parameter is specified, the task is executed repeatedly at the time specified by LaunchTime.
     * Otherwise, the task is only executed once at the date and time specified by LaunchTime.
     */
    @JvmName("ismwtyckgieptmtc")
    public suspend fun launchTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTime = mapped
    }

    /**
     * @param value The maximum number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group.
     */
    @JvmName("jjtxcsroqtgorpam")
    public suspend fun maxValue(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxValue = mapped
    }

    /**
     * @param value The minimum number of instances in a scaling group when the scaling method of the scheduled task is to specify the number of instances in a scaling group.
     */
    @JvmName("ukhsgtgqdxvymgvl")
    public suspend fun minValue(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minValue = mapped
    }

    /**
     * @param value Specifies the end time after which the scheduled task is no longer repeated. Specify the time in the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format.
     * The time must be in UTC. You cannot enter a time point later than 365 days from the date of scheduled task creation. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time.
     */
    @JvmName("kxbxtmhbqrxbfhwo")
    public suspend fun recurrenceEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrenceEndTime = mapped
    }

    /**
     * @param value Specifies the recurrence type of the scheduled task. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time. Valid values:
     * - Daily: The scheduled task is executed once every specified number of days.
     * - Weekly: The scheduled task is executed on each specified day of a week.
     * - Monthly: The scheduled task is executed on each specified day of a month.
     * - Cron: (Available in 1.60.0+) The scheduled task is executed based on the specified cron expression.
     */
    @JvmName("txrtloprginlqlld")
    public suspend fun recurrenceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrenceType = mapped
    }

    /**
     * @param value Specifies how often a scheduled task recurs. **NOTE:** You must specify `RecurrenceType`, `RecurrenceValue`, and `RecurrenceEndTime` at the same time. The valid value depends on `recurrence_type`
     * - Daily: You can enter one value. Valid values: 1 to 31.
     * - Weekly: You can enter multiple values and separate them with commas (,). For example, the values 0 to 6 correspond to the days of the week in sequence from Sunday to Saturday.
     * - Monthly: You can enter two values in A-B format. Valid values of A and B: 1 to 31. The value of B must be greater than or equal to the value of A.
     * - Cron: You can enter a cron expression which is written in UTC and consists of five fields: minute, hour, day of month (date), month, and day of week. The expression can contain wildcard characters including commas (,), question marks (?), hyphens (-), asterisks (*), number signs (#), forward slashes (/), and the L and W letters.
     */
    @JvmName("vwejfqvrfdmmalnc")
    public suspend fun recurrenceValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrenceValue = mapped
    }

    /**
     * @param value The ID of the scaling group where the number of instances is modified when the scheduled task is triggered. After the `ScalingGroupId` parameter is specified, the scaling method of the scheduled task is to specify the number of instances in a scaling group. You must specify at least one of the following parameters: `MinValue`, `MaxValue`, and `DesiredCapacity`. **NOTE:** You cannot specify `scheduled_action` and `scaling_group_id` at the same time.
     */
    @JvmName("lfvkyivyntjtpoen")
    public suspend fun scalingGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingGroupId = mapped
    }

    /**
     * @param value The operation to be performed when a scheduled task is triggered. Enter the unique identifier of a scaling rule. **NOTE:** You cannot specify `scheduled_action` and `scaling_group_id` at the same time.
     */
    @JvmName("rtrptmpbrekmktnq")
    public suspend fun scheduledAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledAction = mapped
    }

    /**
     * @param value Display name of the scheduled task, which must be 2-40 characters (English or Chinese) long.
     */
    @JvmName("adleypcpxkcwrhys")
    public suspend fun scheduledTaskName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledTaskName = mapped
    }

    /**
     * @param value Specifies whether to start the scheduled task. Default to true.
     */
    @JvmName("nuegcvslrnfspxxm")
    public suspend fun taskEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskEnabled = mapped
    }

    internal fun build(): ScheduledTaskArgs = ScheduledTaskArgs(
        description = description,
        desiredCapacity = desiredCapacity,
        launchExpirationTime = launchExpirationTime,
        launchTime = launchTime,
        maxValue = maxValue,
        minValue = minValue,
        recurrenceEndTime = recurrenceEndTime,
        recurrenceType = recurrenceType,
        recurrenceValue = recurrenceValue,
        scalingGroupId = scalingGroupId,
        scheduledAction = scheduledAction,
        scheduledTaskName = scheduledTaskName,
        taskEnabled = taskEnabled,
    )
}
