@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.AlarmExpressionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comparisonOperator The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Supported value: >=, <=, >, <. Defaults to >=.
 * @property metricName The name for the alarm's associated metric. See `dimensions` below for details.
 * @property period The period in seconds over which the specified statistic is applied. Supported value: 60, 120, 300, 900. Defaults to 300.
 * @property statistics The statistic to apply to the alarm's associated metric. Supported value: Average, Minimum, Maximum. Defaults to Average.
 * @property threshold The value against which the specified statistics is compared.
 */
public data class AlarmExpressionArgs(
    public val comparisonOperator: Output<String>? = null,
    public val metricName: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val statistics: Output<String>? = null,
    public val threshold: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.AlarmExpressionArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.AlarmExpressionArgs =
        com.pulumi.alicloud.ess.inputs.AlarmExpressionArgs.builder()
            .comparisonOperator(comparisonOperator?.applyValue({ args0 -> args0 }))
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .statistics(statistics?.applyValue({ args0 -> args0 }))
            .threshold(threshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AlarmExpressionArgs].
 */
@PulumiTagMarker
public class AlarmExpressionArgsBuilder internal constructor() {
    private var comparisonOperator: Output<String>? = null

    private var metricName: Output<String>? = null

    private var period: Output<Int>? = null

    private var statistics: Output<String>? = null

    private var threshold: Output<Double>? = null

    /**
     * @param value The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Supported value: >=, <=, >, <. Defaults to >=.
     */
    @JvmName("lxyfinkncdmliqyw")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value The name for the alarm's associated metric. See `dimensions` below for details.
     */
    @JvmName("viwcnygchdkhnfoj")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The period in seconds over which the specified statistic is applied. Supported value: 60, 120, 300, 900. Defaults to 300.
     */
    @JvmName("smuhrviftgwgyntq")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The statistic to apply to the alarm's associated metric. Supported value: Average, Minimum, Maximum. Defaults to Average.
     */
    @JvmName("vqfcspawwugbjeds")
    public suspend fun statistics(`value`: Output<String>) {
        this.statistics = value
    }

    /**
     * @param value The value against which the specified statistics is compared.
     */
    @JvmName("ryonuukgfjgervbp")
    public suspend fun threshold(`value`: Output<Double>) {
        this.threshold = value
    }

    /**
     * @param value The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand. Supported value: >=, <=, >, <. Defaults to >=.
     */
    @JvmName("plopynyowvrejfbe")
    public suspend fun comparisonOperator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value The name for the alarm's associated metric. See `dimensions` below for details.
     */
    @JvmName("uwgfthtqurupwiip")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The period in seconds over which the specified statistic is applied. Supported value: 60, 120, 300, 900. Defaults to 300.
     */
    @JvmName("oodpnupsanjgcbof")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The statistic to apply to the alarm's associated metric. Supported value: Average, Minimum, Maximum. Defaults to Average.
     */
    @JvmName("pgrgwepduxperqvd")
    public suspend fun statistics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statistics = mapped
    }

    /**
     * @param value The value against which the specified statistics is compared.
     */
    @JvmName("bvdeankybfegmnat")
    public suspend fun threshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    internal fun build(): AlarmExpressionArgs = AlarmExpressionArgs(
        comparisonOperator = comparisonOperator,
        metricName = metricName,
        period = period,
        statistics = statistics,
        threshold = threshold,
    )
}
