@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.EciScalingConfigurationAcrRegistryInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property domains Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
 * when `acr_registry_info` is configured.
 * @property instanceId The ID of Container Registry Enterprise Edition instance. It is required
 * when `acr_registry_info` is configured.
 * @property instanceName The name of Container Registry Enterprise Edition instance. It is required when `acr_registry_info` is
 * configured.
 * @property regionId The region ID of Container Registry Enterprise Edition instance. It is required
 * when `acr_registry_info` is configured.
 */
public data class EciScalingConfigurationAcrRegistryInfoArgs(
    public val domains: Output<List<String>>? = null,
    public val instanceId: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val regionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.EciScalingConfigurationAcrRegistryInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.EciScalingConfigurationAcrRegistryInfoArgs =
        com.pulumi.alicloud.ess.inputs.EciScalingConfigurationAcrRegistryInfoArgs.builder()
            .domains(domains?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .regionId(regionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EciScalingConfigurationAcrRegistryInfoArgs].
 */
@PulumiTagMarker
public class EciScalingConfigurationAcrRegistryInfoArgsBuilder internal constructor() {
    private var domains: Output<List<String>>? = null

    private var instanceId: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var regionId: Output<String>? = null

    /**
     * @param value Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
     * when `acr_registry_info` is configured.
     */
    @JvmName("rtijtcimrbkuyujh")
    public suspend fun domains(`value`: Output<List<String>>) {
        this.domains = value
    }

    @JvmName("ucrujvdxpewwowux")
    public suspend fun domains(vararg values: Output<String>) {
        this.domains = Output.all(values.asList())
    }

    /**
     * @param values Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
     * when `acr_registry_info` is configured.
     */
    @JvmName("qroscxyhaylcfybf")
    public suspend fun domains(values: List<Output<String>>) {
        this.domains = Output.all(values)
    }

    /**
     * @param value The ID of Container Registry Enterprise Edition instance. It is required
     * when `acr_registry_info` is configured.
     */
    @JvmName("ywfcshmrnxuhqdln")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The name of Container Registry Enterprise Edition instance. It is required when `acr_registry_info` is
     * configured.
     */
    @JvmName("etjawasnoxifjwut")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The region ID of Container Registry Enterprise Edition instance. It is required
     * when `acr_registry_info` is configured.
     */
    @JvmName("ildhuhlbplskxljy")
    public suspend fun regionId(`value`: Output<String>) {
        this.regionId = value
    }

    /**
     * @param value Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
     * when `acr_registry_info` is configured.
     */
    @JvmName("nrypjgysgtssxqwt")
    public suspend fun domains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param values Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
     * when `acr_registry_info` is configured.
     */
    @JvmName("wxydtogfgxlwkopq")
    public suspend fun domains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domains = mapped
    }

    /**
     * @param value The ID of Container Registry Enterprise Edition instance. It is required
     * when `acr_registry_info` is configured.
     */
    @JvmName("qmrhhiblwegvhlla")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The name of Container Registry Enterprise Edition instance. It is required when `acr_registry_info` is
     * configured.
     */
    @JvmName("fvquqyphwatsbwqb")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The region ID of Container Registry Enterprise Edition instance. It is required
     * when `acr_registry_info` is configured.
     */
    @JvmName("sbvirctjtosgpnpc")
    public suspend fun regionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionId = mapped
    }

    internal fun build(): EciScalingConfigurationAcrRegistryInfoArgs =
        EciScalingConfigurationAcrRegistryInfoArgs(
            domains = domains,
            instanceId = instanceId,
            instanceName = instanceName,
            regionId = regionId,
        )
}
