@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.EciScalingConfigurationContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property args The arguments passed to the commands.
 * @property commands The commands run by the init container.
 * @property cpu The amount of CPU resources allocated to the container.
 * @property environmentVars The structure of environmentVars.
 * See `environment_vars` below for details.
 * @property gpu The number GPUs.
 * @property image The image of the container.
 * @property imagePullPolicy The restart policy of the image.
 * @property lifecyclePreStopHandlerExecs The commands to be executed in containers when you use the CLI to specify the preStop callback function.
 * @property livenessProbeExecCommands Commands that you want to run in containers when you use the CLI to perform liveness probes.
 * @property livenessProbeFailureThreshold The minimum number of consecutive failures for the liveness probe to be considered failed after having been successful. Default value: 3.
 * @property livenessProbeHttpGetPath The path to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
 * @property livenessProbeHttpGetPort The port to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
 * @property livenessProbeHttpGetScheme The protocol type of HTTP GET requests when you use HTTP requests for liveness probes.Valid values:HTTP and HTTPS.
 * @property livenessProbeInitialDelaySeconds The number of seconds after container has started before liveness probes are initiated.
 * @property livenessProbePeriodSeconds The interval at which the liveness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
 * @property livenessProbeSuccessThreshold The minimum number of consecutive successes for the liveness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
 * @property livenessProbeTcpSocketPort The port detected by TCP sockets when you use TCP sockets to perform liveness probes.
 * @property livenessProbeTimeoutSeconds The timeout period for the liveness probe. Unit: seconds. Default value: 1. Minimum value: 1.
 * @property memory The amount of memory resources allocated to the container.
 * @property name The name of the mounted volume.
 * @property ports The structure of port. See `ports` below for details.
 * @property readinessProbeExecCommands Commands that you want to run in containers when you use the CLI to perform readiness probes.
 * @property readinessProbeFailureThreshold The minimum number of consecutive failures for the readiness probe to be considered failed after having been successful. Default value: 3.
 * @property readinessProbeHttpGetPath The path to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
 * @property readinessProbeHttpGetPort The port to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
 * @property readinessProbeHttpGetScheme The protocol type of HTTP GET requests when you use HTTP requests for readiness probes. Valid values: HTTP and HTTPS.
 * @property readinessProbeInitialDelaySeconds The number of seconds after container N has started before readiness probes are initiated.
 * @property readinessProbePeriodSeconds The interval at which the readiness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
 * @property readinessProbeSuccessThreshold The minimum number of consecutive successes for the readiness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
 * @property readinessProbeTcpSocketPort The port detected by Transmission Control Protocol (TCP) sockets when you use TCP sockets to perform readiness probes.
 * @property readinessProbeTimeoutSeconds The timeout period for the readiness probe. Unit: seconds. Default value: 1. Minimum value: 1.
 * @property securityContextCapabilityAdds Grant certain permissions to processes within container. Optional values:
 * - NET_ADMIN: Allow network management tasks to be performed.
 * - NET_RAW: Allow raw sockets.
 * @property securityContextReadOnlyRootFileSystem Mounts the container's root filesystem as read-only.
 * @property securityContextRunAsUser Specifies user ID  under which all processes run.
 * @property volumeMounts The structure of volumeMounts.
 * See `volume_mounts` below for details.
 * @property workingDir The working directory of the container.
 */
public data class EciScalingConfigurationContainerArgs(
    public val args: Output<List<String>>? = null,
    public val commands: Output<List<String>>? = null,
    public val cpu: Output<Double>? = null,
    public val environmentVars: Output<List<EciScalingConfigurationContainerEnvironmentVarArgs>>? =
        null,
    public val gpu: Output<Int>? = null,
    public val image: Output<String>? = null,
    public val imagePullPolicy: Output<String>? = null,
    public val lifecyclePreStopHandlerExecs: Output<List<String>>? = null,
    public val livenessProbeExecCommands: Output<List<String>>? = null,
    public val livenessProbeFailureThreshold: Output<Int>? = null,
    public val livenessProbeHttpGetPath: Output<String>? = null,
    public val livenessProbeHttpGetPort: Output<Int>? = null,
    public val livenessProbeHttpGetScheme: Output<String>? = null,
    public val livenessProbeInitialDelaySeconds: Output<Int>? = null,
    public val livenessProbePeriodSeconds: Output<Int>? = null,
    public val livenessProbeSuccessThreshold: Output<Int>? = null,
    public val livenessProbeTcpSocketPort: Output<Int>? = null,
    public val livenessProbeTimeoutSeconds: Output<Int>? = null,
    public val memory: Output<Double>? = null,
    public val name: Output<String>? = null,
    public val ports: Output<List<EciScalingConfigurationContainerPortArgs>>? = null,
    public val readinessProbeExecCommands: Output<List<String>>? = null,
    public val readinessProbeFailureThreshold: Output<Int>? = null,
    public val readinessProbeHttpGetPath: Output<String>? = null,
    public val readinessProbeHttpGetPort: Output<Int>? = null,
    public val readinessProbeHttpGetScheme: Output<String>? = null,
    public val readinessProbeInitialDelaySeconds: Output<Int>? = null,
    public val readinessProbePeriodSeconds: Output<Int>? = null,
    public val readinessProbeSuccessThreshold: Output<Int>? = null,
    public val readinessProbeTcpSocketPort: Output<Int>? = null,
    public val readinessProbeTimeoutSeconds: Output<Int>? = null,
    public val securityContextCapabilityAdds: Output<List<String>>? = null,
    public val securityContextReadOnlyRootFileSystem: Output<Boolean>? = null,
    public val securityContextRunAsUser: Output<Int>? = null,
    public val volumeMounts: Output<List<EciScalingConfigurationContainerVolumeMountArgs>>? = null,
    public val workingDir: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.EciScalingConfigurationContainerArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.EciScalingConfigurationContainerArgs =
        com.pulumi.alicloud.ess.inputs.EciScalingConfigurationContainerArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .environmentVars(
                environmentVars?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .gpu(gpu?.applyValue({ args0 -> args0 }))
            .image(image?.applyValue({ args0 -> args0 }))
            .imagePullPolicy(imagePullPolicy?.applyValue({ args0 -> args0 }))
            .lifecyclePreStopHandlerExecs(
                lifecyclePreStopHandlerExecs?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .livenessProbeExecCommands(
                livenessProbeExecCommands?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .livenessProbeFailureThreshold(livenessProbeFailureThreshold?.applyValue({ args0 -> args0 }))
            .livenessProbeHttpGetPath(livenessProbeHttpGetPath?.applyValue({ args0 -> args0 }))
            .livenessProbeHttpGetPort(livenessProbeHttpGetPort?.applyValue({ args0 -> args0 }))
            .livenessProbeHttpGetScheme(livenessProbeHttpGetScheme?.applyValue({ args0 -> args0 }))
            .livenessProbeInitialDelaySeconds(livenessProbeInitialDelaySeconds?.applyValue({ args0 -> args0 }))
            .livenessProbePeriodSeconds(livenessProbePeriodSeconds?.applyValue({ args0 -> args0 }))
            .livenessProbeSuccessThreshold(livenessProbeSuccessThreshold?.applyValue({ args0 -> args0 }))
            .livenessProbeTcpSocketPort(livenessProbeTcpSocketPort?.applyValue({ args0 -> args0 }))
            .livenessProbeTimeoutSeconds(livenessProbeTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ports(ports?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .readinessProbeExecCommands(
                readinessProbeExecCommands?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .readinessProbeFailureThreshold(readinessProbeFailureThreshold?.applyValue({ args0 -> args0 }))
            .readinessProbeHttpGetPath(readinessProbeHttpGetPath?.applyValue({ args0 -> args0 }))
            .readinessProbeHttpGetPort(readinessProbeHttpGetPort?.applyValue({ args0 -> args0 }))
            .readinessProbeHttpGetScheme(readinessProbeHttpGetScheme?.applyValue({ args0 -> args0 }))
            .readinessProbeInitialDelaySeconds(
                readinessProbeInitialDelaySeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .readinessProbePeriodSeconds(readinessProbePeriodSeconds?.applyValue({ args0 -> args0 }))
            .readinessProbeSuccessThreshold(readinessProbeSuccessThreshold?.applyValue({ args0 -> args0 }))
            .readinessProbeTcpSocketPort(readinessProbeTcpSocketPort?.applyValue({ args0 -> args0 }))
            .readinessProbeTimeoutSeconds(readinessProbeTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .securityContextCapabilityAdds(
                securityContextCapabilityAdds?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .securityContextReadOnlyRootFileSystem(
                securityContextReadOnlyRootFileSystem?.applyValue({ args0 ->
                    args0
                }),
            )
            .securityContextRunAsUser(securityContextRunAsUser?.applyValue({ args0 -> args0 }))
            .volumeMounts(
                volumeMounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .workingDir(workingDir?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EciScalingConfigurationContainerArgs].
 */
@PulumiTagMarker
public class EciScalingConfigurationContainerArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var commands: Output<List<String>>? = null

    private var cpu: Output<Double>? = null

    private var environmentVars: Output<List<EciScalingConfigurationContainerEnvironmentVarArgs>>? =
        null

    private var gpu: Output<Int>? = null

    private var image: Output<String>? = null

    private var imagePullPolicy: Output<String>? = null

    private var lifecyclePreStopHandlerExecs: Output<List<String>>? = null

    private var livenessProbeExecCommands: Output<List<String>>? = null

    private var livenessProbeFailureThreshold: Output<Int>? = null

    private var livenessProbeHttpGetPath: Output<String>? = null

    private var livenessProbeHttpGetPort: Output<Int>? = null

    private var livenessProbeHttpGetScheme: Output<String>? = null

    private var livenessProbeInitialDelaySeconds: Output<Int>? = null

    private var livenessProbePeriodSeconds: Output<Int>? = null

    private var livenessProbeSuccessThreshold: Output<Int>? = null

    private var livenessProbeTcpSocketPort: Output<Int>? = null

    private var livenessProbeTimeoutSeconds: Output<Int>? = null

    private var memory: Output<Double>? = null

    private var name: Output<String>? = null

    private var ports: Output<List<EciScalingConfigurationContainerPortArgs>>? = null

    private var readinessProbeExecCommands: Output<List<String>>? = null

    private var readinessProbeFailureThreshold: Output<Int>? = null

    private var readinessProbeHttpGetPath: Output<String>? = null

    private var readinessProbeHttpGetPort: Output<Int>? = null

    private var readinessProbeHttpGetScheme: Output<String>? = null

    private var readinessProbeInitialDelaySeconds: Output<Int>? = null

    private var readinessProbePeriodSeconds: Output<Int>? = null

    private var readinessProbeSuccessThreshold: Output<Int>? = null

    private var readinessProbeTcpSocketPort: Output<Int>? = null

    private var readinessProbeTimeoutSeconds: Output<Int>? = null

    private var securityContextCapabilityAdds: Output<List<String>>? = null

    private var securityContextReadOnlyRootFileSystem: Output<Boolean>? = null

    private var securityContextRunAsUser: Output<Int>? = null

    private var volumeMounts: Output<List<EciScalingConfigurationContainerVolumeMountArgs>>? = null

    private var workingDir: Output<String>? = null

    /**
     * @param value The arguments passed to the commands.
     */
    @JvmName("fktoacarpfsrwigj")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("orptlkqsoljcewvm")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values The arguments passed to the commands.
     */
    @JvmName("derjhlajvrheesak")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value The commands run by the init container.
     */
    @JvmName("wpctpdxgrryqixdg")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("ikrxficqufwnlyal")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values The commands run by the init container.
     */
    @JvmName("pqmhatexarcdjaba")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value The amount of CPU resources allocated to the container.
     */
    @JvmName("pitxtqxmybkddyvb")
    public suspend fun cpu(`value`: Output<Double>) {
        this.cpu = value
    }

    /**
     * @param value The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("fmxqltddwsiuhfci")
    public suspend fun environmentVars(`value`: Output<List<EciScalingConfigurationContainerEnvironmentVarArgs>>) {
        this.environmentVars = value
    }

    @JvmName("cmumyawwfxhykflt")
    public suspend fun environmentVars(vararg values: Output<EciScalingConfigurationContainerEnvironmentVarArgs>) {
        this.environmentVars = Output.all(values.asList())
    }

    /**
     * @param values The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("dkcxacqavuvnlcyv")
    public suspend fun environmentVars(values: List<Output<EciScalingConfigurationContainerEnvironmentVarArgs>>) {
        this.environmentVars = Output.all(values)
    }

    /**
     * @param value The number GPUs.
     */
    @JvmName("agvpbarjmhbngwia")
    public suspend fun gpu(`value`: Output<Int>) {
        this.gpu = value
    }

    /**
     * @param value The image of the container.
     */
    @JvmName("vfvdqqmotbqqnipx")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value The restart policy of the image.
     */
    @JvmName("mfnpheahdinuihrs")
    public suspend fun imagePullPolicy(`value`: Output<String>) {
        this.imagePullPolicy = value
    }

    /**
     * @param value The commands to be executed in containers when you use the CLI to specify the preStop callback function.
     */
    @JvmName("aqeoeqrmpkmuttbe")
    public suspend fun lifecyclePreStopHandlerExecs(`value`: Output<List<String>>) {
        this.lifecyclePreStopHandlerExecs = value
    }

    @JvmName("mwkqutneqgfhitky")
    public suspend fun lifecyclePreStopHandlerExecs(vararg values: Output<String>) {
        this.lifecyclePreStopHandlerExecs = Output.all(values.asList())
    }

    /**
     * @param values The commands to be executed in containers when you use the CLI to specify the preStop callback function.
     */
    @JvmName("muyrcsmjskmdhvfx")
    public suspend fun lifecyclePreStopHandlerExecs(values: List<Output<String>>) {
        this.lifecyclePreStopHandlerExecs = Output.all(values)
    }

    /**
     * @param value Commands that you want to run in containers when you use the CLI to perform liveness probes.
     */
    @JvmName("ubycqvuthcnmfdxj")
    public suspend fun livenessProbeExecCommands(`value`: Output<List<String>>) {
        this.livenessProbeExecCommands = value
    }

    @JvmName("mtqqnwaidhtqosmj")
    public suspend fun livenessProbeExecCommands(vararg values: Output<String>) {
        this.livenessProbeExecCommands = Output.all(values.asList())
    }

    /**
     * @param values Commands that you want to run in containers when you use the CLI to perform liveness probes.
     */
    @JvmName("bujdcembjvlaavcn")
    public suspend fun livenessProbeExecCommands(values: List<Output<String>>) {
        this.livenessProbeExecCommands = Output.all(values)
    }

    /**
     * @param value The minimum number of consecutive failures for the liveness probe to be considered failed after having been successful. Default value: 3.
     */
    @JvmName("ecljjsyttorpgxod")
    public suspend fun livenessProbeFailureThreshold(`value`: Output<Int>) {
        this.livenessProbeFailureThreshold = value
    }

    /**
     * @param value The path to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
     */
    @JvmName("vtkqfkycntthshbo")
    public suspend fun livenessProbeHttpGetPath(`value`: Output<String>) {
        this.livenessProbeHttpGetPath = value
    }

    /**
     * @param value The port to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
     */
    @JvmName("eurbcbuaugjuklos")
    public suspend fun livenessProbeHttpGetPort(`value`: Output<Int>) {
        this.livenessProbeHttpGetPort = value
    }

    /**
     * @param value The protocol type of HTTP GET requests when you use HTTP requests for liveness probes.Valid values:HTTP and HTTPS.
     */
    @JvmName("hjdhyutouxapdovr")
    public suspend fun livenessProbeHttpGetScheme(`value`: Output<String>) {
        this.livenessProbeHttpGetScheme = value
    }

    /**
     * @param value The number of seconds after container has started before liveness probes are initiated.
     */
    @JvmName("yhjwmnfehvjudpho")
    public suspend fun livenessProbeInitialDelaySeconds(`value`: Output<Int>) {
        this.livenessProbeInitialDelaySeconds = value
    }

    /**
     * @param value The interval at which the liveness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
     */
    @JvmName("hklxxuqeinvsvrwf")
    public suspend fun livenessProbePeriodSeconds(`value`: Output<Int>) {
        this.livenessProbePeriodSeconds = value
    }

    /**
     * @param value The minimum number of consecutive successes for the liveness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
     */
    @JvmName("hsdebtomptksljic")
    public suspend fun livenessProbeSuccessThreshold(`value`: Output<Int>) {
        this.livenessProbeSuccessThreshold = value
    }

    /**
     * @param value The port detected by TCP sockets when you use TCP sockets to perform liveness probes.
     */
    @JvmName("xaygtpdfrhmsccmu")
    public suspend fun livenessProbeTcpSocketPort(`value`: Output<Int>) {
        this.livenessProbeTcpSocketPort = value
    }

    /**
     * @param value The timeout period for the liveness probe. Unit: seconds. Default value: 1. Minimum value: 1.
     */
    @JvmName("tlsvvsghxkoomqrg")
    public suspend fun livenessProbeTimeoutSeconds(`value`: Output<Int>) {
        this.livenessProbeTimeoutSeconds = value
    }

    /**
     * @param value The amount of memory resources allocated to the container.
     */
    @JvmName("qnbdwgtympaimyuq")
    public suspend fun memory(`value`: Output<Double>) {
        this.memory = value
    }

    /**
     * @param value The name of the mounted volume.
     */
    @JvmName("qeyxnuhtlaopmmnk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The structure of port. See `ports` below for details.
     */
    @JvmName("fyresasvvygtbmkk")
    public suspend fun ports(`value`: Output<List<EciScalingConfigurationContainerPortArgs>>) {
        this.ports = value
    }

    @JvmName("kwbyfrhjiasfgnva")
    public suspend fun ports(vararg values: Output<EciScalingConfigurationContainerPortArgs>) {
        this.ports = Output.all(values.asList())
    }

    /**
     * @param values The structure of port. See `ports` below for details.
     */
    @JvmName("liebovnmndwpfpto")
    public suspend fun ports(values: List<Output<EciScalingConfigurationContainerPortArgs>>) {
        this.ports = Output.all(values)
    }

    /**
     * @param value Commands that you want to run in containers when you use the CLI to perform readiness probes.
     */
    @JvmName("fhdieglbdaphpecp")
    public suspend fun readinessProbeExecCommands(`value`: Output<List<String>>) {
        this.readinessProbeExecCommands = value
    }

    @JvmName("pckgjsjfpaxtffru")
    public suspend fun readinessProbeExecCommands(vararg values: Output<String>) {
        this.readinessProbeExecCommands = Output.all(values.asList())
    }

    /**
     * @param values Commands that you want to run in containers when you use the CLI to perform readiness probes.
     */
    @JvmName("luhfbvulxakfdkdf")
    public suspend fun readinessProbeExecCommands(values: List<Output<String>>) {
        this.readinessProbeExecCommands = Output.all(values)
    }

    /**
     * @param value The minimum number of consecutive failures for the readiness probe to be considered failed after having been successful. Default value: 3.
     */
    @JvmName("xojlfdouvrtchcfl")
    public suspend fun readinessProbeFailureThreshold(`value`: Output<Int>) {
        this.readinessProbeFailureThreshold = value
    }

    /**
     * @param value The path to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
     */
    @JvmName("bqeernlyefdjmbev")
    public suspend fun readinessProbeHttpGetPath(`value`: Output<String>) {
        this.readinessProbeHttpGetPath = value
    }

    /**
     * @param value The port to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
     */
    @JvmName("rcrbomlvvbdafvbi")
    public suspend fun readinessProbeHttpGetPort(`value`: Output<Int>) {
        this.readinessProbeHttpGetPort = value
    }

    /**
     * @param value The protocol type of HTTP GET requests when you use HTTP requests for readiness probes. Valid values: HTTP and HTTPS.
     */
    @JvmName("isbnipkirlhmjxma")
    public suspend fun readinessProbeHttpGetScheme(`value`: Output<String>) {
        this.readinessProbeHttpGetScheme = value
    }

    /**
     * @param value The number of seconds after container N has started before readiness probes are initiated.
     */
    @JvmName("ygnvpecmvlocqnxc")
    public suspend fun readinessProbeInitialDelaySeconds(`value`: Output<Int>) {
        this.readinessProbeInitialDelaySeconds = value
    }

    /**
     * @param value The interval at which the readiness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
     */
    @JvmName("htjudwrkbpcdneip")
    public suspend fun readinessProbePeriodSeconds(`value`: Output<Int>) {
        this.readinessProbePeriodSeconds = value
    }

    /**
     * @param value The minimum number of consecutive successes for the readiness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
     */
    @JvmName("mblujeedccwnvmki")
    public suspend fun readinessProbeSuccessThreshold(`value`: Output<Int>) {
        this.readinessProbeSuccessThreshold = value
    }

    /**
     * @param value The port detected by Transmission Control Protocol (TCP) sockets when you use TCP sockets to perform readiness probes.
     */
    @JvmName("vjfcpkhytpuwgjfw")
    public suspend fun readinessProbeTcpSocketPort(`value`: Output<Int>) {
        this.readinessProbeTcpSocketPort = value
    }

    /**
     * @param value The timeout period for the readiness probe. Unit: seconds. Default value: 1. Minimum value: 1.
     */
    @JvmName("prlqjgjthmvxpovd")
    public suspend fun readinessProbeTimeoutSeconds(`value`: Output<Int>) {
        this.readinessProbeTimeoutSeconds = value
    }

    /**
     * @param value Grant certain permissions to processes within container. Optional values:
     * - NET_ADMIN: Allow network management tasks to be performed.
     * - NET_RAW: Allow raw sockets.
     */
    @JvmName("gpcfuspadkmmpryf")
    public suspend fun securityContextCapabilityAdds(`value`: Output<List<String>>) {
        this.securityContextCapabilityAdds = value
    }

    @JvmName("dbdxyhpxucyrawxd")
    public suspend fun securityContextCapabilityAdds(vararg values: Output<String>) {
        this.securityContextCapabilityAdds = Output.all(values.asList())
    }

    /**
     * @param values Grant certain permissions to processes within container. Optional values:
     * - NET_ADMIN: Allow network management tasks to be performed.
     * - NET_RAW: Allow raw sockets.
     */
    @JvmName("ovcywlhenpinfnvm")
    public suspend fun securityContextCapabilityAdds(values: List<Output<String>>) {
        this.securityContextCapabilityAdds = Output.all(values)
    }

    /**
     * @param value Mounts the container's root filesystem as read-only.
     */
    @JvmName("bprufpvbhxbtgfsn")
    public suspend fun securityContextReadOnlyRootFileSystem(`value`: Output<Boolean>) {
        this.securityContextReadOnlyRootFileSystem = value
    }

    /**
     * @param value Specifies user ID  under which all processes run.
     */
    @JvmName("yaoamdktmgjfdutg")
    public suspend fun securityContextRunAsUser(`value`: Output<Int>) {
        this.securityContextRunAsUser = value
    }

    /**
     * @param value The structure of volumeMounts.
     * See `volume_mounts` below for details.
     */
    @JvmName("fijsvqsqwybpifoh")
    public suspend fun volumeMounts(`value`: Output<List<EciScalingConfigurationContainerVolumeMountArgs>>) {
        this.volumeMounts = value
    }

    @JvmName("kvfsymjbuusciogq")
    public suspend fun volumeMounts(vararg values: Output<EciScalingConfigurationContainerVolumeMountArgs>) {
        this.volumeMounts = Output.all(values.asList())
    }

    /**
     * @param values The structure of volumeMounts.
     * See `volume_mounts` below for details.
     */
    @JvmName("qkkgatitdenvikjk")
    public suspend fun volumeMounts(values: List<Output<EciScalingConfigurationContainerVolumeMountArgs>>) {
        this.volumeMounts = Output.all(values)
    }

    /**
     * @param value The working directory of the container.
     */
    @JvmName("vxaadqcvinxygogp")
    public suspend fun workingDir(`value`: Output<String>) {
        this.workingDir = value
    }

    /**
     * @param value The arguments passed to the commands.
     */
    @JvmName("ylvfsawulllhavwc")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values The arguments passed to the commands.
     */
    @JvmName("ofeufifnbvadsjbr")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value The commands run by the init container.
     */
    @JvmName("rnktpwnjfoksvhcg")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values The commands run by the init container.
     */
    @JvmName("jkjtnwdfbjoqomck")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value The amount of CPU resources allocated to the container.
     */
    @JvmName("iybqxxphvkkiiwkn")
    public suspend fun cpu(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("viuhydmnedvwtpdh")
    public suspend fun environmentVars(`value`: List<EciScalingConfigurationContainerEnvironmentVarArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("rknxyacrmlbotbuy")
    public suspend fun environmentVars(argument: List<suspend EciScalingConfigurationContainerEnvironmentVarArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationContainerEnvironmentVarArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("dhxhclywrlfymgwg")
    public suspend fun environmentVars(vararg argument: suspend EciScalingConfigurationContainerEnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationContainerEnvironmentVarArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param argument The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("evwnfahmlaikhutt")
    public suspend fun environmentVars(argument: suspend EciScalingConfigurationContainerEnvironmentVarArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EciScalingConfigurationContainerEnvironmentVarArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.environmentVars = mapped
    }

    /**
     * @param values The structure of environmentVars.
     * See `environment_vars` below for details.
     */
    @JvmName("qxiubbcshvbrkmfh")
    public suspend fun environmentVars(vararg values: EciScalingConfigurationContainerEnvironmentVarArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVars = mapped
    }

    /**
     * @param value The number GPUs.
     */
    @JvmName("eoxjjnyeocukthop")
    public suspend fun gpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpu = mapped
    }

    /**
     * @param value The image of the container.
     */
    @JvmName("vkhewddhvgxmkikj")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value The restart policy of the image.
     */
    @JvmName("xvojmmewhxqetald")
    public suspend fun imagePullPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePullPolicy = mapped
    }

    /**
     * @param value The commands to be executed in containers when you use the CLI to specify the preStop callback function.
     */
    @JvmName("spbgvcrjkxxxlefx")
    public suspend fun lifecyclePreStopHandlerExecs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecyclePreStopHandlerExecs = mapped
    }

    /**
     * @param values The commands to be executed in containers when you use the CLI to specify the preStop callback function.
     */
    @JvmName("hirltquarxjjsgyt")
    public suspend fun lifecyclePreStopHandlerExecs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecyclePreStopHandlerExecs = mapped
    }

    /**
     * @param value Commands that you want to run in containers when you use the CLI to perform liveness probes.
     */
    @JvmName("vocnupowcgnhgdjf")
    public suspend fun livenessProbeExecCommands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbeExecCommands = mapped
    }

    /**
     * @param values Commands that you want to run in containers when you use the CLI to perform liveness probes.
     */
    @JvmName("avkuwsxvjfcbucyw")
    public suspend fun livenessProbeExecCommands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.livenessProbeExecCommands = mapped
    }

    /**
     * @param value The minimum number of consecutive failures for the liveness probe to be considered failed after having been successful. Default value: 3.
     */
    @JvmName("shifhptekfliktho")
    public suspend fun livenessProbeFailureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbeFailureThreshold = mapped
    }

    /**
     * @param value The path to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
     */
    @JvmName("kbjdhjmjtcweordj")
    public suspend fun livenessProbeHttpGetPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbeHttpGetPath = mapped
    }

    /**
     * @param value The port to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
     */
    @JvmName("hrgiwekjvbjqljpe")
    public suspend fun livenessProbeHttpGetPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbeHttpGetPort = mapped
    }

    /**
     * @param value The protocol type of HTTP GET requests when you use HTTP requests for liveness probes.Valid values:HTTP and HTTPS.
     */
    @JvmName("lbxvnwhseokddyvf")
    public suspend fun livenessProbeHttpGetScheme(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbeHttpGetScheme = mapped
    }

    /**
     * @param value The number of seconds after container has started before liveness probes are initiated.
     */
    @JvmName("apgsetwgxurfamsc")
    public suspend fun livenessProbeInitialDelaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbeInitialDelaySeconds = mapped
    }

    /**
     * @param value The interval at which the liveness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
     */
    @JvmName("onhuofsgmhqbqyco")
    public suspend fun livenessProbePeriodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbePeriodSeconds = mapped
    }

    /**
     * @param value The minimum number of consecutive successes for the liveness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
     */
    @JvmName("kclblndofhypjufp")
    public suspend fun livenessProbeSuccessThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbeSuccessThreshold = mapped
    }

    /**
     * @param value The port detected by TCP sockets when you use TCP sockets to perform liveness probes.
     */
    @JvmName("effwjmqovqrqrfox")
    public suspend fun livenessProbeTcpSocketPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbeTcpSocketPort = mapped
    }

    /**
     * @param value The timeout period for the liveness probe. Unit: seconds. Default value: 1. Minimum value: 1.
     */
    @JvmName("cmbypvchddkfgbub")
    public suspend fun livenessProbeTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.livenessProbeTimeoutSeconds = mapped
    }

    /**
     * @param value The amount of memory resources allocated to the container.
     */
    @JvmName("kkvrjhbnixvrajri")
    public suspend fun memory(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    /**
     * @param value The name of the mounted volume.
     */
    @JvmName("ykkmbbmxmbdnawns")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The structure of port. See `ports` below for details.
     */
    @JvmName("tirapiouduedprsu")
    public suspend fun ports(`value`: List<EciScalingConfigurationContainerPortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below for details.
     */
    @JvmName("mgywyjwicqalydaw")
    public suspend fun ports(argument: List<suspend EciScalingConfigurationContainerPortArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationContainerPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below for details.
     */
    @JvmName("idaluaihjeuslqyr")
    public suspend fun ports(vararg argument: suspend EciScalingConfigurationContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationContainerPortArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param argument The structure of port. See `ports` below for details.
     */
    @JvmName("dcxxslejlqwqqvqs")
    public suspend fun ports(argument: suspend EciScalingConfigurationContainerPortArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EciScalingConfigurationContainerPortArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ports = mapped
    }

    /**
     * @param values The structure of port. See `ports` below for details.
     */
    @JvmName("uxqcknmpejfqgrvv")
    public suspend fun ports(vararg values: EciScalingConfigurationContainerPortArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ports = mapped
    }

    /**
     * @param value Commands that you want to run in containers when you use the CLI to perform readiness probes.
     */
    @JvmName("pmdoiqbjhhuskkga")
    public suspend fun readinessProbeExecCommands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbeExecCommands = mapped
    }

    /**
     * @param values Commands that you want to run in containers when you use the CLI to perform readiness probes.
     */
    @JvmName("gsptjwxfyrhqmbrv")
    public suspend fun readinessProbeExecCommands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readinessProbeExecCommands = mapped
    }

    /**
     * @param value The minimum number of consecutive failures for the readiness probe to be considered failed after having been successful. Default value: 3.
     */
    @JvmName("uvgametvyvymrewd")
    public suspend fun readinessProbeFailureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbeFailureThreshold = mapped
    }

    /**
     * @param value The path to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
     */
    @JvmName("bxbjvryvvtxjjdbj")
    public suspend fun readinessProbeHttpGetPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbeHttpGetPath = mapped
    }

    /**
     * @param value The port to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
     */
    @JvmName("pboqcorbfrjbifij")
    public suspend fun readinessProbeHttpGetPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbeHttpGetPort = mapped
    }

    /**
     * @param value The protocol type of HTTP GET requests when you use HTTP requests for readiness probes. Valid values: HTTP and HTTPS.
     */
    @JvmName("ewuhbgcuwuqiipfd")
    public suspend fun readinessProbeHttpGetScheme(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbeHttpGetScheme = mapped
    }

    /**
     * @param value The number of seconds after container N has started before readiness probes are initiated.
     */
    @JvmName("lcsvkxrigaiklqma")
    public suspend fun readinessProbeInitialDelaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbeInitialDelaySeconds = mapped
    }

    /**
     * @param value The interval at which the readiness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
     */
    @JvmName("fghafblktiflatdx")
    public suspend fun readinessProbePeriodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbePeriodSeconds = mapped
    }

    /**
     * @param value The minimum number of consecutive successes for the readiness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
     */
    @JvmName("tbtlbvtjdnukqqvs")
    public suspend fun readinessProbeSuccessThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbeSuccessThreshold = mapped
    }

    /**
     * @param value The port detected by Transmission Control Protocol (TCP) sockets when you use TCP sockets to perform readiness probes.
     */
    @JvmName("kvotwxowygpaxrdi")
    public suspend fun readinessProbeTcpSocketPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbeTcpSocketPort = mapped
    }

    /**
     * @param value The timeout period for the readiness probe. Unit: seconds. Default value: 1. Minimum value: 1.
     */
    @JvmName("jlukcysbuvafwnpr")
    public suspend fun readinessProbeTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readinessProbeTimeoutSeconds = mapped
    }

    /**
     * @param value Grant certain permissions to processes within container. Optional values:
     * - NET_ADMIN: Allow network management tasks to be performed.
     * - NET_RAW: Allow raw sockets.
     */
    @JvmName("wynqcyjarqlegvkx")
    public suspend fun securityContextCapabilityAdds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContextCapabilityAdds = mapped
    }

    /**
     * @param values Grant certain permissions to processes within container. Optional values:
     * - NET_ADMIN: Allow network management tasks to be performed.
     * - NET_RAW: Allow raw sockets.
     */
    @JvmName("ilhovmssfdmysxhx")
    public suspend fun securityContextCapabilityAdds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityContextCapabilityAdds = mapped
    }

    /**
     * @param value Mounts the container's root filesystem as read-only.
     */
    @JvmName("ycobcwhvtyypudva")
    public suspend fun securityContextReadOnlyRootFileSystem(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContextReadOnlyRootFileSystem = mapped
    }

    /**
     * @param value Specifies user ID  under which all processes run.
     */
    @JvmName("ecwdexfbxxgoqywh")
    public suspend fun securityContextRunAsUser(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContextRunAsUser = mapped
    }

    /**
     * @param value The structure of volumeMounts.
     * See `volume_mounts` below for details.
     */
    @JvmName("vkigerpursjmrdpa")
    public suspend fun volumeMounts(`value`: List<EciScalingConfigurationContainerVolumeMountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts.
     * See `volume_mounts` below for details.
     */
    @JvmName("powwhmqgjrsjqdlr")
    public suspend fun volumeMounts(argument: List<suspend EciScalingConfigurationContainerVolumeMountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationContainerVolumeMountArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts.
     * See `volume_mounts` below for details.
     */
    @JvmName("adnbnldccgxucfrl")
    public suspend fun volumeMounts(vararg argument: suspend EciScalingConfigurationContainerVolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EciScalingConfigurationContainerVolumeMountArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param argument The structure of volumeMounts.
     * See `volume_mounts` below for details.
     */
    @JvmName("wybvpxiwntotiipr")
    public suspend fun volumeMounts(argument: suspend EciScalingConfigurationContainerVolumeMountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EciScalingConfigurationContainerVolumeMountArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.volumeMounts = mapped
    }

    /**
     * @param values The structure of volumeMounts.
     * See `volume_mounts` below for details.
     */
    @JvmName("mgwftnxgoakcyeyb")
    public suspend fun volumeMounts(vararg values: EciScalingConfigurationContainerVolumeMountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeMounts = mapped
    }

    /**
     * @param value The working directory of the container.
     */
    @JvmName("fiwqsgjipgcjttjk")
    public suspend fun workingDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workingDir = mapped
    }

    internal fun build(): EciScalingConfigurationContainerArgs = EciScalingConfigurationContainerArgs(
        args = args,
        commands = commands,
        cpu = cpu,
        environmentVars = environmentVars,
        gpu = gpu,
        image = image,
        imagePullPolicy = imagePullPolicy,
        lifecyclePreStopHandlerExecs = lifecyclePreStopHandlerExecs,
        livenessProbeExecCommands = livenessProbeExecCommands,
        livenessProbeFailureThreshold = livenessProbeFailureThreshold,
        livenessProbeHttpGetPath = livenessProbeHttpGetPath,
        livenessProbeHttpGetPort = livenessProbeHttpGetPort,
        livenessProbeHttpGetScheme = livenessProbeHttpGetScheme,
        livenessProbeInitialDelaySeconds = livenessProbeInitialDelaySeconds,
        livenessProbePeriodSeconds = livenessProbePeriodSeconds,
        livenessProbeSuccessThreshold = livenessProbeSuccessThreshold,
        livenessProbeTcpSocketPort = livenessProbeTcpSocketPort,
        livenessProbeTimeoutSeconds = livenessProbeTimeoutSeconds,
        memory = memory,
        name = name,
        ports = ports,
        readinessProbeExecCommands = readinessProbeExecCommands,
        readinessProbeFailureThreshold = readinessProbeFailureThreshold,
        readinessProbeHttpGetPath = readinessProbeHttpGetPath,
        readinessProbeHttpGetPort = readinessProbeHttpGetPort,
        readinessProbeHttpGetScheme = readinessProbeHttpGetScheme,
        readinessProbeInitialDelaySeconds = readinessProbeInitialDelaySeconds,
        readinessProbePeriodSeconds = readinessProbePeriodSeconds,
        readinessProbeSuccessThreshold = readinessProbeSuccessThreshold,
        readinessProbeTcpSocketPort = readinessProbeTcpSocketPort,
        readinessProbeTimeoutSeconds = readinessProbeTimeoutSeconds,
        securityContextCapabilityAdds = securityContextCapabilityAdds,
        securityContextReadOnlyRootFileSystem = securityContextReadOnlyRootFileSystem,
        securityContextRunAsUser = securityContextRunAsUser,
        volumeMounts = volumeMounts,
        workingDir = workingDir,
    )
}
