@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.EciScalingConfigurationHostAliasArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property hostnames Adds a host name.
 * @property ip Adds an IP address.
 */
public data class EciScalingConfigurationHostAliasArgs(
    public val hostnames: Output<List<String>>? = null,
    public val ip: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ess.inputs.EciScalingConfigurationHostAliasArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.EciScalingConfigurationHostAliasArgs =
        com.pulumi.alicloud.ess.inputs.EciScalingConfigurationHostAliasArgs.builder()
            .hostnames(hostnames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ip(ip?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EciScalingConfigurationHostAliasArgs].
 */
@PulumiTagMarker
public class EciScalingConfigurationHostAliasArgsBuilder internal constructor() {
    private var hostnames: Output<List<String>>? = null

    private var ip: Output<String>? = null

    /**
     * @param value Adds a host name.
     */
    @JvmName("qdsvbkgfmgbseund")
    public suspend fun hostnames(`value`: Output<List<String>>) {
        this.hostnames = value
    }

    @JvmName("oixjpalkyogekaan")
    public suspend fun hostnames(vararg values: Output<String>) {
        this.hostnames = Output.all(values.asList())
    }

    /**
     * @param values Adds a host name.
     */
    @JvmName("ynunyyqdkvlkomtx")
    public suspend fun hostnames(values: List<Output<String>>) {
        this.hostnames = Output.all(values)
    }

    /**
     * @param value Adds an IP address.
     */
    @JvmName("qaohuvselikomqkh")
    public suspend fun ip(`value`: Output<String>) {
        this.ip = value
    }

    /**
     * @param value Adds a host name.
     */
    @JvmName("ndfcgdvwyysdnfkt")
    public suspend fun hostnames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostnames = mapped
    }

    /**
     * @param values Adds a host name.
     */
    @JvmName("iayywgxqugkbharo")
    public suspend fun hostnames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostnames = mapped
    }

    /**
     * @param value Adds an IP address.
     */
    @JvmName("dwuqyvavshqruupe")
    public suspend fun ip(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    internal fun build(): EciScalingConfigurationHostAliasArgs = EciScalingConfigurationHostAliasArgs(
        hostnames = hostnames,
        ip = ip,
    )
}
