@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ess.kotlin.inputs

import com.pulumi.alicloud.ess.inputs.EciScalingConfigurationImageRegistryCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password The password used to log on to the image repository. It is required
 * when `image_registry_credential` is configured.
 * @property server The address of the image repository. It is required when `image_registry_credential` is
 * configured.
 * @property username The username used to log on to the image repository. It is required
 * when `image_registry_credential` is configured.
 */
public data class EciScalingConfigurationImageRegistryCredentialArgs(
    public val password: Output<String>? = null,
    public val server: Output<String>? = null,
    public val username: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.ess.inputs.EciScalingConfigurationImageRegistryCredentialArgs> {
    override fun toJava(): com.pulumi.alicloud.ess.inputs.EciScalingConfigurationImageRegistryCredentialArgs =
        com.pulumi.alicloud.ess.inputs.EciScalingConfigurationImageRegistryCredentialArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .server(server?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EciScalingConfigurationImageRegistryCredentialArgs].
 */
@PulumiTagMarker
public class EciScalingConfigurationImageRegistryCredentialArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var server: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The password used to log on to the image repository. It is required
     * when `image_registry_credential` is configured.
     */
    @JvmName("adhkpatrktnckkxk")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The address of the image repository. It is required when `image_registry_credential` is
     * configured.
     */
    @JvmName("ekayngjvmeomyanf")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value The username used to log on to the image repository. It is required
     * when `image_registry_credential` is configured.
     */
    @JvmName("cktbjrtivqcmnttm")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The password used to log on to the image repository. It is required
     * when `image_registry_credential` is configured.
     */
    @JvmName("fudbsimftsgppfpq")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The address of the image repository. It is required when `image_registry_credential` is
     * configured.
     */
    @JvmName("mmogfddcwhkdhbfr")
    public suspend fun server(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The username used to log on to the image repository. It is required
     * when `image_registry_credential` is configured.
     */
    @JvmName("tmefvpthckjhkbwi")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): EciScalingConfigurationImageRegistryCredentialArgs =
        EciScalingConfigurationImageRegistryCredentialArgs(
            password = password,
            server = server,
            username = username,
        )
}
